/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.RangeCodegenUtilKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValueKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\b\u001a\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0018\u001a\u00020\n*\u00020\u0019\u001a\u0018\u0010\u001a\u001a\u00020\n*\u00020\u00192\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\n\u0010\u001b\u001a\u00020\n*\u00020\u0019\u001a\f\u0010\u001c\u001a\u00020\n*\u00020\u001dH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\n*\u00020\u00192\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\n\u0010\u001f\u001a\u00020\n*\u00020\u0019\u001a\n\u0010 \u001a\u00020\n*\u00020\u0019\u001a\n\u0010!\u001a\u00020\n*\u00020\u0019\u001a\u0018\u0010\"\u001a\u00020\n*\u00020\u00192\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a.\u0010#\u001a\u00020\n*\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n0'\u00a2\u0006\u0002\b(H\u0086\b\u001a\u0018\u0010)\u001a\u00020\n*\u00020\u00192\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\n\u0010*\u001a\u00020\n*\u00020\u0019\u001a\n\u0010+\u001a\u00020\n*\u00020\u0019\u001a\n\u0010,\u001a\u00020\n*\u00020\u0019\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010\u0004\u001a&\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00010\u0001 \u0002*\u0012\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"JLCLASS_TO_KCLASS", "", "kotlin.jvm.PlatformType", "KCLASS_TO_JLCLASS", "UNBOXING_METHOD_NAMES", "Lcom/google/common/collect/ImmutableSet;", "shouldUseEqualsForWrappers", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "areSameTypedBoxedValues", "", "values", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "buildFqNameByInternal", "Lorg/jetbrains/kotlin/name/FqName;", "internalClassName", "canValuesBeUnboxedForAreEqual", "isProgressionClass", "type", "isUnboxingMethodName", "name", "isWrapperClassName", "isWrapperClassNameOrNumber", "isAreEqualIntrinsic", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isAreEqualIntrinsicForSameTypedBoxedValues", "isBoxing", "isBoxingMethodDescriptor", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "isIteratorMethodCallOfProgression", "isJavaLangClassBoxing", "isJavaLangClassUnboxing", "isJavaLangComparableCompareTo", "isJavaLangComparableCompareToForSameTypedBoxedValues", "isMethodInsnWith", "opcode", "", "condition", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isNextMethodCallOfProgressionIterator", "isPrimitiveBoxing", "isPrimitiveUnboxing", "isUnboxing", "backend"})
public final class BoxingInterpreterKt {
    private static final ImmutableSet<String> UNBOXING_METHOD_NAMES = ImmutableSet.of("booleanValue", "charValue", "byteValue", "shortValue", "intValue", "floatValue", new String[]{"longValue", "doubleValue"});
    private static final String KCLASS_TO_JLCLASS = Type.getMethodDescriptor(AsmTypes.JAVA_CLASS_TYPE, AsmTypes.K_CLASS_TYPE);
    private static final String JLCLASS_TO_KCLASS = Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.JAVA_CLASS_TYPE);
    private static final Set<Type> shouldUseEqualsForWrappers = SetsKt.setOf(Type.DOUBLE_TYPE, Type.FLOAT_TYPE, AsmTypes.JAVA_CLASS_TYPE);

    public static final boolean isUnboxing(@NotNull AbstractInsnNode $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return BoxingInterpreterKt.isPrimitiveUnboxing($receiver) || BoxingInterpreterKt.isJavaLangClassUnboxing($receiver);
    }

    public static final boolean isBoxing(@NotNull AbstractInsnNode $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return BoxingInterpreterKt.isPrimitiveBoxing($receiver) || BoxingInterpreterKt.isJavaLangClassBoxing($receiver);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimitiveUnboxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 182;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        String string2 = $receiver2.owner;
        Intrinsics.checkExpressionValueIsNotNull(string2, "owner");
        if (!BoxingInterpreterKt.isWrapperClassNameOrNumber(string2)) return false;
        String string3 = $receiver2.name;
        Intrinsics.checkExpressionValueIsNotNull(string3, "name");
        if (!BoxingInterpreterKt.isUnboxingMethodName(string3)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaLangClassUnboxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/JvmClassMappingKt")) return false;
        if (!Intrinsics.areEqual($receiver2.name, "getJavaClass")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, KCLASS_TO_JLCLASS)) return false;
        return true;
    }

    public static final boolean isMethodInsnWith(@NotNull AbstractInsnNode $receiver, int opcode, @NotNull Function1<? super MethodInsnNode, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        return $receiver.getOpcode() == opcode && $receiver instanceof MethodInsnNode && condition.invoke((MethodInsnNode)$receiver) != false;
    }

    private static final boolean isWrapperClassNameOrNumber(String internalClassName) {
        return BoxingInterpreterKt.isWrapperClassName(internalClassName) || Intrinsics.areEqual(internalClassName, Type.getInternalName(Number.class));
    }

    private static final boolean isWrapperClassName(String internalClassName) {
        return JvmPrimitiveType.isWrapperClassName(BoxingInterpreterKt.buildFqNameByInternal(internalClassName));
    }

    private static final FqName buildFqNameByInternal(String internalClassName) {
        Type type2 = Type.getObjectType(internalClassName);
        Intrinsics.checkExpressionValueIsNotNull(type2, "Type.getObjectType(internalClassName)");
        return new FqName(type2.getClassName());
    }

    private static final boolean isUnboxingMethodName(String name2) {
        return UNBOXING_METHOD_NAMES.contains(name2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimitiveBoxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        String string2 = $receiver2.owner;
        Intrinsics.checkExpressionValueIsNotNull(string2, "owner");
        if (!BoxingInterpreterKt.isWrapperClassName(string2)) return false;
        if (!Intrinsics.areEqual($receiver2.name, "valueOf")) return false;
        if (!BoxingInterpreterKt.isBoxingMethodDescriptor($receiver2)) return false;
        return true;
    }

    private static final boolean isBoxingMethodDescriptor(@NotNull MethodInsnNode $receiver) {
        Type ownerType = Type.getObjectType($receiver.owner);
        return Intrinsics.areEqual($receiver.desc, Type.getMethodDescriptor(ownerType, AsmUtil.unboxType(ownerType)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaLangClassBoxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/internal/Reflection")) return false;
        if (!Intrinsics.areEqual($receiver2.name, "getOrCreateKotlinClass")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, JLCLASS_TO_KCLASS)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNextMethodCallOfProgressionIterator(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        if (!(CollectionsKt.firstOrNull(values2) instanceof ProgressionIteratorBasicValue)) return false;
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.name, "next")) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorMethodCallOfProgression(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        BasicValue basicValue = CollectionsKt.firstOrNull(values2);
        if (basicValue == null) return false;
        Type type2 = basicValue.getType();
        Type firstArgType = type2;
        if (firstArgType == null) return false;
        if (!BoxingInterpreterKt.isProgressionClass(firstArgType)) return false;
        if (!Intrinsics.areEqual($receiver2.name, "iterator")) return false;
        return true;
    }

    public static final boolean isProgressionClass(@NotNull Type type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        String string2 = type2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string2, "type.internalName");
        return RangeCodegenUtilKt.isRangeOrProgression(BoxingInterpreterKt.buildFqNameByInternal(string2));
    }

    public static final boolean isAreEqualIntrinsicForSameTypedBoxedValues(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        return BoxingInterpreterKt.isAreEqualIntrinsic($receiver) && BoxingInterpreterKt.areSameTypedBoxedValues(values2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean areSameTypedBoxedValues(@NotNull List<? extends BasicValue> values2) {
        void v1;
        List<? extends BasicValue> list2;
        Intrinsics.checkParameterIsNotNull(values2, "values");
        if (values2.size() != 2) {
            return false;
        }
        List<? extends BasicValue> list3 = list2 = values2;
        BasicValue basicValue = list3.get(0);
        list3 = list2;
        BasicValue v2 = list3.get(1);
        return v1 instanceof BoxedBasicValue && v2 instanceof BoxedBasicValue && Intrinsics.areEqual(((BoxedBasicValue)v1).getDescriptor().getUnboxedType(), ((BoxedBasicValue)v2).getDescriptor().getUnboxedType());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAreEqualIntrinsic(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.name, "areEqual")) return false;
        if (!Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/internal/Intrinsics")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, "(Ljava/lang/Object;Ljava/lang/Object;)Z")) return false;
        return true;
    }

    public static final boolean canValuesBeUnboxedForAreEqual(@NotNull List<? extends BasicValue> values2) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(values2, "values");
            Iterable $receiver$iv = values2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    BasicValue it = (BasicValue)element$iv;
                    Type type2 = it.getType();
                    Intrinsics.checkExpressionValueIsNotNull(type2, "it.type");
                    if (!shouldUseEqualsForWrappers.contains(BoxedBasicValueKt.getUnboxedType(type2))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isJavaLangComparableCompareToForSameTypedBoxedValues(@NotNull AbstractInsnNode $receiver, @NotNull List<? extends BasicValue> values2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        return BoxingInterpreterKt.isJavaLangComparableCompareTo($receiver) && BoxingInterpreterKt.areSameTypedBoxedValues(values2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaLangComparableCompareTo(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.name, "compareTo")) return false;
        if (!Intrinsics.areEqual($receiver2.owner, "java/lang/Comparable")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, "(Ljava/lang/Object;)I")) return false;
        return true;
    }
}

