/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.InvocationKind;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.deserialization.ContractDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.TypeDeserializer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0005\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl;", "Lorg/jetbrains/kotlin/serialization/deserialization/ContractDeserializer;", "configuration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;)V", "deserializeContractFromFunction", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor$UserDataKey;", "Lorg/jetbrains/kotlin/contracts/description/LazyContractProvider;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "ownerFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "typeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "ContractDeserializationWorker", "frontend"})
public final class ContractDeserializerImpl
implements ContractDeserializer {
    private final DeserializationConfiguration configuration;

    @Nullable
    public Pair<FunctionDescriptor.UserDataKey<?>, LazyContractProvider> deserializeContractFromFunction(@NotNull ProtoBuf.Function proto, @NotNull FunctionDescriptor ownerFunction, @NotNull TypeTable typeTable, @NotNull TypeDeserializer typeDeserializer) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(ownerFunction, "ownerFunction");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        Intrinsics.checkParameterIsNotNull(typeDeserializer, "typeDeserializer");
        if (!proto.hasContract()) {
            return null;
        }
        if (!this.configuration.getReadDeserializedContracts()) {
            return null;
        }
        ContractDeserializationWorker worker = new ContractDeserializationWorker(typeTable, typeDeserializer, ownerFunction);
        ProtoBuf.Contract contract = proto.getContract();
        Intrinsics.checkExpressionValueIsNotNull(contract, "proto.contract");
        ContractDescription contract2 = worker.deserializeContract(contract);
        return TuplesKt.to(ContractProviderKey.INSTANCE, LazyContractProvider.Companion.createInitialized(contract2));
    }

    public ContractDeserializerImpl(@NotNull DeserializationConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        this.configuration = configuration;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002)*B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\f\u0010\"\u001a\u00020#*\u00020\u0013H\u0002J\u0014\u0010$\u001a\u00020\u0012*\u00020\u00122\u0006\u0010%\u001a\u00020#H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010'*\u00020(H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker;", "", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "typeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "ownerFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "deserializeConstant", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "value", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "deserializeContract", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "deserializeExpression", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression;", "deserializePossiblyConditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect;", "deserializeSimpleEffect", "extractPrimitiveExpression", "primitiveType", "Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$PrimitiveExpressionType;", "extractType", "Lorg/jetbrains/kotlin/types/KotlinType;", "extractVariable", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "getComplexType", "Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$ComplexExpressionType;", "getPrimitiveType", "hasType", "", "invertIfNecessary", "shouldInvert", "toDescriptorInvocationKind", "Lorg/jetbrains/kotlin/contracts/description/InvocationKind;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "ComplexExpressionType", "PrimitiveExpressionType", "frontend"})
    private static final class ContractDeserializationWorker {
        private final TypeTable typeTable;
        private final TypeDeserializer typeDeserializer;
        private final FunctionDescriptor ownerFunction;

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ContractDescription deserializeContract(@NotNull ProtoBuf.Contract proto) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(proto, "proto");
            List<ProtoBuf.Effect> list2 = proto.getEffectList();
            Intrinsics.checkExpressionValueIsNotNull(list2, "proto.effectList");
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                EffectDeclaration effectDeclaration;
                void it;
                ProtoBuf.Effect effect = (ProtoBuf.Effect)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull(v1, "it");
                if (this.deserializePossiblyConditionalEffect((ProtoBuf.Effect)v1) == null) {
                    return null;
                }
                collection.add(effectDeclaration);
            }
            List effects = (List)destination$iv$iv;
            return new ContractDescription(effects, this.ownerFunction);
        }

        private final EffectDeclaration deserializePossiblyConditionalEffect(ProtoBuf.Effect proto) {
            if (proto.hasConclusionOfConditionalEffect()) {
                ProtoBuf.Expression expression2 = proto.getConclusionOfConditionalEffect();
                Intrinsics.checkExpressionValueIsNotNull(expression2, "proto.conclusionOfConditionalEffect");
                BooleanExpression booleanExpression = this.deserializeExpression(expression2);
                if (booleanExpression == null) {
                    return null;
                }
                BooleanExpression conclusion = booleanExpression;
                EffectDeclaration effectDeclaration = this.deserializeSimpleEffect(proto);
                if (effectDeclaration == null) {
                    return null;
                }
                EffectDeclaration effect = effectDeclaration;
                return new ConditionalEffectDeclaration(effect, conclusion);
            }
            return this.deserializeSimpleEffect(proto);
        }

        private final EffectDeclaration deserializeSimpleEffect(ProtoBuf.Effect proto) {
            EffectDeclaration effectDeclaration;
            ProtoBuf.Effect.EffectType type2;
            if (!proto.hasEffectType()) {
                return null;
            }
            ProtoBuf.Effect.EffectType effectType = type2 = proto.getEffectType();
            if (effectType == null) {
                Intrinsics.throwNpe();
            }
            switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
                case 1: {
                    ConstantReference constantReference;
                    List<ProtoBuf.Expression> list2 = proto.getEffectConstructorArgumentList();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "proto.effectConstructorArgumentList");
                    ProtoBuf.Expression argument = kotlin.collections.CollectionsKt.getOrNull(list2, 0);
                    if (argument == null) {
                        constantReference = ConstantReference.Companion.getWILDCARD();
                    } else {
                        BooleanExpression booleanExpression = this.deserializeExpression(argument);
                        if (!(booleanExpression instanceof ConstantReference)) {
                            booleanExpression = null;
                        }
                        if ((constantReference = (ConstantReference)((Object)booleanExpression)) == null) {
                            return null;
                        }
                    }
                    ConstantReference returnValue = constantReference;
                    effectDeclaration = new ReturnsEffectDeclaration(returnValue);
                    break;
                }
                case 2: {
                    effectDeclaration = new ReturnsEffectDeclaration(ConstantReference.Companion.getNOT_NULL());
                    break;
                }
                case 3: {
                    InvocationKind invocationKind;
                    List<ProtoBuf.Expression> list3 = proto.getEffectConstructorArgumentList();
                    Intrinsics.checkExpressionValueIsNotNull(list3, "proto.effectConstructorArgumentList");
                    ProtoBuf.Expression expression2 = kotlin.collections.CollectionsKt.getOrNull(list3, 0);
                    if (expression2 == null) {
                        return null;
                    }
                    ProtoBuf.Expression argument = expression2;
                    VariableReference variableReference = this.extractVariable(argument);
                    if (variableReference == null) {
                        return null;
                    }
                    VariableReference callable = variableReference;
                    if (proto.hasKind()) {
                        ProtoBuf.Effect.InvocationKind invocationKind2 = proto.getKind();
                        Intrinsics.checkExpressionValueIsNotNull(invocationKind2, "proto.kind");
                        invocationKind = this.toDescriptorInvocationKind(invocationKind2);
                        if (invocationKind == null) {
                            return null;
                        }
                    } else {
                        invocationKind = InvocationKind.UNKNOWN;
                    }
                    InvocationKind invocationKind3 = invocationKind;
                    effectDeclaration = new CallsEffectDeclaration(callable, invocationKind3);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return effectDeclaration;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private final BooleanExpression deserializeExpression(ProtoBuf.Expression proto) {
            BooleanExpression booleanExpression;
            PrimitiveExpressionType primitiveType = this.getPrimitiveType(proto);
            BooleanExpression primitiveExpression = this.extractPrimitiveExpression(proto, primitiveType);
            ComplexExpressionType complexType = this.getComplexType(proto);
            List childs = new ArrayList();
            CollectionsKt.addIfNotNull(childs, primitiveExpression);
            ComplexExpressionType complexExpressionType = complexType;
            if (complexExpressionType != null) {
                switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$1[complexExpressionType.ordinal()]) {
                    case 1: {
                        BooleanExpression it;
                        List<ProtoBuf.Expression> list2 = proto.getAndArgumentList();
                        Intrinsics.checkExpressionValueIsNotNull(list2, "proto.andArgumentList");
                        Iterable $receiver$iv = list2;
                        for (Object t : $receiver$iv) {
                            BooleanExpression booleanExpression2;
                            ProtoBuf.Expression expression2 = (ProtoBuf.Expression)t;
                            Collection collection = childs;
                            void v2 = it;
                            Intrinsics.checkExpressionValueIsNotNull(v2, "it");
                            if (this.deserializeExpression((ProtoBuf.Expression)v2) == null) return null;
                            collection.add(booleanExpression2);
                        }
                        $receiver$iv = childs;
                        Iterator iterator$iv = $receiver$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object t = iterator$iv.next();
                        while (true) {
                            void booleanExpression3;
                            void var8_12;
                            if (!iterator$iv.hasNext()) {
                                booleanExpression = (BooleanExpression)var8_12;
                                return booleanExpression;
                            }
                            it = (BooleanExpression)iterator$iv.next();
                            BooleanExpression acc = (BooleanExpression)var8_12;
                            BooleanExpression booleanExpression4 = new LogicalAnd(acc, (BooleanExpression)booleanExpression3);
                        }
                    }
                    case 2: {
                        BooleanExpression it;
                        ProtoBuf.Expression booleanExpression3;
                        List<ProtoBuf.Expression> list3 = proto.getOrArgumentList();
                        Intrinsics.checkExpressionValueIsNotNull(list3, "proto.orArgumentList");
                        Iterable $receiver$iv = list3;
                        for (Object t : $receiver$iv) {
                            BooleanExpression booleanExpression5;
                            booleanExpression3 = (ProtoBuf.Expression)t;
                            Collection collection = childs;
                            void v5 = it;
                            Intrinsics.checkExpressionValueIsNotNull(v5, "it");
                            if (this.deserializeExpression((ProtoBuf.Expression)v5) == null) return null;
                            collection.add(booleanExpression5);
                        }
                        $receiver$iv = childs;
                        Iterator iterator$iv = $receiver$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object t = iterator$iv.next();
                        while (true) {
                            void var8_16;
                            if (!iterator$iv.hasNext()) {
                                booleanExpression = (BooleanExpression)var8_16;
                                return booleanExpression;
                            }
                            it = (BooleanExpression)iterator$iv.next();
                            BooleanExpression acc = (BooleanExpression)var8_16;
                            BooleanExpression booleanExpression6 = new LogicalOr(acc, (BooleanExpression)((Object)booleanExpression3));
                        }
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            booleanExpression = primitiveExpression;
            return booleanExpression;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final BooleanExpression extractPrimitiveExpression(ProtoBuf.Expression proto, PrimitiveExpressionType primitiveType) {
            Boolean isInverted = Flags.IS_NEGATED.get(proto.getFlags());
            PrimitiveExpressionType primitiveExpressionType = primitiveType;
            if (primitiveExpressionType == null) return null;
            switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$2[primitiveExpressionType.ordinal()]) {
                case 1: 
                case 2: {
                    VariableReference variableReference = this.extractVariable(proto);
                    if (!(variableReference instanceof BooleanVariableReference)) {
                        variableReference = null;
                    }
                    BooleanVariableReference booleanVariableReference = (BooleanVariableReference)variableReference;
                    if (booleanVariableReference == null) return null;
                    BooleanExpression booleanExpression = booleanVariableReference;
                    Boolean bl = isInverted;
                    Intrinsics.checkExpressionValueIsNotNull(bl, "isInverted");
                    BooleanExpression booleanExpression2 = this.invertIfNecessary(booleanExpression, bl);
                    return booleanExpression2;
                }
                case 3: {
                    ProtoBuf.Expression.ConstantValue constantValue = proto.getConstantValue();
                    Intrinsics.checkExpressionValueIsNotNull(constantValue, "proto.constantValue");
                    ConstantReference constantReference = this.deserializeConstant(constantValue);
                    if (!(constantReference instanceof BooleanConstantReference)) {
                        constantReference = null;
                    }
                    BooleanConstantReference booleanConstantReference = (BooleanConstantReference)constantReference;
                    if (booleanConstantReference == null) return null;
                    BooleanExpression booleanExpression = booleanConstantReference;
                    Boolean bl = isInverted;
                    Intrinsics.checkExpressionValueIsNotNull(bl, "isInverted");
                    BooleanExpression booleanExpression2 = this.invertIfNecessary(booleanExpression, bl);
                    return booleanExpression2;
                }
                case 4: {
                    VariableReference variableReference = this.extractVariable(proto);
                    if (variableReference == null) return null;
                    VariableReference variable2 = variableReference;
                    KotlinType kotlinType = this.extractType(proto);
                    if (kotlinType == null) return null;
                    KotlinType type2 = kotlinType;
                    Boolean bl = isInverted;
                    Intrinsics.checkExpressionValueIsNotNull(bl, "isInverted");
                    BooleanExpression booleanExpression2 = new IsInstancePredicate(variable2, type2, bl);
                    return booleanExpression2;
                }
                case 5: {
                    VariableReference variableReference = this.extractVariable(proto);
                    if (variableReference == null) return null;
                    VariableReference variable3 = variableReference;
                    Boolean bl = isInverted;
                    Intrinsics.checkExpressionValueIsNotNull(bl, "isInverted");
                    BooleanExpression booleanExpression2 = new IsNullPredicate(variable3, bl);
                    return booleanExpression2;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final BooleanExpression invertIfNecessary(@NotNull BooleanExpression $receiver, boolean shouldInvert) {
            return shouldInvert ? (BooleanExpression)new LogicalNot($receiver) : $receiver;
        }

        private final VariableReference extractVariable(ProtoBuf.Expression proto) {
            ParameterDescriptor parameterDescriptor;
            if (!proto.hasValueParameterReference()) {
                return null;
            }
            if (proto.getValueParameterReference() == 0) {
                ReceiverParameterDescriptor receiverParameterDescriptor = this.ownerFunction.getExtensionReceiverParameter();
                if (receiverParameterDescriptor == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "ownerFunction.extensionR\u2026rParameter ?: return null");
                parameterDescriptor = receiverParameterDescriptor;
            } else {
                List<ValueParameterDescriptor> list2 = this.ownerFunction.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, "ownerFunction.valueParameters");
                ValueParameterDescriptor valueParameterDescriptor = kotlin.collections.CollectionsKt.getOrNull(list2, proto.getValueParameterReference() - 1);
                if (valueParameterDescriptor == null) {
                    return null;
                }
                parameterDescriptor = valueParameterDescriptor;
            }
            ParameterDescriptor parameterDescriptor2 = parameterDescriptor;
            return !KotlinBuiltIns.isBoolean(parameterDescriptor2.getType()) ? new VariableReference(parameterDescriptor2) : (VariableReference)new BooleanVariableReference(parameterDescriptor2);
        }

        private final InvocationKind toDescriptorInvocationKind(@NotNull ProtoBuf.Effect.InvocationKind $receiver) {
            InvocationKind invocationKind;
            switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$3[$receiver.ordinal()]) {
                case 1: {
                    invocationKind = InvocationKind.AT_MOST_ONCE;
                    break;
                }
                case 2: {
                    invocationKind = InvocationKind.EXACTLY_ONCE;
                    break;
                }
                case 3: {
                    invocationKind = InvocationKind.AT_LEAST_ONCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return invocationKind;
        }

        private final KotlinType extractType(ProtoBuf.Expression proto) {
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.isInstanceType(proto, this.typeTable);
            if (type2 == null) {
                return null;
            }
            return TypeDeserializer.type$default(this.typeDeserializer, type2, null, 2, null);
        }

        private final ConstantReference deserializeConstant(ProtoBuf.Expression.ConstantValue value2) {
            ConstantReference constantReference;
            switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$4[value2.ordinal()]) {
                case 1: {
                    constantReference = BooleanConstantReference.Companion.getTRUE();
                    break;
                }
                case 2: {
                    constantReference = BooleanConstantReference.Companion.getFALSE();
                    break;
                }
                case 3: {
                    constantReference = ConstantReference.Companion.getNULL();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return constantReference;
        }

        private final ComplexExpressionType getComplexType(ProtoBuf.Expression proto) {
            boolean isAndSequence;
            boolean isOrSequence = proto.getOrArgumentCount() != 0;
            boolean bl = isAndSequence = proto.getAndArgumentCount() != 0;
            return isOrSequence && isAndSequence ? null : (isOrSequence ? ComplexExpressionType.OR_SEQUENCE : (isAndSequence ? ComplexExpressionType.AND_SEQUENCE : null));
        }

        private final PrimitiveExpressionType getPrimitiveType(ProtoBuf.Expression proto) {
            List expressionTypes = new ArrayList();
            if (proto.hasValueParameterReference() && this.hasType(proto)) {
                expressionTypes.add(PrimitiveExpressionType.INSTANCE_CHECK);
            } else if (proto.hasValueParameterReference()) {
                Boolean bl = Flags.IS_NULL_CHECK_PREDICATE.get(proto.getFlags());
                Intrinsics.checkExpressionValueIsNotNull(bl, "Flags.IS_NULL_CHECK_PREDICATE.get(proto.flags)");
                if (bl.booleanValue()) {
                    expressionTypes.add(PrimitiveExpressionType.NULLABILITY_CHECK);
                }
            }
            Collection collection = expressionTypes;
            if (!collection.isEmpty()) {
                return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull(expressionTypes));
            }
            if (proto.hasValueParameterReference() && proto.getValueParameterReference() > 0) {
                expressionTypes.add(PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE);
            } else if (proto.hasValueParameterReference() && proto.getValueParameterReference() == 0) {
                expressionTypes.add(PrimitiveExpressionType.RECEIVER_REFERENCE);
            } else if (proto.hasConstantValue()) {
                expressionTypes.add(PrimitiveExpressionType.CONSTANT);
            }
            return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull(expressionTypes));
        }

        private final boolean hasType(@NotNull ProtoBuf.Expression $receiver) {
            return $receiver.hasIsInstanceType() || $receiver.hasIsInstanceTypeId();
        }

        public ContractDeserializationWorker(@NotNull TypeTable typeTable, @NotNull TypeDeserializer typeDeserializer, @NotNull FunctionDescriptor ownerFunction) {
            Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
            Intrinsics.checkParameterIsNotNull(typeDeserializer, "typeDeserializer");
            Intrinsics.checkParameterIsNotNull(ownerFunction, "ownerFunction");
            this.typeTable = typeTable;
            this.typeDeserializer = typeDeserializer;
            this.ownerFunction = ownerFunction;
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$PrimitiveExpressionType;", "", "(Ljava/lang/String;I)V", "VALUE_PARAMETER_REFERENCE", "RECEIVER_REFERENCE", "CONSTANT", "INSTANCE_CHECK", "NULLABILITY_CHECK", "frontend"})
        private static final class PrimitiveExpressionType
        extends Enum<PrimitiveExpressionType> {
            public static final /* enum */ PrimitiveExpressionType VALUE_PARAMETER_REFERENCE;
            public static final /* enum */ PrimitiveExpressionType RECEIVER_REFERENCE;
            public static final /* enum */ PrimitiveExpressionType CONSTANT;
            public static final /* enum */ PrimitiveExpressionType INSTANCE_CHECK;
            public static final /* enum */ PrimitiveExpressionType NULLABILITY_CHECK;
            private static final /* synthetic */ PrimitiveExpressionType[] $VALUES;

            static {
                PrimitiveExpressionType[] primitiveExpressionTypeArray = new PrimitiveExpressionType[5];
                PrimitiveExpressionType[] primitiveExpressionTypeArray2 = primitiveExpressionTypeArray;
                primitiveExpressionTypeArray[0] = VALUE_PARAMETER_REFERENCE = new PrimitiveExpressionType();
                primitiveExpressionTypeArray[1] = RECEIVER_REFERENCE = new PrimitiveExpressionType();
                primitiveExpressionTypeArray[2] = CONSTANT = new PrimitiveExpressionType();
                primitiveExpressionTypeArray[3] = INSTANCE_CHECK = new PrimitiveExpressionType();
                primitiveExpressionTypeArray[4] = NULLABILITY_CHECK = new PrimitiveExpressionType();
                $VALUES = primitiveExpressionTypeArray;
            }

            public static PrimitiveExpressionType[] values() {
                return (PrimitiveExpressionType[])$VALUES.clone();
            }

            public static PrimitiveExpressionType valueOf(String string2) {
                return Enum.valueOf(PrimitiveExpressionType.class, string2);
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$ComplexExpressionType;", "", "(Ljava/lang/String;I)V", "AND_SEQUENCE", "OR_SEQUENCE", "frontend"})
        private static final class ComplexExpressionType
        extends Enum<ComplexExpressionType> {
            public static final /* enum */ ComplexExpressionType AND_SEQUENCE;
            public static final /* enum */ ComplexExpressionType OR_SEQUENCE;
            private static final /* synthetic */ ComplexExpressionType[] $VALUES;

            static {
                ComplexExpressionType[] complexExpressionTypeArray = new ComplexExpressionType[2];
                ComplexExpressionType[] complexExpressionTypeArray2 = complexExpressionTypeArray;
                complexExpressionTypeArray[0] = AND_SEQUENCE = new ComplexExpressionType();
                complexExpressionTypeArray[1] = OR_SEQUENCE = new ComplexExpressionType();
                $VALUES = complexExpressionTypeArray;
            }

            public static ComplexExpressionType[] values() {
                return (ComplexExpressionType[])$VALUES.clone();
            }

            public static ComplexExpressionType valueOf(String string2) {
                return Enum.valueOf(ComplexExpressionType.class, string2);
            }
        }
    }
}

