/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

public class PropertySetterDescriptorImpl
extends PropertyAccessorDescriptorImpl
implements PropertySetterDescriptor {
    private ValueParameterDescriptor parameter;
    @NotNull
    private final PropertySetterDescriptor original;

    public PropertySetterDescriptorImpl(@NotNull PropertyDescriptor correspondingProperty, @NotNull Annotations annotations2, @NotNull Modality modality, @NotNull Visibility visibility, boolean isDefault, boolean isExternal, boolean isInline, @NotNull CallableMemberDescriptor.Kind kind, @Nullable PropertySetterDescriptor original, @NotNull SourceElement source) {
        super(modality, visibility, correspondingProperty, annotations2, Name.special("<set-" + correspondingProperty.getName() + ">"), isDefault, isExternal, isInline, kind, source);
        this.original = original != null ? original : this;
    }

    public void initialize(@NotNull ValueParameterDescriptor parameter) {
        assert (this.parameter == null);
        this.parameter = parameter;
    }

    public void initializeDefault() {
        assert (this.parameter == null);
        this.parameter = PropertySetterDescriptorImpl.createSetterParameter(this, this.getCorrespondingProperty().getReturnType());
    }

    public static ValueParameterDescriptorImpl createSetterParameter(@NotNull PropertySetterDescriptor setterDescriptor, @NotNull KotlinType type2) {
        return new ValueParameterDescriptorImpl(setterDescriptor, null, 0, Annotations.Companion.getEMPTY(), Name.special("<set-?>"), type2, false, false, false, null, SourceElement.NO_SOURCE);
    }

    @Override
    @NotNull
    public Collection<? extends PropertySetterDescriptor> getOverriddenDescriptors() {
        return super.getOverriddenDescriptors(false);
    }

    @Override
    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        if (this.parameter == null) {
            throw new IllegalStateException();
        }
        return Collections.singletonList(this.parameter);
    }

    @Override
    @NotNull
    public KotlinType getReturnType() {
        return DescriptorUtilsKt.getBuiltIns(this).getUnitType();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitPropertySetterDescriptor(this, data2);
    }

    @Override
    @NotNull
    public PropertySetterDescriptor getOriginal() {
        return this.original;
    }
}

