/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationContainerLoweringPass;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.descriptors.JsSymbolBuilder;
import org.jetbrains.kotlin.ir.backend.js.descriptors.SymbolBuilderKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionBase;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrMemberAccessExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrSymbolBase;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/FunctionReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/DeclarationContainerLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "lambdas", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/types/KotlinType;", "oldToNewDeclarationMap", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "createClosureGetterName", "", "declaration", "createClosureInstanceName", "createHelperFunctionName", "suffix", "lower", "", "irDeclarationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerKFunctionReference", "", "functionType", "FunctionReferenceCollector", "FunctionReferenceVisitor", "backend.js"})
public final class FunctionReferenceLowering
implements DeclarationContainerLoweringPass,
FileLoweringPass {
    private final Map<IrDeclaration, KotlinType> lambdas;
    private final Map<IrFunctionSymbol, IrFunction> oldToNewDeclarationMap;
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementVisitorVoidKt.acceptVoid(irFile, new FunctionReferenceCollector());
        LowerKt.runOnFilePostfix(this, irFile);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new FunctionReferenceVisitor());
    }

    @Override
    public void lower(@NotNull IrDeclarationContainer irDeclarationContainer) {
        Intrinsics.checkParameterIsNotNull(irDeclarationContainer, "irDeclarationContainer");
        List<IrDeclaration> $receiver$iv = irDeclarationContainer.getDeclarations();
        int i$iv = 0;
        while (i$iv < $receiver$iv.size()) {
            List<IrFunction> transformed$iv;
            List<IrFunction> list2;
            IrDeclaration item$iv = $receiver$iv.get(i$iv);
            IrDeclaration d = item$iv;
            if (d instanceof IrFunction) {
                if (this.lambdas.get(d) != null) {
                    KotlinType kotlinType;
                    KotlinType it = kotlinType;
                    list2 = this.lowerKFunctionReference((IrFunction)d, it);
                } else {
                    list2 = null;
                }
            } else {
                list2 = transformed$iv = null;
            }
            if (transformed$iv == null) {
                ++i$iv;
                continue;
            }
            $receiver$iv.addAll(i$iv, (Collection<IrDeclaration>)transformed$iv);
            $receiver$iv.remove(i$iv += transformed$iv.size());
        }
    }

    private final String createClosureGetterName(IrFunction declaration) {
        return this.createHelperFunctionName(declaration, "KreferenceGet");
    }

    private final String createClosureInstanceName(IrFunction declaration) {
        return this.createHelperFunctionName(declaration, "KreferenceClosure");
    }

    private final String createHelperFunctionName(IrFunction declaration, String suffix) {
        StringBuilder nameBuilder = new StringBuilder();
        if (declaration instanceof IrConstructor) {
            ClassDescriptor classDescriptor = ((IrConstructor)declaration).getDescriptor().getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "declaration.descriptor.constructedClass");
            nameBuilder.append(DescriptorUtilsKt.getFqNameSafe(classDescriptor));
            nameBuilder.append('_');
        }
        nameBuilder.append(declaration.getDescriptor().getName());
        nameBuilder.append('_');
        nameBuilder.append(suffix);
        String string2 = nameBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "nameBuilder.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrFunction> lowerKFunctionReference(IrFunction declaration, KotlinType functionType) {
        int n;
        Object v;
        IrValueParameterSymbolImpl it;
        void $receiver$iv$iv;
        Object object;
        IrValueParameterSymbolImpl p;
        Collection collection;
        void $receiver$iv$iv2;
        Object item$iv$iv3;
        void $receiver$iv$iv3;
        Iterable $receiver$iv;
        Collection p2;
        Object object2;
        Object item$iv$iv22;
        Iterator $receiver$iv$iv4;
        void $receiver$iv2;
        boolean bl;
        List<TypeProjection> closureParams = CollectionsKt.dropLast(functionType.getArguments(), 1);
        int kFunctionValueParamsCount = closureParams.size();
        if (declaration.getDispatchReceiverParameter() != null) {
            --kFunctionValueParamsCount;
        }
        if (declaration.getExtensionReceiverParameter() != null) {
            --kFunctionValueParamsCount;
        }
        boolean bl2 = bl = kFunctionValueParamsCount >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        List<IrValueParameter> getterValueParameters = CollectionsKt.dropLast(declaration.getValueParameters(), kFunctionValueParamsCount);
        String getterName = this.createClosureGetterName(declaration);
        DeclarationDescriptor declarationDescriptor = declaration.getDescriptor().getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "declaration.descriptor.containingDeclaration");
        IrSimpleFunctionSymbolImpl irSimpleFunctionSymbolImpl = JsSymbolBuilder.buildSimpleFunction$default(JsSymbolBuilder.INSTANCE, declarationDescriptor, getterName, null, null, null, 28, null);
        Object $receiver = irSimpleFunctionSymbolImpl;
        Iterable iterable = getterValueParameters;
        List list2 = null;
        Iterable iterable2 = null;
        Map<IrFunctionSymbol, IrFunction> map2 = null;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)$receiver;
        void var15_18 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        int index$iv$iv3 = 0;
        Iterator iterator2 = $receiver$iv$iv4.iterator();
        while (iterator2.hasNext()) {
            void i2;
            item$iv$iv22 = iterator2.next();
            int n2 = index$iv$iv3++;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv22;
            int n3 = n2;
            object2 = destination$iv$iv;
            ValueParameterDescriptor valueParameterDescriptor = LowerUtilsKt.copyAsValueParameter(p2.getDescriptor(), (CallableDescriptor)((IrSymbolBase)$receiver).getDescriptor(), (int)i2);
            object2.add(valueParameterDescriptor);
        }
        object2 = (List)destination$iv$iv;
        SymbolBuilderKt.initialize$default(irSimpleFunctionSymbol, map2, iterable2, list2, (List)object2, functionType, null, null, 103, null);
        IrSimpleFunctionSymbolImpl refGetSymbol = irSimpleFunctionSymbolImpl;
        Object $receiver2 = $receiver = JsIrBuilder.INSTANCE.buildFunction(refGetSymbol);
        iterable2 = $receiver$iv = (Iterable)getterValueParameters;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        int index$iv$iv2 = 0;
        for (Object item$iv$iv3 : $receiver$iv$iv3) {
            void i;
            void p3;
            int n4 = index$iv$iv2++;
            IrValueParameter index$iv$iv3 = (IrValueParameter)item$iv$iv3;
            int n5 = n4;
            item$iv$iv22 = destination$iv$iv2;
            p2 = ((IrFunctionBase)$receiver2).getValueParameters();
            int n6 = p3.getStartOffset();
            int n7 = p3.getEndOffset();
            IrDeclarationOrigin irDeclarationOrigin = p3.getOrigin();
            ValueParameterDescriptor valueParameterDescriptor = ((FunctionDescriptor)refGetSymbol.getDescriptor()).getValueParameters().get((int)i);
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "refGetSymbol.descriptor.valueParameters[i]");
            IrValueParameterImpl i2 = new IrValueParameterImpl(n6, n7, irDeclarationOrigin, valueParameterDescriptor);
            p2.add(i2);
            object2 = Unit.INSTANCE;
            item$iv$iv22.add((Object)object2);
        }
        List cfr_ignored_0 = (List)destination$iv$iv2;
        Object refGetFunction = $receiver;
        String closureName = this.createClosureInstanceName(declaration);
        IrSimpleFunctionSymbolImpl refClosureSymbol = JsSymbolBuilder.buildSimpleFunction$default(JsSymbolBuilder.INSTANCE, refGetSymbol.getDescriptor(), closureName, null, null, null, 28, null);
        Iterable $receiver$iv3 = closureParams;
        destination$iv$iv2 = $receiver$iv3;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
        int index$iv$iv4 = 0;
        for (Object item$iv$iv4 : $receiver$iv$iv2) {
            void index2;
            int n8 = index$iv$iv4++;
            TypeProjection i = (TypeProjection)item$iv$iv4;
            int item$iv$iv22 = n8;
            collection = destination$iv$iv3;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = refClosureSymbol;
            KotlinType kotlinType = p.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "p.type");
            object = JsSymbolBuilder.buildValueParameter$default(JsSymbolBuilder.INSTANCE, irSimpleFunctionSymbol2, (int)index2, kotlinType, null, false, 24, null);
            collection.add(object);
        }
        List closureParamSymbols = (List)destination$iv$iv3;
        Iterable $receiver$iv4 = closureParamSymbols;
        destination$iv$iv3 = $receiver$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv4, 10));
        for (Object item$iv$iv5 : $receiver$iv$iv) {
            p = (IrValueParameterSymbolImpl)item$iv$iv5;
            collection = destination$iv$iv4;
            Object d = it.getDescriptor();
            if (d == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ValueParameterDescriptor");
            }
            object = (ValueParameterDescriptor)d;
            collection.add(object);
        }
        List closureParamDescriptors = (List)destination$iv$iv4;
        SymbolBuilderKt.initialize$default(refClosureSymbol, null, null, null, closureParamDescriptors, declaration.getReturnType(), null, null, 103, null);
        map2 = JsIrBuilder.INSTANCE.buildFunction(refClosureSymbol);
        Object $receiver3 = map2;
        Iterable $receiver$iv5 = closureParamSymbols;
        item$iv$iv3 = $receiver$iv5.iterator();
        while (item$iv$iv3.hasNext()) {
            Object element$iv = item$iv$iv3.next();
            it = (IrValueParameterSymbolImpl)element$iv;
            Collection $i$a$1$map = ((IrFunctionBase)$receiver3).getValueParameters();
            IrValueParameterImpl $i$f$mapTo = JsIrBuilder.INSTANCE.buildValueParameter(it);
            $i$a$1$map.add($i$f$mapTo);
        }
        Object $receiver4 = item$iv$iv3 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, declaration.getSymbol(), null, null, 6, null);
        int p4 = 0;
        if (declaration.getDispatchReceiverParameter() != null) {
            ((IrMemberAccessExpressionBase)$receiver4).setDispatchReceiver(JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)closureParamSymbols.get(p4++)));
        }
        if (declaration.getExtensionReceiverParameter() != null) {
            ((IrMemberAccessExpressionBase)$receiver4).setExtensionReceiver(JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)closureParamSymbols.get(p4++)));
        }
        int j = 0;
        Iterable $receiver$iv6 = ((IrFunctionBase)refGetFunction).getValueParameters();
        for (Object element$iv : $receiver$iv6) {
            v = (IrValueParameter)element$iv;
            n = j;
            j = n + 1;
            ((IrCallWithIndexedArgumentsBase)$receiver4).putValueArgument(n, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)v.getSymbol()));
        }
        $receiver$iv6 = CollectionsKt.drop(closureParamSymbols, p4);
        for (Object element$iv : $receiver$iv6) {
            v = (IrValueParameterSymbolImpl)element$iv;
            n = j;
            j = n + 1;
            ((IrCallWithIndexedArgumentsBase)$receiver4).putValueArgument(n, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)v));
        }
        Object irClosureCall = item$iv$iv3;
        IrReturnImpl irClosureReturn = JsIrBuilder.INSTANCE.buildReturn(refClosureSymbol, (IrExpression)irClosureCall);
        ((IrFunctionBase)$receiver3).setBody(JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.listOf(irClosureReturn)));
        map2 = refGetFunction;
        $receiver3 = map2;
        IrFunctionReferenceImpl irClosureReference = JsIrBuilder.INSTANCE.buildFunctionReference(functionType, refClosureSymbol);
        IrReturnImpl irGetterReturn = JsIrBuilder.INSTANCE.buildReturn(refGetSymbol, irClosureReference);
        ((IrFunctionBase)$receiver3).setBody(JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.listOf(irGetterReturn)));
        map2 = this.oldToNewDeclarationMap;
        IrFunctionSymbol irFunctionSymbol = declaration.getSymbol();
        Object object3 = refGetFunction;
        map2.put(irFunctionSymbol, (IrFunction)object3);
        return CollectionsKt.listOf(declaration, (IrFunction)refGetFunction);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public FunctionReferenceLowering(@NotNull JsIrBackendContext context) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        FunctionReferenceLowering functionReferenceLowering = this;
        functionReferenceLowering.lambdas = map2 = (Map)new LinkedHashMap();
        functionReferenceLowering = this;
        functionReferenceLowering.oldToNewDeclarationMap = map2 = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/FunctionReferenceLowering$FunctionReferenceCollector;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/FunctionReferenceLowering;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFunctionReference", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "backend.js"})
    public final class FunctionReferenceCollector
    implements IrElementVisitorVoid {
        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Map map2 = FunctionReferenceLowering.this.lambdas;
            IrFunction irFunction = expression2.getSymbol().getOwner();
            if (irFunction == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
            }
            IrFunction irFunction2 = irFunction;
            KotlinType kotlinType = expression2.getType();
            map2.put(irFunction2, kotlinType);
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data2);
        }

        @Override
        public void visitBody(@NotNull IrBody body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
        }

        @Override
        public void visitBody(@NotNull IrBody body, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data2);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(jump, "jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
            Intrinsics.checkParameterIsNotNull(loop, "loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(loop, "loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data2);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(branch, "branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
        }

        @Override
        public void visitField(@NotNull IrField declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
        }

        @Override
        public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop) {
            Intrinsics.checkParameterIsNotNull(loop, "loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(loop, "loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            Intrinsics.checkParameterIsNotNull(spread, "spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(spread, "spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            Intrinsics.checkParameterIsNotNull(aTry, "aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(aTry, "aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop) {
            Intrinsics.checkParameterIsNotNull(loop, "loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data2) {
            Intrinsics.checkParameterIsNotNull(loop, "loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data2);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/FunctionReferenceLowering$FunctionReferenceVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/FunctionReferenceLowering;)V", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "backend.js"})
    public final class FunctionReferenceVisitor
    extends IrElementTransformerVoid {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
            IrMemberAccessExpression irMemberAccessExpression;
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrFunction newTarget = (IrFunction)FunctionReferenceLowering.this.oldToNewDeclarationMap.get(expression2.getSymbol());
            if (newTarget != null) {
                IrCallImpl irCallImpl;
                IrCallImpl $receiver = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), newTarget.getSymbol(), expression2.getOrigin());
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom((IrMemberAccessExpression)$receiver, expression2);
                int index2 = 0;
                int n = 0;
                int n2 = expression2.getValueArgumentsCount();
                while (n < n2) {
                    void i;
                    IrExpression arg = expression2.getValueArgument((int)i);
                    if (arg != null) {
                        $receiver.putValueArgument(index2++, arg);
                    }
                    ++i;
                }
                irMemberAccessExpression = irCallImpl;
            } else {
                irMemberAccessExpression = expression2;
            }
            return irMemberAccessExpression;
        }
    }
}

