/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.NameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/SimpleNameGenerator;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameGenerator;", "()V", "nameCache", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getNameForDescriptor", "descriptor", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "getNameForSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "sanitizeName", "", "name", "backend.js"})
public final class SimpleNameGenerator
implements NameGenerator {
    private final Map<DeclarationDescriptor, JsName> nameCache;

    @Override
    @NotNull
    public JsName getNameForSymbol(@NotNull IrSymbol symbol2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(symbol2, "symbol");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return this.getNameForDescriptor(symbol2.getDescriptor(), context);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final JsName getNameForDescriptor(DeclarationDescriptor descriptor2, JsGenerationContext context) {
        JsName jsName;
        Map<DeclarationDescriptor, JsName> $receiver$iv = this.nameCache;
        JsName value$iv = $receiver$iv.get(descriptor2);
        if (value$iv != null) {
            jsName = value$iv;
            return jsName;
        }
        Function1 nameDeclarator2 = new Function1<String, JsName>(context.getCurrentScope()){

            @NotNull
            public final JsName invoke(@NotNull String p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((JsScope)this.receiver).declareName(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(JsScope.class);
            }

            public final String getName() {
                return "declareName";
            }

            public final String getSignature() {
                return "declareName(Ljava/lang/String;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;";
            }
        };
        StringBuilder nameBuilder = new StringBuilder();
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ReceiverParameterDescriptor) {
            ReceiverValue receiverValue = ((ReceiverParameterDescriptor)descriptor2).getValue();
            if (receiverValue instanceof ExtensionReceiver) {
                nameBuilder.append(Namer.INSTANCE.getEXTENSION_RECEIVER_NAME());
            } else {
                if (!(receiverValue instanceof ImplicitClassReceiver)) {
                    String string2 = "name for " + descriptor2;
                    throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
                }
                nameBuilder.append(Namer.INSTANCE.getIMPLICIT_RECEIVER_NAME());
            }
        } else if (declarationDescriptor instanceof ValueParameterDescriptor) {
            String declaredName = ((ValueParameterDescriptor)descriptor2).getName().asString();
            nameBuilder.append(declaredName);
            String string3 = declaredName;
            Intrinsics.checkExpressionValueIsNotNull(string3, "declaredName");
            if (StringsKt.startsWith$default(string3, "$", false, 2, null)) {
                nameBuilder.append('_');
                nameBuilder.append(((ValueParameterDescriptor)descriptor2).getIndex());
            }
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            Name name2 = ((PropertyDescriptor)descriptor2).getName();
            Intrinsics.checkExpressionValueIsNotNull(name2, "descriptor.name");
            nameBuilder.append(name2.getIdentifier());
            if (Intrinsics.areEqual(((PropertyDescriptor)descriptor2).getVisibility(), Visibilities.PRIVATE) || ((PropertyDescriptor)descriptor2).getModality() != Modality.FINAL) {
                nameBuilder.append('$');
                DeclarationDescriptor declarationDescriptor2 = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "descriptor.containingDeclaration");
                nameBuilder.append(this.getNameForDescriptor(declarationDescriptor2, context));
            }
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declaredName = descriptor2;
            if (declaredName instanceof PropertyGetterDescriptor) {
                nameBuilder.append(Namer.INSTANCE.getGETTER_PREFIX());
            } else if (declaredName instanceof PropertySetterDescriptor) {
                nameBuilder.append(Namer.INSTANCE.getSETTER_PREFIX());
            }
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
            nameBuilder.append(propertyDescriptor.getName().asString());
            if (Intrinsics.areEqual(((PropertyAccessorDescriptor)descriptor2).getVisibility(), Visibilities.PRIVATE)) {
                nameBuilder.append('$');
                DeclarationDescriptor declarationDescriptor3 = ((PropertyAccessorDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "descriptor.containingDeclaration");
                nameBuilder.append(this.getNameForDescriptor(declarationDescriptor3, context));
            }
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            Name name3 = ((ClassDescriptor)descriptor2).getName();
            Intrinsics.checkExpressionValueIsNotNull(name3, "descriptor.name");
            if (name3.isSpecial()) {
                String declaredName = ((ClassDescriptor)descriptor2).getName().asString();
                StringBuilder stringBuilder = nameBuilder;
                String it = declaredName;
                StringBuilder stringBuilder2 = new StringBuilder();
                String string4 = it;
                Intrinsics.checkExpressionValueIsNotNull(string4, "it");
                String string5 = string4;
                int n = 1;
                int n2 = it.length() - 1;
                StringBuilder stringBuilder3 = stringBuilder2;
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull(string7, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string8 = string7;
                String string9 = stringBuilder3.append(string8).append(descriptor2.hashCode()).toString();
                stringBuilder.append(string9);
            } else {
                String string10 = DescriptorUtilsKt.getFqNameSafe(descriptor2).asString();
                Intrinsics.checkExpressionValueIsNotNull(string10, "descriptor.fqNameSafe.asString()");
                nameBuilder.append(StringsKt.replace$default(string10, '.', '$', false, 4, null));
            }
        } else if (declarationDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)descriptor2).getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "descriptor.constructedClass");
            nameBuilder.append(this.getNameForDescriptor(classDescriptor, context));
        } else if (declarationDescriptor instanceof LocalVariableDescriptor) {
            Name name4 = ((LocalVariableDescriptor)descriptor2).getName();
            Intrinsics.checkExpressionValueIsNotNull(name4, "descriptor.name");
            nameBuilder.append(name4.getIdentifier());
            nameDeclarator2 = new Function1<String, JsName>(context.getCurrentScope()){

                @NotNull
                public final JsName invoke(@NotNull String p1) {
                    Intrinsics.checkParameterIsNotNull(p1, "p1");
                    return ((JsScope)this.receiver).declareFreshName(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(JsScope.class);
                }

                public final String getName() {
                    return "declareFreshName";
                }

                public final String getSignature() {
                    return "declareFreshName(Ljava/lang/String;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;";
                }
            };
        } else if (declarationDescriptor instanceof CallableDescriptor) {
            DeclarationDescriptorNonRoot it;
            nameBuilder.append(((CallableDescriptor)descriptor2).getName().asString());
            List<TypeParameterDescriptor> list2 = ((CallableDescriptor)descriptor2).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.typeParameters");
            Iterable $receiver$iv2 = list2;
            for (Object element$iv : $receiver$iv2) {
                it = (TypeParameterDescriptor)element$iv;
                StringBuilder stringBuilder = new StringBuilder().append('_');
                TypeParameterDescriptor typeParameterDescriptor = it;
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "it");
                nameBuilder.append(stringBuilder.append(typeParameterDescriptor.getName().asString()).toString());
            }
            List<ValueParameterDescriptor> list3 = ((CallableDescriptor)descriptor2).getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, "descriptor.valueParameters");
            $receiver$iv2 = list3;
            for (Object element$iv : $receiver$iv2) {
                it = (ValueParameterDescriptor)element$iv;
                StringBuilder stringBuilder = new StringBuilder().append('_');
                DeclarationDescriptorNonRoot declarationDescriptorNonRoot = it;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptorNonRoot, "it");
                nameBuilder.append(stringBuilder.append(declarationDescriptorNonRoot.getType()).toString());
            }
        }
        String string11 = nameBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string11, "nameBuilder.toString()");
        JsName answer$iv = (JsName)nameDeclarator2.invoke(this.sanitizeName(string11));
        $receiver$iv.put(descriptor2, answer$iv);
        jsName = answer$iv;
        return jsName;
    }

    /*
     * WARNING - void declaration
     */
    private final String sanitizeName(String name2) {
        Collection<Character> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        CharSequence charSequence = name2;
        if (charSequence.length() == 0) {
            return "_";
        }
        char c = StringsKt.first(name2);
        char it22 = c;
        char first2 = NameSuggestionKt.isES5IdentifierStart(it22) ? it22 : (char)'_';
        CharSequence charSequence2 = StringsKt.drop(name2, 1);
        StringBuilder stringBuilder = new StringBuilder().append(String.valueOf(first2));
        void it22 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length());
        void var6_10 = $receiver$iv$iv;
        for (int i = 0; i < var6_10.length(); ++i) {
            char it;
            char item$iv$iv;
            char c2 = item$iv$iv = var6_10.charAt(i);
            collection = destination$iv$iv;
            Character c3 = Character.valueOf(NameSuggestionKt.isES5IdentifierPart(it) ? it : (char)'_');
            collection.add(c3);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(CollectionsKt.joinToString$default(collection, "", null, null, 0, null, null, 62, null)).toString();
    }

    public SimpleNameGenerator() {
        Map map2;
        SimpleNameGenerator simpleNameGenerator = this;
        simpleNameGenerator.nameCache = map2 = (Map)new LinkedHashMap();
    }
}

