/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsClassModel;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.translate.context.AliasingContext;
import org.jetbrains.kotlin.js.translate.context.DeferredCallSite;
import org.jetbrains.kotlin.js.translate.context.DynamicContext;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.declaration.ClassModelGenerator;
import org.jetbrains.kotlin.js.translate.intrinsic.Intrinsics;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

public class TranslationContext {
    @NotNull
    private final DynamicContext dynamicContext;
    @NotNull
    private final StaticContext staticContext;
    @NotNull
    private final AliasingContext aliasingContext;
    @Nullable
    private final UsageTracker usageTracker;
    @Nullable
    private final TranslationContext parent;
    @Nullable
    private final DeclarationDescriptor declarationDescriptor;
    @Nullable
    private final ClassDescriptor classDescriptor;
    @Nullable
    private final ValueParameterDescriptor continuationParameterDescriptor;
    @Nullable
    private InlineFunctionContext inlineFunctionContext;
    private final Map<JsExpression, TemporaryConstVariable> expressionToTempConstVariableCache = new HashMap<JsExpression, TemporaryConstVariable>();

    @NotNull
    public static TranslationContext rootContext(@NotNull StaticContext staticContext) {
        DynamicContext rootDynamicContext = DynamicContext.rootContext(staticContext.getFragment().getScope(), staticContext.getFragment().getInitializerBlock());
        AliasingContext rootAliasingContext = AliasingContext.getCleanContext();
        return new TranslationContext(null, staticContext, rootDynamicContext, rootAliasingContext, null, null);
    }

    private TranslationContext(@Nullable TranslationContext parent2, @NotNull StaticContext staticContext, @NotNull DynamicContext dynamicContext, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker, @Nullable DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor parentDescriptor;
        this.parent = parent2;
        this.dynamicContext = dynamicContext;
        this.staticContext = staticContext;
        this.aliasingContext = aliasingContext;
        this.usageTracker = usageTracker;
        this.declarationDescriptor = declarationDescriptor;
        this.classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : (parent2 != null ? parent2.classDescriptor : null);
        this.continuationParameterDescriptor = this.calculateContinuationParameter();
        this.inlineFunctionContext = parent2 != null ? parent2.inlineFunctionContext : null;
        DeclarationDescriptor declarationDescriptor2 = parentDescriptor = parent2 != null ? parent2.declarationDescriptor : null;
        if (parentDescriptor != declarationDescriptor && declarationDescriptor instanceof CallableDescriptor && InlineUtil.isInline(declarationDescriptor)) {
            this.inlineFunctionContext = new InlineFunctionContext((CallableDescriptor)declarationDescriptor);
        }
    }

    private ValueParameterDescriptor calculateContinuationParameter() {
        FunctionDescriptor function2;
        if (this.parent != null && this.parent.declarationDescriptor == this.declarationDescriptor) {
            return this.parent.continuationParameterDescriptor;
        }
        if (this.declarationDescriptor instanceof FunctionDescriptor && (function2 = (FunctionDescriptor)this.declarationDescriptor).isSuspend()) {
            ClassDescriptor continuationDescriptor = DescriptorUtilKt.findContinuationClassDescriptor(this.getCurrentModule(), NoLookupLocation.FROM_BACKEND, this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReleaseCoroutines));
            return new ValueParameterDescriptorImpl(function2, null, function2.getValueParameters().size(), Annotations.Companion.getEMPTY(), Name.identifier("continuation"), continuationDescriptor.getDefaultType(), false, false, false, null, SourceElement.NO_SOURCE);
        }
        return null;
    }

    @Nullable
    public UsageTracker usageTracker() {
        return this.usageTracker;
    }

    @NotNull
    public DynamicContext dynamicContext() {
        return this.dynamicContext;
    }

    @Nullable
    public InlineFunctionContext getInlineFunctionContext() {
        return this.inlineFunctionContext;
    }

    @NotNull
    public TranslationContext contextWithScope(@NotNull JsFunction fun) {
        return this.newFunctionBody(fun, this.aliasingContext, this.declarationDescriptor);
    }

    @NotNull
    private TranslationContext newFunctionBody(@NotNull JsFunction fun, @Nullable AliasingContext aliasingContext, DeclarationDescriptor descriptor2) {
        DynamicContext dynamicContext = DynamicContext.newContext(fun.getScope(), fun.getBody());
        if (aliasingContext == null) {
            aliasingContext = this.aliasingContext.inner();
        }
        return new TranslationContext(this, this.staticContext, dynamicContext, aliasingContext, this.usageTracker, descriptor2);
    }

    @NotNull
    public TranslationContext newFunctionBodyWithUsageTracker(@NotNull JsFunction fun, @NotNull MemberDescriptor descriptor2) {
        DynamicContext dynamicContext = DynamicContext.newContext(fun.getScope(), fun.getBody());
        UsageTracker usageTracker = new UsageTracker(this.usageTracker, descriptor2);
        return new TranslationContext(this, this.staticContext, dynamicContext, this.aliasingContext.inner(), usageTracker, descriptor2);
    }

    @NotNull
    public TranslationContext innerWithUsageTracker(@NotNull MemberDescriptor descriptor2) {
        UsageTracker usageTracker = new UsageTracker(this.usageTracker, descriptor2);
        return new TranslationContext(this, this.staticContext, this.dynamicContext, this.aliasingContext.inner(), usageTracker, descriptor2);
    }

    @NotNull
    public TranslationContext inner(@NotNull MemberDescriptor descriptor2) {
        return new TranslationContext(this, this.staticContext, this.dynamicContext, this.aliasingContext.inner(), this.usageTracker, descriptor2);
    }

    @NotNull
    public TranslationContext innerBlock(@NotNull JsBlock block) {
        return new TranslationContext(this, this.staticContext, this.dynamicContext.innerBlock(block), this.aliasingContext, this.usageTracker, this.declarationDescriptor);
    }

    @NotNull
    public TranslationContext innerBlock() {
        return this.innerBlock(new JsBlock());
    }

    @NotNull
    public TranslationContext newDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        JsBlock innerBlock = this.getBlockForDescriptor(descriptor2);
        if (innerBlock == null) {
            innerBlock = this.dynamicContext.jsBlock();
        }
        DynamicContext dynamicContext = DynamicContext.newContext(this.getScopeForDescriptor(descriptor2), innerBlock);
        return new TranslationContext(this, this.staticContext, dynamicContext, this.aliasingContext, this.usageTracker, descriptor2);
    }

    @NotNull
    private TranslationContext innerWithAliasingContext(AliasingContext aliasingContext) {
        return new TranslationContext(this, this.staticContext, this.dynamicContext, aliasingContext, this.usageTracker, this.declarationDescriptor);
    }

    @NotNull
    public TranslationContext innerContextWithAliased(@NotNull DeclarationDescriptor correspondingDescriptor, @NotNull JsExpression alias) {
        return this.innerWithAliasingContext(this.aliasingContext.inner(correspondingDescriptor, alias));
    }

    @NotNull
    public TranslationContext innerContextWithAliasesForExpressions(@NotNull Map<KtExpression, JsExpression> aliases) {
        if (aliases.isEmpty()) {
            return this;
        }
        return this.innerWithAliasingContext(this.aliasingContext.withExpressionsAliased(aliases));
    }

    @NotNull
    public TranslationContext innerContextWithDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases.isEmpty()) {
            return this;
        }
        return this.innerWithAliasingContext(this.aliasingContext.withDescriptorsAliased(aliases));
    }

    @Nullable
    private JsBlock getBlockForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof CallableDescriptor) {
            return this.getFunctionObject((CallableDescriptor)descriptor2).getBody();
        }
        return null;
    }

    @Nullable
    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @NotNull
    public BindingContext bindingContext() {
        return this.staticContext.getBindingContext();
    }

    @NotNull
    public BindingTrace bindingTrace() {
        return this.staticContext.getBindingTrace();
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        return this.staticContext.getScopeForDescriptor(descriptor2);
    }

    @NotNull
    public JsName getNameForElement(@NotNull PsiElement element) {
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForElement(this.bindingContext(), element);
        return this.getNameForDescriptor(descriptor2);
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        return this.staticContext.getNameForDescriptor(descriptor2);
    }

    @NotNull
    public JsName getInnerNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        return this.staticContext.getInnerNameForDescriptor(descriptor2);
    }

    @NotNull
    public JsName getInlineableInnerNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        JsName name2;
        if (this.inlineFunctionContext == null || !this.isPublicInlineFunction() || !org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(descriptor2, this.getConfig()) || DescriptorUtils.isAncestor(this.inlineFunctionContext.getDescriptor(), descriptor2, false)) {
            name2 = this.getInnerNameForDescriptor(descriptor2);
        } else {
            String tag = this.staticContext.getTag(descriptor2);
            name2 = this.inlineFunctionContext.getImports().get(tag);
            if (name2 == null) {
                name2 = this.createInlineableInnerNameForDescriptor(descriptor2);
                this.inlineFunctionContext.getImports().put(tag, name2);
            }
        }
        return name2;
    }

    private JsName createInlineableInnerNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        JsNameRef importedNameRef;
        assert (this.inlineFunctionContext != null);
        JsExpression imported = this.createInlineLocalImportExpression(descriptor2);
        if (imported instanceof JsNameRef && (importedNameRef = (JsNameRef)imported).getQualifier() == null && importedNameRef.getIdent().equals(Namer.getRootPackageName()) && (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof ModuleDescriptor)) {
            return importedNameRef.getName();
        }
        JsName result2 = JsScope.declareTemporaryName(StaticContext.getSuggestedName(descriptor2));
        if (this.isFromCurrentModule(descriptor2) && !AnnotationsUtils.isNativeObject(descriptor2)) {
            MetadataProperties.setLocalAlias(result2, this.getInnerNameForDescriptor(descriptor2));
        }
        MetadataProperties.setDescriptor(result2, descriptor2);
        MetadataProperties.setStaticRef(result2, imported);
        MetadataProperties.setImported(result2, true);
        this.inlineFunctionContext.getImportBlock().getStatements().add(JsAstUtils.newVar(result2, imported));
        return result2;
    }

    @NotNull
    public JsExpression getReferenceToIntrinsic(@NotNull String intrinsicName) {
        JsExpression result2;
        if (this.inlineFunctionContext == null || !this.isPublicInlineFunction()) {
            result2 = this.staticContext.getReferenceToIntrinsic(intrinsicName);
        } else {
            String tag = "intrinsic:" + intrinsicName;
            result2 = JsAstUtils.pureFqn(this.inlineFunctionContext.getImports().computeIfAbsent(tag, t -> {
                JsExpression imported = TranslationUtils.getIntrinsicFqn(intrinsicName);
                JsName name2 = JsScope.declareTemporaryName(NameSuggestion.sanitizeName(intrinsicName));
                MetadataProperties.setImported(name2, true);
                this.inlineFunctionContext.getImportBlock().getStatements().add(JsAstUtils.newVar(name2, imported));
                return name2;
            }), null);
        }
        return result2;
    }

    @NotNull
    public JsName getNameForObjectInstance(@NotNull ClassDescriptor descriptor2) {
        return this.staticContext.getNameForObjectInstance(descriptor2);
    }

    @NotNull
    public JsExpression getQualifiedReference(@NotNull DeclarationDescriptor descriptor2) {
        JsExpression result2 = this.staticContext.getQualifiedReference(descriptor2);
        if (this.isPublicInlineFunction()) {
            if (this.isFromCurrentModule(descriptor2)) {
                if (descriptor2 instanceof MemberDescriptor) {
                    this.staticContext.export((MemberDescriptor)descriptor2, true);
                }
            } else {
                JsExpression replacement;
                ModuleDescriptor module2 = DescriptorUtils.getContainingModule(descriptor2);
                if (module2 != this.staticContext.getCurrentModule() && !this.isInlineFunction(descriptor2) && (replacement = this.staticContext.exportModuleForInline(module2)) != null) {
                    result2 = TranslationContext.replaceModuleReference(result2, this.getInnerNameForDescriptor(module2), replacement);
                }
            }
        }
        return result2;
    }

    private boolean isInlineFunction(@NotNull DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return false;
        }
        return CallExpressionTranslator.shouldBeInlined((CallableDescriptor)descriptor2, this);
    }

    private static JsExpression replaceModuleReference(@NotNull JsExpression expression2, @NotNull JsName expectedModuleName, @NotNull JsExpression reexportExpr) {
        if (expression2 instanceof JsNameRef) {
            JsNameRef nameRef = (JsNameRef)expression2;
            if (nameRef.getQualifier() == null) {
                return expectedModuleName == nameRef.getName() ? reexportExpr : expression2;
            }
            JsExpression newQualifier = TranslationContext.replaceModuleReference(nameRef.getQualifier(), expectedModuleName, reexportExpr);
            if (newQualifier == nameRef.getQualifier()) {
                return expression2;
            }
            JsNameRef result2 = nameRef.getName() != null ? new JsNameRef(nameRef.getName(), newQualifier) : new JsNameRef(nameRef.getIdent(), newQualifier);
            result2.copyMetadataFrom(nameRef);
            return result2;
        }
        return expression2;
    }

    @NotNull
    public JsExpression getInnerReference(@NotNull DeclarationDescriptor descriptor2) {
        return JsAstUtils.pureFqn(this.getInlineableInnerNameForDescriptor(descriptor2), null);
    }

    @NotNull
    private JsExpression createInlineLocalImportExpression(@NotNull DeclarationDescriptor descriptor2) {
        JsExpression result2 = this.getQualifiedReference(descriptor2);
        JsName name2 = this.getInnerNameForDescriptor(descriptor2);
        SuggestedName suggested = this.staticContext.suggestName(descriptor2);
        if (suggested != null && this.getConfig().getModuleKind() != ModuleKind.PLAIN && this.isPublicInlineFunction()) {
            String fileModuleId;
            String moduleId = AnnotationsUtils.getModuleName(suggested.getDescriptor());
            if (moduleId != null) {
                JsExpression replacement = this.staticContext.exportModuleForInline(moduleId, name2);
                result2 = TranslationContext.replaceModuleReference(result2, name2, replacement);
            } else if (AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && DescriptorUtils.isTopLevelDeclaration(suggested.getDescriptor()) && (fileModuleId = AnnotationsUtils.getFileModuleName(this.bindingContext(), suggested.getDescriptor())) != null) {
                JsName fileModuleName = this.staticContext.getImportedModule(fileModuleId, null).getInternalName();
                JsExpression replacement = this.staticContext.exportModuleForInline(fileModuleId, fileModuleName);
                result2 = TranslationContext.replaceModuleReference(this.staticContext.getQualifiedReference(descriptor2), fileModuleName, replacement);
            }
        }
        return result2;
    }

    @NotNull
    public JsName getNameForBackingField(@NotNull VariableDescriptorWithAccessors property) {
        return this.staticContext.getNameForBackingField(property);
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression, @Nullable Object source) {
        return this.dynamicContext.declareTemporary(initExpression, source);
    }

    @NotNull
    public JsExpression defineTemporary(@NotNull JsExpression initExpression) {
        TemporaryVariable var = this.dynamicContext.declareTemporary(initExpression, initExpression.getSource());
        this.addStatementToCurrentBlock(var.assignmentStatement());
        return var.reference();
    }

    @NotNull
    public JsExpression cacheExpressionIfNeeded(@NotNull JsExpression expression2) {
        return TranslationUtils.isCacheNeeded(expression2) ? this.defineTemporary(expression2) : expression2;
    }

    @NotNull
    public TemporaryConstVariable getOrDeclareTemporaryConstVariable(@NotNull JsExpression expression2) {
        TemporaryConstVariable tempVar = this.expressionToTempConstVariableCache.get(expression2);
        if (tempVar == null) {
            TemporaryVariable tmpVar = this.declareTemporary(expression2, expression2.getSource());
            tempVar = new TemporaryConstVariable(tmpVar.name(), tmpVar.assignmentExpression());
            this.expressionToTempConstVariableCache.put(expression2, tempVar);
            this.expressionToTempConstVariableCache.put(tmpVar.assignmentExpression(), tempVar);
        }
        return tempVar;
    }

    @NotNull
    public Namer namer() {
        return this.staticContext.getNamer();
    }

    @NotNull
    public Intrinsics intrinsics() {
        return this.staticContext.getIntrinsics();
    }

    @NotNull
    public JsProgram program() {
        return this.staticContext.getProgram();
    }

    @NotNull
    public JsConfig getConfig() {
        return this.staticContext.getConfig();
    }

    @NotNull
    public JsScope scope() {
        return this.dynamicContext.getScope();
    }

    @NotNull
    public AliasingContext aliasingContext() {
        return this.aliasingContext;
    }

    @NotNull
    public JsFunction getFunctionObject(@NotNull CallableDescriptor descriptor2) {
        return this.staticContext.getFunctionWithScope(descriptor2);
    }

    public void addStatementToCurrentBlock(@NotNull JsStatement statement2) {
        this.dynamicContext.jsBlock().getStatements().add(statement2);
    }

    public void addStatementsToCurrentBlock(@NotNull Collection<JsStatement> statements) {
        this.dynamicContext.jsBlock().getStatements().addAll(statements);
    }

    public void addStatementsToCurrentBlockFrom(@NotNull TranslationContext context) {
        this.addStatementsToCurrentBlockFrom(context.dynamicContext().jsBlock());
    }

    public void addStatementsToCurrentBlockFrom(@NotNull JsBlock block) {
        this.dynamicContext.jsBlock().getStatements().addAll(block.getStatements());
    }

    public boolean currentBlockIsEmpty() {
        return this.dynamicContext.jsBlock().isEmpty();
    }

    public void moveVarsFrom(@NotNull TranslationContext context) {
        this.dynamicContext.moveVarsFrom(context.dynamicContext());
    }

    @NotNull
    public JsBlock getCurrentBlock() {
        return this.dynamicContext.jsBlock();
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        JsExpression nameRef = this.captureIfNeedAndGetCapturedName(descriptor2);
        if (nameRef != null) {
            return nameRef;
        }
        JsExpression alias = this.aliasingContext.getAliasForDescriptor(descriptor2);
        return alias != null ? alias.deepCopy() : null;
    }

    @NotNull
    public JsExpression getDispatchReceiver(@NotNull ReceiverParameterDescriptor descriptor2) {
        JsExpression alias = this.getAliasForDescriptor(descriptor2);
        if (alias != null) {
            return alias;
        }
        if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.isCoroutineLambda(descriptor2.getContainingDeclaration())) {
            JsNameRef result2 = new JsNameRef("$$controller$$", JsAstUtils.stateMachineReceiver());
            MetadataProperties.setCoroutineController(result2, true);
            return result2;
        }
        if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration())) {
            if (this.isConstructorOrDirectScope(descriptor2.getContainingDeclaration())) {
                return new JsThisRef();
            }
            ClassDescriptor objectDescriptor = (ClassDescriptor)descriptor2.getContainingDeclaration();
            return ReferenceTranslator.translateAsValueReference(objectDescriptor, this);
        }
        if (descriptor2.getValue() instanceof ExtensionReceiver) {
            return new JsThisRef();
        }
        ClassifierDescriptor classifier2 = descriptor2.getValue().getType().getConstructor().getDeclarationDescriptor();
        assert (classifier2 instanceof ClassDescriptor);
        ClassDescriptor cls = (ClassDescriptor)classifier2;
        assert (this.classDescriptor != null);
        return this.getDispatchReceiverPath(this.classDescriptor, cls, new JsThisRef());
    }

    private boolean isConstructorOrDirectScope(DeclarationDescriptor descriptor2) {
        return descriptor2 == DescriptorUtils.getParentOfType(this.declarationDescriptor, ClassDescriptor.class, false);
    }

    @NotNull
    private JsExpression getDispatchReceiverPath(@NotNull ClassDescriptor from, @NotNull ClassDescriptor to, @NotNull JsExpression qualifier) {
        while (true) {
            JsExpression alias;
            if ((alias = this.getAliasForDescriptor(from.getThisAsReceiverParameter())) != null) {
                qualifier = alias;
            }
            if (from == to || !from.isInner() || !(from.getContainingDeclaration() instanceof ClassDescriptor)) break;
            qualifier = new JsNameRef("$outer", qualifier);
            from = (ClassDescriptor)from.getContainingDeclaration();
        }
        return qualifier;
    }

    @Nullable
    private JsExpression captureIfNeedAndGetCapturedName(@NotNull DeclarationDescriptor descriptor2) {
        if (this.usageTracker != null) {
            this.usageTracker.used(descriptor2);
            JsName name2 = UsageTrackerKt.getNameForCapturedDescriptor(this.usageTracker, descriptor2);
            if (name2 != null) {
                return this.getCapturedReference(name2);
            }
        }
        return null;
    }

    @Nullable
    public JsExpression captureTypeIfNeedAndGetCapturedName(@NotNull TypeParameterDescriptor descriptor2) {
        if (this.usageTracker == null) {
            return null;
        }
        this.usageTracker.used(descriptor2);
        JsName name2 = this.usageTracker.getCapturedTypes().get(descriptor2);
        return name2 != null ? this.getCapturedReference(name2) : null;
    }

    @NotNull
    public JsName getCapturedTypeName(@NotNull TypeParameterDescriptor descriptor2) {
        JsName result2;
        JsName jsName = result2 = this.usageTracker != null ? this.usageTracker.getCapturedTypes().get(descriptor2) : null;
        if (result2 == null) {
            result2 = this.getNameForDescriptor(descriptor2);
        }
        return result2;
    }

    @NotNull
    private JsExpression getCapturedReference(@NotNull JsName name2) {
        JsExpression result2;
        if (this.shouldCaptureViaThis()) {
            result2 = new JsThisRef();
            int depth = this.getOuterLocalClassDepth();
            for (int i = 0; i < depth; ++i) {
                result2 = new JsNameRef("$outer", result2);
            }
            result2 = new JsNameRef(name2, result2);
        } else {
            result2 = name2.makeRef();
        }
        return result2;
    }

    private int getOuterLocalClassDepth() {
        if (this.usageTracker == null) {
            return 0;
        }
        MemberDescriptor capturingDescriptor = this.usageTracker.getContainingDescriptor();
        if (!(capturingDescriptor instanceof ClassDescriptor)) {
            return 0;
        }
        ClassDescriptor capturingClassDescriptor = (ClassDescriptor)capturingDescriptor;
        ClassDescriptor currentDescriptor = this.classDescriptor;
        if (currentDescriptor == null) {
            return 0;
        }
        int depth = 0;
        while (currentDescriptor != capturingClassDescriptor) {
            DeclarationDescriptor container2 = currentDescriptor.getContainingDeclaration();
            if (!(container2 instanceof ClassDescriptor)) {
                return 0;
            }
            currentDescriptor = (ClassDescriptor)container2;
            ++depth;
        }
        return depth;
    }

    private boolean shouldCaptureViaThis() {
        if (this.declarationDescriptor == null) {
            return false;
        }
        if (DescriptorUtils.isDescriptorWithLocalVisibility(this.declarationDescriptor)) {
            return false;
        }
        return !(this.declarationDescriptor instanceof ConstructorDescriptor) || !DescriptorUtils.isDescriptorWithLocalVisibility(this.declarationDescriptor.getContainingDeclaration());
    }

    @Nullable
    public DeclarationDescriptor getDeclarationDescriptor() {
        return this.declarationDescriptor;
    }

    public void putClassOrConstructorClosure(@NotNull MemberDescriptor descriptor2, @NotNull List<DeclarationDescriptor> closure) {
        this.staticContext.putClassOrConstructorClosure(descriptor2, closure);
    }

    @Nullable
    public List<DeclarationDescriptor> getClassOrConstructorClosure(@NotNull MemberDescriptor classOrConstructor) {
        if (classOrConstructor instanceof TypeAliasConstructorDescriptor) {
            ClassConstructorDescriptor constructorDescriptor = ((TypeAliasConstructorDescriptor)classOrConstructor).getUnderlyingConstructorDescriptor();
            return this.getClassOrConstructorClosure(constructorDescriptor);
        }
        List<DeclarationDescriptor> result2 = this.staticContext.getClassOrConstructorClosure(classOrConstructor);
        if (result2 == null && classOrConstructor instanceof ConstructorDescriptor && ((ConstructorDescriptor)classOrConstructor).isPrimary()) {
            result2 = this.staticContext.getClassOrConstructorClosure((ClassDescriptor)classOrConstructor.getContainingDeclaration());
        }
        return result2;
    }

    @NotNull
    public JsExpression getArgumentForClosureConstructor(@NotNull DeclarationDescriptor descriptor2) {
        JsExpression alias = this.getAliasForDescriptor(descriptor2);
        if (alias != null) {
            return alias;
        }
        if (descriptor2 instanceof ReceiverParameterDescriptor) {
            return this.getDispatchReceiver((ReceiverParameterDescriptor)descriptor2);
        }
        if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
            return new JsThisRef();
        }
        return this.getNameForDescriptor(descriptor2).makeRef();
    }

    @NotNull
    public JsExpression getTypeArgumentForClosureConstructor(@NotNull TypeParameterDescriptor descriptor2) {
        JsName name2;
        JsNameRef captured2 = null;
        if (this.usageTracker != null && (name2 = this.usageTracker.getCapturedTypes().get(descriptor2)) != null) {
            captured2 = name2.makeRef();
        }
        return captured2 != null ? captured2 : this.getNameForDescriptor(descriptor2).makeRef();
    }

    @Nullable
    public JsName getOuterClassReference(ClassDescriptor descriptor2) {
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (!(container2 instanceof ClassDescriptor) || !descriptor2.isInner()) {
            return null;
        }
        return this.staticContext.getScopeForDescriptor(descriptor2).declareName("$outer");
    }

    public void startDeclaration() {
        ClassDescriptor classDescriptor = this.classDescriptor;
        if (classDescriptor != null && !(classDescriptor.getContainingDeclaration() instanceof ClassOrPackageFragmentDescriptor)) {
            this.staticContext.getDeferredCallSites().put(classDescriptor, new ArrayList());
        }
    }

    @NotNull
    public List<DeferredCallSite> endDeclaration() {
        List<DeferredCallSite> result2 = null;
        if (this.classDescriptor != null) {
            result2 = this.staticContext.getDeferredCallSites().remove(this.classDescriptor);
        }
        if (result2 == null) {
            result2 = Collections.emptyList();
        }
        return result2;
    }

    public boolean shouldBeDeferred(@NotNull ClassConstructorDescriptor constructor) {
        ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
        return this.staticContext.getDeferredCallSites().containsKey(classDescriptor);
    }

    public void deferConstructorCall(@NotNull ClassConstructorDescriptor constructor, @NotNull List<JsExpression> invocationArgs) {
        ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
        List<DeferredCallSite> callSites = this.staticContext.getDeferredCallSites().get(classDescriptor);
        if (callSites == null) {
            throw new IllegalStateException("This method should be call only when `shouldBeDeferred` method reports true for given constructor: " + constructor);
        }
        callSites.add(new DeferredCallSite(constructor, invocationArgs, this));
    }

    public void addInlineCall(@NotNull CallableDescriptor descriptor2) {
        this.staticContext.addInlineCall(descriptor2);
    }

    public void addDeclarationStatement(@NotNull JsStatement statement2) {
        if (this.inlineFunctionContext != null) {
            this.inlineFunctionContext.getDeclarationsBlock().getStatements().add(statement2);
        } else {
            this.staticContext.getDeclarationStatements().add(statement2);
        }
    }

    public void addTopLevelStatement(@NotNull JsStatement statement2) {
        this.staticContext.getTopLevelStatements().add(statement2);
    }

    @NotNull
    public JsFunction createRootScopedFunction(@NotNull DeclarationDescriptor descriptor2) {
        return this.createRootScopedFunction(descriptor2.toString());
    }

    @NotNull
    public JsFunction createRootScopedFunction(@NotNull String description2) {
        return new JsFunction(this.staticContext.getFragment().getScope(), new JsBlock(), description2);
    }

    public void addClass(@NotNull ClassDescriptor classDescriptor) {
        if (this.inlineFunctionContext != null) {
            JsClassModel classModel = new ClassModelGenerator(this).generateClassModel(classDescriptor);
            List<JsStatement> targetStatements = this.inlineFunctionContext.getPrototypeBlock().getStatements();
            JsName superName = classModel.getSuperName();
            if (superName != null) {
                targetStatements.addAll(UtilsKt.createPrototypeStatements(superName, classModel.getName()));
            }
            targetStatements.addAll(classModel.getPostDeclarationBlock().getStatements());
        } else {
            this.staticContext.addClass(classDescriptor);
        }
    }

    public void export(@NotNull MemberDescriptor descriptor2) {
        this.staticContext.export(descriptor2, false);
    }

    public boolean isFromCurrentModule(@NotNull DeclarationDescriptor descriptor2) {
        return this.staticContext.getCurrentModule() == DescriptorUtilsKt.getModule(descriptor2);
    }

    public boolean isPublicInlineFunction() {
        if (this.inlineFunctionContext == null) {
            return false;
        }
        return org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(this.inlineFunctionContext.getDescriptor(), this.getConfig());
    }

    @Nullable
    public ValueParameterDescriptor getContinuationParameterDescriptor() {
        return this.continuationParameterDescriptor;
    }

    @NotNull
    public ModuleDescriptor getCurrentModule() {
        return this.staticContext.getCurrentModule();
    }

    @Nullable
    public TranslationContext getParent() {
        return this.parent;
    }

    @NotNull
    public JsExpression declareConstantValue(@NotNull DeclarationDescriptor descriptor2, @NotNull KtSimpleNameExpression expression2, @NotNull JsExpression value2) {
        if (!this.isPublicInlineFunction() && this.isFromCurrentModule(descriptor2)) {
            return ReferenceTranslator.translateSimpleName(expression2, this);
        }
        String tag = Objects.requireNonNull(this.staticContext.getTag(descriptor2));
        String suggestedName = StaticContext.getSuggestedName(descriptor2);
        return this.declareConstantValue(suggestedName, tag, value2);
    }

    @NotNull
    public JsExpression declareConstantValue(@NotNull String suggestedName, @NotNull String tag, @NotNull JsExpression value2) {
        if (this.inlineFunctionContext == null || !this.isPublicInlineFunction()) {
            return this.staticContext.importDeclaration(suggestedName, tag, value2).makeRef();
        }
        return this.inlineFunctionContext.getImports().computeIfAbsent(tag, t -> {
            JsName result2 = JsScope.declareTemporaryName(suggestedName);
            MetadataProperties.setImported(result2, true);
            this.inlineFunctionContext.getImportBlock().getStatements().add(JsAstUtils.newVar(result2, value2));
            return result2;
        }).makeRef();
    }

    @NotNull
    public JsName getNameForSpecialFunction(@NotNull SpecialFunction function2) {
        if (this.inlineFunctionContext == null || !this.isPublicInlineFunction()) {
            return this.staticContext.getNameForSpecialFunction(function2);
        }
        String tag = TranslationUtils.getTagForSpecialFunction(function2);
        return this.inlineFunctionContext.getImports().computeIfAbsent(tag, t -> {
            JsExpression imported = Namer.createSpecialFunction(function2);
            JsName result2 = JsScope.declareTemporaryName(function2.getSuggestedName());
            MetadataProperties.setImported(result2, true);
            MetadataProperties.setSpecialFunction(result2, function2);
            this.inlineFunctionContext.getImportBlock().getStatements().add(JsAstUtils.newVar(result2, imported));
            return result2;
        });
    }

    @NotNull
    public SourceFilePathResolver getSourceFilePathResolver() {
        return this.staticContext.getSourceFilePathResolver();
    }

    @NotNull
    public JsName getVariableForPropertyMetadata(@NotNull VariableDescriptorWithAccessors property) {
        return this.staticContext.getVariableForPropertyMetadata(property);
    }

    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return CommonConfigurationKeysKt.getLanguageVersionSettings(this.staticContext.getConfig().getConfiguration());
    }
}

