/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006*\u00020\u0002H\u0002\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a \u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u001a\u0010\u0016\u001a\u00020\n*\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\"\u0010\u001b\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"requiresExtensionReceiverParameter", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getRequiresExtensionReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getCorrectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "reportInlineFunction", "", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumer;", "descriptor", "translatedFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sourceInfo", "Lcom/intellij/psi/PsiElement;", "translateAndAliasParameters", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "targetList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "translateFunction", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "wrapWithInlineMetadata", "outerContext", "js.translator"})
public final class FunctionTranslatorKt {
    @NotNull
    public static final TranslationContext translateAndAliasParameters(@NotNull TranslationContext $receiver, @NotNull FunctionDescriptor descriptor2, @NotNull List<JsParameter> targetList2) {
        Object object;
        Object suggestedName;
        Object object2;
        Object object3;
        Object paramNameForType;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(targetList2, "targetList");
        Map aliases = new LinkedHashMap();
        Iterator<TypeParameterDescriptor> iterator2 = FunctionTranslatorKt.getCorrectTypeParameters(descriptor2).iterator();
        while (iterator2.hasNext()) {
            JsNameRef jsNameRef;
            TypeParameterDescriptor type2;
            TypeParameterDescriptor typeParameterDescriptor = type2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "type");
            if (!typeParameterDescriptor.isReified()) continue;
            paramNameForType = $receiver.getNameForDescriptor(type2);
            object3 = targetList2;
            object2 = new JsParameter((JsName)paramNameForType);
            object3.add(object2);
            suggestedName = Namer.isInstanceSuggestedName(type2);
            JsName paramName = JsScope.declareTemporaryName((String)suggestedName);
            object = targetList2;
            Object object4 = new JsParameter(paramName);
            object.add(object4);
            object = aliases;
            object4 = type2;
            Intrinsics.checkExpressionValueIsNotNull(paramName.makeRef(), "paramName.makeRef()");
            object.put(object4, jsNameRef);
        }
        if (FunctionTranslatorKt.getRequiresExtensionReceiverParameter(descriptor2)) {
            Object receiverRef;
            JsName receiverParameterName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Object object5 = receiverRef = receiverParameterName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(object5, "receiverRef");
            JsExpression jsExpression = (JsExpression)object5;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "descriptor.extensionReceiverParameter!!");
            MetadataProperties.setType(jsExpression, receiverParameterDescriptor.getType());
            paramNameForType = aliases;
            ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor2, "descriptor.extensionReceiverParameter!!");
            suggestedName = receiverParameterDescriptor2;
            object2 = receiverRef;
            paramNameForType.put(suggestedName, object2);
            paramNameForType = targetList2;
            suggestedName = new JsParameter(receiverParameterName);
            paramNameForType.add(suggestedName);
        }
        for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
            JsNameRef $i$a$1$also;
            HasMetadata it;
            JsName name2;
            JsName jsName = name2 = $receiver.getNameForDescriptor(valueParameter);
            Intrinsics.checkExpressionValueIsNotNull(jsName, "name");
            object2 = JsScope.declareTemporaryName(jsName.getIdent());
            HasMetadata hasMetadata = it = object2;
            Intrinsics.checkExpressionValueIsNotNull(hasMetadata, "it");
            MetadataProperties.setDescriptor((JsName)hasMetadata, (DeclarationDescriptor)valueParameter);
            Object tmpName = object2;
            object2 = aliases;
            ValueParameterDescriptor valueParameterDescriptor = valueParameter;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "valueParameter");
            object = valueParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(JsAstUtils.pureFqn((JsName)tmpName, null), "JsAstUtils.pureFqn(tmpName, null)");
            object2.put(object, $i$a$1$also);
            object2 = targetList2;
            Object $receiver2 = object = new JsParameter((JsName)tmpName);
            MetadataProperties.setHasDefaultValue((JsParameter)$receiver2, ArgumentsUtilsKt.hasDefaultValue(valueParameter));
            object2.add(object);
        }
        ValueParameterDescriptor continuationDescriptor = $receiver.getContinuationParameterDescriptor();
        if (continuationDescriptor != null) {
            JsParameter jsParameter = new JsParameter($receiver.getNameForDescriptor(continuationDescriptor));
            Object object6 = targetList2;
            object6.add(jsParameter);
            object6 = aliases;
            JsExpression jsExpression = JsAstUtils.stateMachineReceiver();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsAstUtils.stateMachineReceiver()");
            object3 = jsExpression;
            object6.put(continuationDescriptor, object3);
        }
        TranslationContext translationContext = $receiver.innerContextWithDescriptorsAliased(aliases);
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "this.innerContextWithDescriptorsAliased(aliases)");
        return translationContext;
    }

    private static final List<TypeParameterDescriptor> getCorrectTypeParameters(@NotNull FunctionDescriptor $receiver) {
        List<TypeParameterDescriptor> list2;
        FunctionDescriptor functionDescriptor = $receiver;
        if (!(functionDescriptor instanceof PropertyAccessorDescriptor)) {
            functionDescriptor = null;
        }
        if ((list2 = (PropertyAccessorDescriptor)functionDescriptor) == null || (list2 = list2.getCorrespondingProperty()) == null || (list2 = list2.getTypeParameters()) == null) {
            list2 = $receiver.getTypeParameters();
        }
        return list2;
    }

    private static final boolean getRequiresExtensionReceiverParameter(@NotNull FunctionDescriptor $receiver) {
        return DescriptorUtils.isExtension($receiver);
    }

    public static final void translateFunction(@NotNull TranslationContext $receiver, @NotNull KtDeclarationWithBody declaration, @NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor($receiver.bindingContext(), declaration);
        if (declaration.hasBody()) {
            JsBlock body = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, $receiver);
            JsBlock jsBlock = function2.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "function.body");
            Collection collection = jsBlock.getStatements();
            JsBlock jsBlock2 = body;
            Intrinsics.checkExpressionValueIsNotNull(jsBlock2, "body");
            List<JsStatement> list2 = jsBlock2.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "body.statements");
            Iterable iterable = list2;
            CollectionsKt.addAll(collection, iterable);
        }
        MetadataProperties.setFunctionDescriptor(function2, descriptor2);
    }

    @NotNull
    public static final JsExpression wrapWithInlineMetadata(@NotNull TranslationContext $receiver, @NotNull TranslationContext outerContext, @NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(outerContext, "outerContext");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "descriptor.source");
        PsiElement sourceInfo = KotlinSourceElementKt.getPsi(sourceElement);
        if (descriptor2.isInline()) {
            IncrementalResultsConsumer incrementalResults;
            JsConfig jsConfig = $receiver.getConfig();
            Intrinsics.checkExpressionValueIsNotNull(jsConfig, "config");
            IncrementalResultsConsumer incrementalResultsConsumer = incrementalResults = jsConfig.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
            if (incrementalResultsConsumer != null) {
                FunctionTranslatorKt.reportInlineFunction(incrementalResultsConsumer, descriptor2, function2, sourceInfo);
            }
            DeclarationDescriptor declarationDescriptor = descriptor2;
            JsConfig jsConfig2 = $receiver.getConfig();
            Intrinsics.checkExpressionValueIsNotNull(jsConfig2, "config");
            if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig2)) {
                InlineMetadata metadata2 = InlineMetadata.Companion.compose(function2, descriptor2, $receiver);
                jsExpression = metadata2.functionWithMetadata(outerContext, sourceInfo);
            } else {
                InlineFunctionContext inlineFunctionContext;
                InlineFunctionContext inlineFunctionContext2 = $receiver.getInlineFunctionContext();
                if (inlineFunctionContext2 == null) {
                    Intrinsics.throwNpe();
                }
                InlineFunctionContext it = inlineFunctionContext = inlineFunctionContext2;
                List<JsStatement> list2 = it.getImportBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list2, "it.importBlock.statements");
                Collection collection = list2;
                List<JsStatement> list3 = it.getPrototypeBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list3, "it.prototypeBlock.statements");
                Collection collection2 = CollectionsKt.plus(collection, (Iterable)list3);
                List<JsStatement> list4 = it.getDeclarationsBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list4, "it.declarationsBlock.statements");
                JsBlock block = new JsBlock(CollectionsKt.plus((Collection)CollectionsKt.plus(collection2, (Iterable)list4), new JsReturn(function2)));
                jsExpression = InlineMetadata.Companion.wrapFunction(outerContext, new FunctionWithWrapper(function2, block), sourceInfo);
            }
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }

    private static final void reportInlineFunction(@NotNull IncrementalResultsConsumer $receiver, FunctionDescriptor descriptor2, JsExpression translatedFunction, PsiElement sourceInfo) {
        String string2;
        Object object;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "descriptor.source");
        SourceFile sourceFile = sourceElement.getContainingFile();
        if (!(sourceFile instanceof PsiSourceFile)) {
            sourceFile = null;
        }
        if ((object = (PsiSourceFile)sourceFile) == null || (object = ((PsiSourceFile)object).getPsiFile()) == null) {
            return;
        }
        Object psiFile = object;
        File file2 = VfsUtilCore.virtualToIoFile(psiFile.getVirtualFile());
        Visibility visibility = descriptor2.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull(visibility, "descriptor.visibility");
        if (EffectiveVisibilityKt.effectiveVisibility(visibility, descriptor2, true).getPrivateApi()) {
            return;
        }
        FunctionDescriptor functionDescriptor = descriptor2;
        if (functionDescriptor instanceof PropertyGetterDescriptor) {
            StringBuilder stringBuilder = new StringBuilder().append("<get>");
            PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
            string2 = stringBuilder.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else if (functionDescriptor instanceof PropertySetterDescriptor) {
            StringBuilder stringBuilder = new StringBuilder().append("<set>");
            PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
            string2 = stringBuilder.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else {
            String string3 = DescriptorUtilsKt.getFqNameSafe(descriptor2).asString();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "descriptor.fqNameSafe.asString()");
        }
        String fqName2 = string2;
        UserDataHolder userDataHolder = sourceInfo;
        Integer offset2 = userDataHolder != null && (userDataHolder = userDataHolder.getNode()) != null ? Integer.valueOf(userDataHolder.getStartOffset()) : null;
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull(fileViewProvider, "psiFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        int sourceLine = -1;
        int sourceColumn = -1;
        if (offset2 != null && document != null) {
            sourceLine = document.getLineNumber(offset2);
            sourceColumn = offset2 - document.getLineStartOffset(sourceLine);
        }
        File file3 = file2;
        Intrinsics.checkExpressionValueIsNotNull(file3, "file");
        $receiver.processInlineFunction(file3, fqName2, translatedFunction, sourceLine, sourceColumn);
    }
}

