/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

public final class InitializerUtils {
    private InitializerUtils() {
    }

    @NotNull
    public static JsStatement generateInitializerForProperty(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2, @NotNull JsExpression value2) {
        JsExpression assignment = TranslationUtils.assignmentToBackingField(context, descriptor2, value2);
        assignment.setSource(KotlinSourceElementKt.getPsi(descriptor2.getSource()));
        return assignment.makeStmt();
    }

    @NotNull
    public static JsStatement generateInitializerForDelegate(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2, @NotNull JsExpression value2) {
        return JsAstUtils.defineSimpleProperty(context.getNameForBackingField(descriptor2), value2, descriptor2.getSource());
    }
}

