/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.ValueParameterData;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

public class JavaPropertyDescriptor
extends PropertyDescriptorImpl
implements JavaCallableMemberDescriptor {
    private final boolean isStaticFinal;

    private JavaPropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name2, @NotNull SourceElement source, @Nullable PropertyDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, boolean isStaticFinal) {
        super(containingDeclaration, original, annotations2, modality, visibility, isVar, name2, kind, source, false, false, false, false, false, false);
        this.isStaticFinal = isStaticFinal;
    }

    @NotNull
    public static JavaPropertyDescriptor create(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name2, @NotNull SourceElement source, boolean isStaticFinal) {
        return new JavaPropertyDescriptor(containingDeclaration, annotations2, modality, visibility, isVar, name2, source, null, CallableMemberDescriptor.Kind.DECLARATION, isStaticFinal);
    }

    @Override
    @NotNull
    protected PropertyDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, @Nullable PropertyDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, @NotNull Name newName2) {
        return new JavaPropertyDescriptor(newOwner, this.getAnnotations(), newModality, newVisibility, this.isVar(), newName2, SourceElement.NO_SOURCE, original, kind, this.isStaticFinal);
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        return false;
    }

    @Override
    @NotNull
    public JavaCallableMemberDescriptor enhance(@Nullable KotlinType enhancedReceiverType, @NotNull List<ValueParameterData> enhancedValueParametersData, @NotNull KotlinType enhancedReturnType) {
        JavaPropertyDescriptor enhanced = new JavaPropertyDescriptor(this.getContainingDeclaration(), this.getAnnotations(), this.getModality(), this.getVisibility(), this.isVar(), this.getName(), this.getSource(), this.getOriginal(), this.getKind(), this.isStaticFinal);
        PropertyGetterDescriptorImpl newGetter = null;
        PropertyGetterDescriptorImpl getter2 = this.getGetter();
        if (getter2 != null) {
            newGetter = new PropertyGetterDescriptorImpl(enhanced, getter2.getAnnotations(), getter2.getModality(), getter2.getVisibility(), getter2.isDefault(), getter2.isExternal(), getter2.isInline(), this.getKind(), getter2, getter2.getSource());
            newGetter.setInitialSignatureDescriptor(getter2.getInitialSignatureDescriptor());
            newGetter.initialize(enhancedReturnType);
        }
        PropertySetterDescriptorImpl newSetter = null;
        PropertySetterDescriptor setter2 = this.getSetter();
        if (setter2 != null) {
            newSetter = new PropertySetterDescriptorImpl(enhanced, setter2.getAnnotations(), setter2.getModality(), setter2.getVisibility(), setter2.isDefault(), setter2.isExternal(), setter2.isInline(), this.getKind(), setter2, setter2.getSource());
            newSetter.setInitialSignatureDescriptor(newSetter.getInitialSignatureDescriptor());
            newSetter.initialize(setter2.getValueParameters().get(0));
        }
        enhanced.initialize(newGetter, newSetter);
        enhanced.setSetterProjectedOut(this.isSetterProjectedOut());
        if (this.compileTimeInitializer != null) {
            enhanced.setCompileTimeInitializer(this.compileTimeInitializer);
        }
        enhanced.setOverriddenDescriptors(this.getOverriddenDescriptors());
        enhanced.setType(enhancedReturnType, this.getTypeParameters(), this.getDispatchReceiverParameter(), enhancedReceiverType);
        return enhanced;
    }

    @Override
    public boolean isConst() {
        KotlinType type2 = this.getType();
        return this.isStaticFinal && ConstUtil.canBeUsedForConstVal(type2) && (!TypeEnhancementKt.hasEnhancedNullability(type2) || KotlinBuiltIns.isString(type2));
    }
}

