/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaArrayType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaWildcardType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0018\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "", "()V", "mapAsmType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "context", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "parseClassOrTypeVariableElement", "signature", "Ljava/text/CharacterIterator;", "parseClassifierRefSignature", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "parseDimensions", "", "parseParameterizedClassRefSignature", "parsePrimitiveType", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "parseTypeParameter", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "parseTypeParametersDeclaration", "", "parseTypeString", "parseTypeVariableRefSignature", "parseTypeWithoutVarianceAndArray", "parseVariance", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "ClsFormatException", "JavaSignatureVariance", "frontend.java"})
public final class BinaryClassSignatureParser {
    @NotNull
    public final List<JavaTypeParameter> parseTypeParametersDeclaration(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(signature2, "signature");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (signature2.current() != '<') {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        ArrayList typeParameters2 = ContainerUtil.newArrayList();
        signature2.next();
        while (signature2.current() != '>') {
            typeParameters2.add(this.parseTypeParameter(signature2, context));
        }
        signature2.next();
        ArrayList arrayList = typeParameters2;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "typeParameters");
        return CollectionsKt.compact(arrayList);
    }

    private final JavaTypeParameter parseTypeParameter(CharacterIterator signature2, ClassifierResolutionContext context) {
        StringBuilder name2 = new StringBuilder();
        while (signature2.current() != ':' && signature2.current() != '\uffff') {
            name2.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw (Throwable)new ClsFormatException(null, null, 3, null);
        }
        String parameterName = name2.toString();
        List list2 = ContainerUtil.newSmartList();
        Intrinsics.checkExpressionValueIsNotNull(list2, "ContainerUtil.newSmartList()");
        List bounds = list2;
        while (signature2.current() == ':') {
            JavaClassifierType bound;
            signature2.next();
            if (this.parseClassifierRefSignature(signature2, context) == null) {
                continue;
            }
            bounds.add(bound);
        }
        Name name3 = Name.identifier(parameterName);
        Intrinsics.checkExpressionValueIsNotNull(name3, "Name.identifier(parameterName)");
        return new BinaryJavaTypeParameter(name3, bounds);
    }

    @Nullable
    public final JavaClassifierType parseClassifierRefSignature(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context) {
        JavaClassifierType javaClassifierType;
        Intrinsics.checkParameterIsNotNull(signature2, "signature");
        Intrinsics.checkParameterIsNotNull(context, "context");
        switch (signature2.current()) {
            case 'L': {
                javaClassifierType = this.parseParameterizedClassRefSignature(signature2, context);
                break;
            }
            case 'T': {
                javaClassifierType = this.parseTypeVariableRefSignature(signature2, context);
                break;
            }
            default: {
                javaClassifierType = null;
            }
        }
        return javaClassifierType;
    }

    private final JavaClassifierType parseTypeVariableRefSignature(CharacterIterator signature2, ClassifierResolutionContext context) {
        StringBuilder id = new StringBuilder();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '>' && signature2.current() != '\uffff') {
            id.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw (Throwable)new ClsFormatException(null, null, 3, null);
        }
        if (signature2.current() == ';') {
            signature2.next();
        }
        return new PlainJavaClassifierType(new Function0<ClassifierResolutionContext.Result>(context, id){
            final /* synthetic */ ClassifierResolutionContext $context;
            final /* synthetic */ StringBuilder $id;

            @NotNull
            public final ClassifierResolutionContext.Result invoke() {
                String string2 = this.$id.toString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "id.toString()");
                return this.$context.resolveTypeParameter$frontend_java(string2);
            }
            {
                this.$context = classifierResolutionContext;
                this.$id = stringBuilder;
                super(0);
            }
        }, kotlin.collections.CollectionsKt.emptyList());
    }

    private final JavaClassifierType parseParameterizedClassRefSignature(CharacterIterator signature2, ClassifierResolutionContext context) {
        StringBuilder canonicalName = new StringBuilder();
        List argumentGroups = ContainerUtil.newSmartList();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '\uffff') {
            char c = signature2.current();
            if (c == '<') {
                List group = new ArrayList();
                signature2.next();
                do {
                    group.add(this.parseClassOrTypeVariableElement(signature2, context));
                } while (signature2.current() != '>');
                argumentGroups.add(group);
            } else if (c != ' ') {
                canonicalName.append(c);
            }
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw (Throwable)new ClsFormatException(null, null, 3, null);
        }
        signature2.next();
        Function0 function0 = new Function0<ClassifierResolutionContext.Result>(context, canonicalName){
            final /* synthetic */ ClassifierResolutionContext $context;
            final /* synthetic */ StringBuilder $canonicalName;

            @NotNull
            public final ClassifierResolutionContext.Result invoke() {
                String string2 = this.$canonicalName.toString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "canonicalName.toString()");
                return this.$context.resolveByInternalName$frontend_java(string2);
            }
            {
                this.$context = classifierResolutionContext;
                this.$canonicalName = stringBuilder;
                super(0);
            }
        };
        List list2 = argumentGroups;
        Intrinsics.checkExpressionValueIsNotNull(list2, "argumentGroups");
        Iterable iterable = kotlin.collections.CollectionsKt.reversed(list2);
        Function0 function02 = function0;
        ArrayList arrayList = new ArrayList();
        List list3 = CollectionsKt.compact((ArrayList)AddToStdlibKt.flattenTo(iterable, (Collection)arrayList));
        Function0 function03 = function02;
        return new PlainJavaClassifierType(function03, list3);
    }

    private final JavaType parseClassOrTypeVariableElement(CharacterIterator signature2, ClassifierResolutionContext context) {
        JavaSignatureVariance variance = this.parseVariance(signature2);
        if (variance == JavaSignatureVariance.STAR) {
            return new PlainJavaWildcardType(null, true);
        }
        JavaType type2 = this.parseTypeString(signature2, context);
        if (variance == JavaSignatureVariance.NO_VARIANCE) {
            return type2;
        }
        return new PlainJavaWildcardType(type2, variance == JavaSignatureVariance.PLUS);
    }

    private final JavaSignatureVariance parseVariance(CharacterIterator signature2) {
        JavaSignatureVariance variance;
        boolean advance = true;
        switch (signature2.current()) {
            case '+': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.PLUS;
                break;
            }
            case '-': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.MINUS;
                break;
            }
            case '*': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.STAR;
                break;
            }
            case '.': 
            case '=': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.NO_VARIANCE;
                break;
            }
            default: {
                advance = false;
                JavaSignatureVariance javaSignatureVariance = variance = JavaSignatureVariance.NO_VARIANCE;
            }
        }
        if (advance) {
            signature2.next();
        }
        return variance;
    }

    private final int parseDimensions(CharacterIterator signature2) {
        int dimensions = 0;
        while (signature2.current() == '[') {
            ++dimensions;
            signature2.next();
        }
        return dimensions;
    }

    @NotNull
    public final JavaType parseTypeString(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(signature2, "signature");
        Intrinsics.checkParameterIsNotNull(context, "context");
        int dimensions = this.parseDimensions(signature2);
        JavaType javaType = this.parseTypeWithoutVarianceAndArray(signature2, context);
        if (javaType == null) {
            throw (Throwable)new ClsFormatException(null, null, 3, null);
        }
        JavaType type2 = javaType;
        int n = 1;
        Iterable $receiver$iv = new IntRange(n, dimensions);
        JavaType accumulator$iv = type2;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int n2 = element$iv = ((IntIterator)iterator2).nextInt();
            JavaType result2 = accumulator$iv;
            accumulator$iv = new PlainJavaArrayType(result2);
        }
        return accumulator$iv;
    }

    @NotNull
    public final JavaType mapAsmType(@NotNull Type type2, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return this.parseTypeString(new StringCharacterIterator(type2.getDescriptor()), context);
    }

    private final JavaType parseTypeWithoutVarianceAndArray(CharacterIterator signature2, ClassifierResolutionContext context) {
        JavaType javaType;
        switch (signature2.current()) {
            case 'L': {
                javaType = this.parseParameterizedClassRefSignature(signature2, context);
                break;
            }
            case 'T': {
                javaType = this.parseTypeVariableRefSignature(signature2, context);
                break;
            }
            case 'B': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.BYTE);
                break;
            }
            case 'C': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.CHAR);
                break;
            }
            case 'D': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.DOUBLE);
                break;
            }
            case 'F': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.FLOAT);
                break;
            }
            case 'I': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.INT);
                break;
            }
            case 'J': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.LONG);
                break;
            }
            case 'Z': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.BOOLEAN);
                break;
            }
            case 'S': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.SHORT);
                break;
            }
            case 'V': {
                javaType = this.parsePrimitiveType(signature2, null);
                break;
            }
            default: {
                javaType = null;
            }
        }
        return javaType;
    }

    private final JavaType parsePrimitiveType(CharacterIterator signature2, PrimitiveType primitiveType) {
        signature2.next();
        return new PlainJavaPrimitiveType(primitiveType);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "", "(Ljava/lang/String;I)V", "PLUS", "MINUS", "STAR", "NO_VARIANCE", "frontend.java"})
    private static final class JavaSignatureVariance
    extends Enum<JavaSignatureVariance> {
        public static final /* enum */ JavaSignatureVariance PLUS;
        public static final /* enum */ JavaSignatureVariance MINUS;
        public static final /* enum */ JavaSignatureVariance STAR;
        public static final /* enum */ JavaSignatureVariance NO_VARIANCE;
        private static final /* synthetic */ JavaSignatureVariance[] $VALUES;

        static {
            JavaSignatureVariance[] javaSignatureVarianceArray = new JavaSignatureVariance[4];
            JavaSignatureVariance[] javaSignatureVarianceArray2 = javaSignatureVarianceArray;
            javaSignatureVarianceArray[0] = PLUS = new JavaSignatureVariance();
            javaSignatureVarianceArray[1] = MINUS = new JavaSignatureVariance();
            javaSignatureVarianceArray[2] = STAR = new JavaSignatureVariance();
            javaSignatureVarianceArray[3] = NO_VARIANCE = new JavaSignatureVariance();
            $VALUES = javaSignatureVarianceArray;
        }

        public static JavaSignatureVariance[] values() {
            return (JavaSignatureVariance[])$VALUES.clone();
        }

        public static JavaSignatureVariance valueOf(String string2) {
            return Enum.valueOf(JavaSignatureVariance.class, string2);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$ClsFormatException;", "", "message", "", "cause", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "frontend.java"})
    public static final class ClsFormatException
    extends Throwable {
        public ClsFormatException(@Nullable String message, @Nullable Throwable cause) {
            super(message, cause);
        }

        public /* synthetic */ ClsFormatException(String string2, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string2, throwable);
        }

        public ClsFormatException() {
            this(null, null, 3, null);
        }
    }
}

