/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\"\u001a\u00020#H\u0016J\u0011\u0010$\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0003J\b\u0010'\u001a\u00020\u0003H\u0016J\"\u0010(\u001a\u00020\u0016*\u00020)2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030*2\u0006\u0010+\u001a\u00020\u001dH\u0002J\u001a\u0010,\u001a\u00020\u0016*\u00020)2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR.\u0010\u000b\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\fj\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0018\u0010\u0010\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts;", "", "packageFqName", "", "(Ljava/lang/String;)V", "metadataParts", "", "getMetadataParts", "()Ljava/util/Set;", "getPackageFqName", "()Ljava/lang/String;", "packageParts", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "parts", "getParts", "className", "getClassName", "(Ljava/lang/String;)Ljava/lang/String;", "packageName", "getPackageName", "addMetadataPart", "", "shortName", "addPart", "partInternalName", "facadeInternalName", "addTo", "builder", "Lorg/jetbrains/kotlin/metadata/jvm/JvmModuleProtoBuf$Module$Builder;", "equals", "", "other", "getMultifileFacadeName", "hashCode", "", "plusAssign", "removePart", "internalName", "toString", "writePartsOutsidePackage", "Lorg/jetbrains/kotlin/metadata/jvm/JvmModuleProtoBuf$PackageParts$Builder;", "", "packageTableBuilder", "writePartsWithinPackage", "metadata.jvm"})
public final class PackageParts {
    private final LinkedHashMap<String, String> packageParts;
    @NotNull
    private final Set<String> metadataParts;
    @NotNull
    private final String packageFqName;

    @NotNull
    public final Set<String> getParts() {
        Set<String> set2 = this.packageParts.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, "packageParts.keys");
        return set2;
    }

    @NotNull
    public final Set<String> getMetadataParts() {
        return this.metadataParts;
    }

    public final void addPart(@NotNull String partInternalName, @Nullable String facadeInternalName) {
        Intrinsics.checkParameterIsNotNull(partInternalName, "partInternalName");
        Map map2 = this.packageParts;
        String string2 = facadeInternalName;
        map2.put(partInternalName, string2);
    }

    public final void removePart(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull(internalName, "internalName");
        this.packageParts.remove(internalName);
    }

    public final void addMetadataPart(@NotNull String shortName) {
        Intrinsics.checkParameterIsNotNull(shortName, "shortName");
        Set<String> set2 = this.metadataParts;
        if (set2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
        }
        TypeIntrinsics.asMutableSet(set2).add(shortName);
    }

    /*
     * WARNING - void declaration
     */
    public final void addTo(@NotNull JvmModuleProtoBuf.Module.Builder builder) {
        Object object;
        Object $receiver;
        JvmModuleProtoBuf.Module.Builder builder2;
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        Object object2 = this.getParts();
        if (!object2.isEmpty()) {
            void partsWithinPackage;
            object2 = JvmModuleProtoBuf.PackageParts.newBuilder();
            builder2 = builder;
            $receiver = object2;
            ((JvmModuleProtoBuf.PackageParts.Builder)$receiver).setPackageFqName(this.packageFqName);
            String string2 = ((JvmModuleProtoBuf.PackageParts.Builder)$receiver).getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageFqName");
            String packageInternalName = StringsKt.replace$default(string2, '.', '/', false, 4, null);
            Iterable $receiver$iv = this.getParts();
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $receiver$iv) {
                String partInternalName = (String)element$iv;
                if (Intrinsics.areEqual(this.getPackageName(partInternalName), packageInternalName)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list2 = pair.component1();
            List partsOutsidePackage = pair.component2();
            this.writePartsWithinPackage((JvmModuleProtoBuf.PackageParts.Builder)$receiver, (List<String>)partsWithinPackage);
            this.writePartsOutsidePackage((JvmModuleProtoBuf.PackageParts.Builder)$receiver, partsOutsidePackage, builder);
            object = object2;
            builder2.addPackageParts((JvmModuleProtoBuf.PackageParts.Builder)object);
        }
        if (!(object2 = (Collection)this.metadataParts).isEmpty()) {
            object2 = JvmModuleProtoBuf.PackageParts.newBuilder();
            builder2 = builder;
            $receiver = object2;
            ((JvmModuleProtoBuf.PackageParts.Builder)$receiver).setPackageFqName(this.packageFqName);
            ((JvmModuleProtoBuf.PackageParts.Builder)$receiver).addAllShortClassName(CollectionsKt.sorted((Iterable)this.metadataParts));
            object = object2;
            builder2.addMetadataParts((JvmModuleProtoBuf.PackageParts.Builder)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writePartsWithinPackage(@NotNull JvmModuleProtoBuf.PackageParts.Builder $receiver, List<String> parts) {
        Object partInternalNames;
        String it;
        Object element$iv$iv;
        void $receiver$iv$iv;
        Map facadeNameToId = new LinkedHashMap();
        Object $receiver$iv = parts;
        Iterable iterable = $receiver$iv;
        Map.Entry destination$iv$iv = new LinkedHashMap();
        Iterator<Object> iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map.Entry $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = iterator2.next();
            it = (String)element$iv$iv;
            String key$iv$iv = this.getMultifileFacadeName(it);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object object = destination$iv$iv;
        Comparator comparator = ComparisonsKt.nullsLast(ComparisonsKt.naturalOrder());
        $receiver$iv = MapsKt.toSortedMap(object, comparator);
        Iterator<Object> iterator3 = $receiver$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry object2;
            destination$iv$iv = object2 = iterator3.next();
            String facadeInternalName = (String)destination$iv$iv.getKey();
            destination$iv$iv = object2;
            Object object3 = partInternalNames = (List)destination$iv$iv.getValue();
            Intrinsics.checkExpressionValueIsNotNull(object3, "partInternalNames");
            for (String partInternalName : CollectionsKt.sorted((Iterable)object3)) {
                Object object4;
                void key$iv;
                void $receiver$iv2;
                $receiver.addShortClassName(this.getClassName(partInternalName));
                if (facadeInternalName == null) continue;
                element$iv$iv = facadeNameToId;
                it = this.getClassName(facadeInternalName);
                int n = 1;
                object = $receiver;
                Object value$iv = $receiver$iv2.get(key$iv);
                if (value$iv == null) {
                    Integer answer$iv = facadeNameToId.size();
                    $receiver$iv2.put(key$iv, answer$iv);
                    object4 = answer$iv;
                } else {
                    object4 = value$iv;
                }
                Object v = object4;
                ((JvmModuleProtoBuf.PackageParts.Builder)object).addMultifileFacadeShortNameId(n + ((Number)v).intValue());
            }
        }
        partInternalNames = $receiver$iv = (Iterable)CollectionsKt.zip((Iterable)facadeNameToId.values(), facadeNameToId.keySet());
        Comparator comparator2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                T receiver = a;
                Comparable comparable = (Comparable)((Pair)receiver).getFirst();
                receiver = b;
                Comparable comparable2 = comparable;
                A a2 = ((Pair)receiver).getFirst();
                return ComparisonsKt.compareValues(comparable2, (Comparable)a2);
            }
        };
        for (Pair pair : CollectionsKt.sortedWith(partInternalNames, comparator2)) {
            boolean bl;
            int facadeId = ((Number)pair.component1()).intValue();
            String facadeName = (String)pair.component2();
            boolean bl2 = bl = facadeId == $receiver.getMultifileFacadeShortNameCount();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Multifile facades are loaded incorrectly: " + facadeNameToId;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            $receiver.addMultifileFacadeShortName(facadeName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writePartsOutsidePackage(@NotNull JvmModuleProtoBuf.PackageParts.Builder $receiver, List<String> parts, JvmModuleProtoBuf.Module.Builder packageTableBuilder) {
        Object list$iv$iv;
        Object key$iv$iv;
        void $receiver$iv$iv;
        List packageIds = new ArrayList();
        Object $receiver$iv = parts;
        Iterable iterable = $receiver$iv;
        Map.Entry destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map.Entry $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator2.next();
            String it = (String)element$iv$iv;
            key$iv$iv = this.getPackageName(it);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = MapsKt.toSortedMap(destination$iv$iv);
        Iterator iterator3 = $receiver$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            void $receiver$iv$iv2;
            Map.Entry entry;
            destination$iv$iv = entry = iterator3.next();
            String packageInternalName = (String)destination$iv$iv.getKey();
            destination$iv$iv = entry;
            List partsInPackage = (List)destination$iv$iv.getValue();
            String string2 = packageInternalName;
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageInternalName");
            String packageFqName = StringsKt.replace$default(string2, '/', '.', false, 4, null);
            if (!packageTableBuilder.getJvmPackageNameList().contains(packageFqName)) {
                packageTableBuilder.addJvmPackageName(packageFqName);
            }
            int packageId = packageTableBuilder.getJvmPackageNameList().indexOf(packageFqName);
            List list2 = partsInPackage;
            Intrinsics.checkExpressionValueIsNotNull(list2, "partsInPackage");
            Iterable $receiver$iv2 = list2;
            key$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                list$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                String string3 = this.getClassName((String)it);
                collection.add(string3);
            }
            for (String part : CollectionsKt.sorted((List)destination$iv$iv2)) {
                $receiver.addClassWithJvmPackageNameShortName(part);
                packageIds.add(packageId);
            }
        }
        while (packageIds.size() > 1 && ((Number)packageIds.get(packageIds.size() - 1)).intValue() == ((Number)packageIds.get(packageIds.size() - 2)).intValue()) {
            packageIds.remove(packageIds.size() - 1);
        }
        $receiver.addAllClassWithJvmPackageNamePackageId(packageIds);
    }

    private final String getPackageName(@NotNull String $receiver) {
        return StringsKt.substringBeforeLast($receiver, '/', "");
    }

    private final String getClassName(@NotNull String $receiver) {
        return StringsKt.substringAfterLast$default($receiver, '/', null, 2, null);
    }

    @Nullable
    public final String getMultifileFacadeName(@NotNull String partInternalName) {
        Intrinsics.checkParameterIsNotNull(partInternalName, "partInternalName");
        return this.packageParts.get(partInternalName);
    }

    /*
     * WARNING - void declaration
     */
    public final void plusAssign(@NotNull PackageParts other) {
        void $receiver$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull(other, "other");
        Map map2 = other.packageParts;
        Object object2 = map2.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3 = object = object2.next();
            String partInternalName = (String)object3.getKey();
            object3 = object;
            String facadeInternalName = (String)object3.getValue();
            this.addPart(partInternalName, facadeInternalName);
        }
        object = other.metadataParts;
        object2 = this;
        for (Object element$iv : $receiver$iv) {
            String p1 = (String)element$iv;
            ((PackageParts)object2).addMetadataPart(p1);
        }
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PackageParts && Intrinsics.areEqual(((PackageParts)other).packageFqName, this.packageFqName) && Intrinsics.areEqual(((PackageParts)other).packageParts, this.packageParts) && Intrinsics.areEqual(((PackageParts)other).metadataParts, this.metadataParts);
    }

    public int hashCode() {
        return (this.packageFqName.hashCode() * 31 + this.packageParts.hashCode()) * 31 + ((Object)this.metadataParts).hashCode();
    }

    @NotNull
    public String toString() {
        return SetsKt.plus(this.getParts(), (Iterable)this.metadataParts).toString();
    }

    @NotNull
    public final String getPackageFqName() {
        return this.packageFqName;
    }

    public PackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        this.packageFqName = packageFqName;
        PackageParts packageParts = this;
        Cloneable cloneable2 = new LinkedHashMap();
        packageParts.packageParts = cloneable2;
        packageParts = this;
        cloneable2 = new LinkedHashSet();
        packageParts.metadataParts = (Set)((Object)cloneable2);
    }
}

