/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0003J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/name/NameUtils;", "", "()V", "SANITIZE_AS_JAVA_INVALID_CHARACTERS", "Lkotlin/text/Regex;", "capitalizeAsJavaClassName", "", "str", "getPackagePartClassNamePrefix", "shortFileName", "getScriptNameForFile", "Lorg/jetbrains/kotlin/name/Name;", "filePath", "sanitizeAsJavaIdentifier", "name", "descriptors"})
public final class NameUtils {
    private static final Regex SANITIZE_AS_JAVA_INVALID_CHARACTERS;
    public static final NameUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final String sanitizeAsJavaIdentifier(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull(name2, "name");
        return SANITIZE_AS_JAVA_INVALID_CHARACTERS.replace((CharSequence)name2, "_");
    }

    @JvmStatic
    @NotNull
    public static final String getPackagePartClassNamePrefix(@NotNull String shortFileName) {
        Intrinsics.checkParameterIsNotNull(shortFileName, "shortFileName");
        CharSequence charSequence = shortFileName;
        return charSequence.length() == 0 ? "_" : NameUtils.capitalizeAsJavaClassName(NameUtils.sanitizeAsJavaIdentifier(shortFileName));
    }

    @JvmStatic
    private static final String capitalizeAsJavaClassName(String str) {
        String string2;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            String string3;
            String string4 = str;
            int n = 0;
            int n2 = 1;
            StringBuilder stringBuilder = new StringBuilder();
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string4 = string3 = string6;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull(locale, "Locale.ENGLISH");
            Locale locale2 = locale;
            String string7 = string4;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toUpperCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull(string8, "(this as java.lang.String).toUpperCase(locale)");
            string3 = string8;
            string4 = str;
            int n3 = 1;
            stringBuilder = stringBuilder.append(string3);
            String string9 = string4;
            if (string9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(n3);
            Intrinsics.checkExpressionValueIsNotNull(string10, "(this as java.lang.String).substring(startIndex)");
            string3 = string10;
            string2 = stringBuilder.append(string3).toString();
        } else {
            string2 = '_' + str;
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final Name getScriptNameForFile(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        Name name2 = Name.identifier(NameUtils.getPackagePartClassNamePrefix(StringsKt.substringBeforeLast$default(StringsKt.substringAfterLast$default(filePath, '/', null, 2, null), '.', null, 2, null)));
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(NameUtil\u2026ubstringBeforeLast('.')))");
        return name2;
    }

    private NameUtils() {
    }

    static {
        NameUtils nameUtils;
        INSTANCE = nameUtils = new NameUtils();
        String string2 = "[^\\p{L}\\p{Digit}]";
        SANITIZE_AS_JAVA_INVALID_CHARACTERS = new Regex(string2);
    }
}

