/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.transformations.AnnotationGenerator;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\f\u0010\u0015\u001a\u00020\u0014*\u00020\u0014H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/ConstantValueGenerator;", "", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "annotationGenerator", "Lorg/jetbrains/kotlin/psi2ir/transformations/AnnotationGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;Lorg/jetbrains/kotlin/psi2ir/transformations/AnnotationGenerator;)V", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/psi2ir/transformations/AnnotationGenerator;)V", "generateConstantValueAsExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "constantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getArrayElementType", "ir.psi2ir"})
public final class ConstantValueGenerator {
    private final ModuleDescriptor moduleDescriptor;
    private final SymbolTable symbolTable;
    private final AnnotationGenerator annotationGenerator;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateConstantValueAsExpression(int startOffset, int endOffset, @NotNull ConstantValue<?> constantValue, @Nullable KotlinType varargElementType) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull(constantValue, "constantValue");
        KotlinType constantType = constantValue.getType(this.moduleDescriptor);
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof StringValue) {
            irExpression = IrConstImpl.Companion.string(startOffset, endOffset, constantType, (String)((StringValue)constantValue).getValue());
        } else if (constantValue2 instanceof IntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((IntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof NullValue) {
            irExpression = IrConstImpl.Companion.constNull(startOffset, endOffset, constantType);
        } else if (constantValue2 instanceof BooleanValue) {
            irExpression = IrConstImpl.Companion.boolean(startOffset, endOffset, constantType, (Boolean)((BooleanValue)constantValue).getValue());
        } else if (constantValue2 instanceof LongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((LongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof DoubleValue) {
            irExpression = IrConstImpl.Companion.double(startOffset, endOffset, constantType, ((Number)((DoubleValue)constantValue).getValue()).doubleValue());
        } else if (constantValue2 instanceof FloatValue) {
            irExpression = IrConstImpl.Companion.float(startOffset, endOffset, constantType, ((Number)((FloatValue)constantValue).getValue()).floatValue());
        } else if (constantValue2 instanceof CharValue) {
            irExpression = IrConstImpl.Companion.char(startOffset, endOffset, constantType, ((Character)((CharValue)constantValue).getValue()).charValue());
        } else if (constantValue2 instanceof ByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((ByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof ShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((ShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof ArrayValue) {
            Collection<IrExpression> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            KotlinType kotlinType = varargElementType;
            if (kotlinType == null) {
                KotlinType kotlinType2 = this.getArrayElementType(constantType);
                kotlinType = kotlinType2;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "constantType.getArrayElementType()");
            }
            KotlinType arrayElementType = kotlinType;
            Iterable iterable = (Iterable)((ArrayValue)constantValue).getValue();
            KotlinType kotlinType3 = arrayElementType;
            KotlinType kotlinType4 = constantType;
            int n = endOffset;
            int n2 = startOffset;
            void var9_15 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ConstantValue constantValue3 = (ConstantValue)item$iv$iv;
                collection = destination$iv$iv;
                IrExpression irExpression2 = this.generateConstantValueAsExpression(startOffset, endOffset, (ConstantValue<?>)it, null);
                collection.add(irExpression2);
            }
            Collection<IrExpression> collection2 = collection = (List)destination$iv$iv;
            KotlinType kotlinType5 = kotlinType3;
            KotlinType kotlinType6 = kotlinType4;
            int n3 = n;
            int n4 = n2;
            irExpression = new IrVarargImpl(n4, n3, kotlinType6, kotlinType5, (List<? extends IrVarargElement>)collection2);
        } else if (constantValue2 instanceof EnumValue) {
            ClassifierDescriptor classifierDescriptor = constantType.getMemberScope().getContributedClassifier(((EnumValue)constantValue).getEnumEntryName(), NoLookupLocation.FROM_BACKEND);
            if (classifierDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No such enum entry " + ((EnumValue)constantValue).getEnumEntryName() + " in " + constantType)));
            }
            ClassifierDescriptor enumEntryDescriptor = classifierDescriptor;
            if (!(enumEntryDescriptor instanceof ClassDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)("Enum entry " + enumEntryDescriptor + " should be a ClassDescriptor")));
            }
            irExpression = new IrGetEnumValueImpl(startOffset, endOffset, constantType, this.symbolTable.referenceEnumEntry((ClassDescriptor)enumEntryDescriptor));
        } else if (constantValue2 instanceof AnnotationValue) {
            if (this.annotationGenerator == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected AnnotationValue: " + constantValue)));
            }
            irExpression = this.annotationGenerator.generateAnnotationConstructorCall((AnnotationDescriptor)((AnnotationValue)constantValue).getValue());
        } else {
            String string2 = "handle other literal values: " + Reflection.getOrCreateKotlinClass(constantValue.getClass()).getSimpleName();
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return irExpression;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IrExpression generateConstantValueAsExpression$default(ConstantValueGenerator constantValueGenerator, int n, int n2, ConstantValue constantValue, KotlinType kotlinType, int n3, Object object) {
        if ((n3 & 8) != 0) {
            kotlinType = null;
        }
        return constantValueGenerator.generateConstantValueAsExpression(n, n2, constantValue, kotlinType);
    }

    private final KotlinType getArrayElementType(@NotNull KotlinType $receiver) {
        return TypeUtilsKt.getBuiltIns($receiver).getArrayElementType($receiver);
    }

    public ConstantValueGenerator(@NotNull ModuleDescriptor moduleDescriptor, @NotNull SymbolTable symbolTable, @Nullable AnnotationGenerator annotationGenerator) {
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(symbolTable, "symbolTable");
        this.moduleDescriptor = moduleDescriptor;
        this.symbolTable = symbolTable;
        this.annotationGenerator = annotationGenerator;
    }

    public ConstantValueGenerator(@NotNull GeneratorContext context, @Nullable AnnotationGenerator annotationGenerator) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this(context.getModuleDescriptor(), context.getSymbolTable(), annotationGenerator);
    }

    public /* synthetic */ ConstantValueGenerator(GeneratorContext generatorContext, AnnotationGenerator annotationGenerator, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            annotationGenerator = null;
        }
        this(generatorContext, annotationGenerator);
    }
}

