/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u00020\u0004\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\b*\u00020\u0004\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0004*\u00020\u0004\u00a8\u0006\f"}, d2={"isInlineClass", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isInlineClassType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isNullableUnderlyingType", "substitutedUnderlyingType", "underlyingRepresentation", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "unsubstitutedUnderlyingParameter", "unsubstitutedUnderlyingType", "descriptors"})
public final class InlineClassesUtilsKt {
    @Nullable
    public static final ValueParameterDescriptor underlyingRepresentation(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!$receiver.isInline()) {
            return null;
        }
        Object object = $receiver.getUnsubstitutedPrimaryConstructor();
        return object != null && (object = object.getValueParameters()) != null ? (ValueParameterDescriptor)CollectionsKt.singleOrNull(object) : null;
    }

    public static final boolean isInlineClass(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof ClassDescriptor && ((ClassDescriptor)$receiver).isInline();
    }

    @Nullable
    public static final ValueParameterDescriptor unsubstitutedUnderlyingParameter(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor $receiver$iv = $receiver.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = $receiver$iv;
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        return classDescriptor != null ? InlineClassesUtilsKt.underlyingRepresentation(classDescriptor) : null;
    }

    @Nullable
    public static final KotlinType unsubstitutedUnderlyingType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ValueParameterDescriptor valueParameterDescriptor = InlineClassesUtilsKt.unsubstitutedUnderlyingParameter($receiver);
        return valueParameterDescriptor != null ? valueParameterDescriptor.getType() : null;
    }

    public static final boolean isInlineClassType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? InlineClassesUtilsKt.isInlineClass(classifierDescriptor) : false;
    }

    @Nullable
    public static final KotlinType substitutedUnderlyingType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ValueParameterDescriptor valueParameterDescriptor = InlineClassesUtilsKt.unsubstitutedUnderlyingParameter($receiver);
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        MemberScope memberScope2 = $receiver.getMemberScope();
        Name name2 = parameter.getName();
        Intrinsics.checkExpressionValueIsNotNull(name2, "parameter.name");
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)CollectionsKt.singleOrNull((Iterable)memberScope2.getContributedVariables(name2, NoLookupLocation.FOR_ALREADY_TRACKED));
        return propertyDescriptor != null ? propertyDescriptor.getType() : null;
    }

    public static final boolean isNullableUnderlyingType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!InlineClassesUtilsKt.isInlineClassType($receiver)) {
            return false;
        }
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType($receiver);
        if (kotlinType == null) {
            return false;
        }
        KotlinType underlyingType = kotlinType;
        return TypeUtils.isNullableType(underlyingType);
    }
}

