/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReceiver;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceCandidate;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferencesCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.components.CreateFreshVariablesSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.inference.components.FreshVariableNewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.tower.PrioritizedCompositeScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.SamePriorityCompositeScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.SimpleScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityError;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u001a0\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001aV\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\"\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006#"}, d2={"asReceiverValueForVisibilityChecks", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReceiver;", "getAsReceiverValueForVisibilityChecks", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReceiver;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "createCallableReferenceProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceCandidate;", "factory", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferencesCandidateFactory;", "getFunctionTypeFromCallableReferenceExpectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "expectedType", "addReceiverConstraint", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;", "toFreshSubstitutor", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/FreshVariableNewTypeSubstitutor;", "receiverArgument", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ArgumentConstraintPosition;", "checkCallableReference", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "dispatchReceiver", "extensionReceiver", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "reflectionCandidateType", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolution"})
public final class CallableReferenceResolutionKt {
    private static final ReceiverValue getAsReceiverValueForVisibilityChecks(@NotNull CallableReceiver $receiver) {
        return $receiver.getReceiver().getReceiverValue();
    }

    @NotNull
    public static final ScopeTowerProcessor<CallableReferenceCandidate> createCallableReferenceProcessor(@NotNull CallableReferencesCandidateFactory factory2) {
        LHSResult lhsResult;
        Intrinsics.checkParameterIsNotNull(factory2, "factory");
        LHSResult lHSResult = lhsResult = factory2.getArgument().getLhsResult();
        if (Intrinsics.areEqual(lHSResult, LHSResult.Empty.INSTANCE) || Intrinsics.areEqual(lHSResult, LHSResult.Error.INSTANCE) || lHSResult instanceof LHSResult.Expression) {
            Object object;
            LHSResult lHSResult2 = lhsResult;
            if (!(lHSResult2 instanceof LHSResult.Expression)) {
                lHSResult2 = null;
            }
            ReceiverValueWithSmartCastInfo explicitReceiver = (object = (LHSResult.Expression)lHSResult2) != null && (object = ((LHSResult.Expression)object).getLshCallArgument()) != null ? object.getReceiver() : null;
            return factory2.createCallableProcessor(explicitReceiver);
        }
        if (lHSResult instanceof LHSResult.Type) {
            SimpleScopeTowerProcessor<CallableReferenceCandidate> simpleScopeTowerProcessor = factory2.createCallableProcessor(((LHSResult.Type)lhsResult).getQualifier());
            SimpleScopeTowerProcessor<CallableReferenceCandidate> unbound = factory2.createCallableProcessor(((LHSResult.Type)lhsResult).getUnboundDetailedReceiver());
            SamePriorityCompositeScopeTowerProcessor staticOrUnbound = new SamePriorityCompositeScopeTowerProcessor(simpleScopeTowerProcessor, unbound);
            ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo = ((LHSResult.Type)lhsResult).getQualifier().getClassValueReceiverWithSmartCastInfo();
            if (receiverValueWithSmartCastInfo == null) {
                return staticOrUnbound;
            }
            ReceiverValueWithSmartCastInfo asValue = receiverValueWithSmartCastInfo;
            return new PrioritizedCompositeScopeTowerProcessor(staticOrUnbound, factory2.createCallableProcessor(asValue));
        }
        if (lHSResult instanceof LHSResult.Object) {
            SimpleScopeTowerProcessor<CallableReferenceCandidate> simpleScopeTowerProcessor = factory2.createCallableProcessor(((LHSResult.Object)lhsResult).getQualifier());
            SimpleScopeTowerProcessor<CallableReferenceCandidate> boundObjectReference = factory2.createCallableProcessor(((LHSResult.Object)lhsResult).getObjectValueReceiver());
            return new SamePriorityCompositeScopeTowerProcessor(simpleScopeTowerProcessor, boundObjectReference);
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final Pair<FreshVariableNewTypeSubstitutor, KotlinCallDiagnostic> checkCallableReference(@NotNull ConstraintSystemOperation $receiver, @NotNull CallableReferenceKotlinCallArgument argument, @Nullable CallableReceiver dispatchReceiver, @Nullable CallableReceiver extensionReceiver, @NotNull CallableDescriptor candidateDescriptor, @NotNull UnwrappedType reflectionCandidateType, @Nullable UnwrappedType expectedType, @NotNull DeclarationDescriptor ownerDescriptor) {
        VisibilityError visibilityError;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(candidateDescriptor, "candidateDescriptor");
        Intrinsics.checkParameterIsNotNull(reflectionCandidateType, "reflectionCandidateType");
        Intrinsics.checkParameterIsNotNull(ownerDescriptor, "ownerDescriptor");
        ArgumentConstraintPosition position = new ArgumentConstraintPosition(argument);
        FreshVariableNewTypeSubstitutor toFreshSubstitutor = CreateFreshVariablesSubstitutor.INSTANCE.createToFreshVariableSubstitutorAndAddInitialConstraints(candidateDescriptor, $receiver);
        if (expectedType != null) {
            $receiver.addSubtypeConstraint(toFreshSubstitutor.safeSubstitute(reflectionCandidateType), expectedType, position);
        }
        CallableReferenceResolutionKt.addReceiverConstraint($receiver, toFreshSubstitutor, dispatchReceiver, candidateDescriptor.getDispatchReceiverParameter(), position);
        CallableReferenceResolutionKt.addReceiverConstraint($receiver, toFreshSubstitutor, extensionReceiver, candidateDescriptor.getExtensionReceiverParameter(), position);
        CallableReceiver callableReceiver = dispatchReceiver;
        DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember(callableReceiver != null ? CallableReferenceResolutionKt.getAsReceiverValueForVisibilityChecks(callableReceiver) : null, candidateDescriptor, ownerDescriptor);
        FreshVariableNewTypeSubstitutor freshVariableNewTypeSubstitutor = toFreshSubstitutor;
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = invisibleMember;
        if (declarationDescriptorWithVisibility != null) {
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility2 = declarationDescriptorWithVisibility;
            FreshVariableNewTypeSubstitutor freshVariableNewTypeSubstitutor2 = freshVariableNewTypeSubstitutor;
            DeclarationDescriptorWithVisibility p1 = declarationDescriptorWithVisibility2;
            VisibilityError visibilityError2 = new VisibilityError(p1);
            freshVariableNewTypeSubstitutor = freshVariableNewTypeSubstitutor2;
            visibilityError = visibilityError2;
        } else {
            visibilityError = null;
        }
        return TuplesKt.to(freshVariableNewTypeSubstitutor, visibilityError);
    }

    private static final void addReceiverConstraint(@NotNull ConstraintSystemOperation $receiver, FreshVariableNewTypeSubstitutor toFreshSubstitutor, CallableReceiver receiverArgument, ReceiverParameterDescriptor receiverParameter, ArgumentConstraintPosition position) {
        if (receiverArgument == null || receiverParameter == null) {
            boolean bl;
            boolean bl2 = bl = receiverArgument == null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Receiver argument should be null if parameter is: " + receiverArgument;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            boolean bl3 = bl = receiverParameter == null;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Receiver parameter should be null if argument is: " + receiverParameter;
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            return;
        }
        ReceiverValue receiverValue = receiverParameter.getValue();
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "receiverParameter.value");
        UnwrappedType expectedType = toFreshSubstitutor.safeSubstitute(receiverValue.getType().unwrap());
        UnwrappedType receiverType = ArgumentsUtilsKt.getStableType(receiverArgument.getReceiver());
        $receiver.addSubtypeConstraint(receiverType, expectedType, position);
    }

    @Nullable
    public static final UnwrappedType getFunctionTypeFromCallableReferenceExpectedType(@Nullable UnwrappedType expectedType) {
        UnwrappedType unwrappedType;
        if (expectedType == null) {
            return null;
        }
        if (FunctionTypesKt.isFunctionType(expectedType)) {
            unwrappedType = expectedType;
        } else if (ReflectionTypes.Companion.isNumberedKFunction(expectedType)) {
            Object element$iv2;
            block6: {
                Iterable $receiver$iv = TypeUtilsKt.immediateSupertypes(expectedType);
                for (Object element$iv2 : $receiver$iv) {
                    KotlinType it = (KotlinType)element$iv2;
                    if (!FunctionTypesKt.isFunctionType(it)) continue;
                    break block6;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            unwrappedType = ((KotlinType)element$iv2).unwrap();
        } else {
            unwrappedType = null;
        }
        return unwrappedType;
    }

    @NotNull
    public static final /* synthetic */ ReceiverValue access$getAsReceiverValueForVisibilityChecks$p(@NotNull CallableReceiver $receiver) {
        return CallableReferenceResolutionKt.getAsReceiverValueForVisibilityChecks($receiver);
    }
}

