/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchImpl;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.scopes.receivers.CastImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class ResolvedCallImpl<D extends CallableDescriptor>
implements MutableResolvedCall<D> {
    private static final Logger LOG = Logger.getInstance(ResolvedCallImpl.class);
    private final Call call;
    private final D candidateDescriptor;
    private D resultingDescriptor;
    private final ReceiverValue dispatchReceiver;
    private ReceiverValue extensionReceiver;
    private final ExplicitReceiverKind explicitReceiverKind;
    private final TypeSubstitutor knownTypeParametersSubstitutor;
    @NotNull
    private final Map<TypeParameterDescriptor, KotlinType> typeArguments;
    @NotNull
    private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments;
    private final MutableDataFlowInfoForArguments dataFlowInfoForArguments;
    @NotNull
    private final Map<ValueArgument, ArgumentMatchImpl> argumentToParameterMap;
    private DelegatingBindingTrace trace;
    private TracingStrategy tracing;
    private ResolutionStatus status = ResolutionStatus.UNKNOWN_STATUS;
    private ConstraintSystem constraintSystem = null;
    private Boolean hasInferredReturnType = null;
    private boolean completed = false;
    private KotlinType smartCastDispatchReceiverType = null;
    private Queue<Function0<Unit>> remainingTasks = null;

    @NotNull
    public static <D extends CallableDescriptor> ResolvedCallImpl<D> create(@NotNull ResolutionCandidate<D> candidate2, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        return new ResolvedCallImpl<D>(candidate2, trace, tracing, dataFlowInfoForArguments);
    }

    private ResolvedCallImpl(@NotNull ResolutionCandidate<D> candidate2, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        this.call = candidate2.getCall();
        this.candidateDescriptor = candidate2.getDescriptor();
        this.dispatchReceiver = candidate2.getDispatchReceiver();
        this.extensionReceiver = null;
        this.explicitReceiverKind = candidate2.getExplicitReceiverKind();
        this.knownTypeParametersSubstitutor = candidate2.getKnownTypeParametersResultingSubstitutor();
        this.trace = trace;
        this.tracing = tracing;
        this.dataFlowInfoForArguments = dataFlowInfoForArguments;
        this.typeArguments = ResolvedCallImpl.createTypeArgumentsMap(this.candidateDescriptor);
        this.valueArguments = ResolvedCallImpl.createValueArgumentsMap(this.candidateDescriptor);
        this.argumentToParameterMap = ResolvedCallImpl.createArgumentsToParameterMap(this.candidateDescriptor);
    }

    public ResolvedCallImpl(@NotNull Call call2, @NotNull D candidateDescriptor, @Nullable ReceiverValue dispatchReceiver, @Nullable ReceiverValue extensionReceiver, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable TypeSubstitutor knownTypeParametersSubstitutor, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        this.call = call2;
        this.candidateDescriptor = candidateDescriptor;
        this.dispatchReceiver = dispatchReceiver;
        this.extensionReceiver = extensionReceiver;
        this.explicitReceiverKind = explicitReceiverKind;
        this.knownTypeParametersSubstitutor = knownTypeParametersSubstitutor;
        this.trace = trace;
        this.tracing = tracing;
        this.dataFlowInfoForArguments = dataFlowInfoForArguments;
        this.typeArguments = ResolvedCallImpl.createTypeArgumentsMap(candidateDescriptor);
        this.valueArguments = ResolvedCallImpl.createValueArgumentsMap(candidateDescriptor);
        this.argumentToParameterMap = ResolvedCallImpl.createArgumentsToParameterMap(candidateDescriptor);
    }

    @NotNull
    private static Map<ValueParameterDescriptor, ResolvedValueArgument> createValueArgumentsMap(CallableDescriptor descriptor2) {
        return descriptor2.getValueParameters().isEmpty() ? Collections.emptyMap() : Maps.newLinkedHashMap();
    }

    @NotNull
    private static Map<ValueArgument, ArgumentMatchImpl> createArgumentsToParameterMap(CallableDescriptor descriptor2) {
        return descriptor2.getValueParameters().isEmpty() ? Collections.emptyMap() : Maps.newHashMap();
    }

    @NotNull
    private static Map<TypeParameterDescriptor, KotlinType> createTypeArgumentsMap(CallableDescriptor descriptor2) {
        return descriptor2.getTypeParameters().isEmpty() ? Collections.emptyMap() : Maps.newLinkedHashMap();
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        return this.status;
    }

    @Override
    public void addStatus(@NotNull ResolutionStatus status2) {
        this.status = this.status.combine(status2);
    }

    @Override
    public void setStatusToSuccess() {
        assert (this.status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE || this.status == ResolutionStatus.UNKNOWN_STATUS);
        this.status = ResolutionStatus.SUCCESS;
    }

    @Override
    @NotNull
    public DelegatingBindingTrace getTrace() {
        this.assertNotCompleted("Trace");
        return this.trace;
    }

    @Override
    @NotNull
    public TracingStrategy getTracingStrategy() {
        this.assertNotCompleted("TracingStrategy");
        return this.tracing;
    }

    @Override
    @NotNull
    public Call getCall() {
        return this.call;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        return this.candidateDescriptor;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        return this.resultingDescriptor == null ? this.candidateDescriptor : this.resultingDescriptor;
    }

    @Override
    public void setResultingSubstitutor(@NotNull TypeSubstitutor substitutor2) {
        this.resultingDescriptor = (CallableDescriptor)this.candidateDescriptor.substitute(substitutor2);
        assert (this.resultingDescriptor != null) : this.candidateDescriptor;
        for (TypeParameterDescriptor typeParameter : this.candidateDescriptor.getTypeParameters()) {
            TypeProjection typeArgumentProjection = substitutor2.getSubstitution().get(typeParameter.getDefaultType());
            if (typeArgumentProjection == null) continue;
            this.typeArguments.put(typeParameter, typeArgumentProjection.getType());
        }
        if (this.candidateDescriptor.getValueParameters().isEmpty()) {
            return;
        }
        List<ValueParameterDescriptor> substitutedParameters = this.resultingDescriptor.getValueParameters();
        SmartList<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> valueArgumentsBeforeSubstitution = new SmartList<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>>((Collection<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>>)this.valueArguments.entrySet());
        this.valueArguments.clear();
        for (Map.Entry entry : valueArgumentsBeforeSubstitution) {
            ValueParameterDescriptor valueParameterDescriptor = substitutedParameters.get(((ValueParameterDescriptor)entry.getKey()).getIndex());
            assert (valueParameterDescriptor != null) : (ValueParameterDescriptor)entry.getKey();
            this.valueArguments.put(valueParameterDescriptor, (ResolvedValueArgument)entry.getValue());
        }
        SmartList<Map.Entry<ValueArgument, ArgumentMatchImpl>> unsubstitutedArgumentMappings = new SmartList<Map.Entry<ValueArgument, ArgumentMatchImpl>>((Collection<Map.Entry<ValueArgument, ArgumentMatchImpl>>)this.argumentToParameterMap.entrySet());
        this.argumentToParameterMap.clear();
        for (Map.Entry entry : unsubstitutedArgumentMappings) {
            ArgumentMatchImpl argumentMatch = (ArgumentMatchImpl)entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = argumentMatch.getValueParameter();
            ValueParameterDescriptor substitutedVersion = substitutedParameters.get(valueParameterDescriptor.getIndex());
            assert (substitutedVersion != null) : valueParameterDescriptor;
            this.argumentToParameterMap.put((ValueArgument)entry.getKey(), argumentMatch.replaceValueParameter(substitutedVersion));
        }
    }

    @Override
    public void setConstraintSystem(@NotNull ConstraintSystem constraintSystem) {
        this.constraintSystem = constraintSystem;
    }

    @Override
    @Nullable
    public ConstraintSystem getConstraintSystem() {
        this.assertNotCompleted("ConstraintSystem");
        return this.constraintSystem;
    }

    @Override
    public void recordValueArgument(@NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument valueArgument) {
        assert (!this.valueArguments.containsKey(valueParameter)) : valueParameter + " -> " + valueArgument;
        this.valueArguments.put(valueParameter, valueArgument);
        for (ValueArgument argument : valueArgument.getArguments()) {
            this.argumentToParameterMap.put(argument, new ArgumentMatchImpl(valueParameter));
        }
    }

    @Override
    @Nullable
    public ReceiverValue getExtensionReceiver() {
        return this.extensionReceiver;
    }

    @Override
    @Nullable
    public ReceiverValue getDispatchReceiver() {
        return this.dispatchReceiver;
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        return this.explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        return this.valueArguments;
    }

    @Override
    @Nullable
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        ArrayList<ResolvedValueArgument> arguments2 = new ArrayList<ResolvedValueArgument>(this.candidateDescriptor.getValueParameters().size());
        for (int i = 0; i < this.candidateDescriptor.getValueParameters().size(); ++i) {
            arguments2.add(null);
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : this.valueArguments.entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument value2 = entry.getValue();
            ResolvedValueArgument oldValue = arguments2.set(parameterDescriptor.getIndex(), value2);
            if (oldValue == null) continue;
            return null;
        }
        for (int i = 0; i < arguments2.size(); ++i) {
            Object o = arguments2.get(i);
            if (o != null) continue;
            return null;
        }
        return arguments2;
    }

    @Override
    public void recordArgumentMatchStatus(@NotNull ValueArgument valueArgument, @NotNull ArgumentMatchStatus matchStatus) {
        ArgumentMatchImpl argumentMatch = this.argumentToParameterMap.get(valueArgument);
        argumentMatch.recordMatchStatus(matchStatus);
    }

    @Override
    @NotNull
    public ArgumentMapping getArgumentMapping(@NotNull ValueArgument valueArgument) {
        ArgumentMatch argumentMatch = this.argumentToParameterMap.get(valueArgument);
        if (argumentMatch == null) {
            if (ArgumentMappingKt.isReallySuccess(this)) {
                LOG.error("ArgumentUnmapped for " + valueArgument + " in successfully resolved call: " + this.call.getCallElement().getText());
            }
            return ArgumentUnmapped.INSTANCE;
        }
        return argumentMatch;
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, KotlinType> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    @NotNull
    public MutableDataFlowInfoForArguments getDataFlowInfoForArguments() {
        return this.dataFlowInfoForArguments;
    }

    @Override
    public boolean hasInferredReturnType() {
        if (!this.completed) {
            this.hasInferredReturnType = this.constraintSystem == null || CallResolverUtilKt.hasInferredReturnType(this.candidateDescriptor, this.constraintSystem);
        }
        assert (this.hasInferredReturnType != null) : "The property 'hasInferredReturnType' was not set when the call was completed.";
        return this.hasInferredReturnType;
    }

    @Override
    public void markCallAsCompleted() {
        if (!this.completed) {
            this.hasInferredReturnType();
        }
        this.trace = null;
        this.constraintSystem = null;
        this.tracing = null;
        this.completed = true;
        this.remainingTasks = null;
    }

    @Override
    public void addRemainingTasks(Function0<Unit> task) {
        if (this.remainingTasks == null) {
            this.remainingTasks = new ArrayDeque<Function0<Unit>>();
        }
        this.remainingTasks.add(task);
    }

    @Override
    public void performRemainingTasks() {
        if (this.remainingTasks == null) {
            return;
        }
        while (!this.remainingTasks.isEmpty()) {
            this.remainingTasks.poll().invoke();
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    private void assertNotCompleted(String elementName) {
        assert (!this.completed) : elementName + " is erased after resolution completion.";
    }

    @Override
    @Nullable
    public TypeSubstitutor getKnownTypeParametersSubstitutor() {
        return this.knownTypeParametersSubstitutor;
    }

    @Override
    public void setSmartCastDispatchReceiverType(@NotNull KotlinType smartCastDispatchReceiverType) {
        this.smartCastDispatchReceiverType = smartCastDispatchReceiverType;
    }

    @Override
    @Nullable
    public KotlinType getSmartCastDispatchReceiverType() {
        return this.smartCastDispatchReceiverType;
    }

    @Override
    public void updateExtensionReceiverWithSmartCastIfNeeded(@NotNull KotlinType smartCastExtensionReceiverType) {
        if (this.extensionReceiver instanceof ImplicitClassReceiver) {
            this.extensionReceiver = new CastImplicitClassReceiver(((ImplicitClassReceiver)this.extensionReceiver).getClassDescriptor(), smartCastExtensionReceiverType);
        }
    }
}

