/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkJvmDefaultsInHierarchy", "", "enableJvmDefault", "frontend.java"})
public final class JvmDefaultChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        boolean bl;
        Object it;
        Object element$iv$iv;
        Iterable $receiver$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv;
        JvmDefaultMode jvmDefaultMode;
        block25: {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(context, "context");
            jvmDefaultMode = context.getLanguageVersionSettings().getFlag(AnalysisFlag.Flags.getJvmDefaultMode());
            AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(AnnotationUtilKt.getJVM_DEFAULT_FQ_NAME());
            if (annotationDescriptor != null) {
                KtElement reportOn;
                AnnotationDescriptor annotationDescriptor2;
                AnnotationDescriptor annotationDescriptor3 = annotationDescriptor2 = annotationDescriptor;
                KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor3);
                KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
                if (!DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                    context.getTrace().report(ErrorsJvm.JVM_DEFAULT_NOT_IN_INTERFACE.on(reportOn));
                } else if (this.jvmTarget == JvmTarget.JVM_1_6) {
                    context.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_JVM6_TARGET.on(reportOn));
                } else if (!jvmDefaultMode.isEnabled()) {
                    context.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtDeclaration)((PsiElement)declaration)));
                }
                return;
            }
            if (descriptor2 instanceof ClassDescriptor) {
                boolean hasDeclaredJvmDefaults;
                block24: {
                    boolean bl2;
                    Iterable reportOn = $receiver$iv = (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null);
                    destination$iv$iv = new ArrayList();
                    Iterator iterator2 = $receiver$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv$iv = iterator2.next();
                        if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            it = (CallableMemberDescriptor)element$iv;
                            CallableMemberDescriptor.Kind kind = it.getKind();
                            Intrinsics.checkExpressionValueIsNotNull((Object)kind, "it.kind");
                            if (!(kind.isReal() && AnnotationUtilKt.hasJvmDefaultAnnotation((CallableMemberDescriptor)it))) continue;
                            bl2 = true;
                            break block24;
                        }
                        bl2 = hasDeclaredJvmDefaults = false;
                    }
                }
                if (!hasDeclaredJvmDefaults && !this.checkJvmDefaultsInHierarchy(descriptor2, jvmDefaultMode.isEnabled())) {
                    context.getTrace().report(ErrorsJvm.JVM_DEFAULT_THROUGH_INHERITANCE.on((KtDeclaration)((PsiElement)declaration)));
                }
            }
            if (!DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                declarationDescriptor = null;
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
            if (callableMemberDescriptor == null) {
                return;
            }
            CallableMemberDescriptor memberDescriptor = callableMemberDescriptor;
            if (descriptor2 instanceof PropertyAccessorDescriptor) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = memberDescriptor.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, "memberDescriptor.overriddenDescriptors");
            $receiver$iv = collection;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    it = (CallableMemberDescriptor)element$iv;
                    if (!it.getAnnotations().hasAnnotation(AnnotationUtilKt.getJVM_DEFAULT_FQ_NAME())) continue;
                    bl = true;
                    break block25;
                }
                bl = false;
            }
        }
        if (bl) {
            context.getTrace().report(ErrorsJvm.JVM_DEFAULT_REQUIRED_FOR_OVERRIDE.on((KtDeclaration)((PsiElement)declaration)));
        } else if (jvmDefaultMode.isEnabled()) {
            Set set2;
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, "descriptor.overriddenDescriptors");
            $receiver$iv = collection;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            it = $receiver$iv$iv.iterator();
            while (it.hasNext()) {
                element$iv$iv = it.next();
                CallableMemberDescriptor it2 = (CallableMemberDescriptor)element$iv$iv;
                Set<CallableMemberDescriptor> set3 = OverridingUtil.getOverriddenDeclarations(it2);
                Intrinsics.checkExpressionValueIsNotNull(set3, "OverridingUtil.getOverriddenDeclarations(it)");
                Iterable list$iv$iv = set3;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Set it3 = set2 = CollectionsKt.toSet((List)destination$iv$iv);
            for (CallableMemberDescriptor realDescriptor : OverridingUtil.filterOutOverridden(it3)) {
                if (!(realDescriptor instanceof JavaMethodDescriptor) || ((JavaMethodDescriptor)realDescriptor).getModality() == Modality.ABSTRACT) continue;
                context.getTrace().report(ErrorsJvm.NON_JVM_DEFAULT_OVERRIDES_JAVA_DEFAULT.on((KtDeclaration)((PsiElement)declaration)));
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkJvmDefaultsInHierarchy(DeclarationDescriptor descriptor2, boolean enableJvmDefault) {
        boolean bl;
        void $receiver$iv$iv;
        if (enableJvmDefault) {
            return true;
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return true;
        }
        Iterable $receiver$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null);
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        object = $receiver$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)element$iv;
            CallableMemberDescriptor.Kind kind = memberDescriptor.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)kind, "memberDescriptor.kind");
            if (!kind.isReal()) {
                boolean bl2;
                Collection<? extends CallableMemberDescriptor> collection = memberDescriptor.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, "memberDescriptor.overriddenDescriptors");
                Set set2 = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((Iterable)collection));
                Intrinsics.checkExpressionValueIsNotNull(set2, "OverridingUtil.filterOut\u2026iddenDescriptors.toSet())");
                Iterable $receiver$iv2 = set2;
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $receiver$iv2) {
                        CallableMemberDescriptor it;
                        CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv2;
                        Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                        if (DescriptorUtils.isInterface(callableMemberDescriptor.getContainingDeclaration()) && AnnotationUtilKt.hasJvmDefaultAnnotation(it)) {
                            if (it.getModality() != Modality.ABSTRACT) return false;
                        }
                        boolean bl3 = true;
                        if (bl3) continue;
                        return false;
                    }
                    bl2 = true;
                }
                if (!bl2) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public JvmDefaultChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkParameterIsNotNull(jvmTarget, "jvmTarget");
        this.jvmTarget = jvmTarget;
    }
}

