/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.modules;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiStatement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00102\u00020\u0001:\u0003\u0010\u0011\u0012B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "", "moduleName", "", "requires", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Requires;", "exports", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Exports;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getExports", "()Ljava/util/List;", "getModuleName", "()Ljava/lang/String;", "getRequires", "toString", "Companion", "Exports", "Requires", "frontend.java"})
public final class JavaModuleInfo {
    @NotNull
    private final String moduleName;
    @NotNull
    private final List<Requires> requires;
    @NotNull
    private final List<Exports> exports;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        return "Module " + this.moduleName + " (" + this.requires.size() + " requires, " + this.exports.size() + " exports)";
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final List<Requires> getRequires() {
        return this.requires;
    }

    @NotNull
    public final List<Exports> getExports() {
        return this.exports;
    }

    public JavaModuleInfo(@NotNull String moduleName, @NotNull List<Requires> requires, @NotNull List<Exports> exports) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(requires, "requires");
        Intrinsics.checkParameterIsNotNull(exports, "exports");
        this.moduleName = moduleName;
        this.requires = requires;
        this.exports = exports;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Requires;", "", "moduleName", "", "isTransitive", "", "(Ljava/lang/String;Z)V", "()Z", "getModuleName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "frontend.java"})
    public static final class Requires {
        @NotNull
        private final String moduleName;
        private final boolean isTransitive;

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        public final boolean isTransitive() {
            return this.isTransitive;
        }

        public Requires(@NotNull String moduleName, boolean isTransitive) {
            Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
            this.moduleName = moduleName;
            this.isTransitive = isTransitive;
        }

        @NotNull
        public final String component1() {
            return this.moduleName;
        }

        public final boolean component2() {
            return this.isTransitive;
        }

        @NotNull
        public final Requires copy(@NotNull String moduleName, boolean isTransitive) {
            Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
            return new Requires(moduleName, isTransitive);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Requires copy$default(Requires requires, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = requires.moduleName;
            }
            if ((n & 2) != 0) {
                bl = requires.isTransitive;
            }
            return requires.copy(string2, bl);
        }

        public String toString() {
            return "Requires(moduleName=" + this.moduleName + ", isTransitive=" + this.isTransitive + ")";
        }

        public int hashCode() {
            String string2 = this.moduleName;
            int n = (string2 != null ? string2.hashCode() : 0) * 31;
            int n2 = this.isTransitive ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Requires)) break block3;
                    Requires requires = (Requires)object;
                    if (!Intrinsics.areEqual(this.moduleName, requires.moduleName) || !(this.isTransitive == requires.isTransitive)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Exports;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "toModules", "", "", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getToModules", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "frontend.java"})
    public static final class Exports {
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final List<String> toModules;

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final List<String> getToModules() {
            return this.toModules;
        }

        public Exports(@NotNull FqName packageFqName, @NotNull List<String> toModules) {
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            Intrinsics.checkParameterIsNotNull(toModules, "toModules");
            this.packageFqName = packageFqName;
            this.toModules = toModules;
        }

        @NotNull
        public final FqName component1() {
            return this.packageFqName;
        }

        @NotNull
        public final List<String> component2() {
            return this.toModules;
        }

        @NotNull
        public final Exports copy(@NotNull FqName packageFqName, @NotNull List<String> toModules) {
            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
            Intrinsics.checkParameterIsNotNull(toModules, "toModules");
            return new Exports(packageFqName, toModules);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Exports copy$default(Exports exports, FqName fqName2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = exports.packageFqName;
            }
            if ((n & 2) != 0) {
                list2 = exports.toModules;
            }
            return exports.copy(fqName2, list2);
        }

        public String toString() {
            return "Exports(packageFqName=" + this.packageFqName + ", toModules=" + this.toModules + ")";
        }

        public int hashCode() {
            FqName fqName2 = this.packageFqName;
            List<String> list2 = this.toModules;
            return (fqName2 != null ? ((Object)fqName2).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Exports)) break block3;
                    Exports exports = (Exports)object;
                    if (!Intrinsics.areEqual(this.packageFqName, exports.packageFqName) || !Intrinsics.areEqual(this.toModules, exports.toModules)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "psiJavaModule", "Lcom/intellij/psi/PsiJavaModule;", "read", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "frontend.java"})
    public static final class Companion {
        @NotNull
        public final JavaModuleInfo create(@NotNull PsiJavaModule psiJavaModule) {
            List list2;
            Object it$iv$iv;
            Object object;
            String string2;
            PsiStatement statement2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable<PsiPackageAccessibilityStatement> $receiver$iv$iv;
            Iterable<PsiPackageAccessibilityStatement> $receiver$iv;
            Intrinsics.checkParameterIsNotNull(psiJavaModule, "psiJavaModule");
            String string3 = psiJavaModule.getName();
            Intrinsics.checkExpressionValueIsNotNull(string3, "psiJavaModule.name");
            Iterable<PsiRequiresStatement> iterable = psiJavaModule.getRequires();
            Intrinsics.checkExpressionValueIsNotNull(iterable, "psiJavaModule.requires");
            Iterable<PsiRequiresStatement> iterable2 = iterable;
            String string4 = string3;
            void var3_4 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterable<PsiPackageAccessibilityStatement> $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator<Object> iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Requires requires;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                statement2 = (PsiRequiresStatement)element$iv$iv;
                PsiRequiresStatement psiRequiresStatement = statement2;
                Intrinsics.checkExpressionValueIsNotNull(psiRequiresStatement, "statement");
                if (psiRequiresStatement.getModuleName() != null) {
                    String moduleName;
                    String string5 = moduleName = string2;
                    Intrinsics.checkExpressionValueIsNotNull(string5, "moduleName");
                    requires = new Requires(string5, statement2.hasModifierProperty("transitive"));
                } else {
                    requires = null;
                }
                if (requires == null) continue;
                it$iv$iv = object = requires;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            Iterable<PsiPackageAccessibilityStatement> iterable3 = psiJavaModule.getExports();
            Intrinsics.checkExpressionValueIsNotNull(iterable3, "psiJavaModule.exports");
            $receiver$iv$iv = $receiver$iv = iterable3;
            destination$iv$iv = new ArrayList();
            $receiver$iv$iv$iv = $receiver$iv$iv;
            iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Exports exports;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                PsiStatement psiStatement = statement2 = (PsiPackageAccessibilityStatement)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull(psiStatement, "statement");
                if (psiStatement.getPackageName() != null) {
                    String packageName = string2;
                    FqName fqName2 = new FqName(packageName);
                    List<String> list4 = statement2.getModuleNames();
                    Intrinsics.checkExpressionValueIsNotNull(list4, "statement.moduleNames");
                    exports = new Exports(fqName2, list4);
                } else {
                    exports = null;
                }
                if (exports == null) continue;
                it$iv$iv = object = exports;
                destination$iv$iv.add(it$iv$iv);
            }
            List list5 = list2 = (List)destination$iv$iv;
            List list6 = list3;
            String string6 = string4;
            return new JavaModuleInfo(string6, list6, list5);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final JavaModuleInfo read(@NotNull VirtualFile file2) {
            JavaModuleInfo javaModuleInfo;
            void moduleName;
            Object object;
            Intrinsics.checkParameterIsNotNull(file2, "file");
            try {
                object = file2.contentsToByteArray();
            }
            catch (IOException e) {
                return null;
            }
            byte[] contents = object;
            object = new Ref.ObjectRef();
            object.element = null;
            ArrayList requires = new ArrayList();
            ArrayList exports = new ArrayList();
            new ClassReader(contents).accept(new ClassVisitor((Ref.ObjectRef)moduleName, requires, exports, 393216){
                final /* synthetic */ Ref.ObjectRef $moduleName;
                final /* synthetic */ ArrayList $requires;
                final /* synthetic */ ArrayList $exports;

                @NotNull
                public ModuleVisitor visitModule(@NotNull String name2, int access, @Nullable String version) {
                    Intrinsics.checkParameterIsNotNull(name2, "name");
                    this.$moduleName.element = name2;
                    return new ModuleVisitor(this, 393216){
                        final /* synthetic */ read.1 this$0;

                        public void visitRequire(@NotNull String module2, int access, @Nullable String version) {
                            Intrinsics.checkParameterIsNotNull(module2, "module");
                            this.this$0.$requires.add(new Requires(module2, (access & 0x20) != 0));
                        }

                        public void visitExport(@NotNull String packageFqName, int access, @Nullable String[] modules) {
                            List<String> list2;
                            Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
                            List<String> list3 = modules != null ? ArraysKt.toList(modules) : null;
                            FqName fqName2 = new FqName(StringsKt.replace$default(packageFqName, '/', '.', false, 4, null));
                            ArrayList arrayList = this.this$0.$exports;
                            List<String> list4 = list3;
                            if (list4 == null) {
                                list4 = kotlin.collections.CollectionsKt.emptyList();
                            }
                            List<String> list5 = list2 = list4;
                            FqName fqName3 = fqName2;
                            arrayList.add(new Exports(fqName3, list5));
                        }
                        {
                            this.this$0 = $outer;
                            super($super_call_param$1);
                        }
                    };
                }
                {
                    this.$moduleName = $captured_local_variable$0;
                    this.$requires = $captured_local_variable$1;
                    this.$exports = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            }, 7);
            if ((String)moduleName.element != null) {
                String string2 = (String)moduleName.element;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                javaModuleInfo = new JavaModuleInfo(string2, CollectionsKt.compact(requires), CollectionsKt.compact(exports));
            } else {
                javaModuleInfo = null;
            }
            return javaModuleInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

