/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.InvocationKind;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.serialization.ContractSerializer$ContractSerializerWorker$WhenMappings;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/serialization/ContractSerializer;", "", "()V", "serializeContractOfFunctionIfAny", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "parentSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "ContractSerializerWorker", "serialization"})
public final class ContractSerializer {
    public final void serializeContractOfFunctionIfAny(@NotNull FunctionDescriptor functionDescriptor, @NotNull ProtoBuf.Function.Builder proto, @NotNull DescriptorSerializer parentSerializer) {
        ContractDescription contractDescription;
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(parentSerializer, "parentSerializer");
        LazyContractProvider lazyContractProvider = (LazyContractProvider)functionDescriptor.getUserData(ContractProviderKey.INSTANCE);
        ContractDescription contractDescription2 = contractDescription = lazyContractProvider != null ? lazyContractProvider.getContractDescription() : null;
        if (contractDescription != null) {
            ContractSerializerWorker worker = new ContractSerializerWorker(parentSerializer);
            proto.setContract(worker.contractProto(contractDescription));
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/serialization/ContractSerializer$ContractSerializerWorker;", "", "parentSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "(Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;)V", "constantValueProtobufEnum", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "contractExpressionProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$Builder;", "contractDescriptionElement", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionElement;", "contractDescription", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "contractProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract$Builder;", "effectProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$Builder;", "effectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "fillEffectProto", "", "builder", "invocationKindProtobufEnum", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "kind", "Lorg/jetbrains/kotlin/contracts/description/InvocationKind;", "writeFlags", "newFlagsValue", "", "serialization"})
    private static final class ContractSerializerWorker {
        private final DescriptorSerializer parentSerializer;

        @NotNull
        public final ProtoBuf.Contract.Builder contractProto(@NotNull ContractDescription contractDescription) {
            ProtoBuf.Contract.Builder builder;
            Intrinsics.checkParameterIsNotNull(contractDescription, "contractDescription");
            ProtoBuf.Contract.Builder $receiver = builder = ProtoBuf.Contract.newBuilder();
            Iterable $receiver$iv = contractDescription.getEffects();
            for (Object element$iv : $receiver$iv) {
                EffectDeclaration it = (EffectDeclaration)element$iv;
                $receiver.addEffect(this.effectProto(it, contractDescription));
            }
            ProtoBuf.Contract.Builder builder2 = builder;
            Intrinsics.checkExpressionValueIsNotNull(builder2, "ProtoBuf.Contract.newBui\u2026ription)) }\n            }");
            return builder2;
        }

        private final ProtoBuf.Effect.Builder effectProto(EffectDeclaration effectDeclaration, ContractDescription contractDescription) {
            ProtoBuf.Effect.Builder builder;
            ProtoBuf.Effect.Builder $receiver;
            ProtoBuf.Effect.Builder builder2 = $receiver = (builder = ProtoBuf.Effect.newBuilder());
            Intrinsics.checkExpressionValueIsNotNull(builder2, "this");
            this.fillEffectProto(builder2, effectDeclaration, contractDescription);
            ProtoBuf.Effect.Builder builder3 = builder;
            Intrinsics.checkExpressionValueIsNotNull(builder3, "ProtoBuf.Effect.newBuild\u2026escription)\n            }");
            return builder3;
        }

        private final void fillEffectProto(ProtoBuf.Effect.Builder builder, EffectDeclaration effectDeclaration, ContractDescription contractDescription) {
            EffectDeclaration effectDeclaration2 = effectDeclaration;
            if (effectDeclaration2 instanceof ConditionalEffectDeclaration) {
                builder.setConclusionOfConditionalEffect(this.contractExpressionProto(((ConditionalEffectDeclaration)effectDeclaration).getCondition(), contractDescription));
                this.fillEffectProto(builder, ((ConditionalEffectDeclaration)effectDeclaration).getEffect(), contractDescription);
            } else if (effectDeclaration2 instanceof ReturnsEffectDeclaration) {
                if (Intrinsics.areEqual(((ReturnsEffectDeclaration)effectDeclaration).getValue(), ConstantReference.Companion.getNOT_NULL())) {
                    builder.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_NOT_NULL);
                } else if (Intrinsics.areEqual(((ReturnsEffectDeclaration)effectDeclaration).getValue(), ConstantReference.Companion.getWILDCARD())) {
                    builder.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                } else {
                    builder.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                    builder.addEffectConstructorArgument(this.contractExpressionProto(((ReturnsEffectDeclaration)effectDeclaration).getValue(), contractDescription));
                }
            } else if (effectDeclaration2 instanceof CallsEffectDeclaration) {
                builder.setEffectType(ProtoBuf.Effect.EffectType.CALLS);
                builder.addEffectConstructorArgument(this.contractExpressionProto(((CallsEffectDeclaration)effectDeclaration).getVariableReference(), contractDescription));
                ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum = this.invocationKindProtobufEnum(((CallsEffectDeclaration)effectDeclaration).getKind());
                if (invocationKindProtobufEnum != null) {
                    builder.setKind(invocationKindProtobufEnum);
                }
            }
        }

        private final ProtoBuf.Expression.Builder contractExpressionProto(ContractDescriptionElement contractDescriptionElement, ContractDescription contractDescription) {
            return (ProtoBuf.Expression.Builder)contractDescriptionElement.accept((ContractDescriptionVisitor)new ContractDescriptionVisitor<ProtoBuf.Expression.Builder, Unit>(this, contractDescription){
                final /* synthetic */ ContractSerializerWorker this$0;
                final /* synthetic */ ContractDescription $contractDescription;

                @NotNull
                public ProtoBuf.Expression.Builder visitLogicalOr(@NotNull LogicalOr logicalOr, @NotNull Unit data2) {
                    ProtoBuf.Expression.Builder builder;
                    Intrinsics.checkParameterIsNotNull(logicalOr, "logicalOr");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalOr.getLeft().accept(this, data2);
                    if (leftBuilder.getAndArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder2;
                        ProtoBuf.Expression.Builder $receiver = builder2 = ProtoBuf.Expression.newBuilder();
                        $receiver.addOrArgument(leftBuilder);
                        $receiver.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(this.this$0, logicalOr.getRight(), this.$contractDescription));
                        ProtoBuf.Expression.Builder builder3 = builder2;
                        builder = builder3;
                        Intrinsics.checkExpressionValueIsNotNull(builder3, "ProtoBuf.Expression.newB\u2026                        }");
                    } else {
                        ProtoBuf.Expression.Builder builder4;
                        ProtoBuf.Expression.Builder $receiver = builder4 = leftBuilder;
                        $receiver.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(this.this$0, logicalOr.getRight(), this.$contractDescription));
                        builder = builder4;
                    }
                    return builder;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitLogicalAnd(@NotNull LogicalAnd logicalAnd, @NotNull Unit data2) {
                    ProtoBuf.Expression.Builder builder;
                    Intrinsics.checkParameterIsNotNull(logicalAnd, "logicalAnd");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalAnd.getLeft().accept(this, data2);
                    if (leftBuilder.getOrArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder2;
                        ProtoBuf.Expression.Builder $receiver = builder2 = ProtoBuf.Expression.newBuilder();
                        $receiver.addAndArgument(leftBuilder);
                        $receiver.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(this.this$0, logicalAnd.getRight(), this.$contractDescription));
                        ProtoBuf.Expression.Builder builder3 = builder2;
                        builder = builder3;
                        Intrinsics.checkExpressionValueIsNotNull(builder3, "ProtoBuf.Expression.newB\u2026                        }");
                    } else {
                        ProtoBuf.Expression.Builder builder4;
                        ProtoBuf.Expression.Builder $receiver = builder4 = leftBuilder;
                        $receiver.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(this.this$0, logicalAnd.getRight(), this.$contractDescription));
                        builder = builder4;
                    }
                    return builder;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitLogicalNot(@NotNull LogicalNot logicalNot, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(logicalNot, "logicalNot");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    R r = logicalNot.getArg().accept(this, data2);
                    ProtoBuf.Expression.Builder $receiver = (ProtoBuf.Expression.Builder)r;
                    ContractSerializerWorker.access$writeFlags(this.this$0, $receiver, Flags.IS_NEGATED.invert($receiver.getFlags()));
                    return (ProtoBuf.Expression.Builder)r;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitIsInstancePredicate(@NotNull IsInstancePredicate isInstancePredicate, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(isInstancePredicate, "isInstancePredicate");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    ProtoBuf.Expression.Builder builder = this.visitVariableReference(isInstancePredicate.getArg(), data2);
                    builder.setIsInstanceTypeId(ContractSerializerWorker.access$getParentSerializer$p(this.this$0).typeId$serialization(isInstancePredicate.getType()));
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder, Flags.getContractExpressionFlags(isInstancePredicate.isNegated(), false));
                    return builder;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitIsNullPredicate(@NotNull IsNullPredicate isNullPredicate, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(isNullPredicate, "isNullPredicate");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    ProtoBuf.Expression.Builder builder = this.visitVariableReference(isNullPredicate.getArg(), data2);
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder, Flags.getContractExpressionFlags(isNullPredicate.isNegated(), true));
                    return builder;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitConstantDescriptor(@NotNull ConstantReference constantReference, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(constantReference, "constantReference");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    ProtoBuf.Expression.Builder builder = ProtoBuf.Expression.newBuilder();
                    ProtoBuf.Expression.ConstantValue constantValueProtobufEnum = ContractSerializerWorker.access$constantValueProtobufEnum(this.this$0, constantReference);
                    if (constantValueProtobufEnum != null) {
                        ProtoBuf.Expression.Builder builder2 = builder;
                        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
                        builder2.setConstantValue(constantValueProtobufEnum);
                    }
                    ProtoBuf.Expression.Builder builder3 = builder;
                    Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
                    return builder3;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitVariableReference(@NotNull VariableReference variableReference, @NotNull Unit data2) {
                    Integer n;
                    ParameterDescriptor descriptor2;
                    Intrinsics.checkParameterIsNotNull(variableReference, "variableReference");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    ProtoBuf.Expression.Builder builder = ProtoBuf.Expression.newBuilder();
                    ParameterDescriptor parameterDescriptor = descriptor2 = variableReference.getDescriptor();
                    if (parameterDescriptor instanceof ReceiverParameterDescriptor) {
                        n = 0;
                    } else if (parameterDescriptor instanceof ValueParameterDescriptor) {
                        Integer n2 = this.$contractDescription.getOwnerFunction().getValueParameters().indexOf(descriptor2);
                        int it = ((Number)n2).intValue();
                        Integer n3 = it != -1 ? n2 : null;
                        n = n3 != null ? Integer.valueOf(n3 + 1) : null;
                    } else {
                        n = null;
                    }
                    Integer indexOfParameter = n;
                    ProtoBuf.Expression.Builder builder2 = builder;
                    Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
                    Integer n4 = indexOfParameter;
                    if (n4 == null) {
                        return builder;
                    }
                    builder2.setValueParameterReference(n4);
                    return builder;
                }
                {
                    this.this$0 = $outer;
                    this.$contractDescription = $captured_local_variable$1;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitBooleanConstantDescriptor(@NotNull BooleanConstantReference booleanConstantDescriptor, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(booleanConstantDescriptor, "booleanConstantDescriptor");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    return ContractDescriptionVisitor.DefaultImpls.visitBooleanConstantDescriptor(this, booleanConstantDescriptor, data2);
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitBooleanExpression(@NotNull BooleanExpression booleanExpression, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(booleanExpression, "booleanExpression");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    return ContractDescriptionVisitor.DefaultImpls.visitBooleanExpression(this, booleanExpression, data2);
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitBooleanVariableReference(@NotNull BooleanVariableReference booleanVariableReference, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(booleanVariableReference, "booleanVariableReference");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    return ContractDescriptionVisitor.DefaultImpls.visitBooleanVariableReference(this, booleanVariableReference, data2);
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitCallsEffectDeclaration(@NotNull CallsEffectDeclaration callsEffect, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(callsEffect, "callsEffect");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    return ContractDescriptionVisitor.DefaultImpls.visitCallsEffectDeclaration(this, callsEffect, data2);
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitConditionalEffectDeclaration(@NotNull ConditionalEffectDeclaration conditionalEffect, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(conditionalEffect, "conditionalEffect");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    return ContractDescriptionVisitor.DefaultImpls.visitConditionalEffectDeclaration(this, conditionalEffect, data2);
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitContractDescriptionElement(@NotNull ContractDescriptionElement contractDescriptionElement, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(contractDescriptionElement, "contractDescriptionElement");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    return ContractDescriptionVisitor.DefaultImpls.visitContractDescriptionElement(this, contractDescriptionElement, data2);
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitEffectDeclaration(@NotNull EffectDeclaration effectDeclaration, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(effectDeclaration, "effectDeclaration");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    return ContractDescriptionVisitor.DefaultImpls.visitEffectDeclaration(this, effectDeclaration, data2);
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitReturnsEffectDeclaration(@NotNull ReturnsEffectDeclaration returnsEffect, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(returnsEffect, "returnsEffect");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    return ContractDescriptionVisitor.DefaultImpls.visitReturnsEffectDeclaration(this, returnsEffect, data2);
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitValue(@NotNull ContractDescriptionValue value2, @NotNull Unit data2) {
                    Intrinsics.checkParameterIsNotNull(value2, "value");
                    Intrinsics.checkParameterIsNotNull(data2, "data");
                    return ContractDescriptionVisitor.DefaultImpls.visitValue(this, value2, data2);
                }
            }, Unit.INSTANCE);
        }

        private final void writeFlags(@NotNull ProtoBuf.Expression.Builder $receiver, int newFlagsValue) {
            if ($receiver.getFlags() != newFlagsValue) {
                $receiver.setFlags(newFlagsValue);
            }
        }

        private final ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum(InvocationKind kind) {
            ProtoBuf.Effect.InvocationKind invocationKind;
            switch (ContractSerializer$ContractSerializerWorker$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_MOST_ONCE;
                    break;
                }
                case 2: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.EXACTLY_ONCE;
                    break;
                }
                case 3: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_LEAST_ONCE;
                    break;
                }
                case 4: {
                    invocationKind = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return invocationKind;
        }

        private final ProtoBuf.Expression.ConstantValue constantValueProtobufEnum(ConstantReference constantReference) {
            ProtoBuf.Expression.ConstantValue constantValue;
            ConstantReference constantReference2 = constantReference;
            if (Intrinsics.areEqual(constantReference2, BooleanConstantReference.Companion.getTRUE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.TRUE;
            } else if (Intrinsics.areEqual(constantReference2, BooleanConstantReference.Companion.getFALSE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.FALSE;
            } else if (Intrinsics.areEqual(constantReference2, ConstantReference.Companion.getNULL())) {
                constantValue = ProtoBuf.Expression.ConstantValue.NULL;
            } else {
                if (Intrinsics.areEqual(constantReference2, ConstantReference.Companion.getNOT_NULL())) {
                    throw (Throwable)new IllegalStateException("Internal error during serialization of function contract: NOT_NULL constant isn't denotable in protobuf format. Its serialization should be handled at higher level");
                }
                if (Intrinsics.areEqual(constantReference2, ConstantReference.Companion.getWILDCARD())) {
                    constantValue = null;
                } else {
                    throw (Throwable)new IllegalArgumentException("Unknown constant: " + constantReference);
                }
            }
            return constantValue;
        }

        public ContractSerializerWorker(@NotNull DescriptorSerializer parentSerializer) {
            Intrinsics.checkParameterIsNotNull(parentSerializer, "parentSerializer");
            this.parentSerializer = parentSerializer;
        }

        @NotNull
        public static final /* synthetic */ ProtoBuf.Expression.Builder access$contractExpressionProto(ContractSerializerWorker $this, @NotNull ContractDescriptionElement contractDescriptionElement, @NotNull ContractDescription contractDescription) {
            return $this.contractExpressionProto(contractDescriptionElement, contractDescription);
        }

        public static final /* synthetic */ void access$writeFlags(ContractSerializerWorker $this, @NotNull ProtoBuf.Expression.Builder $receiver, int newFlagsValue) {
            $this.writeFlags($receiver, newFlagsValue);
        }

        @NotNull
        public static final /* synthetic */ DescriptorSerializer access$getParentSerializer$p(ContractSerializerWorker $this) {
            return $this.parentSerializer;
        }

        @Nullable
        public static final /* synthetic */ ProtoBuf.Expression.ConstantValue access$constantValueProtobufEnum(ContractSerializerWorker $this, @NotNull ConstantReference constantReference) {
            return $this.constantValueProtobufEnum(constantReference);
        }
    }
}

