/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm;

import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ByteVector;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Context;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Item;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.MethodWriter;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;

public class ClassReader {
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;

    public ClassReader(byte[] b) {
        this(b, 0, b.length);
    }

    public ClassReader(byte[] b, int off, int len) {
        this.b = b;
        if (this.readShort(off + 6) > 53) {
            // empty if block
        }
        this.items = new int[this.readUnsignedShort(off + 8)];
        int n = this.items.length;
        this.strings = new String[n];
        int max = 0;
        int index2 = off + 10;
        for (int i = 1; i < n; ++i) {
            int size;
            this.items[i] = index2 + 1;
            switch (b[index2]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index2 + 1);
                    if (size <= max) break;
                    max = size;
                    break;
                }
                case 15: {
                    size = 4;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index2 += size;
        }
        this.maxStringLength = max;
        this.header = index2;
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + 2, new char[this.maxStringLength]);
    }

    void copyPool(ClassWriter classWriter) {
        char[] buf = new char[this.maxStringLength];
        int ll = this.items.length;
        Item[] items2 = new Item[ll];
        for (int i = 1; i < ll; ++i) {
            int index2 = this.items[i];
            byte tag = this.b[index2 - 1];
            Item item = new Item(i);
            switch (tag) {
                case 9: 
                case 10: 
                case 11: {
                    int nameType = this.items[this.readUnsignedShort(index2 + 2)];
                    item.set(tag, this.readClass(index2, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 3: {
                    item.set(this.readInt(index2));
                    break;
                }
                case 4: {
                    item.set(Float.intBitsToFloat(this.readInt(index2)));
                    break;
                }
                case 12: {
                    item.set(tag, this.readUTF8(index2, buf), this.readUTF8(index2 + 2, buf), null);
                    break;
                }
                case 5: {
                    item.set(this.readLong(index2));
                    ++i;
                    break;
                }
                case 6: {
                    item.set(Double.longBitsToDouble(this.readLong(index2)));
                    ++i;
                    break;
                }
                case 1: {
                    String s = this.strings[i];
                    if (s == null) {
                        index2 = this.items[i];
                        s = this.strings[i] = this.readUTF(index2 + 2, this.readUnsignedShort(index2), buf);
                    }
                    item.set(tag, s, null, null);
                    break;
                }
                case 15: {
                    int fieldOrMethodRef = this.items[this.readUnsignedShort(index2 + 1)];
                    int nameType = this.items[this.readUnsignedShort(fieldOrMethodRef + 2)];
                    item.set(20 + this.readByte(index2), this.readClass(fieldOrMethodRef, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 18: {
                    if (classWriter.bootstrapMethods == null) {
                        this.copyBootstrapMethods(classWriter, items2, buf);
                    }
                    int nameType = this.items[this.readUnsignedShort(index2 + 2)];
                    item.set(this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf), this.readUnsignedShort(index2));
                    break;
                }
                default: {
                    item.set(tag, this.readUTF8(index2, buf), null, null);
                }
            }
            int index22 = item.hashCode % items2.length;
            item.next = items2[index22];
            items2[index22] = item;
        }
        int off = this.items[1] - 1;
        classWriter.pool.putByteArray(this.b, off, this.header - off);
        classWriter.items = items2;
        classWriter.threshold = (int)(0.75 * (double)ll);
        classWriter.index = ll;
    }

    private void copyBootstrapMethods(ClassWriter classWriter, Item[] items, char[] c) {
        int u = this.getAttributes();
        boolean found = false;
        for (int i = this.readUnsignedShort(u); i > 0; --i) {
            String attrName = this.readUTF8(u + 2, c);
            if ("BootstrapMethods".equals(attrName)) {
                found = true;
                break;
            }
            u += 6 + this.readInt(u + 4);
        }
        if (!found) {
            return;
        }
        int boostrapMethodCount = this.readUnsignedShort(u + 8);
        int v = u + 10;
        for (int j = 0; j < boostrapMethodCount; ++j) {
            int position = v - u - 10;
            int hashCode2 = this.readConst(this.readUnsignedShort(v), c).hashCode();
            for (int k = this.readUnsignedShort(v + 2); k > 0; --k) {
                hashCode2 ^= this.readConst(this.readUnsignedShort(v + 4), c).hashCode();
                v += 2;
            }
            v += 4;
            Item item = new Item(j);
            item.set(position, hashCode2 & Integer.MAX_VALUE);
            int index2 = item.hashCode % items.length;
            item.next = items[index2];
            items[index2] = item;
        }
        int attrSize = this.readInt(u + 4);
        ByteVector bootstrapMethods = new ByteVector(attrSize + 62);
        bootstrapMethods.putByteArray(this.b, u + 10, attrSize - 2);
        classWriter.bootstrapMethodsCount = boostrapMethodCount;
        classWriter.bootstrapMethods = bootstrapMethods;
    }

    public void accept(ClassVisitor classVisitor2, int flags) {
        this.accept(classVisitor2, new Attribute[0], flags);
    }

    public void accept(ClassVisitor classVisitor2, Attribute[] attrs, int flags) {
        int i;
        int u = this.header;
        char[] c = new char[this.maxStringLength];
        Context context = new Context();
        context.attrs = attrs;
        context.flags = flags;
        context.buffer = c;
        int access = this.readUnsignedShort(u);
        String name2 = this.readClass(u + 2, c);
        String superClass = this.readClass(u + 4, c);
        String[] interfaces = new String[this.readUnsignedShort(u + 6)];
        u += 8;
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            interfaces[i2] = this.readClass(u, c);
            u += 2;
        }
        String signature2 = null;
        String sourceFile = null;
        String sourceDebug = null;
        String enclosingOwner = null;
        String enclosingName = null;
        String enclosingDesc = null;
        String moduleMainClass = null;
        int anns = 0;
        int ianns = 0;
        int tanns = 0;
        int itanns = 0;
        int innerClasses2 = 0;
        int module2 = 0;
        int packages2 = 0;
        Attribute attributes = null;
        u = this.getAttributes();
        for (i = this.readUnsignedShort(u); i > 0; --i) {
            String attrName = this.readUTF8(u + 2, c);
            if ("SourceFile".equals(attrName)) {
                sourceFile = this.readUTF8(u + 8, c);
            } else if ("InnerClasses".equals(attrName)) {
                innerClasses2 = u + 8;
            } else if ("EnclosingMethod".equals(attrName)) {
                enclosingOwner = this.readClass(u + 8, c);
                int item = this.readUnsignedShort(u + 10);
                if (item != 0) {
                    enclosingName = this.readUTF8(this.items[item], c);
                    enclosingDesc = this.readUTF8(this.items[item] + 2, c);
                }
            } else if ("Signature".equals(attrName)) {
                signature2 = this.readUTF8(u + 8, c);
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = u + 8;
            } else if ("Deprecated".equals(attrName)) {
                access |= 0x20000;
            } else if ("Synthetic".equals(attrName)) {
                access |= 0x41000;
            } else if ("SourceDebugExtension".equals(attrName)) {
                int len = this.readInt(u + 4);
                sourceDebug = this.readUTF(u + 8, len, new char[len]);
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = u + 8;
            } else if ("Module".equals(attrName)) {
                module2 = u + 8;
            } else if ("ModuleMainClass".equals(attrName)) {
                moduleMainClass = this.readClass(u + 8, c);
            } else if ("ModulePackages".equals(attrName)) {
                packages2 = u + 10;
            } else if ("BootstrapMethods".equals(attrName)) {
                int[] bootstrapMethods = new int[this.readUnsignedShort(u + 8)];
                int v = u + 10;
                for (int j = 0; j < bootstrapMethods.length; ++j) {
                    bootstrapMethods[j] = v;
                    v += 2 + this.readUnsignedShort(v + 2) << 1;
                }
                context.bootstrapMethods = bootstrapMethods;
            } else {
                Attribute attr = this.readAttribute(attrs, attrName, u + 8, this.readInt(u + 4), c, -1, null);
                if (attr != null) {
                    attr.next = attributes;
                    attributes = attr;
                }
            }
            u += 6 + this.readInt(u + 4);
        }
        classVisitor2.visit(this.readInt(this.items[1] - 7), access, name2, signature2, superClass, interfaces);
        if ((flags & 2) == 0 && (sourceFile != null || sourceDebug != null)) {
            classVisitor2.visitSource(sourceFile, sourceDebug);
        }
        if (module2 != 0) {
            this.readModule(classVisitor2, context, module2, moduleMainClass, packages2);
        }
        if (enclosingOwner != null) {
            classVisitor2.visitOuterClass(enclosingOwner, enclosingName, enclosingDesc);
        }
        if (anns != 0) {
            int v = anns + 2;
            for (i = this.readUnsignedShort(anns); i > 0; --i) {
                v = this.readAnnotationValues(v + 2, c, true, classVisitor2.visitAnnotation(this.readUTF8(v, c), true));
            }
        }
        if (ianns != 0) {
            int v = ianns + 2;
            for (i = this.readUnsignedShort(ianns); i > 0; --i) {
                v = this.readAnnotationValues(v + 2, c, true, classVisitor2.visitAnnotation(this.readUTF8(v, c), false));
            }
        }
        if (tanns != 0) {
            int v = tanns + 2;
            for (i = this.readUnsignedShort(tanns); i > 0; --i) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, classVisitor2.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), true));
            }
        }
        if (itanns != 0) {
            int v = itanns + 2;
            for (i = this.readUnsignedShort(itanns); i > 0; --i) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, classVisitor2.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), false));
            }
        }
        while (attributes != null) {
            Attribute attr = attributes.next;
            attributes.next = null;
            classVisitor2.visitAttribute(attributes);
            attributes = attr;
        }
        if (innerClasses2 != 0) {
            int v = innerClasses2 + 2;
            for (int i3 = this.readUnsignedShort(innerClasses2); i3 > 0; --i3) {
                classVisitor2.visitInnerClass(this.readClass(v, c), this.readClass(v + 2, c), this.readUTF8(v + 4, c), this.readUnsignedShort(v + 6));
                v += 8;
            }
        }
        u = this.header + 10 + 2 * interfaces.length;
        for (i = this.readUnsignedShort(u - 2); i > 0; --i) {
            u = this.readField(classVisitor2, context, u);
        }
        for (i = this.readUnsignedShort((u += 2) - 2); i > 0; --i) {
            u = this.readMethod(classVisitor2, context, u);
        }
        classVisitor2.visitEnd();
    }

    private void readModule(ClassVisitor classVisitor2, Context context, int u, String mainClass, int packages2) {
        int j;
        String[] tos;
        int access;
        int i;
        char[] buffer = context.buffer;
        String name2 = this.readModule(u, buffer);
        int flags = this.readUnsignedShort(u + 2);
        String version = this.readUTF8(u + 4, buffer);
        u += 6;
        ModuleVisitor mv = classVisitor2.visitModule(name2, flags, version);
        if (mv == null) {
            return;
        }
        if (mainClass != null) {
            mv.visitMainClass(mainClass);
        }
        if (packages2 != 0) {
            for (i = this.readUnsignedShort(packages2 - 2); i > 0; --i) {
                String packaze = this.readPackage(packages2, buffer);
                mv.visitPackage(packaze);
                packages2 += 2;
            }
        }
        for (i = this.readUnsignedShort((u += 2) - 2); i > 0; --i) {
            String module2 = this.readModule(u, buffer);
            access = this.readUnsignedShort(u + 2);
            String requireVersion = this.readUTF8(u + 4, buffer);
            mv.visitRequire(module2, access, requireVersion);
            u += 6;
        }
        for (i = this.readUnsignedShort((u += 2) - 2); i > 0; --i) {
            String export = this.readPackage(u, buffer);
            access = this.readUnsignedShort(u + 2);
            int exportToCount = this.readUnsignedShort(u + 4);
            u += 6;
            tos = null;
            if (exportToCount != 0) {
                tos = new String[exportToCount];
                for (j = 0; j < tos.length; ++j) {
                    tos[j] = this.readModule(u, buffer);
                    u += 2;
                }
            }
            mv.visitExport(export, access, tos);
        }
        for (i = this.readUnsignedShort((u += 2) - 2); i > 0; --i) {
            String open = this.readPackage(u, buffer);
            access = this.readUnsignedShort(u + 2);
            int openToCount = this.readUnsignedShort(u + 4);
            u += 6;
            tos = null;
            if (openToCount != 0) {
                tos = new String[openToCount];
                for (j = 0; j < tos.length; ++j) {
                    tos[j] = this.readModule(u, buffer);
                    u += 2;
                }
            }
            mv.visitOpen(open, access, tos);
        }
        for (i = this.readUnsignedShort((u += 2) - 2); i > 0; --i) {
            mv.visitUse(this.readClass(u, buffer));
            u += 2;
        }
        for (i = this.readUnsignedShort((u += 2) - 2); i > 0; --i) {
            String service = this.readClass(u, buffer);
            int provideWithCount = this.readUnsignedShort(u + 2);
            u += 4;
            String[] withs = new String[provideWithCount];
            for (int j2 = 0; j2 < withs.length; ++j2) {
                withs[j2] = this.readClass(u, buffer);
                u += 2;
            }
            mv.visitProvide(service, withs);
        }
        mv.visitEnd();
    }

    private int readField(ClassVisitor classVisitor2, Context context, int u) {
        int v;
        char[] c = context.buffer;
        int access = this.readUnsignedShort(u);
        String name2 = this.readUTF8(u + 2, c);
        String desc = this.readUTF8(u + 4, c);
        u += 6;
        String signature2 = null;
        int anns = 0;
        int ianns = 0;
        int tanns = 0;
        int itanns = 0;
        Object value2 = null;
        Attribute attributes = null;
        for (int i = this.readUnsignedShort(u); i > 0; --i) {
            String attrName = this.readUTF8(u + 2, c);
            if ("ConstantValue".equals(attrName)) {
                int item = this.readUnsignedShort(u + 8);
                value2 = item == 0 ? null : this.readConst(item, c);
            } else if ("Signature".equals(attrName)) {
                signature2 = this.readUTF8(u + 8, c);
            } else if ("Deprecated".equals(attrName)) {
                access |= 0x20000;
            } else if ("Synthetic".equals(attrName)) {
                access |= 0x41000;
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = u + 8;
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = u + 8;
            } else {
                Attribute attr = this.readAttribute(context.attrs, attrName, u + 8, this.readInt(u + 4), c, -1, null);
                if (attr != null) {
                    attr.next = attributes;
                    attributes = attr;
                }
            }
            u += 6 + this.readInt(u + 4);
        }
        u += 2;
        FieldVisitor fv = classVisitor2.visitField(access, name2, desc, signature2, value2);
        if (fv == null) {
            return u;
        }
        if (anns != 0) {
            v = anns + 2;
            for (int i = this.readUnsignedShort(anns); i > 0; --i) {
                v = this.readAnnotationValues(v + 2, c, true, fv.visitAnnotation(this.readUTF8(v, c), true));
            }
        }
        if (ianns != 0) {
            v = ianns + 2;
            for (int i = this.readUnsignedShort(ianns); i > 0; --i) {
                v = this.readAnnotationValues(v + 2, c, true, fv.visitAnnotation(this.readUTF8(v, c), false));
            }
        }
        if (tanns != 0) {
            v = tanns + 2;
            for (int i = this.readUnsignedShort(tanns); i > 0; --i) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, fv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), true));
            }
        }
        if (itanns != 0) {
            v = itanns + 2;
            for (int i = this.readUnsignedShort(itanns); i > 0; --i) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, fv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), false));
            }
        }
        while (attributes != null) {
            Attribute attr = attributes.next;
            attributes.next = null;
            fv.visitAttribute(attributes);
            attributes = attr;
        }
        fv.visitEnd();
        return u;
    }

    private int readMethod(ClassVisitor classVisitor2, Context context, int u) {
        int v;
        char[] c = context.buffer;
        context.access = this.readUnsignedShort(u);
        context.name = this.readUTF8(u + 2, c);
        context.desc = this.readUTF8(u + 4, c);
        u += 6;
        int code = 0;
        int exception = 0;
        String[] exceptions = null;
        String signature2 = null;
        int methodParameters = 0;
        int anns = 0;
        int ianns = 0;
        int tanns = 0;
        int itanns = 0;
        int dann = 0;
        int mpanns = 0;
        int impanns = 0;
        int firstAttribute = u;
        Attribute attributes = null;
        for (int i = this.readUnsignedShort(u); i > 0; --i) {
            String attrName = this.readUTF8(u + 2, c);
            if ("Code".equals(attrName)) {
                if ((context.flags & 1) == 0) {
                    code = u + 8;
                }
            } else if ("Exceptions".equals(attrName)) {
                exceptions = new String[this.readUnsignedShort(u + 8)];
                exception = u + 10;
                for (int j = 0; j < exceptions.length; ++j) {
                    exceptions[j] = this.readClass(exception, c);
                    exception += 2;
                }
            } else if ("Signature".equals(attrName)) {
                signature2 = this.readUTF8(u + 8, c);
            } else if ("Deprecated".equals(attrName)) {
                context.access |= 0x20000;
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u + 8;
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = u + 8;
            } else if ("AnnotationDefault".equals(attrName)) {
                dann = u + 8;
            } else if ("Synthetic".equals(attrName)) {
                context.access |= 0x41000;
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u + 8;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = u + 8;
            } else if ("RuntimeVisibleParameterAnnotations".equals(attrName)) {
                mpanns = u + 8;
            } else if ("RuntimeInvisibleParameterAnnotations".equals(attrName)) {
                impanns = u + 8;
            } else if ("MethodParameters".equals(attrName)) {
                methodParameters = u + 8;
            } else {
                Attribute attr = this.readAttribute(context.attrs, attrName, u + 8, this.readInt(u + 4), c, -1, null);
                if (attr != null) {
                    attr.next = attributes;
                    attributes = attr;
                }
            }
            u += 6 + this.readInt(u + 4);
        }
        u += 2;
        MethodVisitor mv = classVisitor2.visitMethod(context.access, context.name, context.desc, signature2, exceptions);
        if (mv == null) {
            return u;
        }
        if (mv instanceof MethodWriter) {
            MethodWriter mw = (MethodWriter)mv;
            if (mw.cw.cr == this && signature2 == mw.signature) {
                boolean sameExceptions = false;
                if (exceptions == null) {
                    sameExceptions = mw.exceptionCount == 0;
                } else if (exceptions.length == mw.exceptionCount) {
                    sameExceptions = true;
                    for (int j = exceptions.length - 1; j >= 0; --j) {
                        if (mw.exceptions[j] == this.readUnsignedShort(exception -= 2)) continue;
                        sameExceptions = false;
                        break;
                    }
                }
                if (sameExceptions) {
                    mw.classReaderOffset = firstAttribute;
                    mw.classReaderLength = u - firstAttribute;
                    return u;
                }
            }
        }
        if (methodParameters != 0) {
            int i = this.b[methodParameters] & 0xFF;
            v = methodParameters + 1;
            while (i > 0) {
                mv.visitParameter(this.readUTF8(v, c), this.readUnsignedShort(v + 2));
                --i;
                v += 4;
            }
        }
        if (dann != 0) {
            AnnotationVisitor dv = mv.visitAnnotationDefault();
            this.readAnnotationValue(dann, c, null, dv);
            if (dv != null) {
                dv.visitEnd();
            }
        }
        if (anns != 0) {
            v = anns + 2;
            for (int i = this.readUnsignedShort(anns); i > 0; --i) {
                v = this.readAnnotationValues(v + 2, c, true, mv.visitAnnotation(this.readUTF8(v, c), true));
            }
        }
        if (ianns != 0) {
            v = ianns + 2;
            for (int i = this.readUnsignedShort(ianns); i > 0; --i) {
                v = this.readAnnotationValues(v + 2, c, true, mv.visitAnnotation(this.readUTF8(v, c), false));
            }
        }
        if (tanns != 0) {
            v = tanns + 2;
            for (int i = this.readUnsignedShort(tanns); i > 0; --i) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, mv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), true));
            }
        }
        if (itanns != 0) {
            v = itanns + 2;
            for (int i = this.readUnsignedShort(itanns); i > 0; --i) {
                v = this.readAnnotationTarget(context, v);
                v = this.readAnnotationValues(v + 2, c, true, mv.visitTypeAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), false));
            }
        }
        if (mpanns != 0) {
            this.readParameterAnnotations(mv, context, mpanns, true);
        }
        if (impanns != 0) {
            this.readParameterAnnotations(mv, context, impanns, false);
        }
        while (attributes != null) {
            Attribute attr = attributes.next;
            attributes.next = null;
            mv.visitAttribute(attributes);
            attributes = attr;
        }
        if (code != 0) {
            mv.visitCode();
            this.readCode(mv, context, code);
        }
        mv.visitEnd();
        return u;
    }

    private void readCode(MethodVisitor mv, Context context, int u) {
        int i;
        byte[] b = this.b;
        char[] c = context.buffer;
        int maxStack = this.readUnsignedShort(u);
        int maxLocals = this.readUnsignedShort(u + 2);
        int codeLength = this.readInt(u + 4);
        int codeStart = u += 8;
        int codeEnd = u + codeLength;
        context.labels = new Label[codeLength + 2];
        Label[] labels2 = context.labels;
        this.createLabel(codeLength + 1, labels2);
        block32: while (u < codeEnd) {
            int offset2 = u - codeStart;
            int opcode = b[u] & 0xFF;
            switch (ClassWriter.TYPE[opcode]) {
                case 0: 
                case 4: {
                    ++u;
                    continue block32;
                }
                case 9: {
                    this.createLabel(offset2 + this.readShort(u + 1), labels2);
                    u += 3;
                    continue block32;
                }
                case 18: {
                    this.createLabel(offset2 + this.readUnsignedShort(u + 1), labels2);
                    u += 3;
                    continue block32;
                }
                case 10: 
                case 19: {
                    this.createLabel(offset2 + this.readInt(u + 1), labels2);
                    u += 5;
                    continue block32;
                }
                case 17: {
                    opcode = b[u + 1] & 0xFF;
                    if (opcode == 132) {
                        u += 6;
                        continue block32;
                    }
                    u += 4;
                    continue block32;
                }
                case 14: {
                    int i2;
                    u = u + 4 - (offset2 & 3);
                    this.createLabel(offset2 + this.readInt(u), labels2);
                    for (i2 = this.readInt(u + 8) - this.readInt(u + 4) + 1; i2 > 0; --i2) {
                        this.createLabel(offset2 + this.readInt(u + 12), labels2);
                        u += 4;
                    }
                    u += 12;
                    continue block32;
                }
                case 15: {
                    int i2;
                    u = u + 4 - (offset2 & 3);
                    this.createLabel(offset2 + this.readInt(u), labels2);
                    for (i2 = this.readInt(u + 4); i2 > 0; --i2) {
                        this.createLabel(offset2 + this.readInt(u + 12), labels2);
                        u += 8;
                    }
                    u += 8;
                    continue block32;
                }
                case 1: 
                case 3: 
                case 11: {
                    u += 2;
                    continue block32;
                }
                case 2: 
                case 5: 
                case 6: 
                case 12: 
                case 13: {
                    u += 3;
                    continue block32;
                }
                case 7: 
                case 8: {
                    u += 5;
                    continue block32;
                }
            }
            u += 4;
        }
        for (int i3 = this.readUnsignedShort(u); i3 > 0; --i3) {
            Label start = this.createLabel(this.readUnsignedShort(u + 2), labels2);
            Label end = this.createLabel(this.readUnsignedShort(u + 4), labels2);
            Label handler2 = this.createLabel(this.readUnsignedShort(u + 6), labels2);
            String type2 = this.readUTF8(this.items[this.readUnsignedShort(u + 8)], c);
            mv.visitTryCatchBlock(start, end, handler2, type2);
            u += 8;
        }
        u += 2;
        int[] tanns = null;
        int[] itanns = null;
        int tann = 0;
        int itann = 0;
        int ntoff = -1;
        int nitoff = -1;
        int varTable = 0;
        int varTypeTable = 0;
        boolean zip2 = true;
        boolean unzip = (context.flags & 8) != 0;
        int stackMap = 0;
        int stackMapSize = 0;
        int frameCount = 0;
        Context frame = null;
        Attribute attributes = null;
        for (i = this.readUnsignedShort(u); i > 0; --i) {
            int label;
            int j;
            int v;
            String attrName = this.readUTF8(u + 2, c);
            if ("LocalVariableTable".equals(attrName)) {
                if ((context.flags & 2) == 0) {
                    varTable = u + 8;
                    v = u;
                    for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                        label = this.readUnsignedShort(v + 10);
                        this.createDebugLabel(label, labels2);
                        this.createDebugLabel(label += this.readUnsignedShort(v + 12), labels2);
                        v += 10;
                    }
                }
            } else if ("LocalVariableTypeTable".equals(attrName)) {
                varTypeTable = u + 8;
            } else if ("LineNumberTable".equals(attrName)) {
                if ((context.flags & 2) == 0) {
                    v = u;
                    for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                        label = this.readUnsignedShort(v + 10);
                        this.createDebugLabel(label, labels2);
                        Label l = labels2[label];
                        while (l.line > 0) {
                            if (l.next == null) {
                                l.next = new Label();
                            }
                            l = l.next;
                        }
                        l.line = this.readUnsignedShort(v + 12);
                        v += 4;
                    }
                }
            } else if ("RuntimeVisibleTypeAnnotations".equals(attrName)) {
                tanns = this.readTypeAnnotations(mv, context, u + 8, true);
                ntoff = tanns.length == 0 || this.readByte(tanns[0]) < 67 ? -1 : this.readUnsignedShort(tanns[0] + 1);
            } else if ("RuntimeInvisibleTypeAnnotations".equals(attrName)) {
                itanns = this.readTypeAnnotations(mv, context, u + 8, false);
                nitoff = itanns.length == 0 || this.readByte(itanns[0]) < 67 ? -1 : this.readUnsignedShort(itanns[0] + 1);
            } else if ("StackMapTable".equals(attrName)) {
                if ((context.flags & 4) == 0) {
                    stackMap = u + 10;
                    stackMapSize = this.readInt(u + 4);
                    frameCount = this.readUnsignedShort(u + 8);
                }
            } else if ("StackMap".equals(attrName)) {
                if ((context.flags & 4) == 0) {
                    zip2 = false;
                    stackMap = u + 10;
                    stackMapSize = this.readInt(u + 4);
                    frameCount = this.readUnsignedShort(u + 8);
                }
            } else {
                for (j = 0; j < context.attrs.length; ++j) {
                    Attribute attr;
                    if (!context.attrs[j].type.equals(attrName) || (attr = context.attrs[j].read(this, u + 8, this.readInt(u + 4), c, codeStart - 8, labels2)) == null) continue;
                    attr.next = attributes;
                    attributes = attr;
                }
            }
            u += 6 + this.readInt(u + 4);
        }
        u += 2;
        if (stackMap != 0) {
            frame = context;
            frame.offset = -1;
            frame.mode = 0;
            frame.localCount = 0;
            frame.localDiff = 0;
            frame.stackCount = 0;
            frame.local = new Object[maxLocals];
            frame.stack = new Object[maxStack];
            if (unzip) {
                this.getImplicitFrame(context);
            }
            for (i = stackMap; i < stackMap + stackMapSize - 2; ++i) {
                int v;
                if (b[i] != 8 || (v = this.readUnsignedShort(i + 1)) < 0 || v >= codeLength || (b[codeStart + v] & 0xFF) != 187) continue;
                this.createLabel(v, labels2);
            }
        }
        if ((context.flags & 0x100) != 0 && (context.flags & 8) != 0) {
            mv.visitFrame(-1, maxLocals, null, 0, null);
        }
        int opcodeDelta = (context.flags & 0x100) == 0 ? -33 : 0;
        boolean insertFrame = false;
        u = codeStart;
        while (u < codeEnd) {
            int offset3 = u - codeStart;
            Label l = labels2[offset3];
            if (l != null) {
                Label next = l.next;
                l.next = null;
                mv.visitLabel(l);
                if ((context.flags & 2) == 0 && l.line > 0) {
                    mv.visitLineNumber(l.line, l);
                    while (next != null) {
                        mv.visitLineNumber(next.line, l);
                        next = next.next;
                    }
                }
            }
            while (frame != null && (frame.offset == offset3 || frame.offset == -1)) {
                if (frame.offset != -1) {
                    if (!zip2 || unzip) {
                        mv.visitFrame(-1, frame.localCount, frame.local, frame.stackCount, frame.stack);
                    } else {
                        mv.visitFrame(frame.mode, frame.localDiff, frame.local, frame.stackCount, frame.stack);
                    }
                    insertFrame = false;
                }
                if (frameCount > 0) {
                    stackMap = this.readFrame(stackMap, zip2, unzip, frame);
                    --frameCount;
                    continue;
                }
                frame = null;
            }
            if (insertFrame) {
                mv.visitFrame(256, 0, null, 0, null);
                insertFrame = false;
            }
            int opcode = b[u] & 0xFF;
            switch (ClassWriter.TYPE[opcode]) {
                case 0: {
                    mv.visitInsn(opcode);
                    ++u;
                    break;
                }
                case 4: {
                    if (opcode > 54) {
                        mv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                    } else {
                        mv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                    }
                    ++u;
                    break;
                }
                case 9: {
                    mv.visitJumpInsn(opcode, labels2[offset3 + this.readShort(u + 1)]);
                    u += 3;
                    break;
                }
                case 10: {
                    mv.visitJumpInsn(opcode + opcodeDelta, labels2[offset3 + this.readInt(u + 1)]);
                    u += 5;
                    break;
                }
                case 18: {
                    opcode = opcode < 218 ? opcode - 49 : opcode - 20;
                    Label target = labels2[offset3 + this.readUnsignedShort(u + 1)];
                    if (opcode == 167 || opcode == 168) {
                        mv.visitJumpInsn(opcode + 33, target);
                    } else {
                        opcode = opcode <= 166 ? (opcode + 1 ^ 1) - 1 : opcode ^ 1;
                        Label endif = this.createLabel(offset3 + 3, labels2);
                        mv.visitJumpInsn(opcode, endif);
                        mv.visitJumpInsn(200, target);
                        insertFrame = true;
                    }
                    u += 3;
                    break;
                }
                case 19: {
                    mv.visitJumpInsn(200, labels2[offset3 + this.readInt(u + 1)]);
                    insertFrame = true;
                    u += 5;
                    break;
                }
                case 17: {
                    opcode = b[u + 1] & 0xFF;
                    if (opcode == 132) {
                        mv.visitIincInsn(this.readUnsignedShort(u + 2), this.readShort(u + 4));
                        u += 6;
                        break;
                    }
                    mv.visitVarInsn(opcode, this.readUnsignedShort(u + 2));
                    u += 4;
                    break;
                }
                case 14: {
                    u = u + 4 - (offset3 & 3);
                    int label = offset3 + this.readInt(u);
                    int min = this.readInt(u + 4);
                    int max = this.readInt(u + 8);
                    Label[] table = new Label[max - min + 1];
                    u += 12;
                    for (int i4 = 0; i4 < table.length; ++i4) {
                        table[i4] = labels2[offset3 + this.readInt(u)];
                        u += 4;
                    }
                    mv.visitTableSwitchInsn(min, max, labels2[label], table);
                    break;
                }
                case 15: {
                    u = u + 4 - (offset3 & 3);
                    int label = offset3 + this.readInt(u);
                    int len = this.readInt(u + 4);
                    int[] keys2 = new int[len];
                    Label[] values2 = new Label[len];
                    u += 8;
                    for (int i5 = 0; i5 < len; ++i5) {
                        keys2[i5] = this.readInt(u);
                        values2[i5] = labels2[offset3 + this.readInt(u + 4)];
                        u += 8;
                    }
                    mv.visitLookupSwitchInsn(labels2[label], keys2, values2);
                    break;
                }
                case 3: {
                    mv.visitVarInsn(opcode, b[u + 1] & 0xFF);
                    u += 2;
                    break;
                }
                case 1: {
                    mv.visitIntInsn(opcode, b[u + 1]);
                    u += 2;
                    break;
                }
                case 2: {
                    mv.visitIntInsn(opcode, this.readShort(u + 1));
                    u += 3;
                    break;
                }
                case 11: {
                    mv.visitLdcInsn(this.readConst(b[u + 1] & 0xFF, c));
                    u += 2;
                    break;
                }
                case 12: {
                    mv.visitLdcInsn(this.readConst(this.readUnsignedShort(u + 1), c));
                    u += 3;
                    break;
                }
                case 6: 
                case 7: {
                    int cpIndex = this.items[this.readUnsignedShort(u + 1)];
                    boolean itf = b[cpIndex - 1] == 11;
                    String iowner = this.readClass(cpIndex, c);
                    cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                    String iname = this.readUTF8(cpIndex, c);
                    String idesc = this.readUTF8(cpIndex + 2, c);
                    if (opcode < 182) {
                        mv.visitFieldInsn(opcode, iowner, iname, idesc);
                    } else {
                        mv.visitMethodInsn(opcode, iowner, iname, idesc, itf);
                    }
                    if (opcode == 185) {
                        u += 5;
                        break;
                    }
                    u += 3;
                    break;
                }
                case 8: {
                    int cpIndex = this.items[this.readUnsignedShort(u + 1)];
                    int bsmIndex = context.bootstrapMethods[this.readUnsignedShort(cpIndex)];
                    Handle bsm = (Handle)this.readConst(this.readUnsignedShort(bsmIndex), c);
                    int bsmArgCount = this.readUnsignedShort(bsmIndex + 2);
                    Object[] bsmArgs = new Object[bsmArgCount];
                    bsmIndex += 4;
                    for (int i6 = 0; i6 < bsmArgCount; ++i6) {
                        bsmArgs[i6] = this.readConst(this.readUnsignedShort(bsmIndex), c);
                        bsmIndex += 2;
                    }
                    cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                    String iname = this.readUTF8(cpIndex, c);
                    String idesc = this.readUTF8(cpIndex + 2, c);
                    mv.visitInvokeDynamicInsn(iname, idesc, bsm, bsmArgs);
                    u += 5;
                    break;
                }
                case 5: {
                    mv.visitTypeInsn(opcode, this.readClass(u + 1, c));
                    u += 3;
                    break;
                }
                case 13: {
                    mv.visitIincInsn(b[u + 1] & 0xFF, b[u + 2]);
                    u += 3;
                    break;
                }
                default: {
                    mv.visitMultiANewArrayInsn(this.readClass(u + 1, c), b[u + 3] & 0xFF);
                    u += 4;
                }
            }
            while (tanns != null && tann < tanns.length && ntoff <= offset3) {
                if (ntoff == offset3) {
                    int v = this.readAnnotationTarget(context, tanns[tann]);
                    this.readAnnotationValues(v + 2, c, true, mv.visitInsnAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), true));
                }
                ntoff = ++tann >= tanns.length || this.readByte(tanns[tann]) < 67 ? -1 : this.readUnsignedShort(tanns[tann] + 1);
            }
            while (itanns != null && itann < itanns.length && nitoff <= offset3) {
                if (nitoff == offset3) {
                    int v = this.readAnnotationTarget(context, itanns[itann]);
                    this.readAnnotationValues(v + 2, c, true, mv.visitInsnAnnotation(context.typeRef, context.typePath, this.readUTF8(v, c), false));
                }
                nitoff = ++itann >= itanns.length || this.readByte(itanns[itann]) < 67 ? -1 : this.readUnsignedShort(itanns[itann] + 1);
            }
        }
        if (labels2[codeLength] != null) {
            mv.visitLabel(labels2[codeLength]);
        }
        if ((context.flags & 2) == 0 && varTable != 0) {
            int[] typeTable = null;
            if (varTypeTable != 0) {
                u = varTypeTable + 2;
                typeTable = new int[this.readUnsignedShort(varTypeTable) * 3];
                int i7 = typeTable.length;
                while (i7 > 0) {
                    typeTable[--i7] = u + 6;
                    typeTable[--i7] = this.readUnsignedShort(u + 8);
                    typeTable[--i7] = this.readUnsignedShort(u);
                    u += 10;
                }
            }
            u = varTable + 2;
            for (int i8 = this.readUnsignedShort(varTable); i8 > 0; --i8) {
                int start = this.readUnsignedShort(u);
                int length = this.readUnsignedShort(u + 2);
                int index2 = this.readUnsignedShort(u + 8);
                String vsignature = null;
                if (typeTable != null) {
                    for (int j = 0; j < typeTable.length; j += 3) {
                        if (typeTable[j] != start || typeTable[j + 1] != index2) continue;
                        vsignature = this.readUTF8(typeTable[j + 2], c);
                        break;
                    }
                }
                mv.visitLocalVariable(this.readUTF8(u + 4, c), this.readUTF8(u + 6, c), vsignature, labels2[start], labels2[start + length], index2);
                u += 10;
            }
        }
        if (tanns != null) {
            for (int i9 = 0; i9 < tanns.length; ++i9) {
                if (this.readByte(tanns[i9]) >> 1 != 32) continue;
                int v = this.readAnnotationTarget(context, tanns[i9]);
                v = this.readAnnotationValues(v + 2, c, true, mv.visitLocalVariableAnnotation(context.typeRef, context.typePath, context.start, context.end, context.index, this.readUTF8(v, c), true));
            }
        }
        if (itanns != null) {
            for (int i10 = 0; i10 < itanns.length; ++i10) {
                if (this.readByte(itanns[i10]) >> 1 != 32) continue;
                int v = this.readAnnotationTarget(context, itanns[i10]);
                v = this.readAnnotationValues(v + 2, c, true, mv.visitLocalVariableAnnotation(context.typeRef, context.typePath, context.start, context.end, context.index, this.readUTF8(v, c), false));
            }
        }
        while (attributes != null) {
            Attribute attr = attributes.next;
            attributes.next = null;
            mv.visitAttribute(attributes);
            attributes = attr;
        }
        mv.visitMaxs(maxStack, maxLocals);
    }

    private int[] readTypeAnnotations(MethodVisitor mv, Context context, int u, boolean visible) {
        char[] c = context.buffer;
        int[] offsets = new int[this.readUnsignedShort(u)];
        u += 2;
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = u;
            int target = this.readInt(u);
            switch (target >>> 24) {
                case 0: 
                case 1: 
                case 22: {
                    u += 2;
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    ++u;
                    break;
                }
                case 64: 
                case 65: {
                    for (int j = this.readUnsignedShort(u + 1); j > 0; --j) {
                        int start = this.readUnsignedShort(u + 3);
                        int length = this.readUnsignedShort(u + 5);
                        this.createLabel(start, context.labels);
                        this.createLabel(start + length, context.labels);
                        u += 6;
                    }
                    u += 3;
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    u += 4;
                    break;
                }
                default: {
                    u += 3;
                }
            }
            int pathLength = this.readByte(u);
            if (target >>> 24 == 66) {
                TypePath path2 = pathLength == 0 ? null : new TypePath(this.b, u);
                u += 1 + 2 * pathLength;
                u = this.readAnnotationValues(u + 2, c, true, mv.visitTryCatchAnnotation(target, path2, this.readUTF8(u, c), visible));
                continue;
            }
            u = this.readAnnotationValues(u + 3 + 2 * pathLength, c, true, null);
        }
        return offsets;
    }

    private int readAnnotationTarget(Context context, int u) {
        int target = this.readInt(u);
        switch (target >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                target &= 0xFFFF0000;
                u += 2;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                target &= 0xFF000000;
                ++u;
                break;
            }
            case 64: 
            case 65: {
                target &= 0xFF000000;
                int n = this.readUnsignedShort(u + 1);
                context.start = new Label[n];
                context.end = new Label[n];
                context.index = new int[n];
                u += 3;
                for (int i = 0; i < n; ++i) {
                    int start = this.readUnsignedShort(u);
                    int length = this.readUnsignedShort(u + 2);
                    context.start[i] = this.createLabel(start, context.labels);
                    context.end[i] = this.createLabel(start + length, context.labels);
                    context.index[i] = this.readUnsignedShort(u + 4);
                    u += 6;
                }
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                target &= 0xFF0000FF;
                u += 4;
                break;
            }
            default: {
                target &= target >>> 24 < 67 ? -256 : -16777216;
                u += 3;
            }
        }
        int pathLength = this.readByte(u);
        context.typeRef = target;
        context.typePath = pathLength == 0 ? null : new TypePath(this.b, u);
        return u + 1 + 2 * pathLength;
    }

    private void readParameterAnnotations(MethodVisitor mv, Context context, int v, boolean visible) {
        AnnotationVisitor av;
        int i;
        int n = this.b[v++] & 0xFF;
        int synthetics = Type.getArgumentTypes(context.desc).length - n;
        for (i = 0; i < synthetics; ++i) {
            av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", false);
            if (av == null) continue;
            av.visitEnd();
        }
        char[] c = context.buffer;
        while (i < n + synthetics) {
            int j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                av = mv.visitParameterAnnotation(i, this.readUTF8(v, c), visible);
                v = this.readAnnotationValues(v + 2, c, true, av);
                --j;
            }
            ++i;
        }
    }

    private int readAnnotationValues(int v, char[] buf, boolean named, AnnotationVisitor av) {
        int i = this.readUnsignedShort(v);
        v += 2;
        if (named) {
            while (i > 0) {
                v = this.readAnnotationValue(v + 2, buf, this.readUTF8(v, buf), av);
                --i;
            }
        } else {
            while (i > 0) {
                v = this.readAnnotationValue(v, buf, null, av);
                --i;
            }
        }
        if (av != null) {
            av.visitEnd();
        }
        return v;
    }

    private int readAnnotationValue(int v, char[] buf, String name2, AnnotationVisitor av) {
        if (av == null) {
            switch (this.b[v] & 0xFF) {
                case 101: {
                    return v + 5;
                }
                case 64: {
                    return this.readAnnotationValues(v + 3, buf, true, null);
                }
                case 91: {
                    return this.readAnnotationValues(v + 1, buf, false, null);
                }
            }
            return v + 3;
        }
        block5 : switch (this.b[v++] & 0xFF) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                av.visit(name2, this.readConst(this.readUnsignedShort(v), buf));
                v += 2;
                break;
            }
            case 66: {
                av.visit(name2, (byte)this.readInt(this.items[this.readUnsignedShort(v)]));
                v += 2;
                break;
            }
            case 90: {
                av.visit(name2, this.readInt(this.items[this.readUnsignedShort(v)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                v += 2;
                break;
            }
            case 83: {
                av.visit(name2, (short)this.readInt(this.items[this.readUnsignedShort(v)]));
                v += 2;
                break;
            }
            case 67: {
                av.visit(name2, Character.valueOf((char)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 115: {
                av.visit(name2, this.readUTF8(v, buf));
                v += 2;
                break;
            }
            case 101: {
                av.visitEnum(name2, this.readUTF8(v, buf), this.readUTF8(v + 2, buf));
                v += 4;
                break;
            }
            case 99: {
                av.visit(name2, Type.getType(this.readUTF8(v, buf)));
                v += 2;
                break;
            }
            case 64: {
                v = this.readAnnotationValues(v + 2, buf, true, av.visitAnnotation(name2, this.readUTF8(v, buf)));
                break;
            }
            case 91: {
                int size = this.readUnsignedShort(v);
                v += 2;
                if (size == 0) {
                    return this.readAnnotationValues(v - 2, buf, false, av.visitArray(name2));
                }
                switch (this.b[v++] & 0xFF) {
                    case 66: {
                        byte[] bv = new byte[size];
                        for (int i = 0; i < size; ++i) {
                            bv[i] = (byte)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, bv);
                        --v;
                        break block5;
                    }
                    case 90: {
                        boolean[] zv = new boolean[size];
                        for (int i = 0; i < size; ++i) {
                            zv[i] = this.readInt(this.items[this.readUnsignedShort(v)]) != 0;
                            v += 3;
                        }
                        av.visit(name2, zv);
                        --v;
                        break block5;
                    }
                    case 83: {
                        short[] sv = new short[size];
                        for (int i = 0; i < size; ++i) {
                            sv[i] = (short)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, sv);
                        --v;
                        break block5;
                    }
                    case 67: {
                        char[] cv = new char[size];
                        for (int i = 0; i < size; ++i) {
                            cv[i] = (char)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, cv);
                        --v;
                        break block5;
                    }
                    case 73: {
                        int[] iv = new int[size];
                        for (int i = 0; i < size; ++i) {
                            iv[i] = this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, iv);
                        --v;
                        break block5;
                    }
                    case 74: {
                        long[] lv = new long[size];
                        for (int i = 0; i < size; ++i) {
                            lv[i] = this.readLong(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name2, lv);
                        --v;
                        break block5;
                    }
                    case 70: {
                        float[] fv = new float[size];
                        for (int i = 0; i < size; ++i) {
                            fv[i] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name2, fv);
                        --v;
                        break block5;
                    }
                    case 68: {
                        double[] dv = new double[size];
                        for (int i = 0; i < size; ++i) {
                            dv[i] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name2, dv);
                        --v;
                        break block5;
                    }
                }
                v = this.readAnnotationValues(v - 3, buf, false, av.visitArray(name2));
            }
        }
        return v;
    }

    private void getImplicitFrame(Context frame) {
        String desc = frame.desc;
        Object[] locals = frame.local;
        int local = 0;
        if ((frame.access & 8) == 0) {
            locals[local++] = "<init>".equals(frame.name) ? Opcodes.UNINITIALIZED_THIS : this.readClass(this.header + 2, frame.buffer);
        }
        int i = 1;
        block8: while (true) {
            int j = i;
            switch (desc.charAt(i++)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    locals[local++] = Opcodes.INTEGER;
                    continue block8;
                }
                case 'F': {
                    locals[local++] = Opcodes.FLOAT;
                    continue block8;
                }
                case 'J': {
                    locals[local++] = Opcodes.LONG;
                    continue block8;
                }
                case 'D': {
                    locals[local++] = Opcodes.DOUBLE;
                    continue block8;
                }
                case '[': {
                    while (desc.charAt(i) == '[') {
                        ++i;
                    }
                    if (desc.charAt(i) == 'L') {
                        ++i;
                        while (desc.charAt(i) != ';') {
                            ++i;
                        }
                    }
                    locals[local++] = desc.substring(j, ++i);
                    continue block8;
                }
                case 'L': {
                    while (desc.charAt(i) != ';') {
                        ++i;
                    }
                    locals[local++] = desc.substring(j + 1, i++);
                    continue block8;
                }
            }
            break;
        }
        frame.localCount = local;
    }

    private int readFrame(int stackMap, boolean zip2, boolean unzip, Context frame) {
        int delta;
        int tag;
        char[] c = frame.buffer;
        Label[] labels2 = frame.labels;
        if (zip2) {
            tag = this.b[stackMap++] & 0xFF;
        } else {
            tag = 255;
            frame.offset = -1;
        }
        frame.localDiff = 0;
        if (tag < 64) {
            delta = tag;
            frame.mode = 3;
            frame.stackCount = 0;
        } else if (tag < 128) {
            delta = tag - 64;
            stackMap = this.readFrameType(frame.stack, 0, stackMap, c, labels2);
            frame.mode = 4;
            frame.stackCount = 1;
        } else {
            delta = this.readUnsignedShort(stackMap);
            stackMap += 2;
            if (tag == 247) {
                stackMap = this.readFrameType(frame.stack, 0, stackMap, c, labels2);
                frame.mode = 4;
                frame.stackCount = 1;
            } else if (tag >= 248 && tag < 251) {
                frame.mode = 2;
                frame.localDiff = 251 - tag;
                frame.localCount -= frame.localDiff;
                frame.stackCount = 0;
            } else if (tag == 251) {
                frame.mode = 3;
                frame.stackCount = 0;
            } else if (tag < 255) {
                int local = unzip ? frame.localCount : 0;
                for (int i = tag - 251; i > 0; --i) {
                    stackMap = this.readFrameType(frame.local, local++, stackMap, c, labels2);
                }
                frame.mode = 1;
                frame.localDiff = tag - 251;
                frame.localCount += frame.localDiff;
                frame.stackCount = 0;
            } else {
                frame.mode = 0;
                int n = this.readUnsignedShort(stackMap);
                stackMap += 2;
                frame.localDiff = n;
                frame.localCount = n;
                int local = 0;
                while (n > 0) {
                    stackMap = this.readFrameType(frame.local, local++, stackMap, c, labels2);
                    --n;
                }
                n = this.readUnsignedShort(stackMap);
                stackMap += 2;
                frame.stackCount = n;
                int stack = 0;
                while (n > 0) {
                    stackMap = this.readFrameType(frame.stack, stack++, stackMap, c, labels2);
                    --n;
                }
            }
        }
        frame.offset += delta + 1;
        this.createLabel(frame.offset, labels2);
        return stackMap;
    }

    private int readFrameType(Object[] frame, int index2, int v, char[] buf, Label[] labels2) {
        int type2 = this.b[v++] & 0xFF;
        switch (type2) {
            case 0: {
                frame[index2] = Opcodes.TOP;
                break;
            }
            case 1: {
                frame[index2] = Opcodes.INTEGER;
                break;
            }
            case 2: {
                frame[index2] = Opcodes.FLOAT;
                break;
            }
            case 3: {
                frame[index2] = Opcodes.DOUBLE;
                break;
            }
            case 4: {
                frame[index2] = Opcodes.LONG;
                break;
            }
            case 5: {
                frame[index2] = Opcodes.NULL;
                break;
            }
            case 6: {
                frame[index2] = Opcodes.UNINITIALIZED_THIS;
                break;
            }
            case 7: {
                frame[index2] = this.readClass(v, buf);
                v += 2;
                break;
            }
            default: {
                frame[index2] = this.createLabel(this.readUnsignedShort(v), labels2);
                v += 2;
            }
        }
        return v;
    }

    protected Label readLabel(int offset2, Label[] labels2) {
        if (labels2[offset2] == null) {
            labels2[offset2] = new Label();
        }
        return labels2[offset2];
    }

    private Label createLabel(int offset2, Label[] labels2) {
        Label label = this.readLabel(offset2, labels2);
        label.status &= 0xFFFFFFFE;
        return label;
    }

    private void createDebugLabel(int offset2, Label[] labels2) {
        if (labels2[offset2] == null) {
            this.readLabel((int)offset2, (Label[])labels2).status |= 1;
        }
    }

    private int getAttributes() {
        int j;
        int i;
        int u = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;
        for (i = this.readUnsignedShort(u); i > 0; --i) {
            for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                u += 6 + this.readInt(u + 12);
            }
            u += 8;
        }
        for (i = this.readUnsignedShort(u += 2); i > 0; --i) {
            for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                u += 6 + this.readInt(u + 12);
            }
            u += 8;
        }
        return u + 2;
    }

    private Attribute readAttribute(Attribute[] attrs, String type2, int off, int len, char[] buf, int codeOff, Label[] labels2) {
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].type.equals(type2)) continue;
            return attrs[i].read(this, off, len, buf, codeOff, labels2);
        }
        return new Attribute(type2).read(this, off, len, null, -1, null);
    }

    public int readByte(int index2) {
        return this.b[index2] & 0xFF;
    }

    public int readUnsignedShort(int index2) {
        byte[] b = this.b;
        return (b[index2] & 0xFF) << 8 | b[index2 + 1] & 0xFF;
    }

    public short readShort(int index2) {
        byte[] b = this.b;
        return (short)((b[index2] & 0xFF) << 8 | b[index2 + 1] & 0xFF);
    }

    public int readInt(int index2) {
        byte[] b = this.b;
        return (b[index2] & 0xFF) << 24 | (b[index2 + 1] & 0xFF) << 16 | (b[index2 + 2] & 0xFF) << 8 | b[index2 + 3] & 0xFF;
    }

    public long readLong(int index2) {
        long l1 = this.readInt(index2);
        long l0 = (long)this.readInt(index2 + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index2, char[] buf) {
        int item = this.readUnsignedShort(index2);
        if (index2 == 0 || item == 0) {
            return null;
        }
        String s = this.strings[item];
        if (s != null) {
            return s;
        }
        index2 = this.items[item];
        this.strings[item] = this.readUTF(index2 + 2, this.readUnsignedShort(index2), buf);
        return this.strings[item];
    }

    private String readUTF(int index2, int utfLen, char[] buf) {
        int endIndex = index2 + utfLen;
        byte[] b = this.b;
        int strLen = 0;
        int st = 0;
        int cc = 0;
        while (index2 < endIndex) {
            int c = b[index2++];
            switch (st) {
                case 0: {
                    if ((c &= 0xFF) < 128) {
                        buf[strLen++] = (char)c;
                        break;
                    }
                    if (c < 224 && c > 191) {
                        cc = (char)(c & 0x1F);
                        st = 1;
                        break;
                    }
                    cc = (char)(c & 0xF);
                    st = 2;
                    break;
                }
                case 1: {
                    buf[strLen++] = (char)(cc << 6 | c & 0x3F);
                    st = 0;
                    break;
                }
                case 2: {
                    cc = (char)(cc << 6 | c & 0x3F);
                    st = 1;
                }
            }
        }
        return new String(buf, 0, strLen);
    }

    private String readStringish(int index2, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index2)], buf);
    }

    public String readClass(int index2, char[] buf) {
        return this.readStringish(index2, buf);
    }

    public String readModule(int index2, char[] buf) {
        return this.readStringish(index2, buf);
    }

    public String readPackage(int index2, char[] buf) {
        return this.readStringish(index2, buf);
    }

    public Object readConst(int item, char[] buf) {
        int index2 = this.items[item];
        switch (this.b[index2 - 1]) {
            case 3: {
                return this.readInt(index2);
            }
            case 4: {
                return Float.valueOf(Float.intBitsToFloat(this.readInt(index2)));
            }
            case 5: {
                return this.readLong(index2);
            }
            case 6: {
                return Double.longBitsToDouble(this.readLong(index2));
            }
            case 7: {
                return Type.getObjectType(this.readUTF8(index2, buf));
            }
            case 8: {
                return this.readUTF8(index2, buf);
            }
            case 16: {
                return Type.getMethodType(this.readUTF8(index2, buf));
            }
        }
        int tag = this.readByte(index2);
        int[] items = this.items;
        int cpIndex = items[this.readUnsignedShort(index2 + 1)];
        boolean itf = this.b[cpIndex - 1] == 11;
        String owner = this.readClass(cpIndex, buf);
        cpIndex = items[this.readUnsignedShort(cpIndex + 2)];
        String name2 = this.readUTF8(cpIndex, buf);
        String desc = this.readUTF8(cpIndex + 2, buf);
        return new Handle(tag, owner, name2, desc, itf);
    }
}

