/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.provider.HgDiffFromHistoryHandler;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgHistoryProvider
implements VcsHistoryProvider {
    private final Project myProject;

    public HgHistoryProvider(Project project) {
        this.myProject = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])ColumnInfo.EMPTY_ARRAY);
    }

    public AnAction[] getAdditionalActions(Runnable runnable) {
        return new AnAction[]{ShowAllAffectedGenericAction.getInstance(), ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction")};
    }

    public boolean isDateOmittable() {
        return false;
    }

    public String getHelpId() {
        return null;
    }

    public VcsHistorySession createSessionFor(FilePath filePath) {
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
        if (vcsRoot == null) {
            return null;
        }
        ArrayList<VcsFileRevision> revisions = new ArrayList<VcsFileRevision>(HgHistoryProvider.getHistory(filePath, vcsRoot, this.myProject));
        return this.createAppendableSession(vcsRoot, filePath, revisions, null);
    }

    public void reportAppendableHistory(FilePath filePath, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VirtualFile vcsRoot = HgUtil.getHgRootOrThrow(this.myProject, filePath);
        List<HgFileRevision> history = HgHistoryProvider.getHistory(filePath, vcsRoot, this.myProject);
        if (history.size() == 0) {
            return;
        }
        VcsAbstractHistorySession emptySession = this.createAppendableSession(vcsRoot, filePath, Collections.emptyList(), null);
        partner.reportCreatedEmptySession(emptySession);
        for (HgFileRevision hgFileRevision : history) {
            partner.acceptRevision((VcsFileRevision)hgFileRevision);
        }
        partner.finished();
    }

    @NotNull
    private VcsAbstractHistorySession createAppendableSession(final @NotNull VirtualFile vcsRoot, final @NotNull FilePath filePath, @NotNull List<VcsFileRevision> revisions, @Nullable VcsRevisionNumber number) {
        if (vcsRoot == null) {
            HgHistoryProvider.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            HgHistoryProvider.$$$reportNull$$$0(1);
        }
        if (revisions == null) {
            HgHistoryProvider.$$$reportNull$$$0(2);
        }
        VcsAbstractHistorySession vcsAbstractHistorySession = new VcsAbstractHistorySession(revisions, number){

            @Nullable
            protected VcsRevisionNumber calcCurrentRevisionNumber() {
                return (VcsRevisionNumber)new HgWorkingCopyRevisionsCommand((Project)((HgHistoryProvider)HgHistoryProvider.this).myProject).parents((VirtualFile)vcsRoot, (FilePath)filePath).first;
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }

            public VcsHistorySession copy() {
                return HgHistoryProvider.this.createAppendableSession(vcsRoot, filePath, this.getRevisionList(), this.getCurrentRevisionNumber());
            }
        };
        if (vcsAbstractHistorySession == null) {
            HgHistoryProvider.$$$reportNull$$$0(3);
        }
        return vcsAbstractHistorySession;
    }

    public static List<HgFileRevision> getHistory(@NotNull FilePath filePath, @NotNull VirtualFile vcsRoot, @NotNull Project project) {
        if (filePath == null) {
            HgHistoryProvider.$$$reportNull$$$0(4);
        }
        if (vcsRoot == null) {
            HgHistoryProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            HgHistoryProvider.$$$reportNull$$$0(6);
        }
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        return HgHistoryProvider.getHistory(filePath, vcsRoot, project, null, vcsConfiguration.LIMIT_HISTORY ? vcsConfiguration.MAXIMUM_HISTORY_ROWS : -1);
    }

    public static List<HgFileRevision> getHistory(@NotNull FilePath filePath, @NotNull VirtualFile vcsRoot, @NotNull Project project, @Nullable HgRevisionNumber revisionNumber, int limit) {
        if (filePath == null) {
            HgHistoryProvider.$$$reportNull$$$0(7);
        }
        if (vcsRoot == null) {
            HgHistoryProvider.$$$reportNull$$$0(8);
        }
        if (project == null) {
            HgHistoryProvider.$$$reportNull$$$0(9);
        }
        FilePath originalFilePath = HgUtil.getOriginalFileName(filePath, ChangeListManager.getInstance((Project)project));
        if (revisionNumber == null && !filePath.isDirectory() && !filePath.equals(originalFilePath)) {
            return HgHistoryProvider.getHistoryForUncommittedRenamed(originalFilePath, vcsRoot, project, limit);
        }
        HgLogCommand logCommand = new HgLogCommand(project);
        logCommand.setFollowCopies(!filePath.isDirectory());
        logCommand.setIncludeRemoved(true);
        ArrayList<String> args = new ArrayList<String>();
        if (revisionNumber != null) {
            args.add("--rev");
            args.add("reverse(0::" + revisionNumber.getChangeset() + ")");
        }
        return logCommand.execute(new HgFile(vcsRoot, filePath), limit, false, args);
    }

    private static List<HgFileRevision> getHistoryForUncommittedRenamed(@NotNull FilePath originalHgFilePath, @NotNull VirtualFile vcsRoot, @NotNull Project project, int limit) {
        if (originalHgFilePath == null) {
            HgHistoryProvider.$$$reportNull$$$0(10);
        }
        if (vcsRoot == null) {
            HgHistoryProvider.$$$reportNull$$$0(11);
        }
        if (project == null) {
            HgHistoryProvider.$$$reportNull$$$0(12);
        }
        HgFile originalHgFile = new HgFile(vcsRoot, originalHgFilePath);
        HgLogCommand logCommand = new HgLogCommand(project);
        logCommand.setIncludeRemoved(true);
        HgVersion version = logCommand.getVersion();
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(false, version);
        String template = HgChangesetUtil.makeTemplate(templates);
        ArrayList argsForCmd = ContainerUtil.newArrayList();
        String relativePath = originalHgFile.getRelativePath();
        argsForCmd.add("--rev");
        argsForCmd.add(String.format("reverse(follow(%s))", relativePath != null ? "'" + FileUtil.toSystemIndependentName((String)relativePath) + "'" : ""));
        HgCommandResult result = logCommand.execute(vcsRoot, template, limit, relativePath != null ? null : originalHgFile, argsForCmd);
        return HgHistoryUtil.getCommitRecords(project, result, new HgFileRevisionLogParser(project, originalHgFile, version));
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return new HgDiffFromHistoryHandler(this.myProject);
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        if (file == null) {
            HgHistoryProvider.$$$reportNull$$$0(13);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/provider/HgHistoryProvider";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalHgFilePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/provider/HgHistoryProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppendableSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAppendableSession";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHistory";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryForUncommittedRenamed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canShowHistoryFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

