/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.repo.AsyncFilesManagerListener;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgBranchesCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.HgLocalIgnoredHolder;
import org.zmlx.hg4idea.repo.HgConfig;
import org.zmlx.hg4idea.repo.HgRepoInfo;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryReader;
import org.zmlx.hg4idea.repo.HgRepositoryUpdater;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRepositoryImpl
extends RepositoryImpl
implements HgRepository {
    private static final Logger LOG = Logger.getInstance(HgRepositoryImpl.class);
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgRepositoryReader myReader;
    @NotNull
    private final VirtualFile myHgDir;
    @NotNull
    private volatile HgRepoInfo myInfo;
    @NotNull
    private Set<String> myOpenedBranches;
    @NotNull
    private volatile HgConfig myConfig;
    private boolean myIsFresh;
    private final HgLocalIgnoredHolder myLocalIgnoredHolder;

    private HgRepositoryImpl(@NotNull VirtualFile rootDir, @NotNull HgVcs vcs, @NotNull Disposable parentDisposable) {
        if (rootDir == null) {
            HgRepositoryImpl.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            HgRepositoryImpl.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            HgRepositoryImpl.$$$reportNull$$$0(2);
        }
        super(vcs.getProject(), rootDir, parentDisposable);
        this.myOpenedBranches = Collections.emptySet();
        this.myIsFresh = true;
        this.myVcs = vcs;
        this.myHgDir = rootDir.findChild(".hg");
        assert (this.myHgDir != null) : ".hg directory wasn't found under " + rootDir.getPresentableUrl();
        this.myReader = new HgRepositoryReader(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myHgDir));
        this.myConfig = HgConfig.getInstance(this.getProject(), rootDir);
        this.myLocalIgnoredHolder = new HgLocalIgnoredHolder(this);
        Disposer.register((Disposable)this, (Disposable)this.myLocalIgnoredHolder);
        this.myLocalIgnoredHolder.addUpdateStateListener(new MyIgnoredHolderAsyncListener(this.getProject()));
        this.update();
    }

    @NotNull
    public static HgRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable) {
        HgVcs vcs;
        if (root == null) {
            HgRepositoryImpl.$$$reportNull$$$0(3);
        }
        if (project == null) {
            HgRepositoryImpl.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            HgRepositoryImpl.$$$reportNull$$$0(5);
        }
        if ((vcs = HgVcs.getInstance(project)) == null) {
            throw new IllegalArgumentException("Vcs not found for project " + project);
        }
        HgRepositoryImpl repository = new HgRepositoryImpl(root, vcs, parentDisposable);
        repository.setupUpdater();
        HgRepositoryImpl hgRepositoryImpl = repository;
        if (hgRepositoryImpl == null) {
            HgRepositoryImpl.$$$reportNull$$$0(6);
        }
        return hgRepositoryImpl;
    }

    private void setupUpdater() {
        HgRepositoryUpdater updater = new HgRepositoryUpdater(this);
        Disposer.register((Disposable)this, (Disposable)updater);
        this.myLocalIgnoredHolder.startRescan();
    }

    @Override
    @NotNull
    public VirtualFile getHgDir() {
        VirtualFile virtualFile = this.myHgDir;
        if (virtualFile == null) {
            HgRepositoryImpl.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myInfo.getState();
        if (state == null) {
            HgRepositoryImpl.$$$reportNull$$$0(8);
        }
        return state;
    }

    @Nullable
    public String getCurrentBranchName() {
        String branchOrBookMarkName = this.getCurrentBookmark();
        if (StringUtil.isEmptyOrSpaces((String)branchOrBookMarkName)) {
            branchOrBookMarkName = this.getCurrentBranch();
        }
        return branchOrBookMarkName;
    }

    @NotNull
    public AbstractVcs getVcs() {
        HgVcs hgVcs = this.myVcs;
        if (hgVcs == null) {
            HgRepositoryImpl.$$$reportNull$$$0(9);
        }
        return hgVcs;
    }

    @Override
    @NotNull
    public String getCurrentBranch() {
        String string = this.myInfo.getCurrentBranch();
        if (string == null) {
            HgRepositoryImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @Override
    @Nullable
    public String getTipRevision() {
        return this.myInfo.getTipRevision();
    }

    @Override
    @NotNull
    public Map<String, LinkedHashSet<Hash>> getBranches() {
        Map<String, LinkedHashSet<Hash>> map = this.myInfo.getBranches();
        if (map == null) {
            HgRepositoryImpl.$$$reportNull$$$0(11);
        }
        return map;
    }

    @Override
    @NotNull
    public Set<String> getOpenedBranches() {
        Set<String> set = this.myOpenedBranches;
        if (set == null) {
            HgRepositoryImpl.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getBookmarks() {
        Collection<HgNameWithHashInfo> collection = this.myInfo.getBookmarks();
        if (collection == null) {
            HgRepositoryImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Override
    @Nullable
    public String getCurrentBookmark() {
        return this.myInfo.getCurrentBookmark();
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getTags() {
        Collection<HgNameWithHashInfo> collection = this.myInfo.getTags();
        if (collection == null) {
            HgRepositoryImpl.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getLocalTags() {
        Collection<HgNameWithHashInfo> collection = this.myInfo.getLocalTags();
        if (collection == null) {
            HgRepositoryImpl.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @Override
    @NotNull
    public HgConfig getRepositoryConfig() {
        HgConfig hgConfig = this.myConfig;
        if (hgConfig == null) {
            HgRepositoryImpl.$$$reportNull$$$0(16);
        }
        return hgConfig;
    }

    @Override
    public boolean hasSubrepos() {
        return this.myInfo.hasSubrepos();
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getSubrepos() {
        Collection<HgNameWithHashInfo> collection = this.myInfo.getSubrepos();
        if (collection == null) {
            HgRepositoryImpl.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<HgNameWithHashInfo> getMQAppliedPatches() {
        List<HgNameWithHashInfo> list = this.myInfo.getMQApplied();
        if (list == null) {
            HgRepositoryImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getAllPatchNames() {
        List<String> list = this.myInfo.getMqPatchNames();
        if (list == null) {
            HgRepositoryImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getUnappliedPatchNames() {
        List<String> appliedPatches = HgUtil.getNamesWithoutHashes(this.getMQAppliedPatches());
        List list = ContainerUtil.filter(this.getAllPatchNames(), s -> !appliedPatches.contains(s));
        if (list == null) {
            HgRepositoryImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    public boolean isFresh() {
        return this.myIsFresh;
    }

    public void update() {
        HgRepoInfo currentInfo = this.readRepoInfo();
        Project project = this.getProject();
        if (!project.isDisposed() && !currentInfo.equals(this.myInfo)) {
            this.myInfo = currentInfo;
            HgCommandResult branchCommandResult = new HgBranchesCommand(project, this.getRoot()).collectBranches();
            if (branchCommandResult == null || branchCommandResult.getExitValue() != 0) {
                LOG.warn("Could not collect hg opened branches.");
                this.myOpenedBranches = this.myInfo.getBranches().keySet();
            } else {
                this.myOpenedBranches = HgBranchesCommand.collectNames(branchCommandResult);
            }
            BackgroundTaskUtil.executeOnPooledThread((Disposable)project, () -> ((HgUpdater)BackgroundTaskUtil.syncPublisher((Project)project, HgVcs.STATUS_TOPIC)).update(project, this.getRoot()));
        }
    }

    @NotNull
    public String toLogString() {
        String string = "HgRepository " + this.getRoot() + " : " + this.myInfo;
        if (string == null) {
            HgRepositoryImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private HgRepoInfo readRepoInfo() {
        this.myIsFresh = this.myIsFresh && this.myReader.isFresh();
        HgRepoInfo hgRepoInfo = new HgRepoInfo(this.myReader.readCurrentBranch(), this.myReader.readCurrentRevision(), this.myReader.readCurrentTipRevision(), this.myReader.readState(), this.myReader.readBranches(), this.myReader.readBookmarks(), this.myReader.readCurrentBookmark(), this.myReader.readTags(), this.myReader.readLocalTags(), this.myReader.readSubrepos(), this.myReader.readMQAppliedPatches(), this.myReader.readMqPatchNames());
        if (hgRepoInfo == null) {
            HgRepositoryImpl.$$$reportNull$$$0(22);
        }
        return hgRepoInfo;
    }

    @Override
    public void updateConfig() {
        this.myConfig = HgConfig.getInstance(this.getProject(), this.getRoot());
    }

    @Override
    public HgLocalIgnoredHolder getLocalIgnoredHolder() {
        return this.myLocalIgnoredHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/repo/HgRepositoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/repo/HgRepositoryImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHgDir";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranch";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenedBranches";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBookmarks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalTags";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryConfig";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubrepos";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMQAppliedPatches";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPatchNames";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnappliedPatchNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toLogString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "readRepoInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyIgnoredHolderAsyncListener
    implements AsyncFilesManagerListener {
        @NotNull
        private final ChangesViewI myChangesViewI;

        public MyIgnoredHolderAsyncListener(@NotNull Project project) {
            if (project == null) {
                MyIgnoredHolderAsyncListener.$$$reportNull$$$0(0);
            }
            this.myChangesViewI = ChangesViewManager.getInstance((Project)project);
        }

        public void updateStarted() {
            this.myChangesViewI.scheduleRefresh();
        }

        public void updateFinished() {
            this.myChangesViewI.scheduleRefresh();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/repo/HgRepositoryImpl$MyIgnoredHolderAsyncListener", "<init>"));
        }
    }
}

