/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth;

import com.microsoft.alm.auth.BaseAuthenticator;
import com.microsoft.alm.auth.PromptBehavior;
import com.microsoft.alm.auth.oauth.AzureAuthority;
import com.microsoft.alm.auth.oauth.DeviceFlowResponse;
import com.microsoft.alm.auth.oauth.Global;
import com.microsoft.alm.auth.oauth.OAuth2UseragentValidator;
import com.microsoft.alm.auth.oauth.helper.AzureAuthorityProvider;
import com.microsoft.alm.auth.oauth.helper.SwtJarLoader;
import com.microsoft.alm.helpers.Action;
import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.HttpClient;
import com.microsoft.alm.helpers.LoggingHelper;
import com.microsoft.alm.helpers.SettingsHelper;
import com.microsoft.alm.helpers.StringHelper;
import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.secret.TokenPair;
import com.microsoft.alm.storage.InsecureInMemoryStore;
import com.microsoft.alm.storage.SecretStore;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Authenticator
extends BaseAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2Authenticator.class);
    public static final String POPUP_QUERY_PARAM = "display=popup";
    public static final URI APP_VSSPS_VISUALSTUDIO = URI.create("https://app.vssps.visualstudio.com");
    public static final String MANAGEMENT_CORE_RESOURCE = "https://management.core.windows.net/";
    public static final String VALIDATION_ENDPOINT = APP_VSSPS_VISUALSTUDIO + "/_apis/connectionData";
    public static final String VSTS_RESOURCE = "499b84ac-1321-427f-aa17-267ca6975798";
    public static final String SWT_PROIVDER_NAME = "StandardWidgetToolkit";
    public static final String JAVAFX_PROVIDER_NAME = "JavaFx";
    private static final String TYPE = "OAuth2";
    private static final String USER_AGENT_PROVIDER_PROPERTY_NAME = "userAgentProvider";
    private final String resource;
    private final String clientId;
    private final URI redirectUri;
    private final SecretStore<TokenPair> store;
    private final OAuth2UseragentValidator oAuth2UseragentValidator;
    private final Action<DeviceFlowResponse> deviceFlowCallback;
    private AzureAuthorityProvider azureAuthorityProvider = new AzureAuthorityProvider();

    public static OAuth2Authenticator getAuthenticator(String clientId, String redirectUrl, SecretStore<TokenPair> store) {
        logger.debug("Authenticator manages resource: {}", (Object)MANAGEMENT_CORE_RESOURCE);
        return new OAuth2AuthenticatorBuilder().manage(MANAGEMENT_CORE_RESOURCE).withClientId(clientId).redirectTo(redirectUrl).backedBy(store).build();
    }

    public static OAuth2Authenticator getAuthenticator(String clientId, String redirectUrl, SecretStore<TokenPair> store, Action<DeviceFlowResponse> deviceFlowCallback) {
        logger.debug("Authenticator manages resource: {}", (Object)MANAGEMENT_CORE_RESOURCE);
        return new OAuth2AuthenticatorBuilder().manage(MANAGEMENT_CORE_RESOURCE).withClientId(clientId).redirectTo(redirectUrl).backedBy(store).withDeviceFlowCallback(deviceFlowCallback).build();
    }

    OAuth2Authenticator(String resource, String clientId, URI redirectUri, SecretStore<TokenPair> store, OAuth2UseragentValidator oAuth2UseragentValidator, Action<DeviceFlowResponse> deviceFlowCallback) {
        Debug.Assert((resource != null ? 1 : 0) != 0, (String)"resource cannot be null");
        Debug.Assert((clientId != null ? 1 : 0) != 0, (String)"clientId cannot be null");
        Debug.Assert((redirectUri != null ? 1 : 0) != 0, (String)"redirectUri cannot be null");
        this.resource = resource;
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.oAuth2UseragentValidator = oAuth2UseragentValidator;
        this.deviceFlowCallback = deviceFlowCallback;
        logger.debug("Using default SecretStore? {}", (Object)(store == null ? 1 : 0));
        this.store = store == null ? new InsecureInMemoryStore() : store;
    }

    @Override
    public String getAuthType() {
        return TYPE;
    }

    protected SecretStore<TokenPair> getStore() {
        return this.store;
    }

    @Override
    public boolean isOAuth2TokenSupported() {
        return true;
    }

    @Override
    public TokenPair getOAuth2TokenPair() {
        return this.getOAuth2TokenPair(APP_VSSPS_VISUALSTUDIO, PromptBehavior.AUTO);
    }

    @Override
    public TokenPair getOAuth2TokenPair(PromptBehavior promptBehavior) {
        return this.getOAuth2TokenPair(APP_VSSPS_VISUALSTUDIO, promptBehavior);
    }

    @Override
    public TokenPair getOAuth2TokenPair(final URI uri, PromptBehavior promptBehavior) {
        Debug.Assert((promptBehavior != null ? 1 : 0) != 0, (String)"getOAuth2TokenPair promptBehavior cannot be null");
        Debug.Assert((uri != null ? 1 : 0) != 0, (String)"getOAuth2TokenPair uri cannot be null");
        logger.debug("Retrieving OAuth2 TokenPair with prompt behavior: {}", (Object)promptBehavior.name());
        String key = this.getKey(APP_VSSPS_VISUALSTUDIO);
        BaseAuthenticator.SecretRetriever<TokenPair> secretRetriever = new BaseAuthenticator.SecretRetriever<TokenPair>(){

            private boolean validateAccessToken(Token accessToken, URI validationEndpoint) {
                HttpClient client = Global.getHttpClientFactory().createHttpClient();
                accessToken.contributeHeader(client.getHeaders());
                try {
                    String response = client.getGetResponseText(validationEndpoint);
                    return true;
                }
                catch (IOException e) {
                    logger.debug("Validation failed with IOException.", (Throwable)e);
                    return false;
                }
            }

            @Override
            protected boolean tryGetValidated(TokenPair tokenPair, AtomicReference<TokenPair> holder) {
                Debug.Assert((tokenPair != null ? 1 : 0) != 0, (String)"TokenPair is null");
                Debug.Assert((holder != null ? 1 : 0) != 0, (String)"Holder is null");
                URI validationEndpoint = URI.create(VALIDATION_ENDPOINT);
                boolean valid = false;
                if (tokenPair.AccessToken != null && !StringHelper.isNullOrEmpty((String)tokenPair.AccessToken.Value)) {
                    logger.debug("Validating stored OAuth2 Access Token...");
                    valid = this.validateAccessToken(tokenPair.AccessToken, validationEndpoint);
                }
                if (!valid && tokenPair.RefreshToken != null && !StringHelper.isNullOrEmpty((String)tokenPair.RefreshToken.Value)) {
                    logger.debug("OAuth2 Access Token is not valid, and we have a refresh token, try refreshing...");
                    TokenPair renewedTokenPair = OAuth2Authenticator.this.getAzureAuthority(uri).acquireTokenByRefreshToken(OAuth2Authenticator.this.clientId, OAuth2Authenticator.this.resource, tokenPair.RefreshToken);
                    if (renewedTokenPair != null && renewedTokenPair.AccessToken.Value != null && renewedTokenPair.RefreshToken.Value != null) {
                        logger.debug("OAuth2 Access Token refreshed successfully.");
                        valid = true;
                        holder.set(renewedTokenPair);
                    }
                }
                logger.debug("OAuth2 Access Token is {}.", (Object)(valid ? "valid" : "invalid."));
                return valid;
            }

            @Override
            protected TokenPair doRetrieve() {
                logger.info("Ready to launch browser flow to retrieve oauth2 token.");
                AtomicReference<File> swtRuntime = new AtomicReference<File>();
                String defaultProviderName = SettingsHelper.getInstance().getProperty(OAuth2Authenticator.USER_AGENT_PROVIDER_PROPERTY_NAME, OAuth2Authenticator.JAVAFX_PROVIDER_NAME);
                logger.info("Attempt to use oauth2-useragent provider: {}", (Object)defaultProviderName);
                boolean favorSwtBrowser = defaultProviderName.equals(OAuth2Authenticator.SWT_PROIVDER_NAME);
                boolean favorDeviceFlow = defaultProviderName.equalsIgnoreCase("none");
                try {
                    if (favorSwtBrowser) {
                        logger.debug("Prefer SWT Browser, download SWT Runtime if it is not available.");
                        if (OAuth2Authenticator.this.oAuth2UseragentValidator.isOnlyMissingRuntimeFromSwtProvider()) {
                            SwtJarLoader.tryGetSwtJar(swtRuntime);
                        }
                    }
                    if (!favorDeviceFlow && (OAuth2Authenticator.this.oAuth2UseragentValidator.isOAuth2ProviderAvailable() || OAuth2Authenticator.this.oAuth2UseragentValidator.isOnlyMissingRuntimeFromSwtProvider() && SwtJarLoader.tryGetSwtJar(swtRuntime))) {
                        try {
                            logger.info("Using oauth2-useragent providers to retrieve AAD token.");
                            return OAuth2Authenticator.this.getAzureAuthority(uri).acquireToken(OAuth2Authenticator.this.clientId, OAuth2Authenticator.this.resource, OAuth2Authenticator.this.redirectUri, OAuth2Authenticator.POPUP_QUERY_PARAM);
                        }
                        catch (AuthorizationException e) {
                            LoggingHelper.logError((Logger)logger, (String)"Failed to launch oauth2-useragent.", (Throwable)e);
                            if (!"unknown_error".equalsIgnoreCase(e.getCode())) {
                                return null;
                            }
                        }
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (iae.getMessage().startsWith("Unrecognized version string")) {
                        LoggingHelper.logError((Logger)logger, (String)"Could not parse JVM version, continue with device flow.", (Throwable)iae);
                    }
                    throw iae;
                }
                if (OAuth2Authenticator.this.deviceFlowCallback != null) {
                    logger.info("Fallback to Device Flow.");
                    try {
                        return OAuth2Authenticator.this.getAzureAuthority(uri).acquireToken(OAuth2Authenticator.this.clientId, OAuth2Authenticator.this.resource, OAuth2Authenticator.this.redirectUri, (Action<DeviceFlowResponse>)OAuth2Authenticator.this.deviceFlowCallback);
                    }
                    catch (AuthorizationException e) {
                        LoggingHelper.logError((Logger)logger, (String)"Failed to use the Device Flow authenticator.", (Throwable)e);
                    }
                }
                return null;
            }
        };
        return secretRetriever.retrieve(key, this.getStore(), promptBehavior);
    }

    @Override
    public boolean signOut() {
        return super.signOut(APP_VSSPS_VISUALSTUDIO);
    }

    void setAzureAuthorityProvider(AzureAuthorityProvider azureAuthorityProvider) {
        this.azureAuthorityProvider = azureAuthorityProvider;
    }

    private AzureAuthority getAzureAuthority(URI uri) {
        try {
            return this.azureAuthorityProvider.getAzureAuthority(uri);
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    public static class OAuth2AuthenticatorBuilder {
        private String resource;
        private String clientId;
        private URI redirectUri;
        private SecretStore store;
        private String tenantId = "common";
        private Action<DeviceFlowResponse> deviceFlowCallback;

        public OAuth2AuthenticatorBuilder manage(String resource) {
            Debug.Assert((resource != null ? 1 : 0) != 0, (String)"resource cannot be null");
            this.resource = resource;
            return this;
        }

        public OAuth2AuthenticatorBuilder withClientId(UUID clientId) {
            return this.withClientId(clientId.toString());
        }

        public OAuth2AuthenticatorBuilder withClientId(String clientId) {
            Debug.Assert((clientId != null ? 1 : 0) != 0, (String)"clientId cannot be null");
            this.clientId = clientId;
            return this;
        }

        public OAuth2AuthenticatorBuilder redirectTo(URI redirectUri) {
            Debug.Assert((redirectUri != null ? 1 : 0) != 0, (String)"redirectUri cannot be null");
            this.redirectUri = redirectUri;
            return this;
        }

        public OAuth2AuthenticatorBuilder redirectTo(String redirectUri) {
            return this.redirectTo(URI.create(redirectUri));
        }

        public OAuth2AuthenticatorBuilder backedBy(SecretStore store) {
            Debug.Assert((store != null ? 1 : 0) != 0, (String)"store cannot be null");
            this.store = store;
            return this;
        }

        public OAuth2AuthenticatorBuilder withDeviceFlowCallback(Action<DeviceFlowResponse> deviceFlowCallback) {
            this.deviceFlowCallback = deviceFlowCallback;
            return this;
        }

        public OAuth2Authenticator build() {
            if (this.clientId == null) {
                throw new IllegalStateException("ClientId not set");
            }
            if (this.resource == null) {
                throw new IllegalStateException("resource not set");
            }
            if (this.redirectUri == null) {
                throw new IllegalStateException("redirectUri not set");
            }
            OAuth2UseragentValidator oAuth2UseragentValidator = new OAuth2UseragentValidator();
            return new OAuth2Authenticator(this.resource, this.clientId, this.redirectUri, (SecretStore<TokenPair>)this.store, oAuth2UseragentValidator, this.deviceFlowCallback);
        }
    }
}

