/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.auth.oauth;

import com.microsoft.alm.auth.oauth.UserIdentifierType;
import com.microsoft.alm.helpers.StringHelper;

public final class UserIdentifier {
    private static final String ANY_USER_ID = "AnyUser";
    public static final UserIdentifier ANY_USER = new UserIdentifier("AnyUser", UserIdentifierType.UNIQUE_ID);
    private final String id;
    private final UserIdentifierType type;

    public UserIdentifier(String id, UserIdentifierType type) {
        if (StringHelper.isNullOrWhiteSpace((String)id)) {
            throw new IllegalArgumentException("id is null or empty");
        }
        this.id = id;
        this.type = type;
    }

    public UserIdentifierType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    boolean isAnyUser() {
        return this.type == UserIdentifier.ANY_USER.type && this.id.equals(UserIdentifier.ANY_USER.id);
    }

    String getUniqueId() {
        return !this.isAnyUser() && this.type == UserIdentifierType.UNIQUE_ID ? this.id : null;
    }

    String getDisplayableId() {
        return !this.isAnyUser() && (this.type == UserIdentifierType.OPTIONAL_DISPLAYABLE_ID || this.type == UserIdentifierType.REQUIRED_DISPLAYABLE_ID) ? this.id : null;
    }
}

