/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.instrumentation.JSR45Util;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceFilesCollector
extends ClassVisitor {
    private final List<String> sources = new ArrayList<String>(1);
    private final String className;

    SourceFilesCollector(int api, ClassVisitor cv, String className) {
        super(api, cv);
        this.className = className;
    }

    List<String> getSources() {
        return this.sources;
    }

    @Override
    public void visitSource(String source, String debug) {
        if (debug != null) {
            this.sources.addAll(JSR45Util.parseSourcePaths(debug));
        } else {
            this.sources.add(JSR45Util.getClassPackageName(this.className).replace(".", "/") + source);
        }
        super.visitSource(source, debug);
    }
}

