/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.main;

import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import com.intellij.rt.coverage.testDiscovery.main.TestDiscoveryTransformer;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDiscoveryPremain {
    public static final String INCLUDE_PATTERNS_VM_OP = "test.discovery.include.class.patterns";
    public static final String EXCLUDE_PATTERNS_VM_OP = "test.discovery.exclude.class.patterns";

    private void performPremain(Instrumentation instrumentation) {
        System.out.println("---- IntelliJ IDEA Test Discovery ---- ");
        List<Pattern> include = TestDiscoveryPremain.patterns(INCLUDE_PATTERNS_VM_OP);
        List<Pattern> exclude = TestDiscoveryPremain.patterns(EXCLUDE_PATTERNS_VM_OP);
        TestDiscoveryProjectData projectData = TestDiscoveryProjectData.getProjectData();
        instrumentation.addTransformer(new TestDiscoveryTransformer(exclude, include));
    }

    private static List<Pattern> patterns(String key) {
        String property = System.getProperty(key);
        if (property == null) {
            return Collections.emptyList();
        }
        System.out.println("Patterns from " + key);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(1);
        for (String s : property.split(";")) {
            try {
                patterns.add(Pattern.compile(s));
                System.out.println(s);
            }
            catch (PatternSyntaxException ex) {
                System.err.println("Problem occurred with pattern " + s);
                System.err.println(ex.getDescription());
                System.exit(1);
            }
        }
        return patterns;
    }

    public static void premain(String argsString, Instrumentation instrumentation) {
        new TestDiscoveryPremain().performPremain(instrumentation);
    }
}

