/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.Reporter;
import org.testng.internal.Utils;
import org.testng.reporters.XMLReporterConfig;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.XMLSuiteResultWriter;
import org.testng.util.TimeUtils;
import org.testng.xml.XmlSuite;

public class XMLReporter
implements IReporter {
    public static final String FILE_NAME = "testng-results.xml";
    private static final String JVM_ARG = "testng.report.xml.name";
    private final XMLReporterConfig config = new XMLReporterConfig();
    private XMLStringBuffer rootBuffer;

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        if (Utils.isStringEmpty(this.config.getOutputDirectory())) {
            this.config.setOutputDirectory(outputDirectory);
        }
        int passed = 0;
        int failed = 0;
        int skipped = 0;
        int ignored = 0;
        for (ISuite s : suites) {
            Map<String, ISuiteResult> suiteResults = s.getResults();
            for (ISuiteResult sr : suiteResults.values()) {
                ITestContext testContext = sr.getTestContext();
                passed += testContext.getPassedTests().size();
                failed += testContext.getFailedTests().size();
                skipped += testContext.getSkippedTests().size();
                ignored += testContext.getExcludedMethods().size();
            }
        }
        this.rootBuffer = new XMLStringBuffer();
        Properties p = new Properties();
        p.put("passed", (Object)passed);
        p.put("failed", (Object)failed);
        p.put("skipped", (Object)skipped);
        p.put("ignored", (Object)ignored);
        p.put("total", (Object)(passed + failed + skipped + ignored));
        this.rootBuffer.push("testng-results", p);
        this.writeReporterOutput(this.rootBuffer);
        for (ISuite suite : suites) {
            this.writeSuite(suite);
        }
        this.rootBuffer.pop();
        Utils.writeUtf8File(this.config.getOutputDirectory(), XMLReporter.fileName(), this.rootBuffer, null);
    }

    private static final String fileName() {
        return System.getProperty(JVM_ARG, FILE_NAME);
    }

    private void writeReporterOutput(XMLStringBuffer xmlBuffer) {
        xmlBuffer.push("reporter-output");
        List<String> output = Reporter.getOutput();
        for (String line : output) {
            if (line == null) continue;
            xmlBuffer.push("line");
            xmlBuffer.addCDATA(line);
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private void writeSuite(ISuite suite) {
        switch (this.config.getFileFragmentationLevel()) {
            case 1: {
                this.writeSuiteToBuffer(this.rootBuffer, suite);
                break;
            }
            case 2: 
            case 3: {
                File suiteFile = this.referenceSuite(this.rootBuffer, suite);
                this.writeSuiteToFile(suiteFile, suite);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected value: " + this.config.getFileFragmentationLevel()));
            }
        }
    }

    private void writeSuiteToFile(File suiteFile, ISuite suite) {
        XMLStringBuffer xmlBuffer = new XMLStringBuffer();
        this.writeSuiteToBuffer(xmlBuffer, suite);
        File parentDir = suiteFile.getParentFile();
        suiteFile.getParentFile().mkdirs();
        if (parentDir.exists() || suiteFile.getParentFile().exists()) {
            Utils.writeUtf8File(parentDir.getAbsolutePath(), FILE_NAME, xmlBuffer.toXML());
        }
    }

    private File referenceSuite(XMLStringBuffer xmlBuffer, ISuite suite) {
        String relativePath = suite.getName() + File.separatorChar + FILE_NAME;
        File suiteFile = new File(this.config.getOutputDirectory(), relativePath);
        Properties attrs = new Properties();
        attrs.setProperty("url", relativePath);
        xmlBuffer.addEmptyElement("suite", attrs);
        return suiteFile;
    }

    private void writeSuiteToBuffer(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("suite", this.getSuiteAttributes(suite));
        this.writeSuiteGroups(xmlBuffer, suite);
        Map<String, ISuiteResult> results = suite.getResults();
        XMLSuiteResultWriter suiteResultWriter = new XMLSuiteResultWriter(this.config);
        for (Map.Entry<String, ISuiteResult> result : results.entrySet()) {
            suiteResultWriter.writeSuiteResult(xmlBuffer, result.getValue());
        }
        xmlBuffer.pop();
    }

    private void writeSuiteGroups(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("groups");
        Map<String, Collection<ITestNGMethod>> methodsByGroups = suite.getMethodsByGroups();
        for (Map.Entry<String, Collection<ITestNGMethod>> entry : methodsByGroups.entrySet()) {
            Properties groupAttrs = new Properties();
            groupAttrs.setProperty("name", entry.getKey());
            xmlBuffer.push("group", groupAttrs);
            Set<ITestNGMethod> groupMethods = this.getUniqueMethodSet(entry.getValue());
            for (ITestNGMethod groupMethod : groupMethods) {
                Properties methodAttrs = new Properties();
                methodAttrs.setProperty("name", groupMethod.getMethodName());
                methodAttrs.setProperty("signature", groupMethod.toString());
                methodAttrs.setProperty("class", groupMethod.getRealClass().getName());
                xmlBuffer.addEmptyElement("method", methodAttrs);
            }
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private Properties getSuiteAttributes(ISuite suite) {
        Properties props = new Properties();
        props.setProperty("name", suite.getName());
        Map<String, ISuiteResult> results = suite.getResults();
        Date minStartDate = new Date();
        Date maxEndDate = null;
        for (Map.Entry<String, ISuiteResult> result : results.entrySet()) {
            ITestContext testContext = result.getValue().getTestContext();
            Date startDate = testContext.getStartDate();
            Date endDate = testContext.getEndDate();
            if (minStartDate.after(startDate)) {
                minStartDate = startDate;
            }
            if (maxEndDate != null && !maxEndDate.before(endDate)) continue;
            maxEndDate = endDate != null ? endDate : startDate;
        }
        if (maxEndDate == null) {
            maxEndDate = minStartDate;
        }
        XMLReporter.addDurationAttributes(this.config, props, minStartDate, maxEndDate);
        return props;
    }

    public static void addDurationAttributes(XMLReporterConfig config, Properties attributes, Date minStartDate, Date maxEndDate) {
        String startTime = TimeUtils.timeInUTC(minStartDate.getTime(), config.getTimestampFormat());
        String endTime = TimeUtils.timeInUTC(maxEndDate.getTime(), config.getTimestampFormat());
        long duration = maxEndDate.getTime() - minStartDate.getTime();
        attributes.setProperty("started-at", startTime);
        attributes.setProperty("finished-at", endTime);
        attributes.setProperty("duration-ms", Long.toString(duration));
    }

    private Set<ITestNGMethod> getUniqueMethodSet(Collection<ITestNGMethod> methods) {
        LinkedHashSet<ITestNGMethod> result = new LinkedHashSet<ITestNGMethod>();
        for (ITestNGMethod method : methods) {
            result.add(method);
        }
        return result;
    }

    @Deprecated
    public int getFileFragmentationLevel() {
        return this.config.getFileFragmentationLevel();
    }

    @Deprecated
    public void setFileFragmentationLevel(int fileFragmentationLevel) {
        this.config.setFileFragmentationLevel(fileFragmentationLevel);
    }

    @Deprecated
    public int getStackTraceOutputMethod() {
        return this.config.getStackTraceOutputMethod();
    }

    @Deprecated
    public void setStackTraceOutputMethod(int stackTraceOutputMethod) {
        this.config.setStackTraceOutputMethod(stackTraceOutputMethod);
    }

    @Deprecated
    public String getOutputDirectory() {
        return this.config.getOutputDirectory();
    }

    @Deprecated
    public void setOutputDirectory(String outputDirectory) {
        this.config.setOutputDirectory(outputDirectory);
    }

    @Deprecated
    public boolean isGenerateGroupsAttribute() {
        return this.config.isGenerateGroupsAttribute();
    }

    @Deprecated
    public void setGenerateGroupsAttribute(boolean generateGroupsAttribute) {
        this.config.setGenerateGroupsAttribute(generateGroupsAttribute);
    }

    @Deprecated
    public boolean isSplitClassAndPackageNames() {
        return this.config.isSplitClassAndPackageNames();
    }

    @Deprecated
    public void setSplitClassAndPackageNames(boolean splitClassAndPackageNames) {
        this.config.setSplitClassAndPackageNames(splitClassAndPackageNames);
    }

    @Deprecated
    public String getTimestampFormat() {
        return this.config.getTimestampFormat();
    }

    @Deprecated
    public void setTimestampFormat(String timestampFormat) {
        this.config.setTimestampFormat(timestampFormat);
    }

    @Deprecated
    public boolean isGenerateDependsOnMethods() {
        return this.config.isGenerateDependsOnMethods();
    }

    @Deprecated
    public void setGenerateDependsOnMethods(boolean generateDependsOnMethods) {
        this.config.setGenerateDependsOnMethods(generateDependsOnMethods);
    }

    @Deprecated
    public void setGenerateDependsOnGroups(boolean generateDependsOnGroups) {
        this.config.setGenerateDependsOnGroups(generateDependsOnGroups);
    }

    @Deprecated
    public boolean isGenerateDependsOnGroups() {
        return this.config.isGenerateDependsOnGroups();
    }

    @Deprecated
    public void setGenerateTestResultAttributes(boolean generateTestResultAttributes) {
        this.config.setGenerateTestResultAttributes(generateTestResultAttributes);
    }

    @Deprecated
    public boolean isGenerateTestResultAttributes() {
        return this.config.isGenerateTestResultAttributes();
    }

    public XMLReporterConfig getConfig() {
        return this.config;
    }
}

