/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.GithubIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountDecorator;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0004J8\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountDecoratorRenderer;", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountDecorator;", "Ljavax/swing/JPanel;", "()V", "accountName", "Ljavax/swing/JLabel;", "fullName", "loadingError", "Lcom/intellij/ui/SimpleColoredComponent;", "profilePicture", "serverName", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "Companion", "intellij.vcs.github"})
final class GithubAccountDecoratorRenderer
extends JPanel
implements ListCellRenderer<GithubAccountDecorator> {
    private final JLabel accountName = new JLabel();
    private final JLabel serverName = new JLabel();
    private final JLabel profilePicture = new JLabel();
    private final JLabel fullName = new JLabel();
    private final SimpleColoredComponent loadingError = new SimpleColoredComponent();
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends GithubAccountDecorator> list, @NotNull GithubAccountDecorator value, int index, boolean isSelected, boolean cellHasFocus) {
        block3: {
            String string;
            Icon icon;
            JLabel jLabel;
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            UIUtil.setBackgroundRecursively((Component)this, (Color)(isSelected ? list.getSelectionBackground() : list.getBackground()));
            Color textColor = isSelected ? list.getSelectionForeground() : list.getForeground();
            Color grayTextColor = isSelected ? list.getSelectionForeground() : (Color)Gray._120;
            JLabel $receiver = jLabel = this.accountName;
            $receiver.setText(value.getAccount().getName());
            GithubAccountDecoratorRenderer.Companion.setBold($receiver, value.getFullName() == null ? value.getProjectDefault() : false);
            $receiver.setForeground(value.getFullName() == null ? textColor : grayTextColor);
            $receiver = jLabel = this.serverName;
            $receiver.setText(value.getAccount().getServer().toString());
            $receiver.setForeground(grayTextColor);
            JLabel jLabel2 = $receiver = (jLabel = this.profilePicture);
            Image image = value.getProfilePicture();
            if (image != null) {
                Image $i$a$2$apply = image;
                JLabel jLabel3 = jLabel2;
                Image it = $i$a$2$apply;
                int size = JBUI.scale((int)40);
                JBImageIcon jBImageIcon = new JBImageIcon(it.getScaledInstance(size, size, 2));
                jLabel2 = jLabel3;
                icon = (Icon)jBImageIcon;
            } else {
                icon = GithubIcons.DefaultAvatar_40;
            }
            jLabel2.setIcon(icon);
            $receiver = jLabel = this.fullName;
            $receiver.setText(value.getFullName());
            GithubAccountDecoratorRenderer.Companion.setBold($receiver, value.getProjectDefault());
            $receiver.setVisible(value.getFullName() != null);
            $receiver.setForeground(textColor);
            $receiver = jLabel = this.loadingError;
            $receiver.clear();
            String string2 = value.getLoadingError();
            if (string2 == null) break block3;
            String it = string = string2;
            $receiver.append(it, SimpleTextAttributes.ERROR_ATTRIBUTES);
            $receiver.append(" ");
            if (value.getShowLoginLink()) {
                $receiver.append("Log In", value.getErrorLinkPointedAt() ? new SimpleTextAttributes(16, JBColor.link()) : new SimpleTextAttributes(0, JBColor.link()), "EDIT_LINK");
            }
        }
        return this;
    }

    public GithubAccountDecoratorRenderer() {
        JPanel jPanel;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
        JPanel $receiver = jPanel = new JPanel();
        $receiver.setLayout(new GridBagLayout());
        $receiver.setBorder((Border)JBUI.Borders.empty((int)0, (int)6, (int)4, (int)6));
        GridBag bag = new GridBag().setDefaultInsets((Insets)JBUI.insetsRight((int)10)).setDefaultAnchor(17).setDefaultFill(3);
        $receiver.add((Component)this.fullName, bag.nextLine().next());
        $receiver.add((Component)this.accountName, bag.next());
        $receiver.add((Component)this.loadingError, bag.next());
        $receiver.add((Component)this.serverName, bag.nextLine().coverLine());
        JPanel namesPanel = jPanel;
        this.add(this.profilePicture);
        this.add(namesPanel);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountDecoratorRenderer$Companion;", "", "()V", "setBold", "", "Ljavax/swing/JLabel;", "isBold", "", "intellij.vcs.github"})
    public static final class Companion {
        private final void setBold(@NotNull JLabel $receiver, boolean isBold) {
            int n;
            Font font = $receiver.getFont();
            if (isBold) {
                Font font2 = $receiver.getFont();
                Intrinsics.checkExpressionValueIsNotNull((Object)font2, (String)"font");
                n = font2.getStyle() | 1;
            } else {
                Font font3 = $receiver.getFont();
                Intrinsics.checkExpressionValueIsNotNull((Object)font3, (String)"font");
                n = font3.getStyle() & ~1;
            }
            $receiver.setFont(font.deriveFont(n));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

