/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.ThrowableComputable;
import git4idea.DialogManager;
import java.awt.Component;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiTaskExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper$WhenMappings;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u000f\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;", "", "settings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "passwordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "(Lorg/jetbrains/plugins/github/util/GithubSettings;Lcom/intellij/ide/passwordSafe/PasswordSafe;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "clearOldAuth", "", "getOldServer", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getOldServer$intellij_vcs_github", "hasOldAccount", "", "migrate", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "registerAccount", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "token", "", "registerFromDialog", "dialog", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;", "Companion", "intellij.vcs.github"})
public final class GithubAccountsMigrationHelper {
    private final Logger LOG;
    private final GithubSettings settings;
    private final PasswordSafe passwordSafe;
    private final GithubAccountManager accountManager;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final GithubServerPath getOldServer$intellij_vcs_github() {
        try {
            if (this.hasOldAccount()) {
                String string = this.settings.getHost();
                if (string == null) {
                    string = "github.com";
                }
                return GithubServerPath.from(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final boolean hasOldAccount() {
        return this.settings.getAuthType() == GithubAuthData.AuthType.BASIC && this.settings.getLogin() != null || this.settings.getAuthType() == GithubAuthData.AuthType.TOKEN;
    }

    @JvmOverloads
    public final boolean migrate(@NotNull Project project, @Nullable Component parentComponent) {
        boolean hasAnyInfo;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.LOG.debug("Migrating old auth");
        String login2 = this.settings.getLogin();
        String host = this.settings.getHost();
        String password = this.passwordSafe.getPassword(GithubSettings.class, "GITHUB_SETTINGS_PASSWORD_KEY");
        GithubAuthData.AuthType authType = this.settings.getAuthType();
        this.LOG.debug("Old auth data: { login: " + login2 + ", host: " + host + ", authType: " + (Object)((Object)authType) + ", password null: " + (password == null) + " }");
        boolean bl = hasAnyInfo = login2 != null || host != null || authType != null || password != null;
        if (!hasAnyInfo) {
            return true;
        }
        boolean dialogCancelled = false;
        if (this.accountManager.getAccounts().isEmpty()) {
            String string = host;
            if (string == null) {
                string = "github.com";
            }
            String hostToUse = string;
            GithubAuthData.AuthType authType2 = authType;
            if (authType2 != null) {
                switch (GithubAccountsMigrationHelper$WhenMappings.$EnumSwitchMapping$0[authType2.ordinal()]) {
                    case 1: {
                        this.LOG.debug("Migrating token auth");
                        if (password == null) break;
                        try {
                            String accountName2;
                            GithubServerPath server = GithubServerPath.from(hostToUse);
                            ProgressManager progressManager = ProgressManager.getInstance();
                            String string2 = accountName2 = (String)progressManager.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<String, IOException>(progressManager, server, password){
                                final /* synthetic */ ProgressManager $progressManager;
                                final /* synthetic */ GithubServerPath $server;
                                final /* synthetic */ String $password;

                                public final String compute() {
                                    ProgressManager progressManager = this.$progressManager;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"progressManager");
                                    ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"progressManager.progressIndicator");
                                    GithubServerPath githubServerPath = this.$server;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"server");
                                    return (String)GithubApiTaskExecutor.Companion.execute(progressIndicator, githubServerPath, this.$password, migrate.accountName.1.INSTANCE);
                                }
                                {
                                    this.$progressManager = progressManager;
                                    this.$server = githubServerPath;
                                    this.$password = string;
                                }
                            }, "Accessing Github", true, project);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"accountName");
                            GithubServerPath githubServerPath = server;
                            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"server");
                            GithubAccount account = GithubAccountManager.Companion.createAccount(string2, githubServerPath);
                            this.registerAccount(account, password);
                        }
                        catch (Exception e) {
                            this.LOG.debug("Failed to migrate old token-based auth. Showing dialog.", (Throwable)e);
                            GithubLoginDialog githubLoginDialog = new GithubLoginDialog(project, parentComponent, null, null, null, 28, null);
                            String string3 = hostToUse;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"hostToUse");
                            GithubLoginDialog dialog2 = githubLoginDialog.withServer(string3, false).withToken(password).withError(e);
                            dialogCancelled = !this.registerFromDialog(dialog2);
                        }
                        break;
                    }
                    case 2: {
                        this.LOG.debug("Migrating basic auth");
                        GithubLoginDialog githubLoginDialog = new GithubLoginDialog(project, parentComponent, null, null, "Password authentication is no longer supported for Github.\nPersonal access token can be acquired instead.", 12, null);
                        String string4 = hostToUse;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"hostToUse");
                        GithubLoginDialog dialog3 = githubLoginDialog.withServer(string4, false).withCredentials(login2, password);
                        boolean bl2 = dialogCancelled = !this.registerFromDialog(dialog3);
                    }
                }
            }
        }
        if (!dialogCancelled) {
            this.clearOldAuth();
        }
        return !dialogCancelled;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean migrate$default(GithubAccountsMigrationHelper githubAccountsMigrationHelper, Project project, Component component, int n, Object object) {
        if ((n & 2) != 0) {
            component = null;
        }
        return githubAccountsMigrationHelper.migrate(project, component);
    }

    @JvmOverloads
    public final boolean migrate(@NotNull Project project) {
        return GithubAccountsMigrationHelper.migrate$default(this, project, null, 2, null);
    }

    private final boolean registerFromDialog(GithubLoginDialog dialog2) {
        boolean bl;
        DialogManager.show((DialogWrapper)dialog2);
        if (dialog2.isOK()) {
            this.registerAccount(GithubAccountManager.Companion.createAccount(dialog2.getLogin(), dialog2.getServer()), dialog2.getToken());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void registerAccount(GithubAccount account, String token2) {
        GithubAccountManager githubAccountManager = this.accountManager;
        githubAccountManager.setAccounts(SetsKt.plus(githubAccountManager.getAccounts(), (Object)account));
        this.accountManager.updateAccountToken(account, token2);
        this.LOG.debug("Registered account " + account);
    }

    private final void clearOldAuth() {
        this.settings.clearAuth();
        this.passwordSafe.setPassword(GithubSettings.class, "GITHUB_SETTINGS_PASSWORD_KEY", null);
    }

    public GithubAccountsMigrationHelper(@NotNull GithubSettings settings, @NotNull PasswordSafe passwordSafe, @NotNull GithubAccountManager accountManager) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)passwordSafe, (String)"passwordSafe");
        Intrinsics.checkParameterIsNotNull((Object)accountManager, (String)"accountManager");
        this.settings = settings;
        this.passwordSafe = passwordSafe;
        this.accountManager = accountManager;
        GithubAccountsMigrationHelper githubAccountsMigrationHelper = this;
        Logger logger2 = Logger.getInstance(GithubAccountsMigrationHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        githubAccountsMigrationHelper.LOG = logger = logger2;
    }

    @JvmStatic
    @NotNull
    public static final GithubAccountsMigrationHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubAccountsMigrationHelper getInstance() {
            Object object = ServiceManager.getService(GithubAccountsMigrationHelper.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (GithubAccountsMigrationHelper)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

