/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import gnu.trove.TObjectIntHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FtpServerSettingsUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        if ("statistics.deployment.ftp.settings" == null) {
            FtpServerSettingsUsagesCollector.$$$reportNull$$$0(0);
        }
        return "statistics.deployment.ftp.settings";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            FtpServerSettingsUsagesCollector.$$$reportNull$$$0(1);
        }
        List<WebServerConfig> servers = WebServersConfigManager.getInstance(project).getServers(false);
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        TObjectIntHashMap settingTypes = new TObjectIntHashMap();
        for (WebServerConfig server : servers) {
            if (server.getAccessType() != AccessType.FTP || !server.isUsedInProject(project, publishConfig, true)) continue;
            AdvancedOptionsConfig options = server.getFileTransferConfig().getAdvancedOptions();
            FtpServerSettingsUsagesCollector.increaseKey((TObjectIntHashMap<String>)settingTypes, "passiveMode." + (options.isPassiveMode() ? "yes" : "no"));
            FtpServerSettingsUsagesCollector.increaseKey((TObjectIntHashMap<String>)settingTypes, "hiddenFiles." + (options.isShowHiddenFiles() ? "yes" : "no"));
            FtpServerSettingsUsagesCollector.increaseKey((TObjectIntHashMap<String>)settingTypes, "compatibilityMode." + (options.isCompatibilityMode() ? "yes" : "no"));
            FtpServerSettingsUsagesCollector.increaseKey((TObjectIntHashMap<String>)settingTypes, "controlEncoding." + StringUtil.notNullize((String)options.getControlEncoding()));
        }
        if (settingTypes.isEmpty()) {
            Set<UsageDescriptor> set = Collections.emptySet();
            if (set == null) {
                FtpServerSettingsUsagesCollector.$$$reportNull$$$0(2);
            }
            return set;
        }
        HashSet<UsageDescriptor> result = new HashSet<UsageDescriptor>();
        settingTypes.forEachEntry((a, b) -> {
            result.add(new UsageDescriptor(a, b));
            return true;
        });
        HashSet<UsageDescriptor> hashSet = result;
        if (hashSet == null) {
            FtpServerSettingsUsagesCollector.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static void increaseKey(@NotNull TObjectIntHashMap<String> accessTypes, String key) {
        if (accessTypes == null) {
            FtpServerSettingsUsagesCollector.$$$reportNull$$$0(4);
        }
        if (!accessTypes.increment((Object)key)) {
            accessTypes.put((Object)key, 1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/FtpServerSettingsUsagesCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/FtpServerSettingsUsagesCollector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "increaseKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

