/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.LoadFilesAction;
import com.jetbrains.plugins.webDeployment.actions.LocalVsRemoteActionBase;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.SyncLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SyncLocalVsRemoteWithAction
extends SyncLocalVsRemoteAction {
    @Override
    public void update(AnActionEvent e) {
        Collection<Deployable> servers = LoadFilesAction.getExtraServers(e, false, true, true);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(!servers.isEmpty());
        } else {
            e.getPresentation().setEnabled(!servers.isEmpty());
        }
    }

    @Override
    protected void actionPerformedOnProjectView(AnActionEvent event) {
        Collection<Deployable> servers = LoadFilesAction.getExtraServers(event, false, true, true);
        if (servers.isEmpty()) {
            return;
        }
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(event);
        if (files == null || files.length == 0) {
            return;
        }
        Project project = SyncLocalVsRemoteWithAction.getValidProject(event.getDataContext());
        if (project == null) {
            return;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        PublishActionUtil.chooseServer(publishConfig, servers, event, WDBundle.message("choose.server.to.sync.with", new Object[0])).onSuccess(server -> {
            VfsUtilCore.DistinctVFilesRootsCollection distinctFiles = new VfsUtilCore.DistinctVFilesRootsCollection(files);
            ArrayList<LocalMappingDiffRoot> filesMap = new ArrayList<LocalMappingDiffRoot>(files.length);
            for (VirtualFile file : distinctFiles) {
                DeploymentPathMapping mapping = (DeploymentPathMapping)publishConfig.getNearestMappingForLocal(file.getPath(), false, true, false, (Mappable)server, true).getFirst();
                if (mapping == null || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
                filesMap.add(LocalMappingDiffRoot.create(file, mapping));
            }
            if (filesMap.isEmpty()) {
                return;
            }
            LocalVsRemoteActionBase.LocalData localData = new LocalVsRemoteActionBase.LocalData(project, (Deployable)server, (List<LocalMappingDiffRoot>)filesMap);
            this.createTask(localData).queue();
        });
    }
}

