/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.ServerPasswordSafeDeployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ToggleAutoUploadAction
extends ToggleAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleAutoUploadAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Project project = e.getProject();
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(project != null);
        } else {
            e.getPresentation().setEnabled(project != null);
        }
        if (project != null) {
            PublishConfig.AutoUploadState state = PublishConfig.getInstance(project).getAutoUploadState();
            switch (state) {
                case ALWAYS: {
                    e.getPresentation().setText(WDBundle.message("toggle.auto.upload.action.always", new Object[0]));
                    break;
                }
                case ON_EXPLICIT_SAVE: {
                    e.getPresentation().setText(WDBundle.message("toggle.auto.upload.action.on.explicit.save", new Object[0]));
                    break;
                }
                case NEVER: {
                    e.getPresentation().setText(WDBundle.message("toggle.auto.upload.action.never", new Object[0]));
                }
            }
        }
    }

    public boolean isSelected(AnActionEvent e) {
        Project project = e.getProject();
        return project != null && PublishConfig.getInstance(project).getAutoUploadState() != PublishConfig.AutoUploadState.NEVER;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Project project = e.getProject();
        if (project != null) {
            PublishConfig config = PublishConfig.getInstance(project);
            if (state) {
                WebServerConfig server = config.findDefaultServer();
                if (server == null) {
                    List<WebServerConfig> servers = WebServersConfigManager.getInstance(project).getServers(true);
                    ArrayList<Deployable> filteredServers = new ArrayList<Deployable>();
                    for (WebServerConfig serverToCheck : servers) {
                        List<DeploymentPathMapping> mappings;
                        if (serverToCheck == null || !serverToCheck.needsTransfer() || serverToCheck.getFileTransferConfig().validateFast() != null || (mappings = config.getPathMappings(serverToCheck.getId())) == null || mappings.isEmpty()) continue;
                        filteredServers.add(Deployable.create(serverToCheck));
                    }
                    if (filteredServers.isEmpty()) {
                        ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.is.not.configured.and.no.valid.servers", new Object[0]));
                    } else {
                        PublishActionUtil.chooseServer(config, filteredServers, e, WDBundle.message("choose.default.server", new Object[0])).onSuccess(server1 -> {
                            config.setDefaultServer(((ServerPasswordSafeDeployable)server1).getServer(), server1.getName());
                            ToggleAutoUploadAction.setState(state, project, config);
                        });
                    }
                    return;
                }
                if (!server.needsTransfer()) {
                    ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.0.does.n.t.need.automatic.upload", server.getName()));
                    return;
                }
                String validationResult = server.validateFast();
                if (validationResult != null) {
                    ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.0.is.invalid.1", server.getName(), StringUtil.decapitalize((String)validationResult)));
                    return;
                }
                if (!config.hasValidMapping(server)) {
                    ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.0.has.no.valid.mappings", server.getName()));
                    return;
                }
            }
            ToggleAutoUploadAction.setState(state, project, config);
        }
    }

    private static void setState(boolean state, Project project, PublishConfig config) {
        if (state) {
            config.setAutoUploadState(PublishConfig.AutoUploadState.ALWAYS);
        } else {
            config.setAutoUploadState(PublishConfig.AutoUploadState.NEVER);
        }
        ((DeploymentConfigChangeListener)project.getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).optionsChanged();
    }

    private static void showMessage(Project project, String message) {
        Messages.showWarningDialog((Project)project, (String)WDBundle.message("0.n.automatic.upload.is.not.enabled", message), (String)WDBundle.message("automatic.upload.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/actions/ToggleAutoUploadAction", "update"));
    }
}

