/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.OldXmlCredentialProvider;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersAuthStorage;
import com.jetbrains.plugins.webDeployment.config.sftp.SftpAdvancedOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class WebServersConfigManagerBaseImpl<T extends State>
implements PersistentStateComponent<T> {
    protected T myState = this.createState();
    private final boolean isProjectLevel;
    private final List<Listener> myListeners = new SmartList();

    public WebServersConfigManagerBaseImpl(boolean level) {
        this.isProjectLevel = level;
    }

    protected abstract T createState();

    @Deprecated
    public T getState() {
        T state = this.createState();
        for (WebServerConfig server : ((State)this.myState).servers) {
            WebServerConfig clone = server.clone();
            clone.setIsProjectLevel(false);
            ((State)state).servers.add(clone);
        }
        return state;
    }

    public void loadState(@NotNull T state) {
        if (state == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(0);
        }
        this.myState = state;
        for (WebServerConfig server : ((State)this.myState).servers) {
            if (StringUtil.isEmpty((String)server.getId())) {
                server.setId(WebServerConfig.getNextId());
            }
            server.setIsProjectLevel(this.isProjectLevel);
            if (server.getAccessType() != AccessType.SFTP || !server.getFileTransferConfig().isAnonymous()) continue;
            server.getFileTransferConfig().setAnonymous(false);
            WebDeploymentCredentialHelper.saveCredentials(server, "anonymous", "user@example.com", false);
        }
        WebServerConfig.fixDuplicatingNames(((State)this.myState).servers);
        this.getAuthStorage().initServerAuthIfNeeded(((State)this.myState).servers);
        WebDeploymentCredentialHelper.syncWithPasswordSafe(((State)this.myState).servers, new OldXmlCredentialProvider());
        this.fireServersLoaded();
    }

    protected abstract WebServersAuthStorage getAuthStorage();

    private void fireServersLoaded() {
        for (Listener listener : this.myListeners) {
            listener.serversLoaded();
        }
    }

    public void addListener(Listener listener, Disposable parentDisposable) {
        ContainerUtil.add((Object)listener, this.myListeners, (Disposable)parentDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl", "loadState"));
    }

    static interface Listener {
        public void serversLoaded();
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")})
    public static class App
    extends WebServersConfigManagerBaseImpl<AppState> {
        private final Collection<Deployable> myServerIdsToReauth = Collections.synchronizedSet(new SmartHashSet());

        public static App getInstance() {
            return (App)ServiceManager.getService(App.class);
        }

        public App() {
            super(false);
        }

        @Override
        protected AppState createState() {
            return new AppState();
        }

        @Override
        public AppState getState() {
            AppState state = (AppState)super.getState();
            state.mySftpAdvancedOptions = ((AppState)this.myState).mySftpAdvancedOptions.clone();
            return state;
        }

        @Override
        protected WebServersAuthStorage getAuthStorage() {
            return WebServersAuthStorage.AppInstance.getInstance();
        }

        @NotNull
        public SftpAdvancedOptions getSftpAdvancedOptions() {
            SftpAdvancedOptions sftpAdvancedOptions = ((AppState)this.myState).mySftpAdvancedOptions.clone();
            if (sftpAdvancedOptions == null) {
                App.$$$reportNull$$$0(0);
            }
            return sftpAdvancedOptions;
        }

        public void setSftpAdvancedOptions(@NotNull SftpAdvancedOptions options) {
            if (options == null) {
                App.$$$reportNull$$$0(1);
            }
            ((AppState)this.myState).mySftpAdvancedOptions = options.clone();
        }

        public void setDeployableToReauth(Deployable deployable) {
            this.myServerIdsToReauth.add(deployable);
        }

        public boolean shouldReauth(Deployable deployable) {
            return this.myServerIdsToReauth.contains(deployable);
        }

        public void noMoreReauth(Deployable deployable) {
            this.myServerIdsToReauth.remove(deployable);
        }

        void resetReauthCache() {
            this.myServerIdsToReauth.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSftpAdvancedOptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSftpAdvancedOptions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AppState
    extends State {
        @Tag(value="sftpAdvancedGlobalOptions")
        public SftpAdvancedOptions mySftpAdvancedOptions = new SftpAdvancedOptions();
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")})
    public static class Project
    extends WebServersConfigManagerBaseImpl<State> {
        @NotNull
        private final com.intellij.openapi.project.Project myProject;

        public static Project getInstance(@NotNull com.intellij.openapi.project.Project project) {
            if (project == null) {
                Project.$$$reportNull$$$0(0);
            }
            return (Project)ServiceManager.getService((com.intellij.openapi.project.Project)project, Project.class);
        }

        public Project(@NotNull com.intellij.openapi.project.Project project) {
            if (project == null) {
                Project.$$$reportNull$$$0(1);
            }
            super(true);
            this.myProject = project;
        }

        @Override
        protected State createState() {
            return new State();
        }

        @Override
        protected WebServersAuthStorage getAuthStorage() {
            return WebServersAuthStorage.ProjectInstance.getInstance(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$Project";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        @XCollection
        public List<WebServerConfig> servers = new ArrayList<WebServerConfig>();
    }
}

