/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit.notification;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteEditedFilesUploadingService;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;

public class UploadCurrentRemoteFileAction
extends AnAction {
    public UploadCurrentRemoteFileAction() {
        super(WDBundle.message("remote.edit.upload.current.remote.file.action.title", new Object[0]), WDBundle.message("remote.edit.upload.current.remote.file.action.title", new Object[0]), AllIcons.Actions.Upload);
    }

    public void update(AnActionEvent e) {
        boolean enable = UploadCurrentRemoteFileAction.isEnabled(e);
        e.getPresentation().setEnabled(enable);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enable);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        VirtualFile[] files;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        for (VirtualFile file : files = FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
            if (!(file instanceof RemoteVirtualFile)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ApplicationManager.getApplication().saveAll();
        for (VirtualFile file : files = FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
            if (!(file instanceof RemoteVirtualFile)) continue;
            RemoteEditedFilesUploadingService.getInstance(project).queueUpload((RemoteVirtualFile)file);
        }
    }
}

