/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.auth;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.ui.LoginForm;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

class LoginDialog
extends DialogWrapper {
    private LoginForm myForm;
    private final AsyncPromise<Boolean> myResult = new AsyncPromise();

    public static LoginDialog createInstance(Deployable deployable, @NotNull ConnectionOwner connectionOwner, boolean modal) {
        Component parentComponent;
        if (connectionOwner == null) {
            LoginDialog.$$$reportNull$$$0(0);
        }
        if ((parentComponent = connectionOwner.getComponentForDialogCreation()) != null) {
            return new LoginDialog(deployable, parentComponent, modal);
        }
        return new LoginDialog(deployable, connectionOwner.getProjectForDialogCreation(), modal);
    }

    public LoginDialog(Deployable deployable, @Nullable Project project, boolean modal) {
        super(project, false);
        this.initialize(deployable, modal);
    }

    public LoginDialog(Deployable deployable, Component parent, boolean modal) {
        super(parent, false);
        this.initialize(deployable, modal);
    }

    private void initialize(@NotNull Deployable deployable, boolean modal) {
        if (deployable == null) {
            LoginDialog.$$$reportNull$$$0(1);
        }
        this.setModal(modal);
        String name = deployable.getName();
        if (StringUtil.isEmpty((String)name)) {
            name = deployable.getHost();
        }
        this.setTitle(WDBundle.message("login.dialog.title", name, deployable.getAccessType().getTitle()));
        this.myForm = new LoginForm(deployable);
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    public String getUsername() {
        return this.myForm.getUsername();
    }

    public String getPassword() {
        return this.myForm.getPassword();
    }

    public boolean isRememberPassword() {
        return this.myForm.isRememberPassword();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myForm.updateRememberPasswordState();
        this.myResult.setResult((Object)true);
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.myResult.setResult((Object)false);
    }

    protected String getDimensionServiceKey() {
        return "publish.login";
    }

    public Promise<Boolean> showAndGetResult() {
        this.show();
        return this.myResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/auth/LoginDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "initialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

