/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabStub;
import com.jetbrains.plugins.webDeployment.ui.config.ExcludedPathsConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SharedDataHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedPathsConfigurableTabProvider
implements DeploymentConfigurableTabProvider {
    @Override
    public DeploymentConfigurableTab createTab(@Nullable Project project, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(0);
        }
        if (project != null && !project.isDefault()) {
            return new ExcludedPathsConfigurableTab(project, serverStateProvider, sharedData);
        }
        return new DeploymentConfigurableTabStub(ExcludedPathsConfigurableTab.TITLE, 2, WDBundle.message("excluded.paths.tab.stub.text", new Object[0]));
    }

    @Override
    public void copyData(Project project, SettingsDeployable from, SettingsDeployable to, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(1);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        sharedData.getExcludedPaths().put(to.getId(), sharedData.getExcludedPaths().get(from.getId()));
    }

    @Override
    public boolean dataIsEqual(Project project, SettingsDeployable o1, SettingsDeployable o2, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(2);
        }
        if (project == null || project.isDefault()) {
            return true;
        }
        List<ExcludedPath> ex1 = sharedData.getExcludedPaths().get(o1.getId());
        List<ExcludedPath> ex2 = sharedData.getExcludedPaths().get(o2.getId());
        return Comparing.equal(ex1, ex2);
    }

    @Override
    public boolean isNonServerDataModified(Project project, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Override
    public void reset(Project project, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(4);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        HashMap<String, List<ExcludedPath>> excludedPaths = new HashMap<String, List<ExcludedPath>>();
        for (WebServerConfig server : WebServersConfigManager.getInstance(project).getServers(false)) {
            excludedPaths.put(server.getId(), publishConfig.getExcludedPaths(server.getId()));
        }
        sharedData.setExcludedPaths(excludedPaths);
    }

    @Override
    public void apply(Project project, List<SettingsDeployable> currentServers, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(5);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        PublishConfig config = PublishConfig.getInstance(project);
        Map<String, List<ExcludedPath>> paths = sharedData.getExcludedPaths();
        config.setExcludedPaths(DeploymentConfigurable.filterExistingServers(paths, currentServers));
    }

    @Override
    public void onItemCreated(Project project, SettingsDeployable newItem, List<SettingsDeployable> currentItems, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(6);
        }
    }

    @Override
    public void onItemDeleted(Project project, SettingsDeployable item, List<SettingsDeployable> currentItems, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(7);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        sharedData.getExcludedPaths().remove(item.getId());
    }

    @Override
    public void createActions(boolean fromPopup, Project project, List<AnAction> result, Computable<SettingsDeployable> selectionProvider, Runnable updater, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(8);
        }
    }

    @Override
    public boolean isDisplayInBold(Project project, SettingsDeployable item, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(9);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "sharedData";
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTab";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "copyData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "dataIsEqual";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNonServerDataModified";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onItemCreated";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onItemDeleted";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isDisplayInBold";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

