/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.remote.AuthType;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.ServerDeployableWithTempCredentials;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import kotlin.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SettingsDeployable
extends Deployable {
    @Override
    @NotNull
    public SettingsDeployable clone();

    @Override
    @Nullable
    public Credentials getCredentials();

    public void eraseCredentialsFromPasswordSafe();

    public void updateCredentialsFromPasswordSafe();

    @Override
    public String getMountedFolder();

    public String getRootFolder();

    @Override
    public boolean isAnonymous();

    public AdvancedOptionsConfig getAdvancedOptions();

    public boolean isFtpsExplicit();

    public void setAccessType(@NotNull AccessType var1);

    public void setUrl(String var1);

    public void setIsProjectLevel(boolean var1);

    public void setHost(String var1);

    public void setLiteralPort(String var1);

    public void setAnonymous(boolean var1);

    @Deprecated
    public void setUseKeyPair(boolean var1);

    @Deprecated
    public void setUseAuthAgent(boolean var1);

    public void setAuthType(@NotNull AuthType var1);

    public void setPort(int var1);

    public void setRootFolder(String var1);

    public void setPrivateKeyFile(String var1);

    public void setAdvancedOptions(AdvancedOptionsConfig var1);

    public void setMountedFolder(String var1);

    public void setFtpsExplicit(boolean var1);

    @Nullable
    public String getNonBlockingWarnings();

    @NotNull
    public WebServerConfig computeWebServerConfig();

    public void setId(String var1);

    public void setName(String var1);

    @Override
    public String validateFast();

    public int compareTo(@NotNull SettingsDeployable var1, @NotNull PublishConfig var2);

    @Contract(value="null->null; !null->!null")
    public static SettingsDeployable create(@Nullable WebServerConfig server) {
        if (server == null) {
            return null;
        }
        class MyServerWithCredentials
        extends ServerDeployableWithTempCredentials
        implements SettingsDeployable {
            public MyServerWithCredentials(@NotNull WebServerConfig server) {
                if (server == null) {
                    MyServerWithCredentials.$$$reportNull$$$0(0);
                }
                super(server);
                this.updateCredentialsFromPasswordSafe();
            }

            @Override
            @NotNull
            public WebServerConfig computeWebServerConfig() {
                WebServerConfig webServerConfig = this.myServer;
                if (webServerConfig == null) {
                    MyServerWithCredentials.$$$reportNull$$$0(1);
                }
                return webServerConfig;
            }

            @Override
            public void setId(String id) {
                this.myServer.setId(id);
            }

            @Override
            public void setName(String name) {
                this.myServer.setName(name);
            }

            @Override
            public int compareTo(@NotNull SettingsDeployable server2, @NotNull PublishConfig config) {
                if (server2 == null) {
                    MyServerWithCredentials.$$$reportNull$$$0(2);
                }
                if (config == null) {
                    MyServerWithCredentials.$$$reportNull$$$0(3);
                }
                if (server2 instanceof MyServerWithCredentials) {
                    return config.compareServers(this.myServer, ((MyServerWithCredentials)server2).myServer);
                }
                return config.compareServers(this.myServer, server2.computeWebServerConfig());
            }

            @Override
            @NotNull
            public MyServerWithCredentials clone() {
                MyServerWithCredentials myServerWithCredentials = (MyServerWithCredentials)super.clone();
                if (myServerWithCredentials == null) {
                    MyServerWithCredentials.$$$reportNull$$$0(4);
                }
                return myServerWithCredentials;
            }

            @Override
            public void eraseCredentialsFromPasswordSafe() {
                WebDeploymentCredentialHelper.saveCredentials(this.myServer, false, null);
            }

            @Override
            public void updateCredentialsFromPasswordSafe() {
                Pair<Credentials, Boolean> credentialsAndMemoryOnlyStatus = WebDeploymentCredentialHelper.getCredentialsAndMemoryOnlyStatus(this.myServer, false);
                this.myCredentials = (Credentials)credentialsAndMemoryOnlyStatus.getFirst();
                this.isPassMemoryOnly = (Boolean)credentialsAndMemoryOnlyStatus.getSecond();
            }

            @Override
            public String getMountedFolder() {
                return this.myServer.getFileTransferConfig().getMountedFolder();
            }

            @Override
            public String getRootFolder() {
                return this.myServer.getFileTransferConfig().getRootFolder();
            }

            @Override
            public AdvancedOptionsConfig getAdvancedOptions() {
                return this.myServer.getFileTransferConfig().getAdvancedOptions();
            }

            @Override
            public boolean isFtpsExplicit() {
                return this.myServer.getFileTransferConfig().isFtpsExplicit();
            }

            @Override
            public void setAccessType(@NotNull AccessType type) {
                if (type == null) {
                    MyServerWithCredentials.$$$reportNull$$$0(5);
                }
                this.myServer.getFileTransferConfig().setAccessType(type);
            }

            @Override
            public void setUrl(String url) {
                this.myServer.setUrl(url);
            }

            @Override
            public void setIsProjectLevel(boolean projectLevel) {
                this.myServer.setIsProjectLevel(projectLevel);
            }

            @Override
            public void setHost(String host) {
                this.myServer.getFileTransferConfig().setHost(host);
            }

            @Override
            public void setLiteralPort(String literalPort) {
                this.myServer.getFileTransferConfig().setLiteralPort(literalPort);
            }

            @Override
            public void setAnonymous(boolean anonymous) {
                this.myServer.getFileTransferConfig().setAnonymous(anonymous);
            }

            @Override
            @Deprecated
            public void setUseKeyPair(boolean useKeyPair) {
                this.myServer.getFileTransferConfig().setUseKeyPair(useKeyPair);
            }

            @Override
            @Deprecated
            public void setUseAuthAgent(boolean useAuthAgent) {
                this.myServer.getFileTransferConfig().setUseAuthAgent(useAuthAgent);
            }

            @Override
            public void setAuthType(@NotNull AuthType authType) {
                if (authType == null) {
                    MyServerWithCredentials.$$$reportNull$$$0(6);
                }
                this.myServer.getFileTransferConfig().setAuthType(authType);
            }

            @Override
            public void setPort(int port) {
                this.myServer.getFileTransferConfig().setPort(port);
            }

            @Override
            public void setRootFolder(String rootFolder) {
                this.myServer.getFileTransferConfig().setRootFolder(rootFolder);
            }

            @Override
            public void setPrivateKeyFile(String keyFile) {
                this.myServer.getFileTransferConfig().setPrivateKeyFile(keyFile);
            }

            @Override
            public void setAdvancedOptions(AdvancedOptionsConfig config) {
                this.myServer.getFileTransferConfig().setAdvancedOptions(config);
            }

            @Override
            public void setMountedFolder(String mountedFolder) {
                this.myServer.getFileTransferConfig().setMountedFolder(mountedFolder);
            }

            @Override
            public void setFtpsExplicit(boolean explicit) {
                this.myServer.getFileTransferConfig().setFtpsExplicit(explicit);
            }

            @Override
            @Nullable
            public String getNonBlockingWarnings() {
                return this.myServer.getFileTransferConfig().getNonBlockingWarnings();
            }

            @Override
            public String toString() {
                return "MyServerWithCredentials{myServer.name=" + this.myServer.getName() + "myServer.id=" + this.myServer.getId() + ", myCredentials=" + (this.myCredentials == null ? "null" : "***:***") + ", isPassMemoryOnly=" + this.isPassMemoryOnly + '}';
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "server";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/SettingsDeployable$1MyServerWithCredentials";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "server2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "authType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/SettingsDeployable$1MyServerWithCredentials";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "computeWebServerConfig";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "clone";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "compareTo";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "setAccessType";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "setAuthType";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        return new MyServerWithCredentials(server);
    }
}

