/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config.mappings;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabStub;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SharedDataHolder;
import com.jetbrains.plugins.webDeployment.ui.config.mappings.MappingsConfigurableTab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MappingsConfigurableTabProvider
implements DeploymentConfigurableTabProvider {
    @Override
    public DeploymentConfigurableTab createTab(Project project, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(0);
        }
        if (project != null && !project.isDefault()) {
            return new MappingsConfigurableTab(project, serverStateProvider, sharedData);
        }
        return new DeploymentConfigurableTabStub(MappingsConfigurableTab.TITLE, 1, WDBundle.message("mappings.tab.stub.text", new Object[0]));
    }

    @Override
    public void reset(Project project, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(1);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        sharedData.setDefaultServer(publishConfig.getDefaultServerIdAndName());
        HashMap<String, List<DeploymentPathMapping>> mappings = new HashMap<String, List<DeploymentPathMapping>>();
        for (WebServerConfig server : WebServersConfigManager.getInstance(project).getServers(false)) {
            mappings.put(server.getId(), publishConfig.getPathMappings(server.getId()));
        }
        sharedData.setMappings(mappings);
    }

    @Override
    public void apply(Project project, List<SettingsDeployable> currentServers, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(2);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        Pair<String, String> idAndName = sharedData.getDefaultServerIdAndName();
        PublishConfig config = PublishConfig.getInstance(project);
        boolean found = false;
        if (idAndName.first != null) {
            for (SettingsDeployable settingsDeployable : currentServers) {
                if (!StringUtil.equals((CharSequence)settingsDeployable.getId(), (CharSequence)((CharSequence)idAndName.first))) continue;
                config.setDefaultServerIdAndName((String)idAndName.first, settingsDeployable.getName());
                found = true;
                break;
            }
        }
        if (!found) {
            config.setDefaultServerIdAndName(null, null);
        }
        config.setPathMappings(DeploymentConfigurable.filterExistingServers(sharedData.getMappings(), currentServers));
    }

    @Override
    public boolean isNonServerDataModified(Project project, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(3);
        }
        if (project == null || project.isDefault()) {
            return false;
        }
        PublishConfig config = PublishConfig.getInstance(project);
        return !sharedData.getDefaultServerIdAndName().equals(config.getDefaultServerIdAndName());
    }

    @Override
    public void copyData(Project project, SettingsDeployable from, SettingsDeployable to, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(4);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        sharedData.getMappings().put(to.getId(), sharedData.getMappings().get(from.getId()));
    }

    @Override
    public boolean dataIsEqual(Project project, SettingsDeployable o1, SettingsDeployable o2, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(5);
        }
        if (project == null || project.isDefault()) {
            return true;
        }
        List<DeploymentPathMapping> m1 = sharedData.getMappings().get(o1.getId());
        List<DeploymentPathMapping> m2 = sharedData.getMappings().get(o2.getId());
        return Comparing.equal(m1, m2);
    }

    @Override
    public void onItemCreated(Project project, SettingsDeployable newItem, List<SettingsDeployable> currentItems, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(6);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        ArrayList<DeploymentPathMapping> mappings = new ArrayList<DeploymentPathMapping>();
        PublishConfig.addDefaultMappings(project, mappings);
        sharedData.getMappings().put(newItem.getId(), mappings);
        if (currentItems.isEmpty()) {
            sharedData.setDefaultServer(newItem.getId(), newItem.getName());
        }
    }

    @Override
    public void onItemDeleted(Project project, SettingsDeployable item, List<SettingsDeployable> currentItems, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(7);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        if (Comparing.equal((String)((String)sharedData.getDefaultServerIdAndName().first), (String)item.getId())) {
            sharedData.setDefaultServer(null, null);
        }
        sharedData.getMappings().remove(item.getId());
    }

    @Override
    public void createActions(boolean fromPopup, Project project, List<AnAction> result, Computable<SettingsDeployable> selectionProvider, Runnable updater, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(8);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        result.add((AnAction)new MyToggleDefaultServerAction(selectionProvider, fromPopup, updater, sharedData));
    }

    @Override
    public boolean isDisplayInBold(Project project, SettingsDeployable item, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(9);
        }
        if (project == null || project.isDefault()) {
            return false;
        }
        return Comparing.equal((String)((String)sharedData.getDefaultServerIdAndName().first), (String)item.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "sharedData";
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableTabProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTab";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNonServerDataModified";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "copyData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "dataIsEqual";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onItemCreated";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onItemDeleted";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isDisplayInBold";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyToggleDefaultServerAction
    extends ToggleAction
    implements DumbAware {
        private final Computable<SettingsDeployable> mySelectionProvider;
        private final boolean myFromPopup;
        private final Runnable myUpdater;
        @NotNull
        private final SharedDataHolder mySharedData;

        public MyToggleDefaultServerAction(Computable<SettingsDeployable> selectionProvider, boolean fromPopup, Runnable updater, @NotNull SharedDataHolder sharedData) {
            if (sharedData == null) {
                MyToggleDefaultServerAction.$$$reportNull$$$0(0);
            }
            super(WDBundle.message("use.as.default.action.text", new Object[0]), WDBundle.message("use.as.default.action.description", new Object[0]), AllIcons.Actions.SetDefault);
            this.mySelectionProvider = selectionProvider;
            this.myFromPopup = fromPopup;
            this.myUpdater = updater;
            this.mySharedData = sharedData;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                MyToggleDefaultServerAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            boolean bl = enabled = this.mySelectionProvider.compute() != null;
            if (this.myFromPopup) {
                boolean selected = this.isSelected(e);
                String text = selected ? WDBundle.message("dont.use.as.default.action.text", new Object[0]) : WDBundle.message("use.as.default.action.text", new Object[0]);
                e.getPresentation().setText(text);
                String description = selected ? WDBundle.message("dont.use.as.default.action.description", new Object[0]) : WDBundle.message("use.as.default.action.description", new Object[0]);
                e.getPresentation().setDescription(description);
                e.getPresentation().setVisible(enabled);
            } else {
                e.getPresentation().setEnabled(enabled);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            SettingsDeployable item = (SettingsDeployable)this.mySelectionProvider.compute();
            if (item == null) {
                return false;
            }
            Pair<String, String> idAndName = this.mySharedData.getDefaultServerIdAndName();
            return Comparing.equal((String)item.getId(), (String)((String)idAndName.first));
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                SettingsDeployable item = (SettingsDeployable)this.mySelectionProvider.compute();
                this.mySharedData.setDefaultServer(item.getId(), item.getName());
            } else {
                this.mySharedData.setDefaultServer(null, null);
            }
            this.myUpdater.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sharedData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableTabProvider$MyToggleDefaultServerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

