/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.MessageTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MoveCopyPasteSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerTreeBuilder
extends AbstractTreeBuilder {
    private static final Logger LOG = Logger.getInstance(WebServerTreeBuilder.class);
    private static final Comparator<NodeDescriptor> COMPARATOR = (o1, o2) -> {
        if (o1 instanceof MessageTreeNode) {
            return o2 instanceof MessageTreeNode ? ((MessageTreeNode)((Object)o1)).getMessage().compareTo(((MessageTreeNode)((Object)o2)).getMessage()) : -1;
        }
        if (o2 instanceof MessageTreeNode) {
            return 1;
        }
        ServerTreeNode n1 = (ServerTreeNode)((Object)o1);
        ServerTreeNode n2 = (ServerTreeNode)((Object)o2);
        if (n1.isDirectory() && !n2.isDirectory()) {
            return -1;
        }
        if (!n1.isDirectory() && n2.isDirectory()) {
            return 1;
        }
        return n1.getFileName().compareToIgnoreCase(n2.getFileName());
    };
    public static final int UPDATE_NODES_DELAY_MS = 100;
    private final Alarm myUpdateAlarm = new Alarm((Disposable)this);

    public static WebServerTreeBuilder createInstance(@NotNull ServerTreeNode root, @NotNull JTree tree) {
        if (root == null) {
            WebServerTreeBuilder.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            WebServerTreeBuilder.$$$reportNull$$$0(1);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode((Object)root));
        tree.setModel(treeModel);
        tree.getSelectionModel().setSelectionMode(4);
        return new WebServerTreeBuilder(tree, treeModel, (AbstractTreeStructure)new SimpleTreeStructure.Impl(root){

            public boolean isToBuildChildrenInBackground(Object element) {
                return true;
            }

            public boolean isAlwaysLeaf(Object element) {
                if (element instanceof ServerTreeNode) {
                    return !((ServerTreeNode)((Object)element)).isDirectory();
                }
                LOG.assertTrue(element instanceof MessageTreeNode);
                return true;
            }
        });
    }

    public WebServerTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure) {
        super(tree, treeModel, treeStructure, COMPARATOR);
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)new MoveCopyPasteSupport.RemoteHostCopyPasteListener(this.getUpdater(), tree), (Disposable)this);
        this.myUpdateAlarm.setActivationComponent((JComponent)tree);
    }

    protected void runBackgroundLoading(@NotNull Runnable runnable) {
        if (runnable == null) {
            WebServerTreeBuilder.$$$reportNull$$$0(2);
        }
        if (this.isDisposed()) {
            return;
        }
        runnable.run();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof MessageTreeNode) {
            return true;
        }
        if (nodeDescriptor instanceof ServerTreeNode) {
            return !((ServerTreeNode)nodeDescriptor).isDirectory() || ((ServerTreeNode)nodeDescriptor).isRoot();
        }
        return false;
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        if (descriptor instanceof ServerTreeNode) {
            return ((ServerTreeNode)descriptor).isDirectory();
        }
        LOG.assertTrue(descriptor instanceof MessageTreeNode);
        return false;
    }

    public void refreshSubtree(final Collection<WebServerConfig.RemotePath> roots, final boolean resync, final boolean cleanTreeNodesCache, final WebServerConfig.RemotePath selectAfterRefresh) {
        if (this.isDisposed()) {
            return;
        }
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        new Task.Backgroundable(root.getProject(), StringUtil.toTitleCase((String)WDBundle.message("refreshing.remote.files", new Object[0]))){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (WebServerTreeBuilder.this.isDisposed()) {
                    return;
                }
                if (cleanTreeNodesCache || resync) {
                    try {
                        ServerTreeNode root = WebServerTreeBuilder.this.getRoot();
                        if (root == null) {
                            return;
                        }
                        RemoteConnection connection = root.getOpenRemoteConnection();
                        AbstractTreeUi ui = WebServerTreeBuilder.this.getUi();
                        if (connection == null || ui == null) {
                            return;
                        }
                        List expandedElements = ui.getExpandedElements();
                        connection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> {
                            if (indicator == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            for (WebServerConfig.RemotePath root1 : roots) {
                                indicator.checkCanceled();
                                ServerTreeNode node = WebServerTreeBuilder.this.findNode(root1);
                                if (node == null) continue;
                                if (resync && node.getFileObject() != null) {
                                    node.getFileObject().refresh();
                                }
                                if (!cleanTreeNodesCache) continue;
                                node.reloadNecessaryDescendants(true, true, expandedElements);
                            }
                        }), indicator);
                    }
                    catch (FileSystemException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                ActionCallback callback = null;
                for (WebServerConfig.RemotePath root : roots) {
                    indicator.checkCanceled();
                    ServerTreeNode rootNode = WebServerTreeBuilder.this.getRoot();
                    if (rootNode == null) {
                        return;
                    }
                    ServerTreeNode toUpdate = rootNode.createForSelection(root);
                    if (toUpdate == null) {
                        return;
                    }
                    if (toUpdate.getParent() != null) {
                        toUpdate = (ServerTreeNode)toUpdate.getParent();
                    }
                    callback = WebServerTreeBuilder.this.queueUpdateFrom((Object)toUpdate, true);
                }
                if (selectAfterRefresh != null) {
                    if (callback != null) {
                        callback.doWhenDone(() -> WebServerTreeBuilder.this.selectPath(selectAfterRefresh));
                    } else if (ApplicationManager.getApplication().isDispatchThread()) {
                        WebServerTreeBuilder.this.selectPath(selectAfterRefresh);
                    } else {
                        ApplicationManager.getApplication().invokeLater(() -> WebServerTreeBuilder.this.selectPath(selectAfterRefresh));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "indicator";
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    @Nullable
    public ServerTreeNode findNode(WebServerConfig.RemotePath path) {
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return null;
        }
        Object node = this.findNodeByElement((Object)root.createForSelection(path));
        return node instanceof DefaultMutableTreeNode ? (ServerTreeNode)((Object)((DefaultMutableTreeNode)node).getUserObject()) : null;
    }

    public void selectPath(WebServerConfig.RemotePath path) {
        if (this.isDisposed()) {
            return;
        }
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        ServerTreeNode selection = root.createForSelection(path);
        if (selection != null) {
            root.reloadNecessaryDescendantsAndUpdate(false, false, Collections.singletonList(selection), () -> ApplicationManager.getApplication().invokeLater(() -> this.select((Object)selection)));
        }
    }

    @Nullable
    public ServerTreeNode getRoot() {
        AbstractTreeStructure structure = this.getTreeStructure();
        return structure == null ? null : (ServerTreeNode)((Object)structure.getRootElement());
    }

    public void refreshWhenIdle(final ServerTreeNode node) {
        Runnable updater = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractTreeUi ui = WebServerTreeBuilder.this.getUi();
                if (ui == null) {
                    return;
                }
                boolean isIdle = ui.isIdle();
                if (isIdle) {
                    try {
                        WebServerTreeBuilder.this.refreshSubtree(Collections.singletonList(node.getPath()), false, false, null);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    finally {
                        WebServerTreeBuilder.this.myUpdateAlarm.cancelRequest((Runnable)this);
                    }
                } else {
                    WebServerTreeBuilder.this.myUpdateAlarm.addComponentRequest((Runnable)this, 100);
                }
            }
        };
        this.myUpdateAlarm.addComponentRequest(updater, 100);
    }

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
        super.dispose();
    }

    public void refreshRoot() {
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        root.invalidate();
        AbstractTreeUi ui = this.getUi();
        if (ui == null) {
            return;
        }
        root.reloadNecessaryDescendantsAndUpdate(true, true, ui.getExpandedElements(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runBackgroundLoading";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

