/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class AddSrcStorageToFilesInternalAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        boolean enabled = DbImplUtil.getMaybeLocalDataSource((DasDataSource)AddSrcStorageToFilesInternalAction.getDataSource(e.getDataContext())) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DbDataSource source = AddSrcStorageToFilesInternalAction.getDataSource(e.getDataContext());
        if (source == null) {
            return;
        }
        Module[] modules = ModuleManager.getInstance((Project)source.getProject()).getModules();
        VirtualFile path = DbSrcUtils.findDbSrcFile(source, null, true);
        if (modules.length != 0 && path != null) {
            Module module = modules[0];
            ModuleRootModificationUtil.updateModel((Module)module, model -> model.addContentEntry(path));
        }
    }

    @Nullable
    private static DbDataSource getDataSource(DataContext context) {
        DbElement item = (DbElement)DatabaseView.getSelectedElements(context, true).first();
        return item == null ? null : item.getDataSource();
    }
}

