/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.AssignColorDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignColorAction
extends AnAction
implements DumbAware {
    public AssignColorAction() {
        super("Color Settings...");
    }

    public void update(AnActionEvent e) {
        DatabaseView view = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
        boolean enabled = view != null && !DatabaseView.getSelectedElements(e.getDataContext(), true).isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DatabaseView view = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
        if (view == null) {
            return;
        }
        JBIterable<DbElement> selectedElements = DatabaseView.getSelectedElements(e.getDataContext(), true);
        Project project = view.getProject();
        AssignColorDialog dialog = new AssignColorDialog(project, selectedElements.toSet());
        if (dialog.showAndGet()) {
            AssignColorAction.updateOpenFileEditors(project);
            AssignColorAction.updateDatabaseToolwindow(project);
        }
    }

    private static void updateOpenFileEditors(@NotNull Project project) {
        if (project == null) {
            AssignColorAction.$$$reportNull$$$0(0);
        }
        FileEditorManagerEx managerEx = FileEditorManagerEx.getInstanceEx((Project)project);
        for (VirtualFile file : managerEx.getOpenFiles()) {
            managerEx.updateFilePresentation(file);
            if (!DbConsoleRootType.isConsoleFile(file) && !DbImplUtil.isDatabaseVirtualFile(file) && JdbcConsoleProvider.getAttachedConsole(project, file) == null) continue;
            AssignColorAction.updateFileEditors(managerEx, file);
        }
    }

    public static void updateFileEditors(@NotNull FileEditorManagerEx fileEditorManager, @NotNull VirtualFile file) {
        if (fileEditorManager == null) {
            AssignColorAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AssignColorAction.$$$reportNull$$$0(2);
        }
        Project project = fileEditorManager.getProject();
        for (FileEditor fileEditor : fileEditorManager.getEditors(file)) {
            EditorEx editorEx = EditorUtil.getEditorEx((FileEditor)fileEditor);
            JComponent component = editorEx != null ? editorEx.getPermanentHeaderComponent() : fileEditor.getComponent();
            AssignColorAction.updateColors(project, file, component);
        }
    }

    private static void updateDatabaseToolwindow(@NotNull Project project) {
        if (project == null) {
            AssignColorAction.$$$reportNull$$$0(3);
        }
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            AssignColorAction.updateColors(project, console.getLanguageConsole().getVirtualFile(), console.getContent().getComponent());
        }
    }

    private static void updateColors(@NotNull Project project, @NotNull VirtualFile file, @Nullable JComponent root2) {
        if (project == null) {
            AssignColorAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AssignColorAction.$$$reportNull$$$0(5);
        }
        for (EditorHeaderComponent component : UIUtil.uiTraverser((Component)root2).filter(EditorHeaderComponent.class)) {
            DatabaseEditorHelper.configureEditorHeader(project, file, (JComponent)component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/AssignColorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOpenFileEditors";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFileEditors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDatabaseToolwindow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateColors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

