/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.LocalDataSourceManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseViewActions {
    private DatabaseViewActions() {
    }

    @NotNull
    public static ToggleAction toggle(@NotNull String name, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(0);
        }
        if (getter == null) {
            DatabaseViewActions.$$$reportNull$$$0(1);
        }
        if (setter == null) {
            DatabaseViewActions.$$$reportNull$$$0(2);
        }
        ToggleAction toggleAction = DatabaseViewActions.toggle(name, getter, setter, null, null);
        if (toggleAction == null) {
            DatabaseViewActions.$$$reportNull$$$0(3);
        }
        return toggleAction;
    }

    @NotNull
    public static ToggleAction toggle(@NotNull String name, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter, @Nullable Runnable performer) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(4);
        }
        if (getter == null) {
            DatabaseViewActions.$$$reportNull$$$0(5);
        }
        if (setter == null) {
            DatabaseViewActions.$$$reportNull$$$0(6);
        }
        ToggleAction toggleAction = DatabaseViewActions.toggle(name, getter, setter, performer, null);
        if (toggleAction == null) {
            DatabaseViewActions.$$$reportNull$$$0(7);
        }
        return toggleAction;
    }

    @NotNull
    public static ToggleAction toggle(@NotNull String name, final @NotNull Getter<Boolean> getter, final @NotNull Setter<Boolean> setter, final @Nullable Runnable performer, final @Nullable Consumer<Presentation> updater) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(8);
        }
        if (getter == null) {
            DatabaseViewActions.$$$reportNull$$$0(9);
        }
        if (setter == null) {
            DatabaseViewActions.$$$reportNull$$$0(10);
        }
        ToggleAction toggleAction = new ToggleAction(name){

            public boolean isSelected(AnActionEvent e) {
                return (Boolean)getter.get();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                if ((Boolean)getter.get() != state) {
                    setter.set((Object)state);
                    if (performer != null) {
                        performer.run();
                    }
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.update(e);
                if (updater != null) {
                    updater.consume((Object)e.getPresentation());
                }
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseViewActions$1", "update"));
            }
        };
        if (toggleAction == null) {
            DatabaseViewActions.$$$reportNull$$$0(11);
        }
        return toggleAction;
    }

    @Nullable
    public static String getDbGroupName(@NotNull AnActionEvent e) {
        PsiElement selection;
        if (e == null) {
            DatabaseViewActions.$$$reportNull$$$0(12);
        }
        return (selection = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext())) instanceof DatabaseStructure.DbGroup ? ((DatabaseStructure.DbGroup)selection).getQualifiedName() : null;
    }

    @Nullable
    static DbPsiFacade getDbFacade(@NotNull AnActionEvent e) {
        PsiElement element;
        if (e == null) {
            DatabaseViewActions.$$$reportNull$$$0(13);
        }
        return (element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT)) instanceof DatabaseStructure.DbRootGroup ? ((DatabaseStructure.DbRootGroup)element).facade : (DbPsiFacade)e.getData(DatabaseDataKeys.DB_PSI_FACADE);
    }

    private static void onDataSourceCreated(@NotNull DbPsiFacade facade, @NotNull DataSourceManager<?> manager, @NotNull DasDataSource dataSource) {
        if (facade == null) {
            DatabaseViewActions.$$$reportNull$$$0(14);
        }
        if (manager == null) {
            DatabaseViewActions.$$$reportNull$$$0(15);
        }
        if (dataSource == null) {
            DatabaseViewActions.$$$reportNull$$$0(16);
        }
        DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource, manager);
        DataSourceManagerDialog.showDialog(facade, (Object)newElement);
    }

    public static void addToLRUNames(@NotNull Project project, int lruItems, @NotNull String key2, @NotNull String name) {
        if (project == null) {
            DatabaseViewActions.$$$reportNull$$$0(17);
        }
        if (key2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(18);
        }
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(19);
        }
        PropertiesComponent props = PropertiesComponent.getInstance((Project)project);
        List list = (List)JBIterable.of((Object[])props.getValues(key2)).unique().addAllTo((Collection)ContainerUtil.newArrayList());
        list.remove(name);
        list.add(name);
        List lru = list.subList(Math.max(0, list.size() - lruItems), list.size());
        props.setValues(key2, ArrayUtil.toStringArray(lru));
    }

    @NotNull
    public static List<String> getLRUNames(@NotNull Project project, @NotNull String key2) {
        if (project == null) {
            DatabaseViewActions.$$$reportNull$$$0(20);
        }
        if (key2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(21);
        }
        List list = JBIterable.of((Object[])PropertiesComponent.getInstance((Project)project).getValues(key2)).toList();
        if (list == null) {
            DatabaseViewActions.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private static JComponent createKindChooser(@NotNull DatabaseView databaseView) {
        if (databaseView == null) {
            DatabaseViewActions.$$$reportNull$$$0(23);
        }
        DatabaseViewOptions options = databaseView.getViewOptions();
        ArrayList kinds = ContainerUtil.newArrayList(ObjectKind.ourKinds.values());
        kinds.removeAll(Arrays.asList(ObjectKind.NONE, ObjectKind.UNKNOWN_OBJECT, ObjectKind.ROOT, ObjectKind.COMMENT));
        Collections.sort(kinds, Comparator.comparing(ObjectKind::name));
        ElementsChooser<ObjectKind> chooser = new ElementsChooser<ObjectKind>((List)kinds, true){

            protected String getItemText(@NotNull ObjectKind value) {
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StringUtil.capitalizeWords((String)DbPresentation.getPresentableName(value, GenericDialect.INSTANCE), (boolean)true);
            }

            protected Icon getItemIcon(@NotNull ObjectKind value) {
                if (value == null) {
                    2.$$$reportNull$$$0(1);
                }
                return (Icon)ObjectUtils.notNull((Object)DbPresentation.getIcon(value), (Object)EmptyIcon.ICON_16);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getItemText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getItemIcon";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Iterator iterator2 = kinds.iterator();
        while (iterator2.hasNext()) {
            ObjectKind kind;
            chooser.setElementMarked((Object)kind, !options.HIDDEN_KINDS.contains((kind = (ObjectKind)iterator2.next()).code()));
        }
        chooser.addElementsMarkListener((element, isMarked) -> {
            if (databaseView == null) {
                DatabaseViewActions.$$$reportNull$$$0(25);
            }
            if (isMarked) {
                options.HIDDEN_KINDS.remove(element.code());
            } else {
                options.HIDDEN_KINDS.add(element.code());
            }
            databaseView.refreshView();
        });
        chooser.setFocusable(false);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add((Component)chooser);
        JPanel buttons = new JPanel();
        JButton all = new JButton("All");
        all.addActionListener(new ActionListener((ElementsChooser)chooser){
            final /* synthetic */ ElementsChooser val$chooser;
            {
                this.val$chooser = elementsChooser;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$chooser.setAllElementsMarked(true);
            }
        });
        buttons.add(all);
        JButton none = new JButton("None");
        none.addActionListener(new ActionListener((ElementsChooser)chooser){
            final /* synthetic */ ElementsChooser val$chooser;
            {
                this.val$chooser = elementsChooser;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$chooser.setAllElementsMarked(false);
            }
        });
        buttons.add(none);
        JButton invert = new JButton("Invert");
        invert.addActionListener(new ActionListener((ElementsChooser)chooser){
            final /* synthetic */ ElementsChooser val$chooser;
            {
                this.val$chooser = elementsChooser;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$chooser.invertSelection();
            }
        });
        buttons.add(invert);
        panel.add(buttons);
        JPanel jPanel = panel;
        if (jPanel == null) {
            DatabaseViewActions.$$$reportNull$$$0(24);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toggle";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLRUNames";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createKindChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toggle";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 22: 
            case 24: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroupName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDbFacade";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onDataSourceCreated";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addToLRUNames";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLRUNames";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createKindChooser";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createKindChooser$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FilterAction
    extends DumbAwareAction {
        FilterAction() {
        }

        public void update(AnActionEvent e) {
            DatabaseView databaseView = (DatabaseView)((Object)e.getData(DatabaseView.DATABASE_VIEW_KEY));
            boolean active = databaseView != null && !databaseView.getViewOptions().HIDDEN_KINDS.isEmpty();
            e.getPresentation().setEnabledAndVisible(databaseView != null);
            Icon icon = this.getTemplatePresentation().getIcon();
            e.getPresentation().setIcon(active ? ExecutionUtil.getLiveIndicator((Icon)icon) : icon);
        }

        public void actionPerformed(AnActionEvent e) {
            DatabaseView databaseView = (DatabaseView)((Object)e.getData(DatabaseView.DATABASE_VIEW_KEY));
            if (databaseView == null) {
                return;
            }
            Project project = databaseView.getProject();
            JComponent chooser = DatabaseViewActions.createKindChooser(databaseView);
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(chooser, null).setFocusable(false).setRequestFocus(false).setResizable(true).setMinSize(new Dimension(200, 200)).setDimensionServiceKey(project, "DatabaseViewActions_Filter", false).createPopup();
            DbUIUtil.showPopup(popup, (Editor)e.getData(CommonDataKeys.EDITOR), e);
        }
    }

    static class MoveToGroup
    extends DataSourceActionBase {
        MoveToGroup() {
        }

        @Override
        public void update(AnActionEvent e) {
            boolean disable = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbDataSource.class).isEmpty();
            if (disable) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e);
            }
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource source) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(0);
            }
            if (source == null) {
                MoveToGroup.$$$reportNull$$$0(1);
            }
            return source.getDelegate() instanceof AbstractDataSource;
        }

        @Override
        protected void performActionImpl(final @NotNull Project project, @NotNull List<DbDataSource> dataSources2, @NotNull AnActionEvent e) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(2);
            }
            if (dataSources2 == null) {
                MoveToGroup.$$$reportNull$$$0(3);
            }
            if (e == null) {
                MoveToGroup.$$$reportNull$$$0(4);
            }
            JBIterable allDataSources = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)project).getDataSources()).map(DbDataSource::getDelegate).filter(AbstractDataSource.class).collect();
            List groups = (List)allDataSources.filterMap(o -> o.getGroupName()).flatMap(o -> JBIterable.generate((Object)o, o1 -> {
                int idx = o1.lastIndexOf("/");
                return idx < 0 ? null : o1.substring(0, idx);
            })).collect(new TreeSet(NaturalComparator.INSTANCE)).addAllTo(new ArrayList());
            String newGroup = new String("New group...");
            String topGroup = new String("Root group");
            final Consumer action = o -> {
                String groupName;
                if (dataSources2 == null) {
                    MoveToGroup.$$$reportNull$$$0(5);
                }
                if (project == null) {
                    MoveToGroup.$$$reportNull$$$0(6);
                }
                if (o == topGroup) {
                    groupName = null;
                } else if (o != newGroup) {
                    groupName = o;
                } else {
                    String initial = (String)JBIterable.from((Iterable)dataSources2).filterMap(d -> StringUtil.nullize((String)((AbstractDataSource)d.getDelegate()).getGroupName())).first();
                    groupName = Messages.showInputDialog((Project)project, (String)"Group name, i.e. 'staging' or 'qa/quick'", (String)"Create New Group", (Icon)Messages.getQuestionIcon(), (String)initial, null);
                    if (groupName == null) {
                        return;
                    }
                }
                for (DbDataSource dataSource : dataSources2) {
                    ((AbstractDataSource)dataSource.getDelegate()).setGroupName(groupName);
                }
                DatabaseView.refreshViewAndSelect(project, dataSources2);
            };
            if (groups.isEmpty()) {
                action.consume((Object)newGroup);
                return;
            }
            groups.add(0, newGroup);
            groups.add(1, topGroup);
            BaseListPopupStep<String> step = new BaseListPopupStep<String>("Move to Group", groups){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(String o) {
                    String string = o;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public Icon getIconFor(String value) {
                    return DatabaseIcons.ObjectGroup;
                }

                public ListSeparator getSeparatorAbove(String value) {
                    List values2 = this.getValues();
                    int index2 = values2.indexOf(value);
                    return index2 == 2 ? new ListSeparator() : null;
                }

                public PopupStep onChosen(String o, boolean finalChoice) {
                    ApplicationManager.getApplication().invokeLater(() -> action.consume((Object)o), ModalityState.current(), project.getDisposed());
                    return PopupStep.FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$MoveToGroup$1", "getTextFor"));
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step, 20);
            DbUIUtil.showPopup((JBPopup)popup, null, e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$MoveToGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$performActionImpl$4";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CopyAction
    extends DumbAwareAction {
        CopyAction() {
        }

        public void update(AnActionEvent e) {
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
            boolean enabled = elements.size() == 1 && elements.first() instanceof DbDataSource;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || !ActionPlaces.isPopupPlace((String)e.getPlace()));
        }

        public void actionPerformed(AnActionEvent e) {
            DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
            if (facade == null) {
                return;
            }
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
            PsiElement first = (PsiElement)elements.first();
            if (elements.size() != 1 || !(first instanceof DbDataSource)) {
                return;
            }
            DbDataSource element = (DbDataSource)first;
            DatabaseView view = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
            if (view == null) {
                return;
            }
            String newName = DbUtil.generateUniqueDataSourceName((Project)facade.getProject(), (String)element.getName());
            DataSourceManager dbManager = facade.getDataSourceManager(element);
            DasDataSource dsCopy = dbManager.copyDataSource(newName, (DasDataSource)element.getDelegate());
            DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dsCopy, dbManager);
            DataSourceManagerDialog.showDialog(facade, (Object)newElement);
        }
    }

    static class ForgetSchemasAction
    extends DataSourceActionBase {
        ForgetSchemasAction() {
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource) {
            if (project == null) {
                ForgetSchemasAction.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                ForgetSchemasAction.$$$reportNull$$$0(1);
            }
            return dataSource.getDelegate() instanceof LocalDataSource;
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources2, @NotNull AnActionEvent e) {
            if (project == null) {
                ForgetSchemasAction.$$$reportNull$$$0(2);
            }
            if (dataSources2 == null) {
                ForgetSchemasAction.$$$reportNull$$$0(3);
            }
            if (e == null) {
                ForgetSchemasAction.$$$reportNull$$$0(4);
            }
            final DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
            ForgetSchemasAction.performActionImpl(dataSources2, (Consumer<DbDataSource>)((Consumer)dataSource -> {
                LocalDataSource delegate;
                if (project == null) {
                    ForgetSchemasAction.$$$reportNull$$$0(5);
                }
                if ((delegate = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource)) == null) {
                    return;
                }
                new Task.Backgroundable(project, "Clearing Cached Schemas"){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DataSourceSyncManager.getInstance().stopSynchronization(delegate).whenCompleteAsync((r, th) -> delegate.forgetCachedSchemas(), AsyncUtil.POOL_EXECUTOR).whenCompleteAsync((r, th) -> storage.updateDataSource(delegate), AsyncUtil.EDT_EXECUTOR);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction$1", "run"));
                    }
                }.queue();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$performActionImpl$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class DisconnectAction
    extends DataSourceActionBase {
        DisconnectAction() {
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource) {
            if (project == null) {
                DisconnectAction.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                DisconnectAction.$$$reportNull$$$0(1);
            }
            JdbcDriverManager manager = JdbcDriverManager.getDriverManager(project);
            DatabaseSystem delegate = dataSource.getDelegate();
            LocalDataSource local = delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
            return local != null && !manager.getActiveConfigurations(local).isEmpty();
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources2, @NotNull AnActionEvent e) {
            if (project == null) {
                DisconnectAction.$$$reportNull$$$0(2);
            }
            if (dataSources2 == null) {
                DisconnectAction.$$$reportNull$$$0(3);
            }
            if (e == null) {
                DisconnectAction.$$$reportNull$$$0(4);
            }
            JdbcDriverManager manager = JdbcDriverManager.getDriverManager(project);
            DisconnectAction.performActionImpl(dataSources2, (Consumer<DbDataSource>)((Consumer)dataSource -> manager.releaseDriver(DbImplUtil.getLocalDataSource((DasDataSource)dataSource), null)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$DisconnectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class DataSourceActionBase
    extends DumbAwareAction {
        DataSourceActionBase() {
        }

        protected abstract boolean isEnabledFor(@NotNull Project var1, @NotNull DbDataSource var2);

        protected abstract void performActionImpl(@NotNull Project var1, @NotNull List<DbDataSource> var2, @NotNull AnActionEvent var3);

        public void update(AnActionEvent e) {
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            boolean enabled = false;
            boolean strict = false;
            if (project != null && !elements.isEmpty()) {
                HashSet visited = ContainerUtil.newHashSet();
                for (DbElement element : elements) {
                    DbDataSource dataSource = element.getDataSource();
                    if (!visited.add(dataSource.getUniqueId())) continue;
                    strict |= element == dataSource;
                    if (enabled || !this.isEnabledFor(project, dataSource)) continue;
                    enabled = true;
                }
            }
            boolean inPopup = ActionPlaces.isPopupPlace((String)e.getPlace());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(!inPopup || strict);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            if (project == null || elements.isEmpty()) {
                return;
            }
            ArrayList dataSources2 = ContainerUtil.newArrayList();
            HashSet visited = ContainerUtil.newHashSet();
            for (DbElement element : elements) {
                DbDataSource dataSource = element.getDataSource();
                if (!visited.add(dataSource.getUniqueId()) || !this.isEnabledFor(project, dataSource)) continue;
                dataSources2.add(dataSource);
            }
            this.performActionImpl(project, dataSources2, e);
        }

        protected static void performActionImpl(@NotNull List<DbDataSource> dataSources2, @NotNull Consumer<DbDataSource> consumer2) {
            if (dataSources2 == null) {
                DataSourceActionBase.$$$reportNull$$$0(0);
            }
            if (consumer2 == null) {
                DataSourceActionBase.$$$reportNull$$$0(1);
            }
            for (DbDataSource dataSource : dataSources2) {
                consumer2.consume((Object)dataSource);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSources";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/DatabaseViewActions$DataSourceActionBase";
            objectArray[2] = "performActionImpl";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToolsPopupGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        public boolean canBePerformed(DataContext context) {
            return true;
        }

        public void update(AnActionEvent e) {
            boolean enabled = e.getData(DatabaseView.DATABASE_VIEW_KEY) != null;
            boolean visible = enabled && ("DatabaseViewPopup".equals(e.getPlace()) || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()));
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        public void actionPerformed(AnActionEvent e) {
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Database Tools", (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, false, null, 20, null, "DatabaseViewPopup");
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    static class AddDriverAndDataSource
    extends DumbAwareAction {
        AddDriverAndDataSource() {
        }

        public void update(AnActionEvent e) {
            boolean enabled = DatabaseViewActions.getDbFacade(e) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            DbPsiFacade facade = DatabaseViewActions.getDbFacade(e);
            if (facade == null) {
                return;
            }
            Collection<? extends DatabaseDriver> existing = DatabaseDriverManager.getInstance().getDrivers();
            DatabaseDriver driver = DataSourceUiUtil.createDefaultDatabaseDriver(existing);
            LocalDataSource dataSource = driver.createDataSource(null, null);
            LocalDataSourceManager defaultManager = LocalDataSourceManager.getInstance(facade.getProject());
            DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource, defaultManager);
            DataSourceManagerDialog.showDialog(facade, (Object)JBIterable.of((Object[])new Iconable[]{newElement, driver}));
        }
    }

    static class AddDriver
    extends DumbAwareAction {
        AddDriver() {
        }

        public void update(AnActionEvent e) {
            boolean enabled = DatabaseViewActions.getDbFacade(e) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            DbPsiFacade facade = DatabaseViewActions.getDbFacade(e);
            if (facade == null) {
                return;
            }
            Collection<? extends DatabaseDriver> existing = DatabaseDriverManager.getInstance().getDrivers();
            DatabaseDriver driver = DataSourceUiUtil.createDefaultDatabaseDriver(existing);
            DataSourceManagerDialog.showDialog(facade, (Object)driver);
        }
    }

    static class AddDataSourceFromThatAction
    extends AddDataSourceFromPath.FromThat {
        AddDataSourceFromThatAction() {
            super((x$0, x$1, x$2) -> DatabaseViewActions.onDataSourceCreated(x$0, x$1, x$2));
        }
    }

    static class AddDataSourceHereAction
    extends AddDataSourceFromPath.Here {
        AddDataSourceHereAction() {
            super((x$0, x$1, x$2) -> DatabaseViewActions.onDataSourceCreated(x$0, x$1, x$2));
        }
    }

    static class AddDataSourceFromPathAction
    extends AddDataSourceFromPath.FromDialog {
        AddDataSourceFromPathAction() {
            super((x$0, x$1, x$2) -> DatabaseViewActions.onDataSourceCreated(x$0, x$1, x$2));
        }
    }

    static class AddDataSourceFromUrlAction
    extends AddDataSourceFromUrl {
        AddDataSourceFromUrlAction() {
            super((x$0, x$1, x$2) -> DatabaseViewActions.onDataSourceCreated(x$0, x$1, x$2));
        }
    }

    public static interface DataSourceFactory {
        public void create(@NotNull DbPsiFacade var1, @NotNull DataSourceManager<LocalDataSource> var2, @NotNull LocalDataSource var3);
    }

    public static class AddDataSourcesGroup
    extends ActionGroup
    implements DumbAware,
    AlwaysVisibleActionGroup {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            DbPsiFacade facade;
            DbPsiFacade dbPsiFacade = facade = e == null ? null : DatabaseViewActions.getDbFacade(e);
            if (facade == null) {
                if (EMPTY_ARRAY == null) {
                    AddDataSourcesGroup.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }
            String groupName = DatabaseViewActions.getDbGroupName(e);
            List<AnAction> actions = DataSourceManager.getManagers((Project)facade.getProject()).stream().map(manager -> manager.getCreateDataSourceAction(d -> {
                ((AbstractDataSource)((Object)((Object)d))).setGroupName(groupName);
                DatabaseViewActions.onDataSourceCreated(facade, manager, d);
            })).filter(Objects::nonNull).collect(Collectors.toList());
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$AddDataSourcesGroup", "getChildren"));
        }
    }

    public static class AddActionGroupPopup
    extends DefaultActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            e.getPresentation().setIcon(e.isFromActionToolbar() ? IconUtil.getAddIcon() : AllIcons.General.Add);
        }
    }
}

