/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class FillDbFilesCacheInternalAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        boolean enabled = DbImplUtil.getMaybeLocalDataSource((DasDataSource)FillDbFilesCacheInternalAction.getDataSource(e.getDataContext())) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DbDataSourceImpl source = FillDbFilesCacheInternalAction.getDataSource(e.getDataContext());
        if (source == null) {
            return;
        }
        source.getModel().traverser().traverse().filterMap(source::findElement).forEach(o -> DatabaseElementVirtualFileImpl.findFile(o, true));
    }

    @Nullable
    private static DbDataSourceImpl getDataSource(DataContext context) {
        DbElement item = (DbElement)DatabaseView.getSelectedElements(context, true).first();
        return item == null ? null : (DbDataSourceImpl)((Object)ObjectUtils.tryCast((Object)item.getDataSource(), DbDataSourceImpl.class));
    }
}

