/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.grid.selection.GridSelectionTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public abstract class GridOccurrenceSelectionAction
extends DumbAwareAction
implements GridAction {
    public void update(AnActionEvent e) {
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(grid != null && grid.getSelectionModel().getTracker().canPerformOperation(this.getOperation()));
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        if (grid == null || !grid.getSelectionModel().getTracker().canPerformOperation(this.getOperation())) {
            return;
        }
        grid.getSelectionModel().getTracker().performOperation(this.getOperation());
    }

    @NotNull
    abstract GridSelectionTracker.Operation getOperation();

    public static class SelectAllOccurrencesAction
    extends GridOccurrenceSelectionAction {
        @Override
        @NotNull
        GridSelectionTracker.Operation getOperation() {
            GridSelectionTracker.Operation operation2 = GridSelectionTracker.Operation.SELECT_ALL;
            if (operation2 == null) {
                SelectAllOccurrencesAction.$$$reportNull$$$0(0);
            }
            return operation2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GridOccurrenceSelectionAction$SelectAllOccurrencesAction", "getOperation"));
        }
    }

    public static class UnselectPreviousOccurrenceAction
    extends GridOccurrenceSelectionAction {
        @Override
        @NotNull
        GridSelectionTracker.Operation getOperation() {
            GridSelectionTracker.Operation operation2 = GridSelectionTracker.Operation.UNSELECT_PREVIOUS;
            if (operation2 == null) {
                UnselectPreviousOccurrenceAction.$$$reportNull$$$0(0);
            }
            return operation2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GridOccurrenceSelectionAction$UnselectPreviousOccurrenceAction", "getOperation"));
        }
    }

    public static class SelectNextOccurrenceAction
    extends GridOccurrenceSelectionAction {
        @Override
        @NotNull
        GridSelectionTracker.Operation getOperation() {
            GridSelectionTracker.Operation operation2 = GridSelectionTracker.Operation.SELECT_NEXT;
            if (operation2 == null) {
                SelectNextOccurrenceAction.$$$reportNull$$$0(0);
            }
            return operation2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GridOccurrenceSelectionAction$SelectNextOccurrenceAction", "getOperation"));
        }
    }
}

