/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbGridGotoRelatedProvider;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.database.view.DatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public abstract class OpenEditorAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(0);
        }
        boolean mouseSelection = e.getInputEvent() instanceof MouseEvent && UIUtil.isToggleListSelectionEvent((MouseEvent)((MouseEvent)e.getInputEvent()));
        DatabaseView databaseView = (DatabaseView)((Object)e.getData(DatabaseView.DATABASE_VIEW_KEY));
        boolean enabled = databaseView != null && !mouseSelection && !this.getNavigatables(databaseView.getProject(), e, false).filter(Navigatable::canNavigate).isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        OpenSourceUtil.navigate((boolean)true, (boolean)true, this.getNavigatables(project, e, true));
    }

    @NotNull
    protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
        if (project == null) {
            OpenEditorAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(3);
        }
        JBIterable jBIterable = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY)));
        if (jBIterable == null) {
            OpenEditorAction.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatables";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OpenDDLGridAction
    extends AlignedIconWithTextAction
    implements DumbAware {
        OpenDDLGridAction() {
        }

        public void update(AnActionEvent e) {
            PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
            boolean enabled = e.getData(DatabaseDataKeys.DATA_GRID_KEY) != null && DbGridGotoRelatedProvider.getTargetElement(element) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            DbElement target = DbGridGotoRelatedProvider.getTargetElement((PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT));
            if (target == null) {
                return;
            }
            EditorWindow editorWindow = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
            if (editorWindow != null) {
                FileEditorManagerEx.getInstanceEx((Project)target.getProject()).setCurrentWindow(editorWindow);
            }
            DatabaseTargetElementEvaluator.navigateToSource(target, true);
        }
    }

    static class OpenDDLAction
    extends OpenEditorAction {
        OpenDDLAction() {
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDDLAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                OpenDDLAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).filterMap(o -> {
                if (project == null) {
                    OpenDDLAction.$$$reportNull$$$0(3);
                }
                if (!(o instanceof DbElement)) {
                    return o;
                }
                if (DbSqlUtil.isSqlElement((DbElement)o)) {
                    return o;
                }
                DbElement major = DatabaseTargetElementEvaluator.adjustForNavigation((DbElement)o);
                VirtualFile file = DbImplUtil.findSourceVirtualFile(major, forInvoke);
                if (file == null) {
                    return null;
                }
                if (!forInvoke) {
                    return new OpenFileDescriptor(project, file);
                }
                return DatabaseTargetElementEvaluator.createToSourceNavigatable((DbElement)o);
            }).filter(Navigatable.class);
            if (jBIterable == null) {
                OpenDDLAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getNavigatables$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class OpenDataAction
    extends OpenEditorAction {
        OpenDataAction() {
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDataAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                OpenDataAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).map(o -> o instanceof DbTableChild ? ((DbTableChild)o).getParent() : o).filter(DbTable.class).filter(o -> DbImplUtil.isDataTable(o.getKind())).map(o -> o.getVirtualFile()).filter(Conditions.notNull()).map(o -> {
                if (project == null) {
                    OpenDataAction.$$$reportNull$$$0(3);
                }
                return new OpenFileDescriptor(project, o);
            });
            if (jBIterable == null) {
                OpenDataAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getNavigatables$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class OpenDefaultAction
    extends OpenEditorAction {
        OpenDefaultAction() {
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Navigatable single;
            if (e == null) {
                OpenDefaultAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            Project project = e.getProject();
            if (e.getPresentation().isEnabled() && project != null && ((single = (Navigatable)this.getNavigatables(project, e, false).single()) instanceof DbDataSource || single instanceof DbNamespaceImpl) && DbImplUtil.canConnectTo((DbElement)single)) {
                e.getPresentation().setText("Open Console");
                e.getPresentation().setIcon(AllIcons.RunConfigurations.Ql_console);
            }
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDefaultAction.$$$reportNull$$$0(1);
            }
            if (e == null) {
                OpenDefaultAction.$$$reportNull$$$0(2);
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).filter(o -> o instanceof DbElement);
            if (jBIterable == null) {
                OpenDefaultAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDefaultAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDefaultAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

