/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;

public class ShowSchemasAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        DbElement element = (DbElement)DatabaseView.getSelectedElements(e.getDataContext(), true).first();
        LocalDataSource dataSource = element == null ? null : DbImplUtil.getMaybeLocalDataSource((DasDataSource)element.getDataSource());
        DasModel model = dataSource == null ? null : dataSource.getModel();
        boolean enabled = model == DasUtil.emptyModel() || model instanceof BasicModModel;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        LocalDataSource dataSource;
        DbElement element = (DbElement)DatabaseView.getSelectedElements(e.getDataContext(), true).first();
        LocalDataSource localDataSource = dataSource = element == null ? null : DbImplUtil.getMaybeLocalDataSource((DasDataSource)element.getDataSource());
        if (dataSource == null) {
            return;
        }
        BasicElement selection = element.getDelegate() instanceof BasicElement ? (BasicElement)element.getDelegate() : null;
        DataSourceUiUtil.buildHiddenNamespacesPopup(element.getProject(), dataSource, selection).showInBestPositionFor(e.getDataContext());
    }
}

