/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceRegistry {
    private final Project myProject;
    private final Map<LocalDataSource, DataSourceDetector.Callback> myDataSources = ContainerUtil.newLinkedHashMap();
    private final Map<String, DatabaseDriverImpl> myDrivers = ContainerUtil.newLinkedHashMap();
    private boolean myImportedFlag = true;

    public DataSourceRegistry(Project project) {
        this.myProject = project;
    }

    public void setImportedFlag(boolean flag) {
        this.myImportedFlag = flag;
    }

    public DataSourceDetector.Builder getBuilder() {
        return new MyBuilder().reset();
    }

    public boolean isEmpty() {
        return this.myDataSources.isEmpty();
    }

    public Collection<LocalDataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.myDataSources.keySet());
    }

    public boolean showDialog() {
        if (this.isEmpty()) {
            return true;
        }
        return DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)this.myProject), this);
    }

    @Nullable
    public DataSourceDetector.Callback getCallback(LocalDataSource dataSource) {
        return this.myDataSources.get(dataSource);
    }

    public Collection<? extends LocalDataSource> getNewDataSources() {
        if (this.myDataSources.isEmpty()) {
            return Collections.emptyList();
        }
        MultiMap uniqueNames = MultiMap.createLinked();
        for (LocalDataSource localDataSource : this.myDataSources.keySet()) {
            uniqueNames.putValue((Object)localDataSource.getName(), (Object)localDataSource);
        }
        for (AbstractDataSource abstractDataSource : DataSourceStorage.getProjectStorage(this.myProject).getDataSources()) {
            uniqueNames.remove((Object)abstractDataSource.getName());
        }
        return uniqueNames.values();
    }

    private static boolean isEmpty(@NotNull LocalDataSource tmp) {
        if (tmp == null) {
            DataSourceRegistry.$$$reportNull$$$0(0);
        }
        return StringUtil.isEmptyOrSpaces((String)tmp.getDriverClass()) && StringUtil.isEmptyOrSpaces((String)tmp.getUsername()) && StringUtil.isEmptyOrSpaces((String)tmp.getPassword()) && StringUtil.isEmptyOrSpaces((String)tmp.getUrl()) && tmp.getDriverProperties().isEmpty();
    }

    public void retainNewOnly() {
        this.myDataSources.keySet().retainAll(this.getNewDataSources());
    }

    public String toString() {
        return "DataSourceRegistry:" + this.myDataSources.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tmp", "com/intellij/database/autoconfig/DataSourceRegistry", "isEmpty"));
    }

    private static class MyDriverBuilder
    implements DataSourceDetector.DriverBuilder {
        final MyBuilder builder;
        final Set<String> paths = ContainerUtil.newLinkedHashSet();
        DatabaseDriverImpl tmp;

        MyDriverBuilder(MyBuilder builder) {
            this.builder = builder;
        }

        public DataSourceDetector.Builder commitDriver() {
            return this.builder.commitDriver();
        }

        public DataSourceDetector.DriverBuilder withName(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setName(s);
            return this;
        }

        public DataSourceDetector.DriverBuilder withComment(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setComment(s);
            return this;
        }

        public DataSourceDetector.DriverBuilder withDriverClass(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setDriverClass(s);
            return this;
        }

        public DataSourceDetector.DriverBuilder withAdditionalJar(@Nullable String path) {
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                return this;
            }
            for (String s : StringUtil.split((String)path, (String)File.pathSeparator, (boolean)true, (boolean)true)) {
                this.paths.add(VfsUtilCore.pathToUrl((String)s));
            }
            return this;
        }

        public DataSourceDetector.DriverBuilder withDriverProperty(@Nullable String name, @Nullable String value) {
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return this;
            }
            this.tmp.getDriverProperties().put(name, value);
            return this;
        }

        public DataSourceDetector.DriverBuilder withVMOptions(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setVmOptions(s);
            return this;
        }

        public DataSourceDetector.DriverBuilder withVMEnv(@Nullable String name, @Nullable String value) {
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return this;
            }
            this.tmp.getVmEnv().put(name, value);
            return this;
        }
    }

    private class MyBuilder
    implements DataSourceDetector.Builder {
        MyDriverBuilder driverBuilder = new MyDriverBuilder(this);
        LocalDataSource tmp;
        DataSourceDetector.Callback callback;

        private MyBuilder() {
        }

        public DataSourceDetector.Builder commit() {
            ProgressManager.checkCanceled();
            if (!DataSourceRegistry.isEmpty(this.tmp)) {
                DatabaseDriver driver = this.tmp.getDatabaseDriver();
                if (driver == null) {
                    driver = DbImplUtil.guessDatabaseDriver(this.tmp);
                }
                if (driver != null) {
                    this.tmp.setDatabaseDriver(driver);
                    if (driver instanceof DatabaseDriverImpl) {
                        ((DatabaseDriverImpl)driver).setDefaultProperties(this.tmp, false);
                    }
                }
                DataSourceRegistry.this.myDataSources.put(this.tmp, this.callback);
            }
            return this.reset();
        }

        public DataSourceDetector.Builder reset() {
            this.tmp = new LocalDataSource(DataSourceRegistry.this.myImportedFlag);
            this.callback = null;
            this.driverBuilder.paths.clear();
            this.driverBuilder.tmp = null;
            return this;
        }

        public DataSourceDetector.DriverBuilder driver(@NotNull DatabaseFamilyId familyId) {
            if (familyId == null) {
                MyBuilder.$$$reportNull$$$0(0);
            }
            DatabaseDriver baseDriver = DbImplUtil.guessDatabaseDriver(familyId);
            this.driverBuilder.paths.clear();
            this.driverBuilder.tmp = baseDriver == null ? new DatabaseDriverImpl(null, false) : ((DatabaseDriverImpl)baseDriver).copy(null, false);
            return this.driverBuilder;
        }

        DataSourceDetector.Builder commitDriver() {
            List cp = SimpleClasspathElementFactory.createElements((String[])ArrayUtil.toStringArray(this.driverBuilder.paths));
            DatabaseDriverImpl tmp = this.driverBuilder.tmp;
            tmp.setAdditionalClasspathElements(cp);
            DataSourceRegistry.this.myDrivers.put(tmp.getName(), tmp);
            this.driverBuilder.paths.clear();
            this.driverBuilder.tmp = null;
            return this;
        }

        public DataSourceDetector.Builder withCallback(@NotNull DataSourceDetector.Callback callback) {
            if (callback == null) {
                MyBuilder.$$$reportNull$$$0(1);
            }
            this.callback = callback;
            return this;
        }

        public DataSourceDetector.Builder withName(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setName(s);
            return this;
        }

        public DataSourceDetector.Builder withComment(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setComment(s);
            return this;
        }

        public DataSourceDetector.Builder withGroupName(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setGroupName(s);
            return this;
        }

        public DataSourceDetector.Builder withDriverClass(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setDriverClass(s);
            return this;
        }

        public DataSourceDetector.Builder withUrl(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setUrlSmart(s);
            return this;
        }

        public DataSourceDetector.Builder withUser(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setUsername(s);
            return this;
        }

        public DataSourceDetector.Builder withPassword(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setPassword(s);
            return this;
        }

        public DataSourceDetector.Builder withDriverProperty(@Nullable String name, @Nullable String value) {
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return this;
            }
            this.tmp.getDriverProperties().put(name, value);
            return this;
        }

        public DataSourceDetector.Builder withDriver(@Nullable String name) {
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return this;
            }
            this.tmp.setDatabaseDriver((DatabaseDriver)DataSourceRegistry.this.myDrivers.get(name));
            return this;
        }

        public DataSourceDetector.Builder withOrigin(@Nullable Object origin) {
            VirtualFile file = origin instanceof PsiElement ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)origin)) : null;
            String path = file != null ? file.getPath() : null;
            String comment = this.tmp.getComment();
            if (path != null) {
                this.tmp.setComment(StringUtil.isEmpty((String)comment) ? path : comment + "\n\n" + path);
            }
            return this;
        }

        public DataSourceDetector.Builder withVMOptions(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setVmOptions(s);
            return this;
        }

        public DataSourceDetector.Builder withVMEnv(@Nullable String name, @Nullable String value) {
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return this;
            }
            this.tmp.getVmEnv().put(name, value);
            return this;
        }

        public String toString() {
            return "Builder{" + this.tmp.getName() + "; " + this.tmp.getUsername() + "@" + this.tmp.getPassword() + "; " + this.tmp.getUrl() + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/autoconfig/DataSourceRegistry$MyBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "driver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withCallback";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

