/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.restore.mysql;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.MysqlConfigurationBase;
import com.intellij.database.cli.SimpleCliDialogValidator;
import com.intellij.database.cli.argument.CommonMysqlArguments;
import com.intellij.database.cli.restore.mysql.MysqlArguments;
import com.intellij.database.cli.restore.mysql.MysqlArgumentsGroup;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlConfiguration
extends MysqlConfigurationBase {
    public static final MysqlConfiguration INSTANCE = new MysqlConfiguration();

    private MysqlConfiguration() {
        super(MysqlArgumentsGroup.values(), DbCliUtil.INPUT, "MYSQL_RESTORE_KEY", "mysql");
    }

    @Override
    @NotNull
    public String getPartOfValidationOut() {
        if ("mysql" == null) {
            MysqlConfiguration.$$$reportNull$$$0(0);
        }
        return "mysql";
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        String path = super.getDefaultSearchPath();
        return path == null ? null : path + "/mysql";
    }

    @Override
    @NotNull
    public CliDialogValidator getValidator() {
        SimpleCliDialogValidator simpleCliDialogValidator = new SimpleCliDialogValidator(DbCliUtil.INPUT, CommonMysqlArguments.PASSWORD);
        if (simpleCliDialogValidator == null) {
            MysqlConfiguration.$$$reportNull$$$0(1);
        }
        return simpleCliDialogValidator;
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = super.getObjectsPreparer().onlyIfSingleElement((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().filter((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource || e.getKind() == ObjectKind.SCHEMA)).requireNotEmpty().onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().finish();
        if (databaseObjectsPreparer == null) {
            MysqlConfiguration.$$$reportNull$$$0(2);
        }
        return databaseObjectsPreparer;
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        Map<String, String> map = super.getInfoMap();
        MysqlConfiguration.put(map, "Only allow UPDATE and DELETE that uses keys", MysqlArguments.SAFE_UPDATES);
        MysqlConfiguration.put(map, "Enable clear text auth plugin", MysqlArguments.ENABLE_CLEARTEXT_PLUGIN);
        MysqlConfiguration.put(map, "Vertical output on narrow terminal", MysqlArguments.AUTO_VERTICAL_OUTPUT);
        MysqlConfiguration.put(map, "Don't write errors line numbers", MysqlArguments.SKIP_LINE_NUMBERS);
        MysqlConfiguration.put(map, "Don't write column names", MysqlArguments.SKIP_COLUMN_NAMES);
        MysqlConfiguration.put(map, "Disable auto rehashing", MysqlArguments.DISABLE_AUTO_REHASH);
        MysqlConfiguration.put(map, "Disable auto rehashing", MysqlArguments.NO_AUTO_REHASH);
        MysqlConfiguration.put(map, "Enable named commands", MysqlArguments.NAMED_COMMANDS);
        MysqlConfiguration.put(map, "Display column type info", MysqlArguments.COLUMN_TYPE_INFO);
        MysqlConfiguration.put(map, "Ignore space after function name", MysqlArguments.IGNORE_SPACES);
        MysqlConfiguration.put(map, "Ignore non-default database statements", MysqlArguments.ONE_DATABASE);
        MysqlConfiguration.put(map, "Print program arguments", MysqlArguments.PRINT_DEFAULTS);
        MysqlConfiguration.put(map, "Print debug info", MysqlArguments.DEBUG_INFO);
        MysqlConfiguration.put(map, "Ignore SIGINT", MysqlArguments.SIGINT_IGNORE);
        MysqlConfiguration.put(map, "Flush after each query", MysqlArguments.UNBUFFERED);
        MysqlConfiguration.put(map, "Show warnings after each query", MysqlArguments.SHOW_WARNINGS);
        MysqlConfiguration.put(map, "Line numbers for errors", MysqlArguments.LINE_NUMBERS);
        MysqlConfiguration.put(map, "Print column names", MysqlArguments.COLUMN_NAMES);
        MysqlConfiguration.put(map, "Enable LOAD DATA LOCAL INFILE", MysqlArguments.LOCAL_INFILE);
        MysqlConfiguration.put(map, "Ignore option files", MysqlArguments.NO_DEFAULTS);
        MysqlConfiguration.put(map, "Disallows old protocol usage", MysqlArguments.SECURE_AUTH);
        MysqlConfiguration.put(map, "Turns on binary parsing mode", MysqlArguments.BINARY_MODE);
        MysqlConfiguration.put(map, "Preserve comments", MysqlArguments.COMMENTS);
        MysqlConfiguration.put(map, "Enable auto rehashing", MysqlArguments.AUTO_REHASH);
        MysqlConfiguration.put(map, "Use compression", MysqlArguments.COMPRESS);
        MysqlConfiguration.put(map, "Print debug info on exit", MysqlArguments.DEBUG_CHECK);
        MysqlConfiguration.put(map, "Database name", MysqlArguments.DATABASE);
        MysqlConfiguration.put(map, "Print query output vertically", MysqlArguments.VERTICAL);
        MysqlConfiguration.put(map, "Show help", MysqlArguments.HELP);
        MysqlConfiguration.put(map, "Turn off beep on error", MysqlArguments.NO_BEEP);
        MysqlConfiguration.put(map, "Log filtered commands to syslog", MysqlArguments.SYSLOG);
        MysqlConfiguration.put(map, "Reconnect on connection lost", MysqlArguments.RECONNECT);
        MysqlConfiguration.put(map, "Silent mode", MysqlArguments.SILENT);
        MysqlConfiguration.put(map, "Output in table format", MysqlArguments.TABLE);
        MysqlConfiguration.put(map, "Don't use history file", MysqlArguments.BATCH);
        MysqlConfiguration.put(map, "Debug mode", MysqlArguments.DEBUG);
        MysqlConfiguration.put(map, "Continue on SQL error", MysqlArguments.FORCE);
        MysqlConfiguration.put(map, "Don't cache result", MysqlArguments.QUICK);
        MysqlConfiguration.put(map, "HTML output", MysqlArguments.HTML);
        MysqlConfiguration.put(map, "Wait and retry if connection is down", MysqlArguments.WAIT);
        MysqlConfiguration.put(map, "XML output", MysqlArguments.XML);
        MysqlConfiguration.put(map, "Write fields without conversion", MysqlArguments.RAW);
        MysqlConfiguration.put(map, "Ready to handle expired password", MysqlArguments.CONNECT_EXPIRED_PASSWORD);
        MysqlConfiguration.put(map, "Read groups with concat group and suffix", MysqlArguments.DEFAULTS_GROUP_SUFFIX);
        MysqlConfiguration.put(map, "Default charset name", MysqlArguments.DEFAULT_CHARACTER_SET);
        MysqlConfiguration.put(map, "Read this file after global files", MysqlArguments.DEFAULTS_EXTRA_FILE);
        MysqlConfiguration.put(map, "Public RSA key path", MysqlArguments.PUBLIC_KEY_PATH);
        MysqlConfiguration.put(map, "Charset files directory", MysqlArguments.CHARACTER_SETS_DIR);
        MysqlConfiguration.put(map, "Connection timeout in seconds", MysqlArguments.CONNECT_TIMEOUT);
        MysqlConfiguration.put(map, "Default options file", MysqlArguments.DEFAULTS_FILE);
        MysqlConfiguration.put(map, "JOIN row count limit", MysqlArguments.MAX_JOIN_SIZE);
        MysqlConfiguration.put(map, "IP address to bind to", MysqlArguments.BIND_ADDRESS);
        MysqlConfiguration.put(map, "SQL to execute when connecting", MysqlArguments.INIT_COMMAND);
        MysqlConfiguration.put(map, "Client-side auth plugin", MysqlArguments.DEFAULT_AUTH);
        MysqlConfiguration.put(map, "SELECT row count limit", MysqlArguments.SELECT_LIMIT);
        MysqlConfiguration.put(map, "Parameter for server", MysqlArguments.SERVER_ARG);
        MysqlConfiguration.put(map, "Path to read from the login file", MysqlArguments.LOGIN_PATH);
        MysqlConfiguration.put(map, "Command to execute", MysqlArguments.EXECUTE);
        MysqlConfiguration.put(map, "Delimiter to use", MysqlArguments.DELIMITER);
        MysqlConfiguration.put(map, "Socket file", MysqlArguments.SOCKET);
        MysqlConfiguration.put(map, "Connection protocol to use", MysqlArguments.PROTOCOL);
        MysqlConfiguration.put(map, "Mysql prompt value", MysqlArguments.PROMPT);
        MysqlConfiguration.put(map, "Pager to use", MysqlArguments.PAGER);
        MysqlConfiguration.put(map, "Append everything into outfile", MysqlArguments.TEE);
        MysqlConfiguration.put(map, "Disable named commands", "--disable-named-commands");
        MysqlConfiguration.put(map, "Disable pager", "--disable-pager");
        MysqlConfiguration.put(map, "Disable reconnect", "--disable-reconnect");
        MysqlConfiguration.put(map, "Disable tee option", "--disable-tee");
        MysqlConfiguration.put(map, "Disable auto rehash", "--skip-auto-rehash");
        MysqlConfiguration.put(map, "Disable comments", "--skip-comments");
        MysqlConfiguration.put(map, "Disable reconnect", "--skip-reconnect");
        MysqlConfiguration.put(map, "Statements to ignore for logging", MysqlArguments.HISTIGNORE);
        Map<String, String> map2 = map;
        if (map2 == null) {
            MysqlConfiguration.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List list = ContainerUtil.concat((List)ContainerUtil.list((Object[])new String[]{"-e", "-S"}), super.getParameterizableArguments());
        if (list == null) {
            MysqlConfiguration.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            MysqlConfiguration.$$$reportNull$$$0(5);
        }
        MyBuilder myBuilder = new MyBuilder(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.getEnvironmentVarName(), DbCliUtil.INPUT);
        if (myBuilder == null) {
            MysqlConfiguration.$$$reportNull$$$0(6);
        }
        return myBuilder;
    }

    @Override
    @NotNull
    public CliConfiguration.Operation getOperation() {
        CliConfiguration.Operation operation2 = CliConfiguration.Operation.RESTORE;
        if (operation2 == null) {
            MysqlConfiguration.$$$reportNull$$$0(7);
        }
        return operation2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartOfValidationOut";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsPreparer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizableArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCliBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCliBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNotificationManager
    extends CliConfigurationBase.CliNotificationManagerBase {
        private final String myFile;

        public MyNotificationManager(@NotNull Project project, @NotNull CliConfiguration.Operation operation2, @NotNull String name, @NotNull String file) {
            if (project == null) {
                MyNotificationManager.$$$reportNull$$$0(0);
            }
            if (operation2 == null) {
                MyNotificationManager.$$$reportNull$$$0(1);
            }
            if (name == null) {
                MyNotificationManager.$$$reportNull$$$0(2);
            }
            if (file == null) {
                MyNotificationManager.$$$reportNull$$$0(3);
            }
            super(project, operation2, name);
            this.myFile = file;
        }

        @Override
        @NotNull
        protected String getCommandText(@NotNull String text2) {
            if (text2 == null) {
                MyNotificationManager.$$$reportNull$$$0(4);
            }
            String string = StringUtil.trim((String)text2) + " < " + this.myFile;
            if (string == null) {
                MyNotificationManager.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration$MyNotificationManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration$MyNotificationManager";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommandText";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyBuilder
    extends CliConfigurationBase.CliBuilderBase {
        private final String[] myFileArgs;
        private String myFile;

        public MyBuilder(@NotNull CliConfiguration.CliParameterProcessor processor, @NotNull Project project, @NotNull CliConfiguration.Operation operation2, @NotNull String name, @NotNull String envName, @NotNull String[] fileArgs) {
            if (processor == null) {
                MyBuilder.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyBuilder.$$$reportNull$$$0(1);
            }
            if (operation2 == null) {
                MyBuilder.$$$reportNull$$$0(2);
            }
            if (name == null) {
                MyBuilder.$$$reportNull$$$0(3);
            }
            if (envName == null) {
                MyBuilder.$$$reportNull$$$0(4);
            }
            if (fileArgs == null) {
                MyBuilder.$$$reportNull$$$0(5);
            }
            super(processor, project, operation2, name, envName);
            this.myFileArgs = fileArgs;
        }

        @Override
        @NotNull
        public GeneralCommandLine build(@NotNull List<String> parameterizable, @NotNull String command, @Nullable String password) {
            if (parameterizable == null) {
                MyBuilder.$$$reportNull$$$0(6);
            }
            if (command == null) {
                MyBuilder.$$$reportNull$$$0(7);
            }
            String value = (String)ObjectUtils.notNull((Object)DbCliUtil.getArgumentValue(command, parameterizable, this.myFileArgs));
            this.myFile = DbCliUtil.clearString(value, StringUtil::unquoteString);
            LexemeIndicators fileIndicators = new LexemeIndicators(this.myFileArgs);
            String withoutFile = DbCliUtil.getCommandWithout(command, fileIndicators);
            GeneralCommandLine line = super.build(parameterizable, withoutFile, password);
            GeneralCommandLine generalCommandLine = line.withInput(new File(this.myFile));
            if (generalCommandLine == null) {
                MyBuilder.$$$reportNull$$$0(8);
            }
            return generalCommandLine;
        }

        @Override
        @NotNull
        public CliConfiguration.CliNotificationManager getNotificationManager() {
            MyNotificationManager myNotificationManager = new MyNotificationManager(this.myProject, this.myOperation, this.myName, this.myFile);
            if (myNotificationManager == null) {
                MyBuilder.$$$reportNull$$$0(9);
            }
            return myNotificationManager;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileArgs";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration$MyBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration$MyBuilder";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

