/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.icons.AllIcons;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.reference.SoftReference;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.awt.Color;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcConsoleProvider
extends PersistenceConsoleProvider {
    private static final FileAttribute ATTACHED_DATASOURCE_ATTR = new FileAttribute("datasource_uuid", 2, true);
    private static final Key<WeakReference<JdbcConsole>> JDBC_CONSOLE = Key.create((String)"JDBC_CONSOLE");

    public boolean hasRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(0);
        }
        return false;
    }

    public boolean hasRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        PsiFile file;
        if (element == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(1);
        }
        if (DbImplUtil.getDataSourcesForExec(file = element.getContainingFile(), true, false).isEmpty()) {
            return false;
        }
        return JdbcConsoleProvider.isSqlAtPlace(file, JdbcConsoleProvider.elementAt(file, element, editor));
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(2);
        }
        List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
        if (list == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        PsiElement elementAt;
        PsiFile file;
        if (element == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(4);
        }
        if (!JdbcConsoleProvider.isSqlAtPlace(file = element.getContainingFile(), elementAt = JdbcConsoleProvider.elementAt(file, element, editor))) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JdbcConsoleProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        DatabaseSettings.ExecOption execOption = DatabaseSettings.getSettings().execOptions.get(0);
        List<PersistenceConsoleProvider.Runner> list = JdbcConsoleProvider.getRunners(JdbcConsoleProvider.findScriptModel(file, elementAt, editor, execOption), true);
        if (list == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static List<PersistenceConsoleProvider.Runner> getRunners(@Nullable Info info, boolean ignoreForced) {
        if (info == null || info.model.statements().isEmpty()) {
            return Collections.emptyList();
        }
        Project project = info.originalFile.getProject();
        JBIterable<DbDataSource> dataSources2 = DbImplUtil.getDataSourcesForExec(info.file, ignoreForced, false);
        if (dataSources2.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet allowedIds = ContainerUtil.newHashSet();
        for (DbDataSource source : dataSources2) {
            allowedIds.add(source.getUniqueId());
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (JdbcConsole console2 : JdbcConsoleProvider.getRunningConsoles(project)) {
            if (!allowedIds.contains(console2.getDataSource().getUniqueId())) continue;
            result2.add(JdbcConsoleProvider.newRunner(console2, () -> JdbcConsoleProvider.runInner(console2, info)));
        }
        for (DbDataSource dataSource : dataSources2) {
            if (!DbImplUtil.canConnectTo((DbElement)dataSource)) continue;
            result2.add(JdbcConsoleProvider.newRunner(dataSource, info.file.getText(), (Consumer<JdbcConsole>)((Consumer)console -> JdbcConsoleProvider.runInner(console, info))));
        }
        return result2;
    }

    @NotNull
    public static JBIterable<JdbcConsole> getRunningConsoles(Project project) {
        JBIterable jBIterable = JBIterable.from(JdbcConsole.getActiveConsoles(project));
        if (jBIterable == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Nullable
    public static Info findScriptModel(@NotNull PsiFile file, @NotNull PsiElement elementAt, @Nullable Editor editor, @NotNull DatabaseSettings.ExecOption execOption) {
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(8);
        }
        if (elementAt == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(9);
        }
        if (execOption == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(10);
        }
        if (!JdbcConsoleProvider.isSqlAtPlace(file, elementAt)) {
            return null;
        }
        TextRange selectionRange = ScriptModelUtil.getSelectionForConsole(editor, execOption);
        Project project = file.getProject();
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)elementAt);
        if (documentWindow != null && elementAt.getContainingFile() instanceof SqlFile) {
            return JdbcConsoleProvider.findScriptModelInInjection(project, file, elementAt, editor, selectionRange, documentWindow, execOption);
        }
        return JdbcConsoleProvider.findScriptModelNoInject(project, file, editor, selectionRange, execOption);
    }

    @Nullable
    private static Info findScriptModelNoInject(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull TextRange selectionRange, @NotNull DatabaseSettings.ExecOption execOption) {
        Document document;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(11);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(12);
        }
        if (selectionRange == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(13);
        }
        if (execOption == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(14);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file.getVirtualFile())) {
            return null;
        }
        JdbcConsole console = JdbcConsole.getConsole(file.getProject(), virtualFile);
        ScriptModel model = console != null ? console.getScriptModel() : SqlPsiFacade.getInstance((Project)project).createScriptModel(file);
        ScriptModel m = ScriptModelUtil.adjustModelForSelection(model, document, selectionRange, execOption);
        return new Info(file, file, (EditorEx)editor, m, execOption, null);
    }

    @Nullable
    private static Info findScriptModelInInjection(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement elementAt, @Nullable Editor editor, @NotNull TextRange selection0, @NotNull DocumentWindow documentWindow, @NotNull DatabaseSettings.ExecOption execOption) {
        SqlFile sqlFile;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(15);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(16);
        }
        if (elementAt == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(17);
        }
        if (selection0 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(18);
        }
        if (documentWindow == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(19);
        }
        if (execOption == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(20);
        }
        if ((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)elementAt.getContainingFile(), SqlFile.class)) == null) {
            return null;
        }
        TextRange selectionInj = editor instanceof EditorWindow || editor == null ? selection0 : EditorUtil.getSelectionInAnyMode((Editor)InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)sqlFile));
        SyntaxTraverser s = (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)sqlFile)).withTraversal(TreeTraversal.LEAVES_DFS);
        StringBuilder unescaped = new StringBuilder();
        int count2 = s.traverse().size();
        int[] injectedOffsets = new int[count2 + 1];
        int[] copyOffsets = new int[count2 + 1];
        copyOffsets[0] = 0;
        injectedOffsets[0] = 0;
        int i2 = 1;
        int unescEnd = -1;
        int unescStart = -1;
        for (PsiElement e : s) {
            String leafText = InjectedLanguageUtil.getUnescapedLeafText((PsiElement)e, (boolean)false);
            if (leafText == null) continue;
            TextRange r = e.getTextRange();
            if (r.contains(selectionInj.getStartOffset())) {
                unescStart = unescaped.length() + Math.max(leafText.length(), selectionInj.getStartOffset() - r.getStartOffset());
            }
            if (r.contains(selectionInj.getEndOffset())) {
                unescEnd = unescaped.length() + Math.max(leafText.length(), selectionInj.getEndOffset() - r.getStartOffset());
            }
            unescaped.append(leafText);
            injectedOffsets[i2] = r.getEndOffset();
            copyOffsets[i2] = unescaped.length();
            ++i2;
        }
        if (unescStart < 0 || unescEnd < 0) {
            return null;
        }
        TextRange selectionRange = TextRange.create((int)unescStart, (int)unescEnd);
        SqlFile subFile = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)sqlFile.getSqlLanguage(), (CharSequence)unescaped.toString(), true, false);
        LightVirtualFile subVirtualFile = (LightVirtualFile)ObjectUtils.assertNotNull((Object)((LightVirtualFile)subFile.getVirtualFile()));
        subVirtualFile.setOriginalFile(PsiUtilCore.getVirtualFile((PsiElement)sqlFile));
        if (editor instanceof EditorImpl) {
            editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)sqlFile);
        }
        ScriptModel model = SqlPsiFacade.getInstance((Project)project).createScriptModel((PsiFile)subFile);
        ScriptModel m = ScriptModelUtil.adjustModelForSelection(model, (Document)documentWindow, selectionRange, execOption);
        return new Info(file, (PsiFile)subFile, (EditorEx)editor, m, execOption, (NotNullFunction<PsiElement, TextRange>)((NotNullFunction)dom -> JdbcConsoleProvider.calcRangeInInjected(dom, copyOffsets, injectedOffsets)));
    }

    @NotNull
    private static TextRange calcRangeInInjected(PsiElement e, int[] copy, int[] injected) {
        TextRange range = e.getTextRange();
        int i1 = Arrays.binarySearch(copy, range.getStartOffset());
        int i2 = Arrays.binarySearch(copy, range.getEndOffset());
        if (i1 < 0 || i2 < 0) {
            throw new IndexOutOfBoundsException(range + " not found in " + Arrays.toString(copy));
        }
        TextRange textRange = TextRange.create((int)injected[i1], (int)injected[i2]);
        if (textRange == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(21);
        }
        return textRange;
    }

    public static void chooseStatements(final @NotNull Info info, @Nullable String nothingToRunText, boolean allowOutsideOption, final @NotNull Consumer<ScriptModel<?>> consumer2) {
        boolean noUI;
        if (info == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(22);
        }
        if (consumer2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(23);
        }
        DatabaseSettings.ExecOption execOption = info.execOption;
        final LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (ScriptModel.StatementIt it : info.model.statements()) {
            if (map.values().contains(it.range())) continue;
            long offset = it.rangeOffset();
            map.put((PsiElement)it.object(), new ScriptModel.ChosenRange(offset > 0L ? it.range().shiftRight((int)offset) : it.range()));
        }
        boolean modelAtCaret = info.model.getTextRange() instanceof ScriptModel.PositionRange;
        boolean mapEmptyOrBatches = JBIterable.from(map.keySet()).filter(modelAtCaret ? Conditions.not((Condition)Conditions.instanceOf((Class[])new Class[]{SqlBatchBlock.class, SqlFile.class})) : Conditions.alwaysTrue()).isEmpty();
        boolean bl = noUI = nothingToRunText == null;
        if (mapEmptyOrBatches) {
            boolean doDefault = true;
            int option = allowOutsideOption ? execOption.execOutside : -1;
            TextRange range = info.model.getTextRange();
            ScriptModel m = info.model.subModel(null);
            if (modelAtCaret && !m.statements().isEmpty()) {
                TextRange tailRange;
                ScriptModel m1;
                TextRange r;
                if (option == 1) {
                    doDefault = false;
                } else if (option == 2) {
                    consumer2.consume((Object)m);
                    doDefault = false;
                } else if (option == 3 && (r = (TextRange)m.statements().transform(ScriptModelUtil.TO_RANGE).last()) != null && range.getStartOffset() < r.getEndOffset() && !(m1 = m.subModel(tailRange = TextRange.create((int)range.getStartOffset(), (int)r.getEndOffset()))).statements().isEmpty()) {
                    consumer2.consume((Object)m1);
                    doDefault = false;
                }
            }
            if (!doDefault) {
                return;
            }
            if (noUI) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (info == null) {
                    JdbcConsoleProvider.$$$reportNull$$$0(55);
                }
                HintManager.getInstance().showErrorHint((Editor)info.editor, nothingToRunText);
            });
        } else if (!modelAtCaret) {
            consumer2.consume(info.model);
        } else {
            PsiElement element;
            int option = execOption.execInside;
            boolean doDefault = true;
            if (option == 2 || option == 1 && noUI) {
                element = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map)).filter(Conditions.instanceOf(SqlStatement.class)).first();
                consumer2.consume((Object)info.model.subModel((TextRange)map.get(element)));
                doDefault = false;
            } else if (option == 3) {
                element = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map)).filter(Conditions.instanceOf(SqlStatement.class)).last();
                consumer2.consume((Object)info.model.subModel((TextRange)map.get(element)));
                doDefault = false;
            } else if (option == 4) {
                element = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map)).filter(Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlBatchBlock.class})).last();
                consumer2.consume((Object)info.model.subModel((TextRange)map.get(element)));
                doDefault = false;
            } else if (option == 5) {
                consumer2.consume((Object)info.model.subModel(null));
                doDefault = false;
            } else if (option == 6) {
                element = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map)).filter(Conditions.instanceOf(SqlStatement.class)).last();
                TextRange range = TextRange.create((int)((TextRange)map.get(element)).getStartOffset(), (int)info.file.getTextLength());
                consumer2.consume((Object)info.model.subModel(range));
                doDefault = false;
            } else if (map.size() == 1) {
                consumer2.consume((Object)info.model.subModel((TextRange)ContainerUtil.getFirstItem(map.values())));
                doDefault = false;
            }
            if (!doDefault) {
                return;
            }
            if (!info.editor.getComponent().isShowing()) {
                return;
            }
            Pass<PsiElement> pass = new Pass<PsiElement>(){

                public void pass(PsiElement element) {
                    consumer2.consume((Object)info.model.subModel((TextRange)map.get(element)));
                }
            };
            PsiElement selection = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map)).filter(Conditions.instanceOf(SqlStatement.class)).first();
            List<PsiElement> items = JdbcConsoleProvider.smallToLarge(map);
            IntroduceTargetChooser.showChooser((Editor)info.editor, items, (Pass)pass, expression -> StringUtil.first((String)expression.getText().replaceAll("\\s+", " "), (int)50, (boolean)true), (String)"Statements", (int)items.indexOf(selection), (NotNullFunction)((NotNullFunction)ObjectUtils.notNull(info.ranger, (Object)ScopeHighlighter.NATURAL_RANGER)));
        }
    }

    @NotNull
    private static List<PsiElement> smallToLarge(@NotNull Map<PsiElement, TextRange> map) {
        if (map == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(24);
        }
        List list = ContainerUtil.reverse((List)ContainerUtil.newArrayList(map.keySet()));
        if (list == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(25);
        }
        return list;
    }

    public static boolean isSqlAtPlace(@Nullable PsiFile file, @Nullable Editor editor) {
        return JdbcConsoleProvider.isSqlAtPlace(file, JdbcConsoleProvider.elementAt(file, null, editor));
    }

    private static boolean isSqlAtPlace(@Nullable PsiFile file, @Nullable PsiElement elementAt) {
        boolean isInjected = elementAt != null && InjectedLanguageUtil.getDocumentWindow((PsiElement)elementAt) != null;
        return isInjected && PsiTreeUtil.getContextOfType((PsiElement)elementAt, (Class[])new Class[]{SqlFile.class}) != null || file instanceof SqlFile || file != null && file.getFileType() == SqlFileType.INSTANCE;
    }

    @Contract(value="null, _, _->null; _, null, null->null")
    public static PsiElement elementAt(@Nullable PsiFile file, @Nullable PsiElement element, @Nullable Editor editor) {
        int offset;
        int n = offset = file == null ? -1 : JdbcConsoleProvider.getOffset(element, editor);
        if (offset < 0) {
            return null;
        }
        if (file instanceof SqlFile) {
            PsiElement e = file.findElementAt(offset);
            return e != null || offset == 0 ? e : file.findElementAt(offset - 1);
        }
        PsiElement e = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)offset);
        return e != null || offset == 0 ? e : InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)(offset - 1));
    }

    private static int getOffset(@Nullable PsiElement element, @Nullable Editor editor) {
        if (editor != null) {
            return editor.getCaretModel().getOffset();
        }
        if (element != null) {
            return element.getTextRange().getStartOffset();
        }
        return -1;
    }

    public static void doRunQueryInConsole(@NotNull JdbcConsole console, @NotNull Info info) {
        if (console == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(26);
        }
        if (info == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(27);
        }
        JdbcConsoleProvider.chooseStatements(info, "Nothing to run", true, scriptModel -> {
            if (info == null) {
                JdbcConsoleProvider.$$$reportNull$$$0(53);
            }
            if (console == null) {
                JdbcConsoleProvider.$$$reportNull$$$0(54);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            if (((EditorEx)ObjectUtils.notNull((Object)info.editor)).isDisposed()) {
                return;
            }
            if (!console.isValid()) {
                return;
            }
            if (console.beforeExecuteQueries((ScriptModel<?>)scriptModel)) {
                VirtualFile file = info.editor.getVirtualFile();
                SearchPath before2 = null;
                try {
                    if (DbImplUtil.isDatabaseVirtualFile(file)) {
                        SearchPath searchPath = DatabaseEditorHelper.dbSrcSearchPath(console.getProject(), file, false);
                        searchPath = DbImplUtil.getAutoSwitchPath(console.getDataSource(), searchPath);
                        before2 = JdbcConsoleProvider.ensureSearchPath(console, searchPath);
                    }
                    console.executeQueries((Editor)info.editor, (ScriptModel<?>)scriptModel, info.execOption);
                }
                finally {
                    JdbcConsoleProvider.ensureSearchPath(console, before2);
                }
            }
        });
    }

    @Nullable
    private static SearchPath ensureSearchPath(@NotNull JdbcConsole console, @Nullable SearchPath searchPath) {
        if (console == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(28);
        }
        SearchPath currentPath = console.getSearchPath();
        if (searchPath != null && !searchPath.equals((Object)currentPath)) {
            console.switchSchema(searchPath, false);
        }
        return currentPath;
    }

    private static void runInner(@NotNull JdbcConsole console, @NotNull Info info) {
        PsiFile topPsi;
        VirtualFile virtualFile;
        if (console == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(29);
        }
        if (info == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(30);
        }
        if (!console.isValid()) {
            return;
        }
        if (info.editor instanceof EditorWindow && !((EditorWindow)info.editor).isValid()) {
            return;
        }
        if (info.editor != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)(topPsi = InjectedLanguageManager.getInstance((Project)info.originalFile.getProject()).getTopLevelFile((PsiElement)info.originalFile)))) != null) {
            JdbcConsoleProvider.attachConsole(console.getProject(), console, virtualFile);
        }
        JdbcConsoleProvider.doRunQueryInConsole(console, info);
    }

    public static void attachConsole(@NotNull Project project, @Nullable JdbcConsole console, @NotNull VirtualFile file) {
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(31);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(32);
        }
        if (!JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file)) {
            return;
        }
        TransactionGuard.submitTransaction((Disposable)project, () -> {
            if (file == null) {
                JdbcConsoleProvider.$$$reportNull$$$0(51);
            }
            if (project == null) {
                JdbcConsoleProvider.$$$reportNull$$$0(52);
            }
            if (!file.isValid()) {
                return;
            }
            JDBC_CONSOLE.set((UserDataHolder)file, (Object)(console == null ? null : new WeakReference<JdbcConsole>(console)));
            String consoleId = console == null ? null : console.getDataSource().getUniqueId() + ":" + ((VirtualFileWithId)console.getLanguageConsole().getVirtualFile()).getId();
            DbImplUtil.writeVFSAttributeSafe(file, ATTACHED_DATASOURCE_ATTR, consoleId);
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
            if (DbImplUtil.isDatabaseVirtualFile(file)) {
                return;
            }
            if (console == null) {
                DatabaseEditorHelper.removeConsoleToolbar(project, file);
                return;
            }
            DatabaseEditorHelper.configureConsoleToolbar(project, console, file);
        });
    }

    public static boolean isItPossibleToAttachConsoleTo(@NotNull VirtualFile file) {
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(33);
        }
        return !DbConsoleRootType.isConsoleFile(file) && !SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file);
    }

    @Nullable
    public static JdbcConsole getAttachedConsole(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file)) {
            return null;
        }
        JdbcConsole console = (JdbcConsole)SoftReference.dereference((Reference)((Reference)JDBC_CONSOLE.get((UserDataHolder)file)));
        return console != null && console.isValid() ? console : null;
    }

    @Nullable
    public static JdbcConsole findAttachedConsole(@Nullable Project project, @Nullable VirtualFile file) {
        int fileId;
        if (project == null || file == null) {
            return null;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file)) {
            return null;
        }
        String consoleId = DbImplUtil.readVFSAttributeSafe(file, ATTACHED_DATASOURCE_ATTR);
        if (consoleId == null) {
            return null;
        }
        int index2 = consoleId.indexOf(58);
        String dataSourceId = index2 > 0 ? consoleId.substring(0, index2) : consoleId;
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource == null || !DbImplUtil.canConnectTo((DbElement)dataSource)) {
            return null;
        }
        int n = fileId = index2 >= 0 ? StringUtil.parseInt((String)consoleId.substring(index2 + 1), (int)0) : 0;
        if (fileId == 0) {
            return JdbcConsole.newConsole(project).fromDataSource((DasDataSource)dataSource).forFile(DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)dataSource)).buildAndShow(false);
        }
        VirtualFile virtualFile = PersistentFS.getInstance().findFileById(fileId);
        if (!DbConsoleRootType.isConsoleFile(virtualFile)) {
            return null;
        }
        DbDataSource dataSourceByFile = DbConsoleRootType.getDataSource(project, virtualFile);
        if (dataSourceByFile != dataSource) {
            return null;
        }
        JdbcConsole exact = JdbcConsole.getActiveConsoles(project).stream().filter(console -> console.getLanguageConsole().getVirtualFile().equals(virtualFile)).findFirst().orElse(null);
        return exact != null ? exact : JdbcConsole.newConsole(project).fromDataSource((DasDataSource)dataSource).forFile(virtualFile).buildAndShow(false);
    }

    @Nullable
    private static Color getRunnerColor(@NotNull DbDataSource o) {
        if (o == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(34);
        }
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(o.getProject()).getState();
        boolean useColors = state.useColors && state.inDatabaseView;
        return useColors ? DatabaseColorManager.getColor((DbElement)o) : null;
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner newRunner(@NotNull JdbcConsole console, @NotNull Runnable runnable) {
        if (console == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(35);
        }
        if (runnable == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(36);
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)console.getProject());
        DbDataSource dataSource = (DbDataSource)ObjectUtils.notNull((Object)dbPsiFacade.findDataSource(console.getDataSource().getUniqueId()));
        MyRunner myRunner = new MyRunner(console.getTitle(), true, false, console.getDataSource().getIcon(0), JdbcConsoleProvider.getRunnerColor(dataSource), runnable);
        if (myRunner == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(37);
        }
        return myRunner;
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner newRunner(@NotNull DbDataSource dataSource, @NotNull Runnable runnable) {
        if (dataSource == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(38);
        }
        if (runnable == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(39);
        }
        MyRunner myRunner = new MyRunner(dataSource.getName(), false, false, dataSource.getIcon(0), JdbcConsoleProvider.getRunnerColor(dataSource), runnable);
        if (myRunner == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(40);
        }
        return myRunner;
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner newRunner(final @NotNull DbDataSource dataSource, final @Nullable String newText, final @NotNull Consumer<JdbcConsole> consumer2) {
        if (dataSource == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(41);
        }
        if (consumer2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(42);
        }
        final Project project = dataSource.getProject();
        MyRunner myRunner = new MyRunner(dataSource.getName(), false, false, dataSource.getIcon(0), JdbcConsoleProvider.getRunnerColor(dataSource), EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                VirtualFile consoleDir = DatabaseEditorHelper.getConsoleRootDir((DasDataSource)dataSource);
                Icon icon = dataSource.getIcon(0);
                Color color = JdbcConsoleProvider.getRunnerColor(dataSource);
                Icon newIcon = LayeredIcon.create((Icon)AllIcons.RunConfigurations.Ql_console, (Icon)AllIcons.Actions.New);
                PersistenceConsoleProvider.Runner newRunner = JdbcConsoleProvider.newPriorityRunner(PriorityAction.Priority.HIGH, "New console", false, consoleDir == null, newIcon, color, () -> {
                    if (consumer2 == null) {
                        2.$$$reportNull$$$0(10);
                    }
                    if (dataSource == null) {
                        2.$$$reportNull$$$0(11);
                    }
                    consumer2.consume((Object)JdbcConsole.newConsole(project).fromDataSource((DasDataSource)dataSource).forFile(DatabaseEditorHelper.createNewConsoleVirtualFile((DasDataSource)dataSource)).withQuery(newText).buildAndShow(false));
                });
                if (consoleDir == null) {
                    List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(newRunner);
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                VirtualFile defaultConsoleFile = DatabaseEditorHelper.findExistingConsoleVirtualFile((DasDataSource)dataSource);
                Map allRunningFiles = JBIterable.from(JdbcConsole.getActiveConsoles(project)).toReverseMap(o -> o.getLanguageConsole().getVirtualFile());
                PersistenceConsoleProvider.Runner defRunner = JdbcConsoleProvider.newPriorityRunner(PriorityAction.Priority.HIGH, "console (Default)", allRunningFiles.containsKey(defaultConsoleFile), true, icon, color, () -> {
                    if (consumer2 == null) {
                        2.$$$reportNull$$$0(7);
                    }
                    if (dataSource == null) {
                        2.$$$reportNull$$$0(8);
                    }
                    consumer2.consume(ObjectUtils.notNull(allRunningFiles.get(defaultConsoleFile), () -> {
                        if (dataSource == null) {
                            2.$$$reportNull$$$0(9);
                        }
                        return JdbcConsole.newConsole(project).fromDataSource((DasDataSource)dataSource).forFile(DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)dataSource)).buildAndShow(false);
                    }));
                });
                JBIterable perFile = FileUtil.fileTraverser((File)VfsUtilCore.virtualToIoFile((VirtualFile)consoleDir)).traverse(TreeTraversal.LEAVES_BFS).take(100).filterMap(file -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)).filter(file -> !file.equals(defaultConsoleFile)).map(file -> {
                    if (consumer2 == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (dataSource == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return JdbcConsoleProvider.newRunner(StringUtil.trimExtensions((String)((String)ObjectUtils.notNull((Object)VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)consoleDir)))), allRunningFiles.containsKey(file), false, icon, color, () -> {
                        if (consumer2 == null) {
                            2.$$$reportNull$$$0(4);
                        }
                        if (dataSource == null) {
                            2.$$$reportNull$$$0(5);
                        }
                        consumer2.consume(ObjectUtils.notNull(allRunningFiles.get(file), () -> {
                            if (dataSource == null) {
                                2.$$$reportNull$$$0(6);
                            }
                            return JdbcConsole.newConsole(project).fromDataSource((DasDataSource)dataSource).forFile((VirtualFile)file).buildAndShow(false);
                        }));
                    });
                });
                PersistenceConsoleProvider.Runner dir = JdbcConsoleProvider.newPriorityRunner(PriorityAction.Priority.LOW, "Jump to Console Files", false, false, null, color, () -> {
                    PsiManager psiManager = PsiManager.getInstance((Project)project);
                    PsiDirectory psiDirectory = psiManager.findDirectory(consoleDir);
                    if (psiDirectory != null) {
                        psiDirectory.navigate(true);
                    }
                });
                List list = (List)JBIterable.of((Object[])new PersistenceConsoleProvider.Runner[]{defRunner, newRunner}).append((Iterable)perFile).append((Object)dir).addAllTo(new ArrayList());
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/JdbcConsoleProvider$2";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubRunners";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/JdbcConsoleProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getSubRunners$8";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$null$7";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$null$6";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getSubRunners$3";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$null$2";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getSubRunners$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (myRunner == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(43);
        }
        return myRunner;
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner newRunner(@NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
        if (displayName == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(44);
        }
        if (runnable == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(45);
        }
        MyRunner myRunner = new MyRunner(displayName, running, defaultSubRunner, icon, color, runnable);
        if (myRunner == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(46);
        }
        return myRunner;
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner newPriorityRunner(final @NotNull PriorityAction.Priority priority, @NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
        if (priority == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(47);
        }
        if (displayName == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(48);
        }
        if (runnable == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(49);
        }
        class R
        extends MyRunner
        implements PriorityAction {
            R(@NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
                if (var7_7 == null) {
                    R.$$$reportNull$$$0(0);
                }
                super(displayName, running, defaultSubRunner, icon, color, runnable);
            }

            @NotNull
            public PriorityAction.Priority getPriority() {
                PriorityAction.Priority priority2 = priority;
                if (priority2 == null) {
                    R.$$$reportNull$$$0(1);
                }
                return priority2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/JdbcConsoleProvider$1R";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/JdbcConsoleProvider$1R";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPriority";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        R r = new R(displayName, running, defaultSubRunner, icon, color, runnable);
        if (r == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(50);
        }
        return r;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsoleProvider";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 32: 
            case 33: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 11: 
            case 15: 
            case 31: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection0";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 22: 
            case 27: 
            case 30: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 23: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 26: 
            case 28: 
            case 29: 
            case 35: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 36: 
            case 39: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsoleProvider";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningConsoles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRangeInInjected";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "smallToLarge";
                break;
            }
            case 37: 
            case 40: 
            case 43: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "newRunner";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "newPriorityRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasRunners";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 50: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findScriptModel";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findScriptModelNoInject";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findScriptModelInInjection";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "chooseStatements";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "smallToLarge";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doRunQueryInConsole";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureSearchPath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runInner";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "attachConsole";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isItPossibleToAttachConsoleTo";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerColor";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "newRunner";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "newPriorityRunner";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$attachConsole$6";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doRunQueryInConsole$5";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$chooseStatements$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyRunner
    extends PersistenceConsoleProvider.Runner {
        final String displayName;
        final boolean running;
        final boolean defaultSubRunner;
        final Icon icon;
        final Color color;
        final Runnable runnable;

        MyRunner(@NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
            if (displayName == null) {
                MyRunner.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                MyRunner.$$$reportNull$$$0(1);
            }
            this.displayName = displayName;
            this.running = running;
            this.defaultSubRunner = defaultSubRunner;
            this.icon = icon;
            this.color = color;
            this.runnable = runnable;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Nullable
        public Color getColor() {
            return this.color;
        }

        public boolean isAlreadyRunning() {
            return this.running;
        }

        public boolean isDefaultSubRunner() {
            return this.defaultSubRunner;
        }

        public void run() {
            this.runnable.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/JdbcConsoleProvider$MyRunner";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Info {
        public final PsiFile originalFile;
        public final PsiFile file;
        public final ScriptModel<?> model;
        public final EditorEx editor;
        public final DatabaseSettings.ExecOption execOption;
        public final NotNullFunction<PsiElement, TextRange> ranger;

        public Info(PsiFile originalFile, PsiFile file, EditorEx editor, ScriptModel<?> model, DatabaseSettings.ExecOption execOption, NotNullFunction<PsiElement, TextRange> ranger) {
            this.originalFile = originalFile;
            this.file = file;
            this.model = model;
            this.editor = editor;
            this.execOption = execOption;
            this.ranger = ranger;
        }
    }
}

