/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFederatedProvider;

public class JdbcConsoleRunContext
implements ConsoleRunConfiguration.RunContext {
    private static final Collection<String> IGNORED_SUFFIXES = Arrays.asList(".txt", ".me", ".info", ".pom", ".xml");
    public static final String MAIN_CLASS = "com.intellij.database.remote.RemoteJdbcServer";
    private static final String ZONE_PROPERTY = "user.timezone";
    private final LocalDataSource myDataSource;

    JdbcConsoleRunContext(LocalDataSource dataSource) {
        this.myDataSource = dataSource;
    }

    public static void addSslAndWinAuthProperties(@NotNull LocalDataSource dataSource, @NotNull Properties properties) {
        DataSourceSslConfiguration ssl;
        DatabaseFamilyId familyId;
        if (dataSource == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(1);
        }
        if ((familyId = dataSource.getFamilyId()).isMicrosoft()) {
            boolean jTds = JdbcConsoleRunContext.isJTds(dataSource);
            if (dataSource.isDomainAuthentication() && !jTds) {
                properties.setProperty("integratedSecurity", "true");
            }
        }
        if ((ssl = dataSource.getSslCfg()) != null && ssl.myEnabled) {
            if (familyId.isMysql()) {
                properties.setProperty("useSSL", "true");
                properties.setProperty("requireSSL", "true");
            } else if (familyId.isPostgres()) {
                properties.setProperty("ssl", "true");
            }
        }
    }

    public static void addUtilJars(@NotNull PathsList cp, boolean addGroovy) {
        if (cp == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(2);
        }
        cp.add(PathUtil.getJarPathForClass(StringUtilRt.class));
        cp.add(PathUtil.getJarPathForClass(ExceptionUtil.class));
        cp.add(PathUtil.getJarPathForClass(ContainerUtil.class));
        cp.add(PathUtil.getJarPathForClass(TObjectHashingStrategy.class));
        if (addGroovy) {
            JdbcConsoleRunContext.addClassJar(cp, JdbcConsole.class, "groovy.lang.GroovyShell");
        }
    }

    public static void addJdbcConsoleJars(PathsList cp) {
        JdbcConsoleRunContext.addClassJar(cp, JdbcEngine.class, MAIN_CLASS);
        JdbcConsoleRunContext.addClassJar(cp, JdbcEngine.class, JdbcIntermediateFederatedProvider.class.getName());
    }

    public static void addClassJar(@NotNull PathsList cp, @NotNull Class<?> context, @NotNull String className) {
        String s;
        if (cp == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(3);
        }
        if (context == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(4);
        }
        if (className == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(5);
        }
        if ((s = PathManager.getResourceRoot(context, (String)("/" + className.replace('.', '/') + ".class"))) == null) {
            return;
        }
        cp.add(new File(s).getAbsoluteFile().getAbsolutePath());
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    @Override
    public String getMainClassName() {
        return MAIN_CLASS;
    }

    @Override
    public void collectClassPath(PathsList cp) {
        JdbcConsoleRunContext.addUtilJars(cp, true);
        JdbcConsoleRunContext.addJdbcConsoleJars(cp);
        boolean sensitive = LocalFileSystem.getInstance().isCaseSensitive();
        block0: for (SimpleClasspathElement classpathElement : this.myDataSource.getClasspathElements()) {
            for (String url : classpathElement.getClassesRootUrls()) {
                String path = PathUtil.toPresentableUrl((String)url);
                for (String suffix : IGNORED_SUFFIXES) {
                    if (!(sensitive ? path.endsWith(suffix) : StringUtil.endsWithIgnoreCase((String)path, (String)suffix))) continue;
                    continue block0;
                }
                cp.add(path);
            }
        }
    }

    @Override
    public void tuneParams(@NotNull SimpleJavaParameters params) throws ExecutionException {
        String driverClass;
        if (params == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)(driverClass = this.myDataSource.getDriverClass()))) {
            throw new ExecutionException("No driver class for: " + this.myDataSource.getName());
        }
        DataSourceSslConfiguration ssl = this.myDataSource.getSslCfg();
        ParametersList vmParams = params.getVMParametersList();
        if (ssl != null && ssl.myEnabled) {
            JdbcConsoleRunContext.addNotEmpty(vmParams, ssl.myCaCertPath, "sslCaCertPath");
            JdbcConsoleRunContext.addNotEmpty(vmParams, ssl.myClientCertPath, "sslClientCertPath");
            JdbcConsoleRunContext.addNotEmpty(vmParams, ssl.myClientKeyPath, "sslClientKeyPath");
        }
        if (!vmParams.hasProperty(ZONE_PROPERTY) && !this.myDataSource.getFamilyId().isClickHouse()) {
            vmParams.addProperty(ZONE_PROPERTY, "UTC");
        }
        if (this.myDataSource.getFamilyId().isMicrosoft() && this.myDataSource.isDomainAuthentication()) {
            String libPath = "/#BITNESS" + (JdbcConsoleRunContext.isJTds(this.myDataSource) ? "/SSO/ntlmauth.dll" : "/sqljdbc_auth.dll");
            vmParams.addProperty("domain.auth.library", libPath);
        }
        params.getProgramParametersList().add(driverClass);
    }

    private static void addNotEmpty(@NotNull ParametersList props, @Nullable String value, @NotNull String key2) {
        if (props == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(7);
        }
        if (key2 == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(8);
        }
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            props.addProperty(key2, value);
        }
    }

    private static boolean isJTds(@NotNull LocalDataSource dataSource) {
        DatabaseDriver driver;
        if (dataSource == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(9);
        }
        String driverClass = (driver = dataSource.getDatabaseDriver()) == null ? null : driver.getDriverClass();
        return driverClass != null && StringUtil.containsIgnoreCase((String)driverClass, (String)"jTds");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/console/JdbcConsoleRunContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addSslAndWinAuthProperties";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addUtilJars";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addClassJar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "tuneParams";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addNotEmpty";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isJTds";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

